/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.message.menuconfig;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.message.channel.cache.MsgServiceCacheHelper;
import kd.bos.message.menuconfig.MessageMenuConfigObject;
import kd.bos.message.utils.MessageUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class MenuConfigUtil {
    public static List<MessageMenuConfigObject> getPersonMenuConfig() {
        String msgTypes = MsgServiceCacheHelper.getMenuConfigCache();
        List<Object> object = new ArrayList();
        object = MessageUtils.isNotEmpty(msgTypes) ? SerializationUtils.fromJsonStringToList((String)msgTypes, MessageMenuConfigObject.class) : MenuConfigUtil.getEnableMsgMenu();
        ArrayList<MessageMenuConfigObject> re = new ArrayList<MessageMenuConfigObject>();
        for (MessageMenuConfigObject messageMenuConfigObject : object) {
            if (!messageMenuConfigObject.isPersonalcentershow()) continue;
            re.add(messageMenuConfigObject);
        }
        return re;
    }

    public static List<MessageMenuConfigObject> getMessageMenuConfig() {
        String msgTypes = MsgServiceCacheHelper.getMenuConfigCache();
        List<Object> object = new ArrayList();
        object = MessageUtils.isNotEmpty(msgTypes) ? SerializationUtils.fromJsonStringToList((String)msgTypes, MessageMenuConfigObject.class) : MenuConfigUtil.getEnableMsgMenu();
        ArrayList<MessageMenuConfigObject> re = new ArrayList<MessageMenuConfigObject>();
        for (MessageMenuConfigObject messageMenuConfigObject : object) {
            if (!messageMenuConfigObject.isMsgcentershow()) continue;
            re.add(messageMenuConfigObject);
        }
        return re;
    }

    private static List<MessageMenuConfigObject> getEnableMsgMenu() {
        DynamicObject[] msgConfig = BusinessDataServiceHelper.load((String)"msg_menuconfig", (String)"msgtypeid,number,msgcentershow,personalcentershow,name,category", null);
        ArrayList<MessageMenuConfigObject> objects = new ArrayList<MessageMenuConfigObject>(msgConfig.length);
        if (msgConfig != null && msgConfig.length > 0) {
            for (int i = 0; i < msgConfig.length; ++i) {
                MessageMenuConfigObject messageMenuConfigObject = new MessageMenuConfigObject();
                ILocaleString localeStrings = msgConfig[i].getLocaleString("name");
                LocaleString localeString = new LocaleString();
                if (localeStrings != null) {
                    for (Map.Entry entry : localeStrings.entrySet()) {
                        localeString.put((String)entry.getKey(), entry.getValue());
                    }
                }
                messageMenuConfigObject.setName(localeString);
                messageMenuConfigObject.setNumber(msgConfig[i].getString("number"));
                messageMenuConfigObject.setMsgtypeid(msgConfig[i].getLong("msgtypeid"));
                messageMenuConfigObject.setMsgcentershow(msgConfig[i].getBoolean("msgcentershow"));
                messageMenuConfigObject.setPersonalcentershow(msgConfig[i].getBoolean("personalcentershow"));
                messageMenuConfigObject.setCategory(msgConfig[i].getString("category"));
                objects.add(messageMenuConfigObject);
            }
        } else {
            DynamicObject[] msgTypeConfig = BusinessDataServiceHelper.load((String)"msg_type", (String)"id,number,name", (QFilter[])new QFilter[]{new QFilter("number", "!=", (Object)"task")});
            for (int i = 0; i < msgTypeConfig.length; ++i) {
                MessageMenuConfigObject messageMenuConfigObject = new MessageMenuConfigObject();
                ILocaleString localeStrings = msgTypeConfig[i].getLocaleString("name");
                LocaleString localeString = new LocaleString();
                if (localeStrings != null) {
                    for (Map.Entry entry : localeStrings.entrySet()) {
                        localeString.put((String)entry.getKey(), entry.getValue());
                    }
                }
                messageMenuConfigObject.setName(localeString);
                messageMenuConfigObject.setNumber(msgTypeConfig[i].getString("number"));
                messageMenuConfigObject.setMsgtypeid(msgTypeConfig[i].getLong("id"));
                messageMenuConfigObject.setMsgcentershow(true);
                messageMenuConfigObject.setPersonalcentershow(true);
                objects.add(messageMenuConfigObject);
            }
        }
        MsgServiceCacheHelper.putMenuConfigCache(SerializationUtils.toJsonString(objects));
        return objects;
    }
}

