/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.message.mutilLange;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.cache.PromptWordCacheNew;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.format.FormatFactory;
import kd.bos.entity.format.FormatObject;
import kd.bos.entity.format.FormatTypes;
import kd.bos.entity.format.IFormat;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.inte.api.EnabledLang;
import kd.bos.lang.Lang;
import kd.bos.message.utils.MessageUtils;
import kd.bos.service.KDDateFormatUtils;
import kd.bos.servicehelper.inte.InteServiceHelper;

public class MessageMultilangageUtils {
    public static ILocaleString getPromptWordLocaleString(String srcTran, String resId, String projectNum) {
        LocaleString result = new LocaleString();
        List enabledLangs = InteServiceHelper.getEnabledLang();
        for (EnabledLang enabledLang : enabledLangs) {
            result.put((Object)enabledLang.getNumber(), (Object)MessageMultilangageUtils.getPromptWord(srcTran, resId, enabledLang.getNumber(), projectNum));
        }
        return result;
    }

    public static String getPromptWord(String srcTran, String resId, String language, String projectNum) {
        try {
            PromptWordCacheNew promptWordCacheNew = new PromptWordCacheNew();
            String promptWord = promptWordCacheNew.getPromptWord(srcTran, resId, language, projectNum);
            return promptWord;
        }
        catch (Exception e) {
            return srcTran;
        }
    }

    public static ILocaleString getMultiLangValue(String zhValue, String twValue, String enValue) {
        LocaleString result = new LocaleString();
        result.put((Object)Locale.SIMPLIFIED_CHINESE.toString(), (Object)zhValue);
        result.put((Object)Locale.TRADITIONAL_CHINESE.toString(), (Object)twValue);
        result.put((Object)Locale.US.toString(), (Object)enValue);
        return result;
    }

    public static String getGeneralLangSQL(String entityNumber, String masterTableAlias, String multiLangTableAlias, String fieldName, String fieldNameAlias, String propertyName) {
        StringBuilder sql = new StringBuilder();
        String masterTableSQL = masterTableAlias + "." + fieldName;
        String multiLangTableSQL = multiLangTableAlias + "." + fieldName;
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        DynamicProperty property = entityType.getProperty(propertyName);
        if (property instanceof MuliLangTextProp && !property.isDbIgnore()) {
            sql.append("case when ").append(multiLangTableSQL).append(" is null then ").append(masterTableSQL);
            sql.append(" when ").append(multiLangTableSQL).append(" = ' ' then ").append(masterTableSQL);
            sql.append(" when ").append(multiLangTableSQL).append(" = '' then ").append(masterTableSQL);
            sql.append(" else ").append(multiLangTableSQL).append(" end ").append(fieldNameAlias);
            return sql.toString();
        }
        return sql.append(multiLangTableSQL).append(" ").append(fieldNameAlias).toString();
    }

    public static Date parseToUserZoneDate(Date date, boolean onlyDate) {
        if (date == null) {
            return null;
        }
        try {
            SimpleDateFormat simpleDateFormat = MessageMultilangageUtils.getUserDateFormat(onlyDate);
            if (simpleDateFormat != null) {
                Date dateParse = MessageMultilangageUtils.getUserZoneDate(date);
                String dateFormatString = simpleDateFormat.format(dateParse);
                return simpleDateFormat.parse(dateFormatString);
            }
        }
        catch (ParseException arg3) {
            throw new KDBizException(BosErrorCode.filterSqlBuilder, new Object[]{String.format(ResManager.loadKDString((String)"\u65e5\u671f\u65f6\u95f4\u683c\u5f0f\u9519\u8bef\uff0c\u8f6c\u5316\u5931\u8d25\u3002\u539f\u56e0\uff1a%s\u3002", (String)"MessageMultilangageUtils_1", (String)"bos-message-common", (Object[])new Object[0]), arg3.getMessage())});
        }
        return date;
    }

    public static Date getUserZoneDate(Date date) {
        if (date == null) {
            return null;
        }
        try {
            DateFormat userZoneDateFormat = KDDateFormatUtils.getUserZoneDateFormat();
            if (userZoneDateFormat != null) {
                String dateString = userZoneDateFormat.format(date);
                DateFormat systemTimeZoneDateFormat = KDDateFormatUtils.getSystemTimeZoneDateFormat();
                if (systemTimeZoneDateFormat != null) {
                    return systemTimeZoneDateFormat.parse(dateString);
                }
            }
        }
        catch (ParseException e) {
            throw new KDBizException(BosErrorCode.filterSqlBuilder, new Object[]{String.format(ResManager.loadKDString((String)"\u65e5\u671f\u65f6\u95f4\u683c\u5f0f\u9519\u8bef\uff0c\u8f6c\u5316\u5931\u8d25\u3002\u539f\u56e0\uff1a%s\u3002", (String)"MessageMultilangageUtils_1", (String)"bos-message-common", (Object[])new Object[0]), e.getMessage())});
        }
        return date;
    }

    private static SimpleDateFormat getUserDateFormat(boolean date) {
        IFormat format;
        FormatObject formatObject = FormatFactory.getFormat((Long)MessageMultilangageUtils.getCurrentUser());
        if (formatObject != null && (format = FormatFactory.get((FormatTypes)(date ? FormatTypes.Date : FormatTypes.Time))) != null) {
            return (SimpleDateFormat)format.getFormat(formatObject);
        }
        return null;
    }

    public static Long getCurrentUser() {
        return Long.valueOf(RequestContext.get().getUserId());
    }

    public static LocaleString swithLocaleStringFromOrm(ILocaleString ormLocaleData) {
        LocaleString data = new LocaleString();
        Set entrySet = ormLocaleData.entrySet();
        for (Map.Entry entry : entrySet) {
            data.setItem((String)entry.getKey(), entry.getValue());
        }
        return data;
    }

    public static Lang[] getSupportLangs() {
        List enabledLangs = InteServiceHelper.getEnabledLang();
        Lang[] langs = new Lang[enabledLangs.size()];
        for (int i = 0; i < enabledLangs.size(); ++i) {
            langs[i] = Lang.from((String)((EnabledLang)enabledLangs.get(i)).getNumber());
        }
        return langs;
    }

    public static void clipLocaleString(ILocaleString data, int len) {
        Set entrySet = data.entrySet();
        for (Map.Entry entry : entrySet) {
            String item = (String)data.getItem((String)entry.getKey());
            if (!MessageUtils.isNotEmpty(item) || item.length() <= len) continue;
            data.setItem((String)entry.getKey(), (Object)item.substring(0, len - 10));
        }
    }

    public static ILocaleString getFormatMergeValue(List<ILocaleString> formatLocalStringList) {
        LocaleString formatLocalString = new LocaleString();
        for (Lang lang : MessageMultilangageUtils.getSupportLangs()) {
            StringBuilder userNameFormatLang = new StringBuilder();
            for (ILocaleString format : formatLocalStringList) {
                if (MessageUtils.isNotEmpty((String)format.get((Object)lang.toString()))) {
                    userNameFormatLang.append((String)format.get((Object)lang.toString())).append(',');
                    continue;
                }
                String defaultString = MessageMultilangageUtils.getValueFromLocalString(format, lang.toString());
                defaultString = MessageUtils.isNotEmpty(defaultString) ? defaultString + "," : "";
                userNameFormatLang.append(defaultString);
            }
            String userNameFormatLangStr = userNameFormatLang.toString();
            if (MessageUtils.isNotEmpty(userNameFormatLangStr)) {
                userNameFormatLangStr = userNameFormatLang.substring(0, userNameFormatLang.length() - 1);
            }
            formatLocalString.setItem(lang.toString(), (Object)userNameFormatLangStr);
        }
        return formatLocalString;
    }

    public static String getValueFromLocalString(ILocaleString value, String language) {
        if (MessageUtils.isEmpty(value)) {
            return "";
        }
        String localeValue = (String)value.get((Object)language);
        if (MessageUtils.isNotEmpty(localeValue)) {
            return localeValue;
        }
        String glValue = value.toString();
        if (MessageUtils.isNotEmpty(glValue)) {
            return glValue;
        }
        String defaultLang = InteServiceHelper.getDefaultLangNumber();
        String defaultValue = (String)value.get((Object)defaultLang);
        if (MessageUtils.isNotEmpty(defaultValue)) {
            return defaultValue;
        }
        return value.getLocaleValue_zh_CN();
    }
}

