/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.message.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.fileservice.FileItem;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.engine.msg.info.MessageAttachment;
import kd.bos.workflow.engine.msg.info.MessageInfo;

public class MessageAttachmentUtils {
    private static Log logger = LogFactory.getLog(MessageAttachmentUtils.class);

    public static List<String> putAttachmentData(MessageInfo message) {
        MessageAttachment attachments = message.getAttachment();
        long msgChannelId = message.getChannelMsgId();
        long messageId = message.getId();
        List attachmentDatas = attachments.getAttachments();
        ArrayList<String> attachmentUrls = new ArrayList<String>();
        try {
            FileService fileService = FileServiceFactory.getAttachmentFileService();
            RequestContext requestContext = RequestContext.get();
            String tenantId = requestContext.getTenantId();
            String accountId = requestContext.getAccountId();
            Calendar cale = Calendar.getInstance();
            SimpleDateFormat sf = new SimpleDateFormat("yyyyMM");
            String date = sf.format(cale.getTime());
            StringBuilder filePath = new StringBuilder();
            filePath.append("/").append(tenantId).append("/").append(accountId).append("/").append(date).append("/wftask").append("/mcenterFiles/").append(messageId).append("/attachments/");
            String basePath = filePath.toString();
            for (int i = 0; i < attachmentDatas.size(); ++i) {
                byte[] attachmentData = (byte[])attachmentDatas.get(i);
                ByteArrayInputStream is = new ByteArrayInputStream(attachmentData);
                String fileName = msgChannelId + "-" + i + ".zip";
                String fileUrl = fileService.upload(new FileItem(fileName, basePath + fileName, (InputStream)is));
                attachmentUrls.add(fileUrl);
            }
        }
        catch (Exception e) {
            logger.warn("MessageAttachmentUtils-put-" + e.getMessage());
        }
        return attachmentUrls;
    }

    public static void downloadAttachmentData(MessageInfo message) {
        Map param = message.getParams();
        List attachmentNames = (List)param.get("attachmentNames");
        List attachmentUrls = (List)param.get("attachmentUrls");
        FileService fileService = FileServiceFactory.getAttachmentFileService();
        MessageAttachment attachment = new MessageAttachment();
        ArrayList<byte[]> attachmentDatas = new ArrayList<byte[]>(attachmentUrls.size());
        for (int i = 0; i < attachmentUrls.size(); ++i) {
            ByteArrayOutputStream temp = new ByteArrayOutputStream();
            String url = (String)attachmentUrls.get(i);
            fileService.download(url, (OutputStream)temp, "");
            byte[] bt = temp.toByteArray();
            attachmentDatas.add(bt);
        }
        attachment.setAttachmentNames(attachmentNames);
        attachment.setAttachments(attachmentDatas);
        message.setAttachment(attachment);
    }

    public static void deleteAttachmentData(MessageInfo message) {
        Map param = message.getParams();
        List attachmentUrls = (List)param.get("attachmentUrls");
        MessageAttachmentUtils.deleteAttachmentData(attachmentUrls);
    }

    public static void deleteAttachmentData(List<String> attachmentUrls) {
        FileService fileService = FileServiceFactory.getAttachmentFileService();
        for (String url : attachmentUrls) {
            try {
                fileService.delete(url);
            }
            catch (Exception e) {
                logger.warn(String.format("MessageAttachmentUtils-delete-[%s]-[%s]", url, e.getMessage()));
            }
        }
    }
}

