/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.message.utils;

import java.util.Iterator;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.message.utils.MessageUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class MessageConfigurationUtil {
    protected static Log logger = LogFactory.getLog(MessageConfigurationUtil.class);
    private static final String MSG_SHOWOUTERSYSTEMTASKBYBROWSERTAB = "msg.showOuterSystemTaskByBrowserTab";
    private static final String REPAIREMSGRECEIVERCOMPLETE = "msg.msgreceiver.repaireMsgReceiverFinish";
    private static final String QUERYSMSINFODAYS = "msg.sms.querySmsInfoDays";
    private static final String SMSPULLURL = "msg.sms.smsPullUrl";
    private static final String MCENTERDUPLICATECONFIGS = "msg.mcenter.duplicateConfigs";
    private static final String MCENTERLIMITERCONFIGS = "msg.mcenter.limiterConfigs";

    private static Object getConfigCenterVal(String key) {
        try {
            DynamicObject t;
            Iterator iter;
            QFilter qs = new QFilter("key", "=", (Object)key);
            Map ret = BusinessDataServiceHelper.loadFromCache((String)"wf_confcenter", (String)"value", (QFilter[])new QFilter[]{qs});
            if (ret != null && ret.size() > 0 && (iter = ret.values().iterator()).hasNext() && (t = (DynamicObject)iter.next()) != null) {
                return t.get("value");
            }
        }
        catch (Exception e) {
            logger.info(String.format("there is error on getting configcenter value,msg is [%s]", e.getMessage()));
        }
        return null;
    }

    public static boolean showOuterSystemTaskByBrowserTab() {
        boolean isShowByBrowserTab = true;
        try {
            Object ret = MessageConfigurationUtil.getConfigCenterVal(MSG_SHOWOUTERSYSTEMTASKBYBROWSERTAB);
            if (ret != null) {
                isShowByBrowserTab = Boolean.parseBoolean((String)ret);
            }
        }
        catch (Exception e) {
            logger.warn("showOuterSystemTaskByBrowserTab function has exception:" + MessageUtils.getExceptionStacktrace(e));
        }
        return isShowByBrowserTab;
    }

    public static Boolean isRepaireMsgReceiverComplete() {
        try {
            Object val = MessageConfigurationUtil.getConfigCenterVal(REPAIREMSGRECEIVERCOMPLETE);
            return val != null ? "true".equals(val) : false;
        }
        catch (Exception e) {
            return Boolean.FALSE;
        }
    }

    public static int getQuerySmsInfoDays() {
        int days = 3;
        try {
            Object val = MessageConfigurationUtil.getConfigCenterVal(QUERYSMSINFODAYS);
            if (val != null) {
                days = (Integer)val;
            }
        }
        catch (Exception e) {
            logger.warn("getQuerySmsInfoDays function has exception:" + MessageUtils.getExceptionStacktrace(e));
        }
        return days;
    }

    public static String getPullSmsUrl() {
        String pullSmsUrl = "https://api.kingdee.com/msgsrv/sms/report/pull";
        try {
            Object val = MessageConfigurationUtil.getConfigCenterVal(SMSPULLURL);
            if (val != null) {
                pullSmsUrl = (String)val;
            }
        }
        catch (Exception e) {
            logger.warn("getPullSmsUrl function has exception:" + MessageUtils.getExceptionStacktrace(e));
        }
        return pullSmsUrl;
    }

    public static String getDuplicateConfigs() {
        String configs = "true-30-title,content,tag,userIds,senderId,type,notifyType,tplScene,entityNumber,bizDataId,nestEntityNumber,nestBillId";
        try {
            Object val = MessageConfigurationUtil.getConfigCenterVal(MCENTERDUPLICATECONFIGS);
            if (val != null) {
                configs = (String)val;
            }
        }
        catch (Exception e) {
            logger.warn("getDuplicateConfigs function has exception:" + MessageUtils.getExceptionStacktrace(e));
        }
        return configs;
    }

    public static String getLimiterConfigs() {
        String configs = "true-email,sms";
        try {
            Object val = MessageConfigurationUtil.getConfigCenterVal(MCENTERLIMITERCONFIGS);
            if (val != null) {
                configs = (String)val;
            }
        }
        catch (Exception e) {
            logger.warn("getLimiterConfigs function has exception:" + MessageUtils.getExceptionStacktrace(e));
        }
        return configs;
    }
}

