/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.message.utils;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.message.api.IMessageService;
import kd.bos.message.channel.cache.MsgServiceCacheHelper;
import kd.bos.message.utils.MessageEventType;
import kd.bos.message.utils.MessageUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.workflow.engine.msg.info.MessageInfo;

public class MessageEventListenerUtils {
    private static Log logger = LogFactory.getLog(MessageEventListenerUtils.class);
    private static final String EVENTLISTENERS = "eventListeners";
    private static final String ENTITYNUMBER = "entitynumber";
    private static final String MSGTYPE = "msgtype";
    private static final String NODATA = "nodata";
    private static final String EVENT = "event";
    private static final String IMPLEMENTATION = "implementation";
    private static final String METHODNAME = "methodName";

    public static Map<String, Object> calculateMessageContent(String bizPlugin, Map<String, Object> params) throws Exception {
        Map<String, Object> invokeMapData = new HashMap<String, Object>();
        JSONObject data = new JSONObject();
        data.put(IMPLEMENTATION, (Object)bizPlugin);
        data.put(METHODNAME, (Object)"calculateMessageContent");
        Object invokeResult = MessageEventListenerUtils.invokeMsgEventLisenter(data, MessageEventType.CALCULATEMESSAGECONTENT, 0L, params);
        if (StringUtils.isNotBlank((Object)invokeResult)) {
            invokeMapData = (Map)invokeResult;
        }
        return invokeMapData;
    }

    public static boolean interveneMsgSend(MessageInfo messageInfo) {
        boolean continueSend = Boolean.TRUE;
        String entityNumber = messageInfo.getEntityNumber();
        Long bussinessKey = messageInfo.getBizDataId();
        if (StringUtils.isBlank((CharSequence)entityNumber) || StringUtils.isBlank((Object)bussinessKey)) {
            return continueSend;
        }
        JSONObject data = MessageEventListenerUtils.getEventListenerData(MessageEventType.INTERVENEMSGSSEND, messageInfo.getType(), entityNumber);
        if (data != null) {
            HashMap<String, Object> param = new HashMap<String, Object>();
            param.put("entityNumber", entityNumber);
            param.put("businessKey", bussinessKey);
            param.put("msgId", messageInfo.getId());
            param.put("channelMsgId", messageInfo.getChannelMsgId());
            try {
                Object invokeResult = MessageEventListenerUtils.invokeMsgEventLisenter(data, MessageEventType.INTERVENEMSGSSEND, messageInfo.getId(), param);
                if (StringUtils.isNotBlank((Object)invokeResult)) {
                    continueSend = (Boolean)invokeResult;
                }
            }
            catch (Exception e) {
                logger.warn("interveneMsgSend fail:" + MessageUtils.getExceptionStacktrace(e));
            }
        }
        return continueSend;
    }

    public static void subscribeMsgResult(String msgType, String entityNumber, MessageEventType eventType, Long msgId, Map<String, Object> param) {
        if (StringUtils.isBlank((CharSequence)entityNumber)) {
            return;
        }
        try {
            logger.debug(String.format("subscribeMsg, event[%s]", eventType.getNumber()));
            JSONObject data = MessageEventListenerUtils.getEventListenerData(eventType, msgType, entityNumber);
            if (data != null) {
                MessageEventListenerUtils.invokeMsgEventLisenter(data, eventType, msgId, param);
            }
        }
        catch (Exception e) {
            logger.warn("subscribeMsg fail:" + MessageUtils.getExceptionStacktrace(e));
        }
        try {
            if (MessageEventType.SUBSCRIBESUCCESSMSG == eventType || MessageEventType.SUBSCRIBEFAILMSG == eventType) {
                MessageEventType historyEventType = MessageEventType.SUBSCRIBESUCCESSMSG == eventType ? MessageEventType.SUBSCRIBESUCCESSRESULT : MessageEventType.SUBSCRIBEFAILRESULT;
                logger.debug(String.format("subscribeMsg_old, event[%s]", historyEventType.getNumber()));
                JSONObject data = MessageEventListenerUtils.getEventListenerData(historyEventType, msgType, entityNumber);
                if (data != null) {
                    MessageEventListenerUtils.invokeMsgEventLisenter(data, historyEventType, msgId, param);
                }
            }
        }
        catch (Exception e) {
            logger.error("subscribeMsg_old fail:" + MessageUtils.getExceptionStacktrace(e));
        }
    }

    private static JSONObject getEventListenerData(MessageEventType eventType, String msgType, String entityNumber) {
        try {
            String data = MessageEventListenerUtils.getMsgEventListenerdata(msgType, entityNumber);
            if (StringUtils.isNotBlank((CharSequence)data)) {
                JSONArray eventListeners;
                if (data.equals(NODATA)) {
                    return null;
                }
                JSONObject datajson = JSONObject.parseObject((String)data);
                if (datajson != null && (eventListeners = datajson.getJSONArray(EVENTLISTENERS)) != null && !eventListeners.isEmpty()) {
                    for (int i = 0; i < eventListeners.size(); ++i) {
                        JSONObject targetEvent = eventListeners.getJSONObject(i);
                        if (!eventType.getNumber().equals(targetEvent.getString(EVENT))) continue;
                        return targetEvent;
                    }
                }
            }
        }
        catch (Exception e) {
            logger.error("getEventListenerData fail:" + MessageUtils.getExceptionStacktrace(e));
        }
        return null;
    }

    private static String getMsgEventListenerdata(String msgType, String entityNumber) {
        String data = MsgServiceCacheHelper.getMsgEventListenerCache(entityNumber, msgType);
        if (StringUtils.isBlank((CharSequence)data)) {
            data = MessageEventListenerUtils.getMsgEventDataFromDB(entityNumber, msgType);
            if (StringUtils.isBlank((CharSequence)data)) {
                data = NODATA;
            }
            MsgServiceCacheHelper.putMsgEventListenerCache(entityNumber, msgType, data);
        }
        return data;
    }

    private static String getMsgEventDataFromDB(String entityNumber, String msgType) {
        QFilter msgTypeFilter = new QFilter(MSGTYPE, "=", (Object)msgType).or(new QFilter(MSGTYPE, "=", (Object)"*"));
        QFilter entityNumberFilter = new QFilter(ENTITYNUMBER, "=", (Object)entityNumber).or(new QFilter(ENTITYNUMBER, "=", (Object)"*"));
        QFilter[] fitlers = new QFilter[]{msgTypeFilter, entityNumberFilter};
        DynamicObjectCollection eventListenersDatas = QueryServiceHelper.query((String)"msg_eventlisteners", (String)"entitynumber,msgtype,data", (QFilter[])fitlers);
        DynamicObject msgEventListener = null;
        String objEntityNumber = null;
        String objMsgType = null;
        String data = null;
        int orderKey = 4;
        if (eventListenersDatas != null && eventListenersDatas.size() != 0) {
            for (int i = 0; i < eventListenersDatas.size(); ++i) {
                msgEventListener = (DynamicObject)eventListenersDatas.get(i);
                objEntityNumber = msgEventListener.getString(ENTITYNUMBER);
                objMsgType = msgEventListener.getString(MSGTYPE);
                if (!"*".equals(objEntityNumber) && !"*".equals(objMsgType)) {
                    data = msgEventListener.getString("data");
                    break;
                }
                if (!"*".equals(objEntityNumber) && "*".equals(objMsgType) && orderKey > 1) {
                    orderKey = 1;
                    data = msgEventListener.getString("data");
                    continue;
                }
                if ("*".equals(objEntityNumber) && !"*".equals(objMsgType) && orderKey > 2) {
                    orderKey = 2;
                    data = msgEventListener.getString("data");
                    continue;
                }
                if ("*".equals(objEntityNumber) && "*".equals(objMsgType) && orderKey > 3) {
                    orderKey = 3;
                    data = msgEventListener.getString("data");
                    continue;
                }
                logger.debug("it is impossiable");
            }
        }
        return data;
    }

    private static Object invokeMsgEventLisenter(JSONObject data, MessageEventType eventType, Long msgId, Map<String, Object> param) throws Exception {
        Object entityNumber = param.get("entityNumber");
        String bizPlugin = data.getString(IMPLEMENTATION);
        String bizMethod = data.getString(METHODNAME);
        String bizAppId = data.getString("appId");
        if (StringUtils.isBlank((Object)entityNumber)) {
            return null;
        }
        Object[] params = null;
        if (MessageEventType.SUBSCRIBESUCCESSRESULT == eventType || MessageEventType.SUBSCRIBESUCCESSMSG == eventType) {
            params = new Object[]{msgId, param};
        } else if (MessageEventType.SUBSCRIBEFAILRESULT == eventType || MessageEventType.SUBSCRIBEFAILMSG == eventType) {
            params = new Object[]{msgId, param};
        } else if (MessageEventType.INTERVENEMSGSSEND == eventType) {
            params = new Object[]{param};
        } else if (MessageEventType.CALCULATEMESSAGECONTENT == eventType) {
            params = new Object[]{param};
        } else if (MessageEventType.UPDATENOCODEFLOWUSERAVATARBADGE == eventType) {
            params = new Object[]{param};
        }
        if (StringUtils.isBlank((CharSequence)bizAppId)) {
            if (StringUtils.isNotBlank((Object)entityNumber)) {
                MainEntityType dt = EntityMetadataCache.getDataEntityType((String)((String)entityNumber));
                bizAppId = dt.getAppId();
            } else {
                bizAppId = "wf";
            }
        }
        logger.debug(String.format("invokeMsgEventLisenter-begineInvoke- bizAppId[%s], bizPlugin[%s]", bizAppId, bizPlugin));
        Object invokeResult = DispatchServiceHelper.invokeBOSService((String)bizAppId, (String)IMessageService.class.getSimpleName(), (String)"invokeMsgBizPlugin", (Object[])new Object[]{bizPlugin, bizMethod, params});
        return invokeResult;
    }
}

