/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.message.utils;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.dataentity.utils.StringUtils;

public class MessageHtmlFormatUtil {
    private static final String REGEX_BR = "<br\\s*\\/?>";
    private static final String REGEX_SCRIPT = "<script[^>]*?>[\\s\\S]*?<\\/script>";
    private static final String REGEX_STYLE = "<style[^>]*?>[\\s\\S]*?<\\/style>";
    private static final String REGEX_HTML = "<(\\S*?)[^>]*>.*?|<.*? />";
    private static final String REGEX_HTML_SUPPORT_A = "<(?!(a>|a\\s|/a>))(\\S*?)[^>]*>.*?|<.*? />";
    private static final String REGEX_SPACE = "\\s*|\t|\r|\n";

    public static String clearHtmlTags(String content) {
        return MessageHtmlFormatUtil.clearHtmlTags(content, false);
    }

    public static String clearHtmlTags(String content, boolean allowATag) {
        if (StringUtils.isBlank((CharSequence)content) || !content.contains("<") || !content.contains(">")) {
            return content;
        }
        Pattern br = Pattern.compile(REGEX_BR, 2);
        Matcher brMatcher = br.matcher(content);
        content = brMatcher.replaceAll("\r\n");
        Pattern script = Pattern.compile(REGEX_SCRIPT, 2);
        Matcher scriptMatcher = script.matcher(content);
        content = scriptMatcher.replaceAll("");
        Pattern stylePattern = Pattern.compile(REGEX_STYLE, 2);
        Matcher styleMatcher = stylePattern.matcher(content);
        content = styleMatcher.replaceAll("");
        Pattern htmlPattern = Pattern.compile(allowATag ? REGEX_HTML_SUPPORT_A : REGEX_HTML, 2);
        Matcher htmlMatcher = htmlPattern.matcher(content);
        content = htmlMatcher.replaceAll("");
        content = allowATag ? MessageHtmlFormatUtil.filterUnsafeTag(content, "</a>") : content;
        return content.trim();
    }

    private static String filterUnsafeTag(String content, String split) {
        StringBuilder sj = new StringBuilder();
        String[] arr = content.split(split, -1);
        int len = arr.length;
        for (int i = 0; i < len; ++i) {
            int suffixIndex;
            int prefixIndex;
            String tmp;
            String item = arr[i];
            if (item.contains("<") && item.contains(">") && ((tmp = item.substring(prefixIndex = item.indexOf("<"), suffixIndex = item.indexOf(">"))).contains("onclick=") || tmp.contains("javascript"))) {
                sj.append(item.substring(0, prefixIndex));
                sj.append(item.substring(suffixIndex + 1));
                continue;
            }
            sj.append(item).append(i == arr.length - 1 ? "" : split);
        }
        return sj.toString();
    }
}

