/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.message.utils;

import java.util.regex.Pattern;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.param.AppParam;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.message.utils.MessageUtils;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.url.UrlService;

public class MessageSystemParamterUtils {
    private static final String MESSAGECENTERAPPID = "L+YYPU4WNDE";
    private static final int STANDARDLIMITFAILWARNING = 100;
    private static final int STANDARDRESENDRANGE = 15;
    private static final String TASKTYPE = "tasktype";
    public static final String BYBILLNAME = "bybillname";
    public static final String CLEANMODE = "cleanmode";
    private static final Integer MSGSAVEDATEDEFAULT = 6;
    private static final String ISINTEGERPATTERN = "^[-\\+]?[\\d]*$";
    public static final Log logger = LogFactory.getLog(MessageSystemParamterUtils.class);
    private static final String[] LINKWHITELIST = new String[]{"https://vip.kingdee.com", "https://mp.weixin.qq.com", "http://survey.kingdee.com"};

    private static Object getSysParamConfig(String key) {
        AppParam param = new AppParam();
        param.setAppId(MESSAGECENTERAPPID);
        String userId = RequestContext.get().getUserId();
        Long mainOrgId = UserServiceHelper.getUserMainOrgId((long)Long.parseLong(userId));
        if (MessageUtils.isEmpty(mainOrgId)) {
            param.setOrgId(Long.valueOf(OrgUnitServiceHelper.getRootOrgId()));
        } else {
            param.setOrgId(mainOrgId);
        }
        param.setViewType("01");
        Object obj = SystemParamServiceHelper.loadAppParameterFromCache((AppParam)param, (String)key);
        logger.debug("getSysParamConfig orgId:" + param.getOrgId() + " and result:" + obj);
        return obj;
    }

    public static int getFailMsgResendRange() {
        int resendRange = 15;
        try {
            Object range = MessageSystemParamterUtils.getSysParamConfig("resendrange");
            if (StringUtils.isNotBlank((Object)range)) {
                resendRange = (Integer)range;
            }
        }
        catch (Exception e) {
            logger.warn(String.format("MessageSystemParamterUtils-%s-%s", "resendrange", e.getMessage()));
        }
        return resendRange;
    }

    public static int getFailMsgAlarmLimit() {
        int limitOfFailWarning = 100;
        try {
            Object limit = MessageSystemParamterUtils.getSysParamConfig("alarmlimitsize");
            if (StringUtils.isNotBlank((Object)limit)) {
                limitOfFailWarning = (Integer)limit;
            }
        }
        catch (Exception e) {
            logger.warn(String.format("MessageSystemParamterUtils-%s-%s", "alarmlimitsize", e.getMessage()));
        }
        return limitOfFailWarning;
    }

    public static String getTaskType() {
        try {
            Object taskType = MessageSystemParamterUtils.getSysParamConfig(TASKTYPE);
            if (StringUtils.isNotBlank((Object)taskType)) {
                return (String)taskType;
            }
        }
        catch (Exception e) {
            logger.warn(String.format("MessageSystemParamterUtils-%s-%s", TASKTYPE, e.getMessage()));
        }
        return null;
    }

    public static String getLinkWhiteList() {
        try {
            StringBuilder sb = new StringBuilder();
            Object uc = MessageSystemParamterUtils.getSysParamConfig("linkwhitelist");
            if (StringUtils.isNotBlank((Object)uc)) {
                sb.append(uc);
                if (!StringUtils.endsWith((CharSequence)((String)uc), (CharSequence)",")) {
                    sb.append(',');
                }
            }
            sb.append(UrlService.getDomainContextUrl());
            for (int i = 0; i < LINKWHITELIST.length; ++i) {
                sb.append(",").append(LINKWHITELIST[i]);
            }
            return sb.toString();
        }
        catch (Exception e) {
            logger.warn(String.format("MessageSystemParamterUtils-%s-%s", "linkwhitelist", e.getMessage()));
            return null;
        }
    }

    public static boolean startBizFlow() {
        boolean startBizFlow = Boolean.FALSE;
        try {
            Object authTaskRelatePerson = MessageSystemParamterUtils.getSysParamConfig("startbizflow");
            if (StringUtils.isNotBlank((Object)authTaskRelatePerson)) {
                startBizFlow = (Boolean)authTaskRelatePerson;
            }
        }
        catch (Exception e) {
            logger.warn(String.format("MessageSystemParamterUtils-%s-%s", "startBizFlow", e.getMessage()));
        }
        return startBizFlow;
    }

    public static boolean showSubmitLog() {
        boolean showSubmitLog = Boolean.TRUE;
        try {
            Object authTaskRelatePerson = MessageSystemParamterUtils.getSysParamConfig("showsubmitlog");
            if (StringUtils.isNotBlank((Object)authTaskRelatePerson)) {
                showSubmitLog = (Boolean)authTaskRelatePerson;
            }
        }
        catch (Exception e) {
            logger.warn(String.format("MessageSystemParamterUtils-%1$s-%2$s", "showSubmitLog", e.getMessage()));
        }
        return showSubmitLog;
    }

    public static String getCleanMode() {
        try {
            Object cleanMode = MessageSystemParamterUtils.getSysParamConfig(CLEANMODE);
            if (StringUtils.isNotBlank((Object)cleanMode)) {
                return (String)cleanMode;
            }
        }
        catch (Exception e) {
            logger.debug(String.format("MessageSystemParamterUtils-%s-%s", CLEANMODE, e.getMessage()));
        }
        return null;
    }

    public static Integer getMsgSaveDate() {
        try {
            Object object = MessageSystemParamterUtils.getSysParamConfig("msgsavedate");
            Integer msgSaveDate = 0;
            if (object instanceof DynamicObject) {
                DynamicObject obj = (DynamicObject)object;
                msgSaveDate = MessageSystemParamterUtils.checkMsgSaveDate((String)obj.get("number"));
            } else if (object instanceof String) {
                msgSaveDate = MessageSystemParamterUtils.checkMsgSaveDate((String)object);
            }
            return msgSaveDate;
        }
        catch (Exception e) {
            logger.warn(String.format("MessageSystemParamterUtils-%s-%s", "getMsgSaveDate is error", e.getMessage()));
            return null;
        }
    }

    public static Integer checkMsgSaveDate(String str) {
        Integer msgSaveDate = MSGSAVEDATEDEFAULT;
        Pattern pattern = Pattern.compile(ISINTEGERPATTERN);
        if (pattern.matcher(str).matches()) {
            msgSaveDate = Integer.valueOf(str);
        }
        return msgSaveDate;
    }
}

