/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.message.utils;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.encrypt.Encrypters;
import kd.bos.log.api.AppLogInfo;
import kd.bos.log.api.OpLogAppInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.message.api.MessageChannels;
import kd.bos.message.channel.MessageChannelUtils;
import kd.bos.message.channel.cache.MsgServiceCache;
import kd.bos.message.channel.cache.MsgServiceCacheHelper;
import kd.bos.message.channel.model.MsgChannelInfo;
import kd.bos.message.utils.MessageHtmlFormatUtil;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.log.LogServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.workflow.engine.msg.info.MessageInfo;
import kd.sdk.annotation.SdkInternal;
import org.apache.commons.lang.exception.ExceptionUtils;

@SdkInternal
public class MessageUtils {
    public static final Log logger = LogFactory.getLog(MessageUtils.class);
    private static final long ATTACHMENTSIZELIMIT = 0x500000L;
    private static final long CONTETNSIZELIMIT = 0x100000L;
    private static final String CHANNELS = "channels";
    private static final String ENABLE = "enable";
    private static final String MSG_CHANNEL = "msg_channel";
    private static final String FROMUSERNAME = "fromUserName";
    private static final String PW_FIELD = "password";
    private static final String MODIFYDATE = "modifydate";
    private static final String MESSAGEUTILS_1 = "MessageUtils_1";
    private static final String NUMBER = "number";
    private static final String RESULT = "result";
    private static final String MSGTYPE = "msgtype";
    private static final String SUCCESS = "success";
    private static final String TPLCONTENT = "tplContent";
    private static final String BIZPLUGIN = "bizPlugin";
    private static final String BOSMSERVICEMESSAGE = "bos-mservice-message";
    private static final String BOSMESSAGECOMMON = "bos-message-common";
    private static final String MSGSCENE = "msgscene";
    private static final String COMMONLANG = "commonlang";
    private static final String SYSNOTICE = "sysnotice";

    @Deprecated
    public static void addOperateLog(String operateFormId, String operateName, String operateDescription) {
        try {
            AppLogInfo info = new AppLogInfo();
            info.setUserID(Long.valueOf(RequestContext.get().getUserId()));
            info.setBizAppID("18XR3MJ0W0ET");
            info.setBizObjID(operateFormId);
            info.setOrgID(Long.valueOf(RequestContext.get().getOrgId()));
            info.setOpTime(TimeServiceHelper.now());
            info.setClientType(RequestContext.get().getClient());
            info.setClientIP(RequestContext.get().getLoginIP());
            info.setOpName(operateName);
            info.setOpDescription(operateDescription);
            LogServiceHelper.addLog((AppLogInfo)info);
        }
        catch (Exception e) {
            logger.warn(e.getMessage());
        }
    }

    public static void addOperateLog(String operateFormId, String opKey, String operateName, MultiLangEnumBridge descBridge, Object ... args) {
        try {
            OpLogAppInfo info = new OpLogAppInfo();
            info.setUserID(Long.valueOf(RequestContext.get().getUserId()));
            info.setBizAppID("18XR3MJ0W0ET");
            info.setBizObjID(operateFormId);
            info.setOrgID(Long.valueOf(RequestContext.get().getOrgId()));
            info.setOpTime(TimeServiceHelper.now());
            info.setClientType(RequestContext.get().getClient());
            info.setClientIP(RequestContext.get().getLoginIP());
            info.setOpName(opKey, operateName);
            String[] strArgs = MessageUtils.processObjects(args);
            if (descBridge == null) {
                info.setOpDescription(strArgs[0]);
            } else {
                info.setOpDesc(descBridge, strArgs);
            }
            LogServiceHelper.addLog((AppLogInfo)info);
        }
        catch (Exception e) {
            logger.warn(e.getMessage());
        }
    }

    public static void addOperateLog(String operateFormId, String opKey, MultiLangEnumBridge opNameBridge, MultiLangEnumBridge descBridge, Object ... args) {
        try {
            OpLogAppInfo info = new OpLogAppInfo();
            info.setUserID(Long.valueOf(RequestContext.get().getUserId()));
            info.setBizAppID("18XR3MJ0W0ET");
            info.setBizObjID(operateFormId);
            info.setOrgID(Long.valueOf(RequestContext.get().getOrgId()));
            info.setOpTime(TimeServiceHelper.now());
            info.setClientType(RequestContext.get().getClient());
            info.setClientIP(RequestContext.get().getLoginIP());
            info.setOpName(opKey, opNameBridge);
            String[] strArgs = MessageUtils.processObjects(args);
            if (descBridge == null) {
                info.setOpDescription(strArgs[0]);
            } else {
                info.setOpDesc(descBridge, strArgs);
            }
            LogServiceHelper.addLog((AppLogInfo)info);
        }
        catch (Exception e) {
            logger.warn(e.getMessage());
        }
    }

    private static String[] processObjects(Object ... objects) {
        String[] strings = new String[objects.length];
        for (int i = 0; i < objects.length; ++i) {
            strings[i] = String.valueOf(objects[i]);
        }
        return strings;
    }

    public static String getExceptionStacktrace(Throwable exception) {
        if (exception != null) {
            return ExceptionUtils.getStackTrace((Throwable)exception);
        }
        return "exception is null!!!!";
    }

    public static boolean isEmpty(ILocaleString value) {
        if (value == null || value.keySet().isEmpty()) {
            return true;
        }
        for (String key : value.keySet()) {
            if (!MessageUtils.isNotEmpty((String)value.get((Object)key))) continue;
            return false;
        }
        return true;
    }

    public static boolean isNotEmpty(ILocaleString value) {
        return !MessageUtils.isEmpty(value);
    }

    public static boolean isEmpty(String value) {
        return value == null || value.trim().length() <= 0;
    }

    public static boolean isNotEmpty(String value) {
        return !MessageUtils.isEmpty(value);
    }

    public static boolean isEmpty(Long val) {
        return val == null || val == 0L;
    }

    public static boolean isNotEmptyString(Object value) {
        if (value == null) {
            return false;
        }
        return MessageUtils.isNotEmpty(value.toString());
    }

    public static Map<String, Object> updateChannelData(Map<String, Object> channelParam) {
        Map<Object, Object> result = new HashMap();
        result = MessageUtils.checkChannelNecessaryParam(channelParam);
        if (!((Boolean)result.get(RESULT)).booleanValue()) {
            return result;
        }
        try {
            MessageUtils.updateChannelDBData(channelParam);
            MessageUtils.updateChannelCacheData(channelParam);
            result = MessageUtils.wrapResult(SUCCESS);
        }
        catch (Exception e) {
            result = MessageUtils.wrapResult(e.getMessage());
        }
        return result;
    }

    private static String getStaticEntries() {
        return ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u63a5\u53e3\u5165\u53c2\u5c5e\u6027", (String)MESSAGEUTILS_1, (String)BOSMESSAGECOMMON, (Object[])new Object[0]);
    }

    private static Map<String, Object> checkChannelNecessaryParam(Map<String, Object> channelParam) {
        Object number = channelParam.get(NUMBER);
        if (StringUtils.isBlank((Object)channelParam.get(NUMBER))) {
            return MessageUtils.wrapResult(MessageUtils.getStaticEntries() + NUMBER);
        }
        if (StringUtils.isBlank((Object)channelParam.get("name"))) {
            return MessageUtils.wrapResult(MessageUtils.getStaticEntries() + "name");
        }
        if (!(channelParam.get("name") instanceof ILocaleString)) {
            LocaleString name = new LocaleString();
            name.setLocaleValue_zh_CN((String)channelParam.get("name"));
            name.setLocaleValue_zh_TW((String)channelParam.get("name"));
            channelParam.put("name", name);
        }
        if (StringUtils.isBlank((Object)channelParam.get("createDate")) || StringUtils.isBlank((Object)channelParam.get(MODIFYDATE))) {
            return MessageUtils.wrapResult(MessageUtils.getStaticEntries() + MODIFYDATE);
        }
        if ("email".equals(number)) {
            String pw;
            Object[] arr = new Object[]{channelParam.get("smtpHost"), channelParam.get("smtpPort"), channelParam.get("userName"), channelParam.get(PW_FIELD), channelParam.get("fromAccount"), channelParam.get(FROMUSERNAME)};
            boolean exitBlankParam = false;
            for (int i = 0; i < arr.length; ++i) {
                if (!StringUtils.isBlank((Object)arr[i])) continue;
                exitBlankParam = true;
                break;
            }
            if (exitBlankParam) {
                return MessageUtils.wrapResult(MessageUtils.getStaticEntries());
            }
            if (!(channelParam.get(FROMUSERNAME) instanceof ILocaleString)) {
                LocaleString fromUserName = new LocaleString();
                fromUserName.setLocaleValue_zh_CN((String)channelParam.get(FROMUSERNAME));
                fromUserName.setLocaleValue_zh_TW((String)channelParam.get(FROMUSERNAME));
                channelParam.put(FROMUSERNAME, fromUserName);
            }
            String pwAfterEncode = (pw = (String)channelParam.get(PW_FIELD)).startsWith("d@f*g:") ? pw : Encrypters.encode((String)pw);
            channelParam.put(PW_FIELD, pwAfterEncode);
        }
        return MessageUtils.wrapResult(SUCCESS);
    }

    private static Map<String, Object> updateChannelDBData(Map<String, Object> channelParam) {
        String properties = "number,name,category,mobileapp,serviceclass,enable,modifydate,createdate,smtphost,smtpport,username,password,fromaccount,fromusername,tls,domain,smsapiurl,smscode,clientid,clientsecret,mobileappconfig,config";
        Object number = channelParam.get(NUMBER);
        QFilter[] filters = new QFilter[]{new QFilter(NUMBER, "=", number)};
        DynamicObject targetChannle = BusinessDataServiceHelper.loadSingle((String)MSG_CHANNEL, (String)properties, (QFilter[])filters);
        if (targetChannle == null) {
            targetChannle = BusinessDataServiceHelper.newDynamicObject((String)MSG_CHANNEL);
        }
        targetChannle.set(NUMBER, number);
        targetChannle.set("name", channelParam.get("name"));
        targetChannle.set("category", channelParam.get("category"));
        targetChannle.set("mobileapp", channelParam.get("mobileApp"));
        targetChannle.set("serviceclass", channelParam.get("serviceClass"));
        targetChannle.set(ENABLE, channelParam.get(ENABLE));
        targetChannle.set(MODIFYDATE, channelParam.get(MODIFYDATE));
        targetChannle.set("createdate", channelParam.get("createDate"));
        if ("email".equals(number)) {
            targetChannle.set("smtphost", channelParam.get("smtpHost"));
            targetChannle.set("smtpport", channelParam.get("smtpPort"));
            targetChannle.set("username", channelParam.get("userName"));
            targetChannle.set(PW_FIELD, channelParam.get(PW_FIELD));
            targetChannle.set("fromaccount", channelParam.get("fromAccount"));
            targetChannle.set(FROMUSERNAME, channelParam.get(FROMUSERNAME));
            targetChannle.set("tls", channelParam.get("tls"));
            targetChannle.set("domain", channelParam.get("domain"));
        } else if ("sms".equals(number)) {
            targetChannle.set("smsapiurl", channelParam.get("smsApiUrl"));
            targetChannle.set("smscode", channelParam.get("smsCode"));
            targetChannle.set("clientid", channelParam.get("clientId"));
            targetChannle.set("clientsecret", channelParam.get("clientSecret"));
        } else if ("yunzhijia".equals(number)) {
            targetChannle.set("mobileappconfig", channelParam.get("mobileAppConfig"));
        } else {
            targetChannle.set("mobileappconfig", channelParam.get("mobileAppConfig"));
        }
        Object timeStep = channelParam.get("timeStep");
        Object retries = channelParam.get("retries");
        if (StringUtils.isNotBlank((Object)timeStep) || StringUtils.isNotBlank((Object)retries)) {
            JSONObject retryConfig = new JSONObject();
            retryConfig.put("timestep", timeStep);
            retryConfig.put("retries", retries);
            targetChannle.set("config", (Object)retryConfig.toJSONString());
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{targetChannle});
        MessageUtils.addOperateLog(MSG_CHANNEL, "save", ResManager.getLocaleString((String)"\u4fdd\u5b58", (String)"MessageUtils_2", (String)BOSMESSAGECOMMON).getLocaleValue_zh_CN(), new MultiLangEnumBridge("%s\u6570\u636e\u5e93\u66f4\u65b0\u6210\u529f", "MessageUtils_3", BOSMESSAGECOMMON), number);
        return MessageUtils.wrapResult(SUCCESS);
    }

    private static Map<String, Object> updateChannelCacheData(Map<String, Object> channelParam) {
        MessageChannelUtils.updateMsgChannelTagKeyInCache();
        String number = (String)channelParam.get(NUMBER);
        boolean enable = (Boolean)channelParam.get(ENABLE);
        MsgServiceCache.refreshMsgChannelCacheInfo(number, !enable);
        MessageUtils.addOperateLog(MSG_CHANNEL, "save", ResManager.getLocaleString((String)"\u4fdd\u5b58", (String)"MessageUtils_2", (String)BOSMESSAGECOMMON).getLocaleValue_zh_CN(), new MultiLangEnumBridge("%s\u7f13\u5b58\u66f4\u65b0\u6210\u529f", "MessageUtils_4", BOSMESSAGECOMMON), number);
        return null;
    }

    public static void wrapYunzhijiaChannel(Object pkId, String number) {
        if (pkId != null && pkId.equals(475756772099906560L) || number != null && "yunzhijia".equalsIgnoreCase(number)) {
            MessageUtils.setEnable(788906877554546688L, Boolean.FALSE);
            MessageUtils.setEnable(1010798510410329088L, Boolean.FALSE);
        }
        if (pkId != null && pkId.equals(788906877554546688L) || number != null && "yunzhijiaeco".equalsIgnoreCase(number)) {
            MessageUtils.setEnable(475756772099906560L, Boolean.FALSE);
            MessageUtils.setEnable(1010798510410329088L, Boolean.FALSE);
        }
        if (pkId != null && pkId.equals(1010798510410329088L) || number != null && "yunzhijiaup".equalsIgnoreCase(number)) {
            MessageUtils.setEnable(475756772099906560L, Boolean.FALSE);
            MessageUtils.setEnable(788906877554546688L, Boolean.FALSE);
        }
        if (pkId != null && pkId.equals(742567749984728064L) || number != null && "weixinqy".equalsIgnoreCase(number)) {
            MessageUtils.setEnable(1532867705844058112L, Boolean.FALSE);
        }
        if (pkId != null && pkId.equals(1532867705844058112L) || number != null && "kingdee_sky".equalsIgnoreCase(number)) {
            MessageUtils.setEnable(742567749984728064L, Boolean.FALSE);
        }
    }

    public static boolean setEnable(Object pkId, boolean enable) {
        String channelName = "";
        try (TXHandle tx = TX.requiresNew();){
            DynamicObject msgChannel = BusinessDataServiceHelper.loadSingle((Object)pkId, (String)MSG_CHANNEL);
            if (msgChannel.getBoolean(ENABLE) == enable) {
                boolean bl = false;
                return bl;
            }
            if (MessageUtils.isNotEmpty(msgChannel.getLocaleString("name"))) {
                channelName = msgChannel.getLocaleString("name").toString();
            }
            msgChannel.set(ENABLE, (Object)enable);
            msgChannel.set(MODIFYDATE, (Object)System.currentTimeMillis());
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{msgChannel});
            MessageChannelUtils.updateMsgChannelTagKeyInCache();
            MsgServiceCache.refreshMsgChannelCacheInfo(msgChannel.getString(NUMBER), !enable);
        }
        if (!enable) {
            MessageUtils.addOperateLog(MSG_CHANNEL, "disable", ResManager.getLocaleString((String)"\u7981\u7528\u6d88\u606f\u6e20\u9053", (String)"MessageUtils_6", (String)BOSMESSAGECOMMON).getLocaleValue_zh_CN(), new MultiLangEnumBridge("%s\u6e20\u9053\u7981\u7528\u6210\u529f\u3002", "MessageUtils_7", BOSMESSAGECOMMON), channelName);
        } else {
            MessageUtils.addOperateLog(MSG_CHANNEL, ENABLE, ResManager.getLocaleString((String)"\u542f\u7528\u6d88\u606f\u6e20\u9053", (String)"MessageUtils_8", (String)BOSMESSAGECOMMON).getLocaleValue_zh_CN(), new MultiLangEnumBridge("%s\u6e20\u9053\u542f\u7528\u6210\u529f\u3002", "MessageUtils_9", BOSMESSAGECOMMON), channelName);
        }
        return true;
    }

    public static List<Object> removeChannelInMsgType(Object channelId, String channelName) {
        QFilter[] filters = new QFilter[]{new QFilter(CHANNELS, "like", (Object)("%" + channelId + "%"))};
        DynamicObject[] msgTypes = BusinessDataServiceHelper.load((String)"msg_type", (String)"id,channels,channelname", (QFilter[])filters);
        if (msgTypes == null || msgTypes.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<Object> typeIds = new ArrayList<Object>(msgTypes.length);
        DynamicObject[] msgChannels = BusinessDataServiceHelper.load((String)MSG_CHANNEL, (String)"id,number,name", (QFilter[])new QFilter[]{new QFilter(ENABLE, "=", (Object)"1")});
        for (DynamicObject msgType : msgTypes) {
            String chan;
            String standardChannels = msgType.getString(CHANNELS);
            StringBuilder channels = new StringBuilder();
            ILocaleString channelNames = msgType.getLocaleString("channelname");
            for (String key : channelNames.keySet()) {
                channelNames.put((Object)key, (Object)"");
            }
            if (msgChannels != null && msgChannels.length > 0) {
                for (DynamicObject msgChannel : msgChannels) {
                    String channelNumber = msgChannel.getString(NUMBER);
                    if (SYSNOTICE.equals(channelNumber) || !standardChannels.contains(msgChannel.getString("id"))) continue;
                    channels.append(msgChannel.getString("id")).append(",");
                    ILocaleString name = msgChannel.getLocaleString("name");
                    MessageUtils.wrapLocaleString(channelNames, name);
                }
            }
            msgType.set(CHANNELS, (Object)((chan = channels.toString()).endsWith(",") ? chan.substring(0, chan.length() - 1) : chan));
            msgType.set("channelname", (Object)channelNames);
            typeIds.add(msgType.get("id"));
        }
        SaveServiceHelper.save((DynamicObject[])msgTypes);
        return typeIds;
    }

    public static void wrapLocaleString(ILocaleString src, ILocaleString val) {
        if (MessageUtils.isEmpty(val)) {
            return;
        }
        Set entrySet = src.entrySet();
        for (Map.Entry entry : entrySet) {
            String key = (String)entry.getKey();
            String srcItem = (String)entry.getValue();
            String valItem = (String)val.get((Object)key);
            if (!MessageUtils.isNotEmpty(valItem)) continue;
            srcItem = MessageUtils.isNotEmpty(srcItem) ? srcItem + "," + valItem : valItem;
            src.put((Object)key, (Object)srcItem);
        }
    }

    public static void updateChannelsOfTypeInCache(Object typeId) {
        Map<String, Object> typeInfo = MessageUtils.getTypeData((Long)typeId, null);
        if (!typeInfo.isEmpty()) {
            String typeNumber = (String)typeInfo.get(NUMBER);
            MsgServiceCacheHelper.putMessageTypeCache(typeNumber, SerializationUtils.toJsonString(typeInfo));
        }
    }

    public static Map<String, Object> wrapResult(String description) {
        HashMap<String, Object> sendResult = new HashMap<String, Object>();
        if (SUCCESS.equals(description)) {
            sendResult.put(RESULT, true);
            sendResult.put("code", "0");
            sendResult.put("description", String.format(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f\u3002", (String)"MessageUtils_10", (String)BOSMESSAGECOMMON, (Object[])new Object[0]), new Object[0]));
        } else {
            sendResult.put(RESULT, false);
            sendResult.put("code", "400");
            sendResult.put("description", String.format(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25%s", (String)"MessageUtils_11", (String)BOSMESSAGECOMMON, (Object[])new Object[0]), description));
        }
        logger.debug("MessageUtils--result: " + description);
        return sendResult;
    }

    public static Map<String, Object> wrapResult(String description, Object data) {
        Map<String, Object> sendResult = MessageUtils.wrapResult(description);
        sendResult.put("data", data);
        return sendResult;
    }

    public static Map<String, Object> wrapResult(boolean result, String description, Object data) {
        Map<String, Object> sendResult = MessageUtils.wrapResult(description, data);
        sendResult.put(RESULT, result);
        return sendResult;
    }

    @SdkInternal
    public static Map<String, Object> getMessageTemplateLocalByNumber(String templateNumber) {
        logger.debug("getMessageTemplateLocalByNumber-templateNumber:" + templateNumber);
        return MessageUtils.getMessageTemplateInfo(templateNumber, null, null, null, null);
    }

    @SdkInternal
    public static List<ILocaleString> getMessageTemplateLocale(String templateNumber, String type, String channel, String scene, String entityNumber) {
        Object tpl;
        logger.debug("getMessageTemplateLocale-api-templateNumber:" + templateNumber);
        ArrayList<ILocaleString> templates = new ArrayList<ILocaleString>();
        Map<String, Object> mapData = MessageUtils.getMessageTemplateInfo(templateNumber, type, channel, scene, entityNumber);
        if (!mapData.isEmpty() && StringUtils.isNotBlank((Object)(tpl = mapData.get(TPLCONTENT)))) {
            ILocaleString template = (ILocaleString)SerializationUtils.fromJsonString((String)((String)mapData.get(TPLCONTENT)), LocaleString.class);
            templates.add(template);
        }
        return templates;
    }

    public static Map<String, Object> getMessageTemplateInfo(String templateNumber, String type, String channel, String scene, String entityNumber) {
        logger.debug(String.format("getMessageTemplateInfo, number:[%s], type:[%s], channel:[%s], scene:[%s], entity:[%s]", templateNumber, type, channel, scene, entityNumber));
        Map<String, Object> mapData = new HashMap<String, Object>();
        if (StringUtils.isBlank((CharSequence)templateNumber) && (StringUtils.isBlank((CharSequence)type) || StringUtils.isBlank((CharSequence)channel))) {
            return mapData;
        }
        String templateCacheData = null;
        boolean isUserTemplateNumber = StringUtils.isNotBlank((CharSequence)templateNumber) ? Boolean.TRUE : Boolean.FALSE;
        if (isUserTemplateNumber) {
            templateCacheData = MsgServiceCacheHelper.getTemplateCache(templateNumber);
        } else {
            scene = StringUtils.isBlank((CharSequence)scene) ? "default" : scene;
            entityNumber = StringUtils.isBlank((CharSequence)entityNumber) ? "wf_task" : entityNumber;
            templateCacheData = MsgServiceCacheHelper.getTemplateCache(type, channel, scene, entityNumber);
        }
        if (StringUtils.isBlank((CharSequence)templateCacheData) || !templateCacheData.contains(BIZPLUGIN) || !templateCacheData.contains(TPLCONTENT)) {
            QFilter[] filters = null;
            if (isUserTemplateNumber) {
                filters = new QFilter[]{new QFilter(NUMBER, "=", (Object)templateNumber)};
            } else {
                QFilter f1 = new QFilter(MSGTYPE, "=", (Object)type);
                QFilter f2 = new QFilter("msgchannel", "=", (Object)channel);
                QFilter f3 = new QFilter(MSGSCENE, "like", (Object)("%" + scene + "%"));
                QFilter f4 = new QFilter("msgentity", "=", (Object)entityNumber);
                filters = new QFilter[]{f1, f2, f3, f4};
            }
            String selectFileds = "id, number, msgtype, msgchannel, msgscene, msgentity, msgtemplate, bizplugin, commonlang";
            DynamicObject[] tplObjects = BusinessDataServiceHelper.load((String)"msg_template", (String)selectFileds, (QFilter[])filters);
            if (tplObjects != null && tplObjects.length != 0) {
                mapData = MessageUtils.getMsgTemplate(tplObjects, isUserTemplateNumber, scene, templateNumber, type, channel, entityNumber);
            } else if ("circulate".equals(type)) {
                templateCacheData = MsgServiceCacheHelper.getTemplateCache("message", channel, scene, entityNumber);
                if (StringUtils.isBlank((CharSequence)templateCacheData) || !templateCacheData.contains(BIZPLUGIN) || !templateCacheData.contains(TPLCONTENT)) {
                    QFilter f4;
                    QFilter f1 = new QFilter(MSGTYPE, "=", (Object)"message");
                    QFilter f2 = new QFilter("msgchannel", "=", (Object)channel);
                    QFilter f3 = new QFilter(MSGSCENE, "like", (Object)("%" + scene + "%"));
                    filters = new QFilter[]{f1, f2, f3, f4 = new QFilter("msgentity", "=", (Object)entityNumber)};
                    DynamicObject[] tplObject = BusinessDataServiceHelper.load((String)"msg_template", (String)selectFileds, (QFilter[])filters);
                    if (tplObject != null && tplObject.length != 0) {
                        mapData = MessageUtils.getMsgTemplate(tplObject, isUserTemplateNumber, scene, templateNumber, "message", channel, entityNumber);
                    }
                } else {
                    mapData = (Map)SerializationUtils.fromJsonString((String)templateCacheData, Map.class);
                }
            }
        } else {
            mapData = (Map)SerializationUtils.fromJsonString((String)templateCacheData, Map.class);
        }
        return mapData;
    }

    private static Map<String, Object> getMsgTemplate(DynamicObject[] tplObjects, boolean isUserTemplateNumber, String scene, String templateNumber, String type, String channel, String entityNumber) {
        HashMap<String, Object> mapData = new HashMap<String, Object>();
        LocaleString templateContent = new LocaleString();
        String bizPluginInfo = null;
        if (isUserTemplateNumber) {
            DynamicObject tpl = tplObjects[0];
            ILocaleString tplContent = tpl.getLocaleString("msgtemplate");
            for (String lang : tplContent.keySet()) {
                templateContent.put((Object)lang, tplContent.getItem(lang));
            }
            templateContent.put((Object)COMMONLANG, (Object)tpl.getString(COMMONLANG));
            bizPluginInfo = tpl.getString(BIZPLUGIN);
            mapData.put(TPLCONTENT, SerializationUtils.toJsonString((Object)templateContent));
            mapData.put(BIZPLUGIN, bizPluginInfo);
            mapData.put("tplNumber", tpl.getString(NUMBER));
            MsgServiceCacheHelper.putTemplateCache(templateNumber, SerializationUtils.toJsonString(mapData));
        } else {
            String[] sceneArray;
            boolean hasScene = false;
            DynamicObject tpl2 = null;
            for (DynamicObject tpl2 : tplObjects) {
                String msgScene = tpl2.getString(MSGSCENE);
                String[] msgSceneArr = msgScene.split(",");
                int length = msgSceneArr.length;
                for (int j = 0; j < length; ++j) {
                    if (!scene.equalsIgnoreCase(msgSceneArr[j])) continue;
                    ILocaleString tplContent = tpl2.getLocaleString("msgtemplate");
                    for (String lang : tplContent.keySet()) {
                        templateContent.put((Object)lang, tplContent.getItem(lang));
                    }
                    templateContent.put((Object)COMMONLANG, (Object)tpl2.getString(COMMONLANG));
                    bizPluginInfo = tpl2.getString(BIZPLUGIN);
                    hasScene = true;
                    break;
                }
                if (hasScene) break;
            }
            if (!hasScene) {
                return mapData;
            }
            mapData.put(TPLCONTENT, SerializationUtils.toJsonString((Object)templateContent));
            mapData.put(BIZPLUGIN, bizPluginInfo);
            mapData.put("tplNumber", tpl2.getString(NUMBER));
            for (String s : sceneArray = tpl2.getString(MSGSCENE).split(",")) {
                if (!StringUtils.isNotBlank((CharSequence)s)) continue;
                MsgServiceCacheHelper.putTemplateCache(type, channel, s, entityNumber, SerializationUtils.toJsonString(mapData));
            }
        }
        return mapData;
    }

    public static boolean isAttachmentBeyondLimit(List<byte[]> attachments) {
        JSONObject jsonConfig;
        long attachmentSizeLimt = 0x500000L;
        MsgChannelInfo emailChannelInfo = MessageChannelUtils.getChannelConfig(MessageChannels.EMAIL.getNumber());
        if (emailChannelInfo != null && emailChannelInfo.getConfig() != null && (jsonConfig = JSONObject.parseObject((String)emailChannelInfo.getConfig())) != null && jsonConfig.containsKey((Object)"attachmentSizeLimt")) {
            attachmentSizeLimt = (long)(jsonConfig.getIntValue("attachmentSizeLimt") * 1024) * 1024L;
        }
        boolean isAttachmentBeyondLimit = Boolean.FALSE;
        long size = 0L;
        for (byte[] bt : attachments) {
            size += (long)bt.length;
        }
        if (size > attachmentSizeLimt) {
            isAttachmentBeyondLimit = Boolean.TRUE;
        }
        return isAttachmentBeyondLimit;
    }

    public static boolean isMessageContentBeyondLimit(ILocaleString messageContent) {
        if (messageContent == null) {
            return false;
        }
        boolean isContentBeyondLimit = Boolean.FALSE;
        String content = messageContent.getLocaleValue();
        if (content != null && (long)content.length() > 524288L) {
            isContentBeyondLimit = Boolean.TRUE;
        }
        return isContentBeyondLimit;
    }

    public static Map<String, Object> getMessageTypeInfo(String number) {
        Map<Object, Object> typeInfo = new HashMap();
        String typeData = MsgServiceCacheHelper.getMessageTypeCache(number);
        if (StringUtils.isNotBlank((CharSequence)typeData)) {
            try {
                typeInfo = (Map)SerializationUtils.fromJsonString((String)typeData, Map.class);
            }
            catch (Exception e) {
                logger.warn(String.format("invalid json string[%s] with error[%s]", typeData, e.getMessage()));
            }
        }
        if (StringUtils.isBlank((CharSequence)typeData) || typeInfo.isEmpty()) {
            typeInfo = MessageUtils.getTypeData(null, number);
            MsgServiceCacheHelper.putMessageTypeCache(number, SerializationUtils.toJsonString(typeInfo));
        }
        return typeInfo;
    }

    private static Map<String, Object> getTypeData(Long typeId, String number) {
        HashMap<String, Object> typeInfo = new HashMap<String, Object>();
        QFilter[] filters = null;
        filters = StringUtils.isNotBlank((Object)typeId) ? new QFilter[]{new QFilter("id", "=", (Object)typeId)} : new QFilter[]{new QFilter(NUMBER, "=", (Object)number)};
        try {
            DynamicObject typeObj = BusinessDataServiceHelper.loadSingle((String)"msg_type", (String)"id,number,channels", (QFilter[])filters);
            String typeNumber = typeObj.getString(NUMBER);
            String chennelIds = typeObj.getString(CHANNELS);
            typeId = typeObj.getLong("id");
            StringBuilder channelNumbers = new StringBuilder();
            if (StringUtils.isNotBlank((CharSequence)chennelIds)) {
                QFilter[] channeleFilters;
                DynamicObject[] channelObjs;
                String channelIDs = chennelIds.trim().startsWith(",") ? chennelIds.substring(1) : chennelIds;
                ArrayList<Long> channelIdList = new ArrayList<Long>();
                for (String channelId : channelIDs.split(",")) {
                    if (channelId == null || !StringUtils.isNotBlank((CharSequence)channelId)) continue;
                    channelIdList.add(Long.parseLong(channelId));
                }
                if (channelIdList.size() != 0 && (channelObjs = BusinessDataServiceHelper.load((String)MSG_CHANNEL, (String)"id,number", (QFilter[])(channeleFilters = new QFilter[]{new QFilter("id", "in", channelIdList)}))) != null && channelObjs.length > 0) {
                    for (int i = 0; i < channelObjs.length; ++i) {
                        DynamicObject channelObj = channelObjs[i];
                        if (i == channelObjs.length - 1) {
                            channelNumbers.append(channelObj.getString(NUMBER));
                            continue;
                        }
                        channelNumbers.append(channelObj.getString(NUMBER)).append(',');
                    }
                }
            }
            if ("notice".equalsIgnoreCase(typeNumber)) {
                if (channelNumbers.length() != 0) {
                    channelNumbers.append(",").append(SYSNOTICE);
                } else {
                    channelNumbers.append(SYSNOTICE);
                }
            }
            typeInfo.put("id", typeId);
            typeInfo.put(NUMBER, typeNumber);
            typeInfo.put(CHANNELS, channelNumbers.toString());
        }
        catch (Exception e) {
            logger.debug("getTypeData--queryDBHasException:" + e.getMessage());
        }
        return typeInfo;
    }

    public static void clearHtmlTags(MessageInfo messageInfo) {
        if (messageInfo != null) {
            boolean isAllowATag;
            Object tempAllowATag = messageInfo.getParams().get("temp_allowATag");
            boolean bl = isAllowATag = tempAllowATag != null && (Boolean)tempAllowATag != false;
            if (messageInfo.getMessageContent() != null) {
                ILocaleString messageContent = messageInfo.getMessageContent();
                for (Map.Entry entry : messageInfo.getMessageContent().entrySet()) {
                    String k = (String)entry.getKey();
                    String v = (String)entry.getValue();
                    messageContent.setItem(k, (Object)MessageHtmlFormatUtil.clearHtmlTags(v, isAllowATag));
                }
            }
            messageInfo.setContent(MessageHtmlFormatUtil.clearHtmlTags(messageInfo.getContent(), isAllowATag));
        }
    }

    public static String removeSurplusMarksInFilter(String filterStr) {
        try {
            Pattern pattern = Pattern.compile("(?i)is not null(\\s*)(\"|')(\\s*)(\"|')");
            Matcher matcher = pattern.matcher(filterStr);
            return matcher.replaceAll("is not null");
        }
        catch (Exception e) {
            logger.warn("MessageUtils_removeSurplusMarksInFilter_\u8fd9\u91cc\u5e94\u8be5\u4e0d\u4f1a\u62a5\u9519\u54270.0" + e.getMessage());
            return filterStr;
        }
    }

    public static String dealUnreplacField(String sql, Map<String, String> formFieldMapSQLFiled) {
        try {
            for (Map.Entry<String, String> entry : formFieldMapSQLFiled.entrySet()) {
                Pattern pattern = Pattern.compile("(?i)and(\\s*)" + entry.getKey() + "(\\s*)");
                Matcher matcher = pattern.matcher(sql);
                if (!matcher.find()) continue;
                sql = matcher.replaceAll("and " + entry.getValue() + ' ');
            }
        }
        catch (Exception e) {
            logger.debug("MessageListPlugin.dealUnreplacField_\u89e3\u6790\u8fc7\u6ee4\u6761\u4ef6\uff1a" + e.getMessage());
        }
        return sql;
    }

    public static Date getDateBeforeThreeMonths() {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(System.currentTimeMillis());
        cal.add(2, -3);
        cal.add(7, -3);
        return cal.getTime();
    }

    public static Set<String> split(String target, String regex) {
        String[] vs;
        HashSet<String> result = new HashSet<String>();
        if (target == null || MessageUtils.isEmpty(target)) {
            return result;
        }
        for (String v : vs = target.split(regex)) {
            if (v == null || !MessageUtils.isNotEmpty(v.trim())) continue;
            result.add(v);
        }
        return result;
    }
}

