/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.message.utils.personalSetting;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.message.channel.cache.MsgServiceCacheHelper;
import kd.bos.message.menuconfig.MenuConfigUtil;
import kd.bos.message.menuconfig.MessageMenuConfigObject;
import kd.bos.message.mutilLange.MessageMultilangageUtils;
import kd.bos.message.utils.MessageConfigurationUtil;
import kd.bos.message.utils.MessageHtmlFormatUtil;
import kd.bos.message.utils.MessageUtils;
import kd.bos.message.utils.personalSetting.PersonalSettingInfo;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.portal.NewPortalServiceHelper;
import org.apache.commons.collections.CollectionUtils;
import org.jsoup.Jsoup;

public class MessagePersonalSettingUtils {
    private static Log logger = LogFactory.getLog(MessagePersonalSettingUtils.class);
    private static final String ENTITY_TASK = "wf_task";
    private static final String ENTITY_MSGMESSAGE = "wf_msg_message";
    private static final String ENTITY_PARTICIPANT = "wf_participant";
    private static final String ENTITY_CONFCENTER = "wf_confcenter";
    private static final String masterTableAlias = "a";
    private static final String multiLangTableAlias = "b";
    private static final String ALGOKEY = "messageCenter.queryGridData";
    private static final String VALUE = "value";
    private static final String ID = "id";
    private static final String TIME = "time";
    private static final String TITLE = "title";
    private static final String CONTENT = "content";
    private static final String CREATEDATE = "createdate";
    private static final String HANDLESTATE = "handlestate";
    private static final String CURRENTSUBJECT = "currentsubject";
    private static final String CREATEDATE_COMPARE = "createdateCompare";
    private static final String TIME_COMPARE = "timeCompare";
    private static final String RELIABILITY = "reliability";
    private static final String TASKID = "taskid";
    private static final String TASKTYPE = "taskType";
    private static final String COORDINATE = "coordinate";
    private static final String ENABLEUSERPERSONALSETTINGCACHE = "msg.enableUsePersonalSettingCache";
    private static final int TOPSIZE = 5;
    private static final int NEWTOPSIZE = 100;

    public static void updatePersonSourceIdsCache(Map<Long, List<PersonalSettingInfo>> personalSettingInfos) {
        if (personalSettingInfos == null || personalSettingInfos.isEmpty()) {
            return;
        }
        logger.info("updatePSTopIdsCache, PersonalSettingInfo" + personalSettingInfos.toString());
        Set<Map.Entry<Long, List<PersonalSettingInfo>>> entrySet = personalSettingInfos.entrySet();
        for (Map.Entry<Long, List<PersonalSettingInfo>> entry : entrySet) {
            Long userId = entry.getKey();
            String value = MsgServiceCacheHelper.getMsgPersonalSettingDataTopIdsCache(userId);
            if (StringUtils.isEmpty((CharSequence)value)) {
                logger.debug("updatePSTopIdsCache, no redis cache");
                continue;
            }
            try {
                List<PersonalSettingInfo> v1 = entry.getValue();
                if (v1 == null || v1.isEmpty()) {
                    MsgServiceCacheHelper.removeMsgPersonalSettingDataTopIdsCache(userId);
                    continue;
                }
                MessagePersonalSettingUtils.updatePersonalSettingSourceIdsCache(userId, v1, value);
            }
            catch (Exception e) {
                logger.warn("updatePSTopIdsCache hasError:" + MessageUtils.getExceptionStacktrace(e));
            }
        }
    }

    private static void updatePersonalSettingSourceIdsCache(Long userId, List<PersonalSettingInfo> personalSettingInfos, String cacheValue) {
        Map psCache = (Map)SerializationUtils.fromJsonString((String)cacheValue, Map.class);
        ArrayList<String> gatherTaskSourceIds = new ArrayList<String>();
        ArrayList<String> gatherMsgSourceIds = new ArrayList<String>();
        MessagePersonalSettingUtils.gatherAddSourceIds(personalSettingInfos, psCache, gatherTaskSourceIds, gatherMsgSourceIds);
        MessagePersonalSettingUtils.deleteSourceIdInCache(personalSettingInfos, psCache, gatherTaskSourceIds, gatherMsgSourceIds);
        MessagePersonalSettingUtils.wrapPSCacheReliability(gatherTaskSourceIds, psCache, PersonalSettingInfo.SourceTypeEnum.TASK);
        MessagePersonalSettingUtils.wrapPSCacheReliability(gatherMsgSourceIds, psCache, PersonalSettingInfo.SourceTypeEnum.MESSAGE);
        MsgServiceCacheHelper.putMsgPersonalSettingDataTopIdsCache(userId, SerializationUtils.toJsonString((Object)psCache));
    }

    private static void gatherAddSourceIds(List<PersonalSettingInfo> personalSettingInfos, Map<String, List<String>> psCache, List<String> gatherTaskSourceIds, List<String> gatherMsgSourceIds) {
        for (PersonalSettingInfo personalSettingInfo : personalSettingInfos) {
            if (PersonalSettingInfo.UpdateTypeEnum.ADDONE != personalSettingInfo.getUpdateType()) continue;
            PersonalSettingInfo.SourceTypeEnum sourceType = personalSettingInfo.getSourceType();
            List<String> targetIds = psCache.get(sourceType.getType());
            Long sourceId = personalSettingInfo.getSourceId();
            if (PersonalSettingInfo.SourceTypeEnum.TASK == sourceType) {
                if (MessagePersonalSettingUtils.isExistInCacheSource(targetIds, String.valueOf(sourceId))) continue;
                if (!personalSettingInfo.getParams().isEmpty() && personalSettingInfo.getParams().containsKey(TASKTYPE)) {
                    gatherTaskSourceIds.add(MessagePersonalSettingUtils.buildTaskSourceId(sourceId, personalSettingInfo.getDate(), COORDINATE));
                    continue;
                }
                gatherTaskSourceIds.add(MessagePersonalSettingUtils.buildTaskSourceId(sourceId, personalSettingInfo.getDate(), null));
                continue;
            }
            if (targetIds.contains(String.valueOf(sourceId))) continue;
            gatherMsgSourceIds.add(String.valueOf(sourceId));
        }
        List<String> taskIds = psCache.get(PersonalSettingInfo.SourceTypeEnum.TASK.getType());
        int pushSize1 = gatherTaskSourceIds.size();
        for (int i = 0; i < taskIds.size(); ++i) {
            gatherTaskSourceIds.add(pushSize1 + i, taskIds.get(i));
        }
        List<String> messageIds = psCache.get(PersonalSettingInfo.SourceTypeEnum.MESSAGE.getType());
        int pushSize2 = gatherMsgSourceIds.size();
        for (int i = 0; i < messageIds.size(); ++i) {
            gatherMsgSourceIds.add(pushSize2 + i, messageIds.get(i));
        }
    }

    private static void deleteSourceIdInCache(List<PersonalSettingInfo> personalSettingInfos, Map<String, List<String>> psCache, List<String> gatherTaskSourceIds, List<String> gatherMsgSourceIds) {
        for (PersonalSettingInfo personalSettingInfo : personalSettingInfos) {
            if (PersonalSettingInfo.UpdateTypeEnum.DELETEONE != personalSettingInfo.getUpdateType()) continue;
            PersonalSettingInfo.SourceTypeEnum sourceType = personalSettingInfo.getSourceType();
            Long sourceId = personalSettingInfo.getSourceId();
            if (PersonalSettingInfo.SourceTypeEnum.TASK == sourceType) {
                String id = null;
                for (String taskSourceId : gatherTaskSourceIds) {
                    if (taskSourceId.indexOf(String.valueOf(sourceId)) < 0) continue;
                    id = taskSourceId;
                    break;
                }
                if (id == null) continue;
                gatherTaskSourceIds.remove(id);
                continue;
            }
            gatherMsgSourceIds.remove(String.valueOf(sourceId));
        }
    }

    private static boolean isExistInCacheSource(List<String> targetIds, String key) {
        boolean isExistInCache = Boolean.FALSE;
        for (String targetId : targetIds) {
            if (!targetId.contains(key)) continue;
            isExistInCache = Boolean.TRUE;
            break;
        }
        return isExistInCache;
    }

    public static List<Map<String, Object>> getToHandleTaskUnreadMessageData(Long userId, int top, PersonalSettingInfo.SourceTypeEnum sourceType) {
        boolean isUseCache = MessagePersonalSettingUtils.enablePersonalSettingCache();
        logger.info("updatePSTopIdsCache, getPersonalSettingSourceisUseCache:" + isUseCache);
        List<Map<String, Object>> taskDataInfos = new ArrayList<Map<String, Object>>();
        try {
            List<Object> sourceIds = new ArrayList();
            sourceIds = isUseCache ? MessagePersonalSettingUtils.getTargetDataIds(userId, sourceType, top) : MessagePersonalSettingUtils.getIdsFromDataBase(userId, sourceType);
            taskDataInfos = MessagePersonalSettingUtils.getDataByIds(sourceIds, userId, sourceType, top);
        }
        catch (Exception e) {
            logger.info("updatePSTopIdsCache, getPersonalSettingSourceDataError:" + MessageUtils.getExceptionStacktrace(e));
        }
        return taskDataInfos;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static List<String> getTargetDataIds(Long userId, PersonalSettingInfo.SourceTypeEnum sourceType, int top) {
        List isReliability;
        List<String> targetIds;
        String value = MsgServiceCacheHelper.getMsgPersonalSettingDataTopIdsCache(userId);
        boolean targetTypeDataIdsNotExist = Boolean.TRUE;
        Map<String, List<String>> psCache = new HashMap();
        if (StringUtils.isNotEmpty((CharSequence)value)) {
            psCache = (Map)SerializationUtils.fromJsonString((String)value, Map.class);
            targetIds = (List<String>)psCache.get(sourceType.getType());
            if (targetIds != null) {
                JSONObject json;
                boolean isCacheReliability = true;
                List isReliability2 = (List)psCache.get(RELIABILITY);
                if (isReliability2 != null && !isReliability2.isEmpty() && (json = JSONObject.parseObject((String)((String)isReliability2.get(0)))).get((Object)sourceType.getType()) != null) {
                    isCacheReliability = (Boolean)json.get((Object)sourceType.getType());
                }
                if (targetIds.size() >= top || isCacheReliability) return targetIds;
                logger.info(String.format("updatePSTopIdsCache, user[%s], sourceType[%s] is not reliablility and reset doit", userId, sourceType.getType()));
                targetTypeDataIdsNotExist = Boolean.TRUE;
            }
        } else {
            psCache = new HashMap();
        }
        if (!targetTypeDataIdsNotExist) return Collections.emptyList();
        logger.debug("updatePSTopIdsCache, use DB");
        targetIds = MessagePersonalSettingUtils.getIdsFromDataBase(userId, sourceType);
        if (psCache.get(RELIABILITY) != null && !(isReliability = (List)psCache.get(RELIABILITY)).isEmpty()) {
            JSONObject json = JSONObject.parseObject((String)((String)isReliability.get(0)));
            json.remove((Object)sourceType.getType());
            isReliability.clear();
            isReliability.add(json.toJSONString());
        }
        MessagePersonalSettingUtils.wrapPSCacheReliability(targetIds, psCache, sourceType);
        MsgServiceCacheHelper.putMsgPersonalSettingDataTopIdsCache(userId, SerializationUtils.toJsonString(psCache));
        return targetIds;
    }

    private static void wrapPSCacheReliability(List<String> sourceIds, Map<String, List<String>> psCache, PersonalSettingInfo.SourceTypeEnum sourceType) {
        int topSize = MessagePersonalSettingUtils.getTopSize();
        if (sourceIds.size() >= topSize) {
            List<String> isReliability = psCache.get(RELIABILITY);
            JSONObject json = null;
            if (isReliability != null && !isReliability.isEmpty()) {
                isReliability = psCache.get(RELIABILITY);
                json = JSONObject.parseObject((String)isReliability.get(0));
            } else {
                isReliability = new ArrayList<String>(1);
                json = new JSONObject();
            }
            json.put(sourceType.getType(), (Object)false);
            isReliability.clear();
            isReliability.add(json.toJSONString());
            psCache.put(RELIABILITY, isReliability);
            if (sourceIds.size() > topSize) {
                sourceIds = sourceIds.subList(0, topSize);
            }
        }
        psCache.put(sourceType.getType(), sourceIds);
    }

    private static List<String> getIdsFromDataBase(Long userId, PersonalSettingInfo.SourceTypeEnum sourceType) {
        ArrayList<String> ids = new ArrayList<String>();
        StringBuilder sql = new StringBuilder();
        int topSize = MessagePersonalSettingUtils.getTopSize();
        if (PersonalSettingInfo.SourceTypeEnum.TASK == sourceType) {
            sql.append("select top ");
            sql.append(topSize);
            sql.append(" c.ftaskid id, c.fcreatedate createdate, c.ftype type ");
            sql.append("from t_wf_participant c ");
            sql.append("where c.fuserid = ? and c.fcompositetaskid = 0 and c.fisdisplay = '1' and c.ftaskid != 0 ");
            sql.append("order by c.fcreatedate desc;");
        } else {
            List<MessageMenuConfigObject> menuConfigObjects = MenuConfigUtil.getPersonMenuConfig();
            if (CollectionUtils.isEmpty(menuConfigObjects)) {
                return ids;
            }
            String ailsa = "";
            if (MessageConfigurationUtil.isRepaireMsgReceiverComplete().booleanValue()) {
                sql.append("select top ");
                sql.append(topSize);
                sql.append(" c.fmessageid id ");
                sql.append("from t_wf_msgreceiver c ");
                sql.append("where c.freceiverid = ? and c.freadstate = 'unread' ");
                ailsa = "c";
            } else {
                sql.append("select top ");
                sql.append(topSize);
                sql.append(" a.fid id ");
                sql.append("from  t_wf_message a left join t_wf_msgreceiver c on c.fmessageid = a.fid ");
                sql.append("where c.freceiverid = ? and c.freadstate = 'unread' ");
                ailsa = masterTableAlias;
            }
            StringBuilder values = new StringBuilder();
            for (int i = 0; i < menuConfigObjects.size(); ++i) {
                values.append(menuConfigObjects.get(i).getMsgtypeid());
                if (i >= menuConfigObjects.size() - 1) continue;
                values.append(",");
            }
            sql.append(" and ").append(ailsa).append(".ftype in (").append((CharSequence)values).append(") ");
            sql.append("order by c.fcreatedate desc;");
        }
        Object[] params = new Object[]{userId};
        try (DataSet dataSet = DB.queryDataSet((String)ALGOKEY, (DBRoute)DBRoute.workflow, (String)sql.toString(), (Object[])params);){
            if (dataSet == null) {
                ArrayList<String> i = ids;
                return i;
            }
            for (Row row : dataSet) {
                if (PersonalSettingInfo.SourceTypeEnum.TASK == sourceType) {
                    Date createDate = row.getDate(CREATEDATE);
                    if (createDate == null) continue;
                    ids.add(MessagePersonalSettingUtils.buildTaskSourceId(row.getLong(ID), createDate, row.getString("type")));
                    continue;
                }
                ids.add(row.getString(ID));
            }
        }
        return ids;
    }

    private static String buildTaskSourceId(Long taskId, Date createDate, String type) {
        if (type != null && COORDINATE.equalsIgnoreCase(type)) {
            return String.valueOf(taskId) + "-" + String.valueOf(createDate.getTime()) + "-1";
        }
        return String.valueOf(taskId) + "-" + String.valueOf(createDate.getTime());
    }

    private static List<Map<String, Object>> getDataByIds(List<String> ids, Long userId, final PersonalSettingInfo.SourceTypeEnum sourceType, int top) {
        Object subjectSQL;
        ArrayList<Map<String, Object>> dataInfos = new ArrayList<Map<String, Object>>();
        if (ids == null || ids.isEmpty()) {
            return dataInfos;
        }
        StringBuilder sql = new StringBuilder();
        String localeLang = RequestContext.get().getLang().toString();
        String idStr = "";
        HashMap<String, Date> mapping = new HashMap<String, Date>();
        ArrayList<Long> coordinateTaskIds = new ArrayList<Long>(ids.size());
        for (String id : ids) {
            String sourceId = "";
            if (PersonalSettingInfo.SourceTypeEnum.TASK == sourceType) {
                String[] idSplits = id.split("-");
                sourceId = idSplits[0];
                Date creatdate = new Date(Long.parseLong(idSplits[1]));
                mapping.put(sourceId, creatdate);
                if (idSplits.length == 3) {
                    coordinateTaskIds.add(Long.valueOf(sourceId));
                }
            } else {
                sourceId = id;
            }
            idStr = idStr + sourceId + ",";
        }
        String string = idStr = idStr.length() != 0 ? idStr.substring(0, idStr.length() - 1) : "";
        if (PersonalSettingInfo.SourceTypeEnum.TASK == sourceType) {
            String entityNameSQL = MessageMultilangageUtils.getGeneralLangSQL(ENTITY_TASK, masterTableAlias, multiLangTableAlias, "fentityName", "entityname", "entityname");
            String startNameSQL = MessageMultilangageUtils.getGeneralLangSQL(ENTITY_TASK, masterTableAlias, multiLangTableAlias, "fstartname", "startname", "startname");
            subjectSQL = MessageMultilangageUtils.getGeneralLangSQL(ENTITY_TASK, masterTableAlias, multiLangTableAlias, "fsubject", "subject", "subject");
            sql.append("select a.fid id, ");
            sql.append(entityNameSQL).append(", ");
            sql.append(startNameSQL).append(", ");
            sql.append((String)subjectSQL).append(", ");
            sql.append("a.fhandlestate handlestate ");
            sql.append("from t_wf_task a inner join t_wf_task_l b on a.fid = b.fid and b.flocaleid = '").append(localeLang).append("' ");
            sql.append("where a.fid in (").append(idStr).append(") ");
            sql.append("and a.fisdisplay = '1' and a.fendtype != 'mobile';");
        } else {
            String titleSQL = MessageMultilangageUtils.getGeneralLangSQL(ENTITY_MSGMESSAGE, masterTableAlias, multiLangTableAlias, "ftitle", TITLE, TITLE);
            sql.append("select a.fid id, ");
            sql.append(titleSQL).append(", ");
            sql.append("b.fcontent content,b.fcontent_summary contentsummary,a.fcontent_summary contentsummaryc,a.ftype type, a.fcreatedate createdate, a.fconfig config ");
            sql.append("from t_wf_message a left join t_wf_message_l b on a.fid = b.fid and b.flocaleid = '").append(localeLang).append("' ");
            sql.append("where a.fid in (").append(idStr).append(");");
        }
        try (DataSet dataSet = DB.queryDataSet((String)ALGOKEY, (DBRoute)DBRoute.workflow, (String)sql.toString(), null);){
            if (dataSet == null) {
                subjectSQL = dataInfos;
                return subjectSQL;
            }
            Iterator rows = dataSet.iterator();
            Map<Long, String> coordinateTaskInfos = null;
            if (!coordinateTaskIds.isEmpty()) {
                coordinateTaskInfos = MessagePersonalSettingUtils.getCoordinateTaskInfos(coordinateTaskIds, userId, localeLang);
            }
            while (rows.hasNext()) {
                Map param;
                Row row = (Row)rows.next();
                HashMap<String, Object> dataInfo = new HashMap<String, Object>();
                if (PersonalSettingInfo.SourceTypeEnum.TASK == sourceType) {
                    dataInfo.put(ID, row.getString(ID));
                    String title = String.format(ResManager.loadKDString((String)"%1$s\u63d0\u4ea4\u7684%2$s", (String)"MessagePersonalSettingUtils_1", (String)"bos-message-common", (Object[])new Object[0]), row.getString("startname"), row.getString("entityname"));
                    dataInfo.put(TITLE, title);
                    if (coordinateTaskInfos != null && coordinateTaskInfos.get(row.get(ID)) != null) {
                        dataInfo.put(CONTENT, coordinateTaskInfos.get(row.get(ID)));
                    } else {
                        dataInfo.put(CONTENT, row.getString("subject"));
                    }
                    dataInfo.put(HANDLESTATE, StringUtils.isNotEmpty((CharSequence)row.getString(HANDLESTATE)) ? MessagePersonalSettingUtils.getTaskStateName(row.getString(HANDLESTATE)) : "");
                    dataInfo.put(TIME, MessageMultilangageUtils.parseToUserZoneDate((Date)mapping.get(row.getString(ID)), false));
                    dataInfo.put(TIME_COMPARE, mapping.get(row.getString(ID)));
                    dataInfos.add(dataInfo);
                    continue;
                }
                String content = row.getString("contentsummary");
                if (StringUtils.isBlank((CharSequence)content) && StringUtils.isBlank((CharSequence)(content = row.getString("contentsummaryc")))) {
                    content = row.getString(CONTENT);
                }
                String title = row.getString(TITLE);
                String config = row.getString("config");
                if (MessageUtils.isNotEmpty(title) && title.contains("<") && title.contains(">") && MessageUtils.isNotEmpty(config) && !"{}".equals(config) && (param = (Map)SerializationUtils.fromJsonString((String)config, Map.class)).get("isTitleHtml") != null) {
                    title = Jsoup.parse((String)title).text();
                }
                dataInfo.put(ID, row.getLong(ID));
                dataInfo.put(TITLE, title);
                dataInfo.put(CONTENT, MessageHtmlFormatUtil.clearHtmlTags(content));
                dataInfo.put(HANDLESTATE, ResManager.loadKDString((String)"\u672a\u8bfb", (String)"MessagePersonalSettingUtils_2", (String)"bos-message-common", (Object[])new Object[0]));
                dataInfo.put(CREATEDATE, MessageMultilangageUtils.parseToUserZoneDate(row.getDate(CREATEDATE), false));
                dataInfo.put(CREATEDATE_COMPARE, row.getDate(CREATEDATE));
                dataInfos.add(dataInfo);
            }
        }
        Collections.sort(dataInfos, new Comparator<Map<String, Object>>(){

            @Override
            public int compare(Map<String, Object> df1, Map<String, Object> df2) {
                Date createDate1 = sourceType == PersonalSettingInfo.SourceTypeEnum.TASK ? (Date)df1.get(MessagePersonalSettingUtils.TIME_COMPARE) : (Date)df1.get(MessagePersonalSettingUtils.CREATEDATE_COMPARE);
                Date createDate2 = sourceType == PersonalSettingInfo.SourceTypeEnum.TASK ? (Date)df2.get(MessagePersonalSettingUtils.TIME_COMPARE) : (Date)df2.get(MessagePersonalSettingUtils.CREATEDATE_COMPARE);
                return createDate2.compareTo(createDate1);
            }
        });
        dataInfos = dataInfos.size() > top ? dataInfos.subList(0, top) : dataInfos;
        return dataInfos;
    }

    private static int getTopSize() {
        if (NewPortalServiceHelper.isPersonalSettingNewPortal()) {
            return 200;
        }
        return 40;
    }

    private static Map<Long, String> getCoordinateTaskInfos(List<Long> ids, Long userId, String lang) {
        HashMap<Long, String> coordinateTaskInfos = new HashMap<Long, String>(ids.size());
        QFilter f1 = new QFilter(TASKID, "in", ids);
        QFilter f2 = new QFilter("userid", "=", (Object)userId);
        DynamicObject[] participants = BusinessDataServiceHelper.load((String)ENTITY_PARTICIPANT, (String)"taskid,currentsubject", (QFilter[])new QFilter[]{f1, f2});
        if (participants != null && participants.length != 0) {
            for (DynamicObject participant : participants) {
                if (participant.getLocaleString(CURRENTSUBJECT) == null || !StringUtils.isNotBlank((CharSequence)((CharSequence)participant.getLocaleString(CURRENTSUBJECT).getItem(lang)))) continue;
                coordinateTaskInfos.put(participant.getLong(TASKID), (String)participant.getLocaleString(CURRENTSUBJECT).getItem(lang));
            }
        }
        return coordinateTaskInfos;
    }

    private static String getTaskStateName(String number) {
        String stateName = "";
        switch (number) {
            case "dismissed": {
                stateName = ResManager.loadKDString((String)"\u88ab\u9a73\u56de", (String)"MessagePersonalSettingUtils_3", (String)"bos-message-common", (Object[])new Object[0]);
                break;
            }
            case "willApproval": {
                stateName = ResManager.loadKDString((String)"\u5f85\u5ba1\u6279", (String)"MessagePersonalSettingUtils_4", (String)"bos-message-common", (Object[])new Object[0]);
                break;
            }
            case "freeze": {
                stateName = ResManager.loadKDString((String)"\u5df2\u51bb\u7ed3", (String)"MessagePersonalSettingUtils_5", (String)"bos-message-common", (Object[])new Object[0]);
                break;
            }
            case "willHandled": {
                stateName = ResManager.loadKDString((String)"\u5f85\u5904\u7406", (String)"MessagePersonalSettingUtils_6", (String)"bos-message-common", (Object[])new Object[0]);
                break;
            }
            case "unConverted": {
                stateName = ResManager.loadKDString((String)"\u5f85\u8f6c\u6362", (String)"MessagePersonalSettingUtils_7", (String)"bos-message-common", (Object[])new Object[0]);
                break;
            }
            case "converted": {
                stateName = ResManager.loadKDString((String)"\u5df2\u8f6c\u6362", (String)"MessagePersonalSettingUtils_8", (String)"bos-message-common", (Object[])new Object[0]);
                break;
            }
            case "converting": {
                stateName = ResManager.loadKDString((String)"\u8f6c\u6362\u4e2d", (String)"MessagePersonalSettingUtils_9", (String)"bos-message-common", (Object[])new Object[0]);
                break;
            }
            case "manualSuspended": {
                stateName = ResManager.loadKDString((String)"\u5df2\u6302\u8d77", (String)"MessagePersonalSettingUtils_10", (String)"bos-message-common", (Object[])new Object[0]);
                break;
            }
            default: {
                stateName = "";
            }
        }
        return stateName;
    }

    public static boolean enablePersonalSettingCache() {
        boolean enablePersonalSettingCache = false;
        try {
            QFilter qs = new QFilter("key", "=", (Object)ENABLEUSERPERSONALSETTINGCACHE);
            DynamicObject ret = BusinessDataServiceHelper.loadSingleFromCache((String)ENTITY_CONFCENTER, (String)VALUE, (QFilter[])new QFilter[]{qs});
            if (ret != null) {
                enablePersonalSettingCache = ret.getBoolean(VALUE);
            }
        }
        catch (Exception e) {
            logger.info("updatePSTopIdsCache, enablePersonalSettingCache function has exception:" + MessageUtils.getExceptionStacktrace(e));
        }
        return enablePersonalSettingCache;
    }
}

