/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.message.formplugin;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.IPageCache;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.message.api.EmailInfo;
import kd.bos.message.api.ShortMessageInfo;
import kd.bos.orm.util.ReflectionUtils;
import kd.bos.servicehelper.message.MessageServiceHelper;
import kd.bos.servicehelper.workflow.MessageCenterServiceHelper;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.msg.info.MessageAttachment;
import kd.bos.workflow.engine.msg.info.MessageInfo;

public class ContentTestPlugin
extends AbstractFormPlugin
implements ItemClickListener,
UploadListener {
    private static Log logger = LogFactory.getLog(ContentTestPlugin.class);
    private static final String CONTENT = "content";
    private static final String PHONE = "phone";
    private static final String EMAIL = "email";
    private static final String ATTACHMENTCACHE = "attachmentCache";
    private static final String[] badField = new String[]{"serialVersionUID", "attachment", "messageTitle", "messageContent"};

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Button btnUrl = (Button)this.getControl("btnok");
        btnUrl.addClickListener((ClickListener)this);
        AttachmentPanel dbspanel = (AttachmentPanel)this.getView().getControl("attachmentpanelap");
        dbspanel.addUploadListener((UploadListener)this);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        if (StringUtils.equals((CharSequence)source.getKey(), (CharSequence)"btnok")) {
            String body = (String)this.getModel().getValue(CONTENT);
            if (StringUtils.isNotBlank((CharSequence)body)) {
                JSONObject bodyJson = JSONObject.parseObject((String)body);
                String operationType = bodyJson.getString("operationtype");
                if ("sendmessage".equalsIgnoreCase(operationType)) {
                    this.sendMessage(bodyJson);
                } else if ("testimple".equalsIgnoreCase(operationType)) {
                    this.testOldMessageApi(bodyJson);
                } else {
                    this.testImplements(bodyJson);
                }
            } else {
                this.getView().showMessage("please input content json body.");
            }
        }
    }

    private void testOldMessageApi(JSONObject bodyJson) {
        String type = bodyJson.getString("type");
        String content = bodyJson.getString(CONTENT);
        if ("sms".equals(type)) {
            JSONArray phone = bodyJson.getJSONArray(PHONE);
            List receivers = JSONArray.parseArray((String)phone.toJSONString(), String.class);
            ShortMessageInfo info = new ShortMessageInfo();
            info.setMessage(content);
            info.setPhone(receivers);
            MessageServiceHelper.sendShortMessage((ShortMessageInfo)info);
        } else if (EMAIL.equals(type)) {
            JSONArray attachments;
            IPageCache pageCache;
            String attachmentCache;
            JSONArray secret;
            String title = bodyJson.getString("title");
            JSONArray email = bodyJson.getJSONArray(EMAIL);
            List receivers = JSONArray.parseArray((String)email.toJSONString(), String.class);
            EmailInfo info = new EmailInfo();
            info.setTitle(title);
            info.setContent(content);
            info.setReceiver(receivers);
            JSONArray copy = bodyJson.getJSONArray("copyReceiver");
            if (StringUtils.isNotBlank((Object)copy)) {
                List copyReceiver = JSONArray.parseArray((String)copy.toJSONString(), String.class);
                info.setCopyReceiver(copyReceiver);
            }
            if (StringUtils.isNotBlank((Object)(secret = bodyJson.getJSONArray("secretReceiver")))) {
                List secretReceiver = JSONArray.parseArray((String)secret.toJSONString(), String.class);
                info.setSecretReceiver(secretReceiver);
            }
            if (StringUtils.isNotBlank((CharSequence)(attachmentCache = (pageCache = this.getPageCache()).get(ATTACHMENTCACHE))) && (attachments = JSONArray.parseArray((String)attachmentCache)).size() > 0) {
                ArrayList<String> attachmentNames = new ArrayList<String>(attachments.size());
                ArrayList<byte[]> attachmentDatas = new ArrayList<byte[]>(attachments.size());
                for (int i = 0; i < attachments.size(); ++i) {
                    JSONObject attachment = attachments.getJSONObject(i);
                    String attachmentName = attachment.getString("name");
                    byte[] attachmentData = this.getAttachmentByteData(attachment.getString("url"));
                    attachmentNames.add(attachmentName);
                    attachmentDatas.add(attachmentData);
                }
                info.setAttachmentNames(attachmentNames);
                info.setAttachments(attachmentDatas);
            }
            MessageServiceHelper.sendEmail((EmailInfo)info);
        }
        this.getView().showMessage(ResManager.loadKDString((String)"\u53d1\u9001\u666e\u901a\u6d88\u606f\u7ed9\u201c\u7cfb\u7edf\u7ea7\u6d88\u606f\u52a9\u624b\u201d\u6210\u529f\u3002", (String)"ContentTestPlugin_3", (String)"bos-wf-message", (Object[])new Object[0]));
    }

    public void upload(UploadEvent uploadEvt) {
        Map url = (Map)uploadEvt.getUrls()[0];
        JSONObject attachment = new JSONObject();
        attachment.put("uid", (Object)((String)url.get("uid")));
        attachment.put("name", (Object)((String)url.get("name")));
        attachment.put("url", (Object)((String)url.get("url")));
        IPageCache pageCache = this.getPageCache();
        String attachmentCache = pageCache.get(ATTACHMENTCACHE);
        JSONArray attachments = new JSONArray();
        if (StringUtils.isNotBlank((CharSequence)attachmentCache)) {
            attachments = JSONArray.parseArray((String)attachmentCache);
        }
        attachments.add((Object)attachment);
        pageCache.put(ATTACHMENTCACHE, attachments.toJSONString());
    }

    public void remove(UploadEvent uploadEvt) {
        Map url = (Map)uploadEvt.getUrls()[0];
        String uid = (String)url.get("uid");
        IPageCache pageCache = this.getPageCache();
        String attachmentCache = pageCache.get(ATTACHMENTCACHE);
        if (StringUtils.isNotBlank((CharSequence)attachmentCache)) {
            JSONArray attachments = JSONArray.parseArray((String)attachmentCache);
            for (int i = 0; i < attachments.size(); ++i) {
                JSONObject attachment = attachments.getJSONObject(i);
                if (!attachment.getString("uid").equalsIgnoreCase(uid)) continue;
                attachments.remove((Object)attachment);
                break;
            }
            pageCache.put(ATTACHMENTCACHE, attachments.toJSONString());
        }
    }

    private void testImplements(JSONObject bodyJson) {
        String className = bodyJson.getString("class");
        String functionName = bodyJson.getString("functionname");
        JSONObject param = bodyJson.getJSONObject("param");
        try {
            Object[] parameterValues = new Object[param.size()];
            for (Map.Entry entry : param.entrySet()) {
                JSONObject p = param.getJSONObject((String)entry.getKey());
                int index = p.getIntValue("index");
                parameterValues[index] = p.get((Object)"value");
            }
            Class[] parameterClzzs = new Class[param.size()];
            Class clazz = TypesContainer.getOrRegister((String)className);
            Method[] methods = clazz.getMethods();
            Executable targetMethod = null;
            for (Method m : methods) {
                if (!m.getName().equalsIgnoreCase(functionName)) continue;
                targetMethod = m;
                break;
            }
            if (targetMethod == null) {
                return;
            }
            Parameter[] parameters = targetMethod.getParameters();
            for (int i = 0; i < parameters.length; ++i) {
                parameterClzzs[i] = parameters[i].getType();
            }
            Method method = clazz.getDeclaredMethod(functionName, parameterClzzs);
            Object result = method.invoke(clazz.newInstance(), parameterValues);
            this.getView().showMessage("method is invoke and the result:" + result);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            this.getView().showMessage("method is invoke and catch exception:" + e.getMessage());
        }
    }

    private void sendMessage(JSONObject bodyJson) {
        MessageInfo messageInfo = new MessageInfo();
        try {
            ContentTestPlugin.putPropertyValue(messageInfo, bodyJson);
        }
        catch (Exception e) {
            logger.debug(e.getMessage());
        }
        this.wrapMessageAttachment(messageInfo);
        this.wrapMessageContent(messageInfo);
        Long msgId = MessageCenterServiceHelper.sendMessage((MessageInfo)messageInfo);
        this.getView().showMessage(ResManager.loadKDString((String)"\u666e\u901a\u6d88\u606f\u53d1\u9001\u6210\u529f\u3002", (String)"ContentTestPlugin_4", (String)"bos-wf-message", (Object[])new Object[0]));
    }

    private void wrapMessageContent(MessageInfo messageInfo) {
    }

    private static void putPropertyValue(MessageInfo messageInfo, JSONObject bodyJson) throws Exception {
        Field[] fields;
        for (Field field : fields = messageInfo.getClass().getDeclaredFields()) {
            String paramName = field.getName();
            boolean belongToArr = false;
            for (int i = 0; i < badField.length; ++i) {
                if (!badField[i].equalsIgnoreCase(paramName)) continue;
                belongToArr = true;
                break;
            }
            if (Modifier.isFinal(field.getModifiers()) || belongToArr) continue;
            ReflectionUtils.makeAccessible((Field)field);
            String type = field.getGenericType().getTypeName();
            String paramValue = bodyJson.getString(paramName);
            if (!StringUtils.isNotBlank((CharSequence)paramValue)) continue;
            if (type.endsWith("Object")) {
                field.set(messageInfo, paramValue);
                continue;
            }
            if (type.contains("ILocaleString")) {
                if (!"senderName".equals(paramName) && !"tag".equals(paramName)) continue;
                ILocaleString lv = WfUtils.getMultiLangValue((String)paramValue);
                field.set(messageInfo, lv);
                continue;
            }
            if (type.endsWith("String")) {
                field.set(messageInfo, paramValue);
                continue;
            }
            if (type.endsWith("int") || type.endsWith("Integer")) {
                field.set(messageInfo, Integer.valueOf(paramValue));
                continue;
            }
            if (type.endsWith("boolean") || type.endsWith("Boolean")) {
                field.set(messageInfo, Boolean.valueOf(paramValue));
                continue;
            }
            if (type.endsWith("long") || type.endsWith("Long")) {
                field.set(messageInfo, Long.valueOf(paramValue));
                continue;
            }
            if (type.contains("java.util.List")) {
                List l = JSONArray.parseArray((String)bodyJson.getJSONArray(paramName).toJSONString(), Long.class);
                field.set(messageInfo, l);
                continue;
            }
            if (!type.contains("java.util.Map")) continue;
            Map m = (Map)JSON.toJavaObject((JSON)bodyJson.getJSONObject(paramName), Map.class);
            field.set(messageInfo, m);
        }
    }

    private void wrapMessageAttachment(MessageInfo messageInfo) {
        JSONArray attachments;
        IPageCache pageCache = this.getPageCache();
        String attachmentCache = pageCache.get(ATTACHMENTCACHE);
        if (StringUtils.isNotBlank((CharSequence)attachmentCache) && (attachments = JSONArray.parseArray((String)attachmentCache)).size() > 0) {
            ArrayList<String> attachmentNames = new ArrayList<String>(attachments.size());
            ArrayList<byte[]> attachmentDatas = new ArrayList<byte[]>(attachments.size());
            for (int i = 0; i < attachments.size(); ++i) {
                JSONObject attachment = attachments.getJSONObject(i);
                String attachmentName = attachment.getString("name");
                byte[] attachmentData = this.getAttachmentByteData(attachment.getString("url"));
                attachmentNames.add(attachmentName);
                attachmentDatas.add(attachmentData);
            }
            MessageAttachment messageAttachments = new MessageAttachment();
            messageAttachments.setAttachmentNames(attachmentNames);
            messageAttachments.setAttachments(attachmentDatas);
            messageInfo.setAttachment(messageAttachments);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] getAttachmentByteData(String url) {
        TempFileCache cache = CacheFactory.getCommonCacheFactory().getTempFileCache();
        InputStream is = cache.getInputStream(url);
        byte[] attachmentData = new byte[]{};
        try {
            attachmentData = this.input2byte(is);
        }
        catch (IOException e) {
            logger.debug(e.getMessage());
        }
        finally {
            try {
                if (null != is) {
                    is.close();
                }
            }
            catch (Exception e) {
                logger.debug(WfUtils.getExceptionStacktrace((Throwable)e));
            }
        }
        return attachmentData;
    }

    private byte[] input2byte(InputStream inStream) throws IOException {
        ByteArrayOutputStream swapStream = new ByteArrayOutputStream();
        byte[] buff = new byte[1024];
        int rc = 0;
        while ((rc = inStream.read(buff, 0, 1024)) > 0) {
            swapStream.write(buff, 0, rc);
        }
        byte[] in2b = swapStream.toByteArray();
        return in2b;
    }
}

