/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.message.formplugin;

import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DBRoute;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.Html;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.message.utils.MessageSystemParamterUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.report.ReportShowParameter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.workflow.engine.ArchiveService;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.msg.ArchiveRouteIndexCondition;
import kd.bos.workflow.message.service.util.MessageCacheUtils;
import kd.bos.workflow.message.service.util.MessageHtmlTagsWhiteList;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Attribute;
import org.jsoup.nodes.Attributes;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public class MessageContentPlugin
extends AbstractFormPlugin
implements ItemClickListener {
    private static Log logger = LogFactory.getLog(MessageContentPlugin.class);
    private static final String CONTENT = "content";
    private static final String CONTENTSUMMARY = "content_summary";
    private static final String CONTENTURL = "contenturl";
    private static final String MESSAGEENTITY = "wf_msg_message";
    private static final String DEADLETTERJOB = "wf_deadletterjob";
    private static final String TABKEY = "_submaintab_";
    private static final String FROMID = "formId";
    private static final String CAPTION = "caption";
    private static final String OPERATIONSTATUS = "operationStatus";
    private static final String VIEW = "view";
    private static final String EDIT = "edit";
    private static final String ADDNEW = "addnew";
    private static final String AUDIT = "audit";
    private static final String SUBMIT = "submit";
    private static final String OPENSTYLE = "openStyle";
    private static final String APPTYPE = "&apptype=";
    private static final String MCENTER = "mcenter";
    private static final String MSGID = "&msgId=";
    private static final String ID = "id";
    private static final String BILLFORMID = "billFormId";
    private static final int CONTENTSIZELIMIT = 0x100000;

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Button btnUrl = (Button)this.getControl(CONTENTURL);
        btnUrl.addClickListener((ClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        Pattern pattern;
        Matcher matcher;
        String content;
        Map systemNotice;
        String config;
        Map c;
        super.afterCreateNewData(e);
        this.getView().setVisible(Boolean.FALSE, new String[]{CONTENTURL});
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        DynamicObject messageObject = null;
        try {
            Long messageId = Long.valueOf((String)customParams.get("pkId"));
            messageObject = BusinessDataServiceHelper.loadSingle((Object)messageId, (String)MESSAGEENTITY);
            if (messageObject == null) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u60a8\u8981\u8bfb\u53d6\u7684\u6570\u636e\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\uff0c\u53ef\u80fd\u5df2\u7ecf\u88ab\u5220\u9664\u3002", (String)"MessageContentPlugin_1", (String)"bos-wf-message", (Object[])new Object[0]));
                return;
            }
            boolean isValidateReceiver = false;
            QFilter f1 = new QFilter("messageid", "=", (Object)messageId);
            Long userId = Long.valueOf(RequestContext.get().getUserId());
            QFilter f2 = new QFilter("receiverid", "=", (Object)userId);
            isValidateReceiver = QueryServiceHelper.exists((String)"wf_msg_receiver", (QFilter[])new QFilter[]{f1, f2});
            if (!isValidateReceiver) {
                logger.debug(String.format("MessageContentPlugin, messageId [%s] userId[%s] isValidateReceiver is false", messageId, userId));
                return;
            }
        }
        catch (Exception e2) {
            logger.warn(String.format("MessageContentPlugin, messageId [%s] is error: %s", customParams.get("pkId"), WfUtils.getExceptionStacktrace((Throwable)e2)));
        }
        if (messageObject == null) {
            logger.debug("MessageContentPlugin, message is null");
            return;
        }
        Html html = (Html)this.getView().getControl(CONTENT);
        ILocaleString contentStr = messageObject.getLocaleString(CONTENT);
        String messageContent = this.getMessageContent(contentStr, "");
        if (WfUtils.isEmpty((String)messageContent)) {
            ILocaleString contentSummary = messageObject.getLocaleString(CONTENTSUMMARY);
            if (WfUtils.isNotEmpty((ILocaleString)contentSummary)) {
                messageContent = contentSummary.toString();
            }
        } else {
            int maxLength = 524288;
            if (messageContent.length() > maxLength) {
                messageContent = messageContent.substring(0, maxLength);
            }
        }
        if (1223746113903789056L == messageObject.getLong("type") && !(c = (Map)SerializationUtils.fromJsonString((String)(config = messageObject.getString("config")), Map.class)).isEmpty() && StringUtils.isNotBlank(c.get("systemNotice")) && StringUtils.isNotBlank((systemNotice = (Map)c.get("systemNotice")).get("url"))) {
            String url = (String)systemNotice.get("url");
            messageContent = messageContent + "<a href='" + url + "' target='_blank'>" + ResManager.loadKDString((String)"\u67e5\u770b\u8be6\u60c5", (String)"MessageContentPlugin_2", (String)"bos-wf-message", (Object[])new Object[0]) + "</a>";
        }
        if (!(content = this.filterMessageCentent(messageContent)).contains("</table>") && (matcher = (pattern = Pattern.compile("(\r\n|\n)")).matcher(content)).find()) {
            content = matcher.replaceAll("<br/>");
        }
        html.setConent(content);
        String contentUrl = messageObject.getString(CONTENTURL);
        if (StringUtils.isNotEmpty((CharSequence)contentUrl)) {
            StringBuilder newContentUrl = new StringBuilder(contentUrl);
            Map paramMap = WfUtils.parseUrlParams((String)(contentUrl = newContentUrl.append(APPTYPE).append(MCENTER).append(MSGID).append(messageObject.getLong(ID)).toString()));
            String formId = (String)paramMap.get(FROMID);
            if (formId != null && DEADLETTERJOB.equalsIgnoreCase(formId)) {
                Long deadletterJobId = Long.parseLong((String)paramMap.get("pkId"));
                boolean deadLetterJobIsExist = QueryServiceHelper.exists((String)DEADLETTERJOB, (Object)deadletterJobId);
                if (deadLetterJobIsExist) {
                    this.getPageCache().put(CONTENTURL, contentUrl);
                    this.getView().setVisible(Boolean.TRUE, new String[]{CONTENTURL});
                } else {
                    this.getView().setVisible(Boolean.FALSE, new String[]{CONTENTURL});
                }
            } else {
                this.getPageCache().put(CONTENTURL, contentUrl);
                this.getView().setVisible(Boolean.TRUE, new String[]{CONTENTURL});
            }
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{CONTENTURL});
        }
    }

    private String filterMessageCentent(String content) {
        String htmlContent = this.isNeedSanitizeHtml(content);
        if (StringUtils.isBlank((CharSequence)htmlContent)) {
            htmlContent = Jsoup.parse((String)content).text();
        }
        return htmlContent;
    }

    private String isNeedSanitizeHtml(String content) {
        Map<String, String> htmlTagsWhiteList = MessageHtmlTagsWhiteList.getWhitelist();
        String htmlContent = content;
        try {
            if (content.contains("<") && content.contains(">")) {
                Document doc = Jsoup.parse((String)content);
                Elements elems = doc.getAllElements();
                for (int i = 0; i < elems.size(); ++i) {
                    String tagName = ((Element)elems.get(i)).tagName();
                    if ("#root".equals(tagName) || "html".equals(tagName) || "head".equals(tagName) || "body".equals(tagName) || !StringUtils.isNotBlank((CharSequence)tagName)) continue;
                    if (!htmlTagsWhiteList.containsKey(tagName)) {
                        return null;
                    }
                    String tagProperty = htmlTagsWhiteList.get(tagName);
                    Attributes attributes = ((Element)elems.get(i)).attributes();
                    List attributeList = attributes.asList();
                    for (int j = attributeList.size() - 1; j >= 0; --j) {
                        Attribute attribute = (Attribute)attributeList.get(j);
                        if (!tagProperty.contains(attribute.getKey()) && !StringUtils.equals((CharSequence)attribute.getKey(), (CharSequence)"style")) {
                            return null;
                        }
                        if ("href".equals(attribute.getKey()) && "a".equals(tagName) && !this.isURLWhiteList(attribute.getValue())) {
                            logger.info("nodisable url is : " + attribute.getValue());
                            String value = attribute.getValue();
                            value = value.replaceAll("\\(", "\\\\(");
                            value = value.replaceAll("\\)", "\\\\)");
                            Pattern pattern = Pattern.compile("href=(\\s*)(\"|')?" + value + "(\\s*)(\"|')?", 2);
                            Matcher matcher = pattern.matcher(htmlContent);
                            htmlContent = matcher.replaceAll("");
                        }
                        if (!attribute.getKey().startsWith("on")) continue;
                        return null;
                    }
                }
            }
        }
        catch (Exception e) {
            htmlContent = null;
            logger.info("MessageContestPlugin -- isNeedSanitizeHtml : parse messagecontent is fail :" + e.getMessage());
        }
        return htmlContent;
    }

    private boolean isURLWhiteList(String url) {
        if (StringUtils.isNotBlank((CharSequence)url)) {
            String linkWhiteList = MessageSystemParamterUtils.getLinkWhiteList();
            logger.info("whiteList is :" + linkWhiteList + "url is" + url);
            String[] linkArr = linkWhiteList.split(",");
            for (int i = 0; i < linkArr.length; ++i) {
                if (!url.startsWith(linkArr[i])) continue;
                return true;
            }
        }
        return false;
    }

    public void beforeClosed(BeforeClosedEvent e) {
        IPageCache pageCache = this.getPageCache();
        pageCache.remove(CONTENTURL);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        if (StringUtils.equals((CharSequence)source.getKey(), (CharSequence)CONTENTURL)) {
            Map map = this.getView().getFormShowParameter().getCustomParams();
            Long messageId = Long.parseLong((String)map.get("pkId"));
            boolean exists = QueryServiceHelper.exists((String)MESSAGEENTITY, (Object)messageId);
            if (!exists) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u60a8\u8981\u8bfb\u53d6\u7684\u6570\u636e\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\uff0c\u53ef\u80fd\u5df2\u7ecf\u88ab\u5220\u9664\u3002", (String)"MessageContentPlugin_1", (String)"bos-wf-message", (Object[])new Object[0]));
                return;
            }
            this.showContentPage(messageId, this.getPageCache().get(CONTENTURL));
        }
    }

    private void showContentPage(long messageId, String url) {
        this.showContent(this.getView(), messageId, url, 1);
    }

    public void showContent(IFormView view, long messageId, String url, int type) {
        String entityId;
        boolean needCheckRightAppId = false;
        Object val = WfConfigurationUtil.getConfigCenterVal((String)"msg.needCheckRightAppId");
        if (val != null && "true".equals(val)) {
            needCheckRightAppId = true;
        }
        IFormView messageListView = null;
        if (type == 1) {
            messageListView = view.getParentView();
        } else if (type == 2) {
            messageListView = view;
        }
        if (messageListView == null) {
            return;
        }
        IFormView messageCenterView = messageListView.getParentView();
        if (MessageContentPlugin.hasCurrentPageTab(view, messageCenterView, messageId)) {
            return;
        }
        ReportShowParameter viewParameter = null;
        Map paramMap = WfUtils.parseUrlParams((String)url);
        paramMap.put("isIgnoreLicense", Boolean.TRUE);
        String formId = (String)paramMap.get(FROMID);
        if (WfUtils.isEmpty((String)formId)) {
            messageListView.showMessage(ResManager.loadKDString((String)"\u60a8\u8981\u8bfb\u53d6\u7684\u6570\u636e\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\uff0c\u53ef\u80fd\u5df2\u7ecf\u88ab\u5220\u9664\u3002", (String)"MessageContentPlugin_1", (String)"bos-wf-message", (Object[])new Object[0]));
            return;
        }
        ShowType openStyle = ShowType.NewTabPage;
        if (paramMap.get(OPENSTYLE) != null) {
            String os = (String)paramMap.get(OPENSTYLE);
            openStyle = os.equalsIgnoreCase("modal") ? ShowType.Modal : ShowType.NewTabPage;
        }
        if (WfUtils.isTileMenuModel()) {
            openStyle = ShowType.MainNewTabPage;
        }
        String billFormId = "";
        if ("bos_list".equals(formId) && StringUtils.isNotBlank(paramMap.get(BILLFORMID))) {
            billFormId = (String)paramMap.get(BILLFORMID);
            entityId = FormMetadataCache.getFormConfig((String)billFormId).getEntityTypeId();
        } else {
            entityId = FormMetadataCache.getFormConfig((String)formId).getEntityTypeId();
        }
        MainEntityType entityType = null;
        if (WfUtils.isNotEmpty((String)entityId)) {
            entityType = EntityMetadataCache.getDataEntityType((String)entityId);
        }
        if (entityType instanceof BillEntityType) {
            if (paramMap.containsKey("type") && "list".equals(paramMap.get("type"))) {
                ListShowParameter parameter = new ListShowParameter();
                parameter.setPageId(MessageContentPlugin.getPageId(messageCenterView, messageId, type));
                parameter.getOpenStyle().setTargetKey(TABKEY);
                parameter.getOpenStyle().setShowType(openStyle);
                parameter.setCustomParams(paramMap);
                if (StringUtils.isNotBlank(paramMap.get(CAPTION))) {
                    parameter.setCaption((String)paramMap.get(CAPTION));
                }
                billFormId = StringUtils.isNotBlank((CharSequence)billFormId) ? billFormId : (String)paramMap.get(FROMID);
                parameter.setBillFormId(billFormId);
                String lisdFormId = StringUtils.isBlank(paramMap.get("list_formId")) ? "bos_list" : (String)paramMap.get("list_formId");
                parameter.setFormId(lisdFormId);
                if (needCheckRightAppId) {
                    parameter.setCustomParam("checkRightAppId", (Object)MessageContentPlugin.getEntityAppId(billFormId));
                } else {
                    parameter.setHasRight(Boolean.TRUE.booleanValue());
                }
                viewParameter = parameter;
            } else {
                BillShowParameter parameter = new BillShowParameter();
                parameter.setPageId(MessageContentPlugin.getPageId(messageCenterView, messageId, type));
                parameter.getOpenStyle().setTargetKey(TABKEY);
                parameter.getOpenStyle().setShowType(openStyle);
                parameter.setCustomParams(paramMap);
                if (StringUtils.isNotBlank(paramMap.get(CAPTION))) {
                    parameter.setCaption((String)paramMap.get(CAPTION));
                }
                parameter.setFormId(formId);
                parameter.setPkId((Object)((String)paramMap.get("pkId")));
                if (needCheckRightAppId) {
                    parameter.setCustomParam("checkRightAppId", (Object)MessageContentPlugin.getEntityAppId(formId));
                } else {
                    parameter.setHasRight(Boolean.TRUE.booleanValue());
                }
                Object operationStatus = paramMap.get(OPERATIONSTATUS);
                if (VIEW.equals(operationStatus)) {
                    parameter.setBillStatus(BillOperationStatus.VIEW);
                } else if (EDIT.equals(operationStatus)) {
                    parameter.setBillStatus(BillOperationStatus.EDIT);
                } else if (ADDNEW.equals(operationStatus)) {
                    parameter.setPkId(null);
                    parameter.setBillStatus(BillOperationStatus.ADDNEW);
                } else if (AUDIT.equals(operationStatus)) {
                    parameter.setBillStatus(BillOperationStatus.AUDIT);
                } else if (SUBMIT.equals(operationStatus)) {
                    parameter.setBillStatus(BillOperationStatus.SUBMIT);
                }
                viewParameter = parameter;
            }
        } else if (paramMap.containsKey("type") && "report".equals(paramMap.get("type"))) {
            ReportShowParameter parameter = new ReportShowParameter();
            parameter.setPageId(MessageContentPlugin.getPageId(messageCenterView, messageId, type));
            parameter.getOpenStyle().setTargetKey(TABKEY);
            parameter.getOpenStyle().setShowType(openStyle);
            parameter.setCustomParams(paramMap);
            if (StringUtils.isNotBlank(paramMap.get(CAPTION))) {
                parameter.setCaption((String)paramMap.get(CAPTION));
            }
            parameter.setFormId(formId);
            if (needCheckRightAppId) {
                parameter.setCustomParam("checkRightAppId", (Object)MessageContentPlugin.getEntityAppId(formId));
            } else {
                parameter.setHasRight(Boolean.TRUE.booleanValue());
            }
            viewParameter = parameter;
        } else {
            FormShowParameter parameter = new FormShowParameter();
            parameter.setPageId(MessageContentPlugin.getPageId(messageCenterView, messageId, type));
            parameter.getOpenStyle().setTargetKey(TABKEY);
            parameter.getOpenStyle().setShowType(openStyle);
            parameter.setCustomParams(paramMap);
            if (StringUtils.isNotBlank(paramMap.get(CAPTION))) {
                parameter.setCaption((String)paramMap.get(CAPTION));
            }
            if ("botp_convertop".equals(formId)) {
                parameter.setFormId("wf_approvalpage_bac");
                parameter.setCustomParam("onlyView", (Object)Boolean.TRUE);
            } else {
                parameter.setFormId(formId);
                if (needCheckRightAppId) {
                    parameter.setCustomParam("checkRightAppId", (Object)MessageContentPlugin.getEntityAppId(formId));
                }
            }
            this.setArchiveRoute4WF(parameter);
            Object operationStatus = paramMap.get(OPERATIONSTATUS);
            if (VIEW.equals(operationStatus)) {
                parameter.setStatus(OperationStatus.VIEW);
            } else if (EDIT.equals(operationStatus)) {
                parameter.setStatus(OperationStatus.EDIT);
            } else if (ADDNEW.equals(operationStatus)) {
                parameter.setStatus(OperationStatus.ADDNEW);
            }
            parameter.setHasRight(Boolean.TRUE.booleanValue());
            viewParameter = parameter;
        }
        if (null != messageCenterView) {
            messageCenterView.showForm((FormShowParameter)viewParameter);
            view.sendFormAction(messageCenterView);
        } else {
            viewParameter.getOpenStyle().setShowType(ShowType.NonModal);
            view.showForm((FormShowParameter)viewParameter);
        }
    }

    private void setArchiveRoute4WF(FormShowParameter parameter) {
        String formId = parameter.getFormId();
        if (parameter.getCustomParam("pkId") != null && ("wf_approvalpage_bac".equals(formId) || "wf_approvalpageview_bac".equals(formId) || "wf_approvalbill".equals(formId) || "wf_approvalbill_view".equals(formId) || "wf_approvalpageud_flofull".equals(formId) || "wf_approvalpageud_tifull".equals(formId))) {
            ArchiveRouteIndexCondition condition;
            String businessKey = (String)parameter.getCustomParam("pkId");
            ArchiveService archiveService = ArchiveService.create();
            String archiveRouteKey = archiveService.injectArchiveRouteInfo("wf_hiprocinst", condition = new ArchiveRouteIndexCondition("businessKey", (Object)businessKey));
            if (WfUtils.isNotEmpty((String)archiveRouteKey) && !DBRoute.workflow.getRouteKey().equalsIgnoreCase(archiveRouteKey) && !WfUtils.WFS.getRouteKey().equalsIgnoreCase(archiveRouteKey)) {
                parameter.setCustomParam("routeKey", (Object)WfUtils.WFS.getRouteKey());
                parameter.setCustomParam("archiveRouteKey", (Object)archiveRouteKey);
            }
        }
    }

    private String getMessageContent(ILocaleString contentStr, String messageContent) {
        if (WfUtils.isNotEmpty((ILocaleString)contentStr) && WfUtils.isEmpty((String)(messageContent = contentStr.getLocaleValue()))) {
            messageContent = contentStr.toString();
        }
        return messageContent;
    }

    @Deprecated
    public static boolean hasCurrentPageTab(IFormView view, long messageId, int type) {
        return false;
    }

    private static boolean hasCurrentPageTab(IFormView view, IFormView messageCenterView, long messageId) {
        IFormView targetTabFormView;
        String pageKey;
        IPageCache messageCenterPageCache = (IPageCache)messageCenterView.getService(IPageCache.class);
        String pageId = messageCenterPageCache.get(pageKey = MessageContentPlugin.getPageKey(messageCenterView, messageId));
        if (WfUtils.isNotEmpty((String)pageId) && (targetTabFormView = messageCenterView.getViewNoPlugin(pageId)) != null) {
            targetTabFormView.activate();
            view.sendFormAction(targetTabFormView);
            return true;
        }
        return false;
    }

    public static String getPageId(IFormView messsageCenterView, long messageId, int type) {
        String pageId = UUID.randomUUID().toString();
        IPageCache messageCenterPageCache = (IPageCache)messsageCenterView.getService(IPageCache.class);
        String pageKey = MessageContentPlugin.getPageKey(messsageCenterView, messageId);
        messageCenterPageCache.put(pageKey, pageId);
        return pageId;
    }

    private static String getPageKey(IFormView view, long messageId) {
        return messageId + RequestContext.get().getUserId() + view.getPageId();
    }

    private static String getEntityAppId(String formId) {
        String ret = "";
        if (WfUtils.isEmpty((String)formId)) {
            return ret;
        }
        ret = MessageCacheUtils.getCheckRightAppId(formId);
        logger.debug(String.format("open formId:%s , checkrightappid is %s", formId, ret));
        return ret;
    }
}

