/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.message.formplugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.workflow.engine.WfUtils;

public class MessageDuplicateLogPlugin
extends AbstractFormPlugin {
    private static Log logger = LogFactory.getLog(MessageDuplicateLogPlugin.class);
    private static final String ID = "id";
    private static final String NAME = "name";
    private static final String REFEX = ",";

    public void afterBindData(EventObject e) {
        this.getView().setStatus(OperationStatus.VIEW);
        ArrayList<Long> userIds = new ArrayList<Long>();
        String receiverIds = (String)this.getModel().getValue("receiver");
        if (WfUtils.isNotEmpty((String)receiverIds)) {
            String[] rIds = receiverIds.split(REFEX);
            try {
                userIds.addAll(Stream.of(rIds).map(item -> Long.parseLong(item)).collect(Collectors.toList()));
                userIds = userIds.size() > 100 ? userIds.subList(0, 100) : userIds;
            }
            catch (Exception ex) {
                logger.info("afterBindData occur error" + ex.getMessage());
            }
        }
        boolean senderReceiveMsg = false;
        String senderId = (String)this.getModel().getValue("sender");
        if (WfUtils.isNotEmpty((String)senderId) && !senderId.equals("0")) {
            if (userIds.contains(Long.parseLong(senderId))) {
                senderReceiveMsg = true;
            } else {
                userIds.add(Long.parseLong(senderId));
            }
        }
        if (userIds.isEmpty()) {
            return;
        }
        QFilter[] filters = new QFilter[]{new QFilter(ID, "in", userIds)};
        DynamicObject[] userDatas = BusinessDataServiceHelper.load((String)"bos_user", (String)"id, name", (QFilter[])filters);
        if (userDatas == null || userDatas.length == 0) {
            return;
        }
        DynamicObject sender = null;
        if (WfUtils.isNotEmpty((String)senderId) && !senderId.equals("0")) {
            sender = Stream.of(userDatas).filter(user -> user.getString(ID).equals(senderId)).findFirst().orElse(null);
            if (sender != null) {
                this.getModel().setValue("sendername", (Object)sender.getLocaleString(NAME).toString());
            }
        } else {
            ILocaleString senderName = WfUtils.getPromptWordLocaleString((String)"\u7cfb\u7edf\u53d1\u9001", (String)"MessageListPlugin_1", (String)"bos-wf-message");
            this.getModel().setValue("sendername", (Object)senderName.toString());
        }
        List receiverNames = Stream.of(userDatas).filter(user -> !user.getString(ID).equals(senderId)).map(user -> user.getLocaleString(NAME).toString()).collect(Collectors.toList());
        if (sender != null && senderReceiveMsg) {
            receiverNames.add(sender.getLocaleString(NAME).toString());
        }
        if (receiverNames != null && !receiverNames.isEmpty()) {
            this.getModel().setValue("receivername", (Object)String.join((CharSequence)REFEX, receiverNames));
        } else {
            this.getModel().setValue("receivername", (Object)receiverIds);
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        e.setCheckDataChange(false);
    }
}

