/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.message.formplugin;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.dlock.DLock;
import kd.bos.dlock.DLockInfo;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.message.channel.cache.MsgServiceCache;
import kd.bos.message.channel.cache.MsgServiceCacheHelper;
import kd.bos.message.utils.MessageUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.concurrent.ConcurrentBizType;
import kd.bos.workflow.engine.msg.MessageServiceUtil;
import kd.bos.workflow.engine.msg.quantitysum.MessageQuantitySummaryServcie;
import kd.bos.workflow.message.service.impl.MigrateDBData2WfFromSysImpl;
import kd.bos.workflow.message.service.impl.UpdateMsgChannelImpl;
import kd.bos.workflow.message.service.util.MessageCacheUtils;

public class MessageToolsPlugin
extends AbstractFormPlugin
implements ItemClickListener {
    private static final String ENTITYNUMBER = "msg_tools";
    private static final String BTN_MIGRATEDATA = "migratedata";
    private static final String BTN_CLEARCHANNEL = "clearchannel";
    private static final String BTN_CLEARTYPE = "cleartype";
    private static final String BTN_CLEARTPL = "cleartpl";
    private static final String BTN_QUERYCHANNEL = "querychannel";
    private static final String BTN_QUERYTYPE = "querytype";
    private static final String BTN_QUERYTPL = "querytpl";
    private static final String BTN_CORRECTQUANTITYSUM = "correctquantitysum";
    private static final String BTN_CORRECTAllUSERQUANTITYSUM = "correctalllqs";
    private static final String BTN_CORRECTUSER = "correctuser";
    private static final String BTN_QUERYQS = "queryqs";
    private static final String BTN_PUSHQS = "pushqs";
    private static final String BTN_UPDATEEMAIL = "updateemail";
    private static final String BTN_DELETEQS = "deleteqs";
    private static final String CHOOSEUSER = "chooseuser";
    private static final String QSVALUE = "qsvalue";
    private static final String UPDATETASKBILLTYPE = "updatebilltype";
    private static final String QUEREYPSTOP = "querypstop";
    private static final String PUSHPSTOP = "pushpstop";
    private static final String DELETEPSTOP = "deletepstop";
    private static final String CHOOSEPSUSER = "choosepsuser";
    private static final String QSPSTOPVALUE = "qspsvalue";
    private static final String CACHEKEY = "cachekey";
    private static final String CACHETYPE = "cachetype";
    private static final String CACHEVALUE = "cachevalue";
    private static final String BTN_QUERYCACHE = "querycache";
    private static final String BTN_CLEARCACHE = "clearcache";
    private static final String BTN_QUERYINFO = "queryinfo";
    private static final String BTN_CLEARNAVENTITYNAME = "clearquerynaventityname";
    private static final String NAVENTITYNAMEVALUE = "naventitynamecache";
    private static final String BTN_CLEARALLUSERQUANTITYSUMMARYDATA = "clearqsdata";
    private static final String BTN_CLEARCONSURRENTKEY = "clearconcurrentkey";
    private static final String BTN_CLEARCONSURRENTLOCK = "clearconcurrentlock";
    private static final String BTN_QUERYCHANNELCONFIG = "querychannelconfig";
    private static final String BTN_PUSHCHANNELCONFIG = "pushchannleconfig";
    private static final String CHOOSECHANNLE = "choosechannel";
    private static final String CHANNELCONFIG = "channelconfig";
    private static final String FIELD_ENTITYNUMBER = "entitynumber";
    private static final String EXECUTION_SELECT = "entitynumber, billtype, entrabillname";
    private static final String TASK_SELECT = "entitynumber, billtype, entityname";
    private static final String FIELD_TASKBILLNAME = "entityname";
    private static final String FIELD_EXECUTIONBILLNAME = "entrabillname";
    private static final String[] UPDATEBILLTYPEENTITYARR = new String[]{"wf_task", "wf_hitaskinst", "wf_execution", "wf_hiprocinst"};
    private static final String BTN_YZJTODO = "yzjtodo";
    private static final String BTN_YZJNEWTODO = "yzjnewtodo";
    private static final String BTN_GETDDTASK = "getddtask";
    private static final String BTN_DINGTODO = "dingtodo";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTN_MIGRATEDATA, BTN_CLEARCHANNEL, BTN_CLEARTYPE, BTN_CLEARTPL, BTN_QUERYCHANNEL, BTN_QUERYTYPE, BTN_QUERYTPL, BTN_CORRECTQUANTITYSUM, BTN_CORRECTAllUSERQUANTITYSUM, BTN_QUERYQS, BTN_PUSHQS, BTN_DELETEQS, UPDATETASKBILLTYPE, QUEREYPSTOP, PUSHPSTOP, DELETEPSTOP, BTN_QUERYCACHE, BTN_CLEARCACHE, BTN_QUERYINFO, BTN_CLEARNAVENTITYNAME, BTN_CLEARALLUSERQUANTITYSUMMARYDATA, BTN_CLEARCONSURRENTKEY, BTN_CLEARCONSURRENTLOCK, BTN_QUERYCHANNELCONFIG, BTN_PUSHCHANNELCONFIG, BTN_UPDATEEMAIL, BTN_YZJTODO, BTN_YZJNEWTODO, BTN_GETDDTASK, BTN_DINGTODO});
        BasedataEdit bosUserF7 = (BasedataEdit)this.getControl(BTN_CORRECTUSER);
        bosUserF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            FormShowParameter parameter = beforeF7SelectEvent.getFormShowParameter();
            parameter.setCustomParam("externalUserType", (Object)"all");
        });
        BasedataEdit chooseUser = (BasedataEdit)this.getControl(CHOOSEUSER);
        chooseUser.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            FormShowParameter parameter = beforeF7SelectEvent.getFormShowParameter();
            parameter.setCustomParam("externalUserType", (Object)"all");
        });
    }

    public void click(EventObject evt) {
        String key;
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "migratedata": {
                this.migrateDataByHandle();
                break;
            }
            case "clearchannel": {
                this.clearRedisCache(BTN_CLEARCHANNEL);
                break;
            }
            case "cleartype": {
                this.clearRedisCache(BTN_CLEARTYPE);
                break;
            }
            case "cleartpl": {
                this.clearRedisCache(BTN_CLEARTPL);
                break;
            }
            case "querychannel": {
                this.queryRedisCacheData(BTN_QUERYCHANNEL);
                break;
            }
            case "querytype": {
                this.queryRedisCacheData(BTN_QUERYTYPE);
                break;
            }
            case "querytpl": {
                this.queryRedisCacheData(BTN_QUERYTPL);
                break;
            }
            case "correctquantitysum": {
                this.correctMsgQuantitySummary();
                break;
            }
            case "correctalllqs": {
                this.correctAllUserQuantitySummary();
                break;
            }
            case "queryqs": {
                this.quantitySummaryOpertion(BTN_QUERYQS);
                break;
            }
            case "pushqs": {
                this.quantitySummaryOpertion(BTN_PUSHQS);
                break;
            }
            case "deleteqs": {
                this.quantitySummaryOpertion(BTN_DELETEQS);
                break;
            }
            case "updatebilltype": {
                this.updateBillTypeAndBillName();
                break;
            }
            case "querypstop": {
                this.perosnalSettingTopSourceIds(QUEREYPSTOP);
                break;
            }
            case "pushpstop": {
                this.perosnalSettingTopSourceIds(PUSHPSTOP);
                break;
            }
            case "deletepstop": {
                this.perosnalSettingTopSourceIds(DELETEPSTOP);
                break;
            }
            case "querycache": {
                this.handleMsgCache(BTN_QUERYCACHE);
                break;
            }
            case "clearcache": {
                this.handleMsgCache(BTN_CLEARCACHE);
                break;
            }
            case "queryinfo": {
                this.queryTenantAndDataBaseInfo();
                break;
            }
            case "clearquerynaventityname": {
                this.clearNavEntityNameCache();
                break;
            }
            case "clearqsdata": {
                this.clearAllUserQuantitySummaryDataAndCache();
                break;
            }
            case "clearconcurrentkey": {
                this.clearConcurrentThread(BTN_CLEARCONSURRENTKEY);
                break;
            }
            case "clearconcurrentlock": {
                this.clearConcurrentThread(BTN_CLEARCONSURRENTLOCK);
                break;
            }
            case "pushchannleconfig": {
                this.wrapChannelConfig(BTN_PUSHCHANNELCONFIG);
                break;
            }
            case "querychannelconfig": {
                this.wrapChannelConfig(BTN_QUERYCHANNELCONFIG);
                break;
            }
            case "updateemail": {
                this.updateAuthAndProtocol();
                break;
            }
            case "yzjtodo": {
                this.showTodoState("yunzhijia");
                break;
            }
            case "yzjnewtodo": {
                this.showTodoState("yunzhijiaup");
                break;
            }
            case "getddtask": {
                this.showDDTaskList();
                break;
            }
            case "dingtodo": {
                this.showDingTodoState();
                break;
            }
        }
    }

    private void showTodoState(String channelNumber) {
        if (!WfConfigurationUtil.isYunzhijiaEnable()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e91\u4e4b\u5bb6\u6e20\u9053\u5df2\u5173\u95ed\u3002", (String)"MessageToolsPlugin_1", (String)"bos-wf-message", (Object[])new Object[0]));
            return;
        }
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("wf_todostate");
        parameter.setCustomParam("channelNumber", (Object)channelNumber);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        if ("yunzhijia".equalsIgnoreCase(channelNumber)) {
            parameter.setCaption(ResManager.loadKDString((String)"\u4e91\u4e4b\u5bb6\u5f85\u529e\u4efb\u52a1\u5904\u7406", (String)"MessageToolsPlugin_2", (String)"bos-wf-message", (Object[])new Object[0]));
        } else {
            parameter.setCaption(ResManager.loadKDString((String)"\u4e91\u4e4b\u5bb6\u7edf\u4e00\u6d41\u7a0b\u4e2d\u5fc3\u5f85\u529e\u4efb\u52a1\u5904\u7406", (String)"MessageToolsPlugin_3", (String)"bos-wf-message", (Object[])new Object[0]));
        }
        this.getView().showForm(parameter);
    }

    private void showDDTaskList() {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("wf_searchddtask");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(parameter);
    }

    private void showDingTodoState() {
        if (!WfConfigurationUtil.isDDEnable()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u9489\u9489\u201d\u672a\u542f\u7528\u3002", (String)"EventLogEntryListPlugin_3", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            return;
        }
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("wf_dingtodostate");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCaption(ResManager.loadKDString((String)"\u9489\u9489\u5f85\u529e\u5904\u7406", (String)"EventLogEntryListPlugin_4", (String)"bos-wf-formplugin", (Object[])new Object[0]));
        this.getView().showForm(parameter);
    }

    private void wrapChannelConfig(String btnType) {
        Object value = this.getModel().getValue(CHOOSECHANNLE);
        if (value == null) {
            this.getView().showTipNotification("please choose channle", Integer.valueOf(3000));
            return;
        }
        long id = ((DynamicObject)value).getLong("id");
        QFilter[] filters = new QFilter[]{new QFilter("id", "=", (Object)id)};
        DynamicObject[] channles = BusinessDataServiceHelper.load((String)"msg_channel", (String)"id,number,enable,config", (QFilter[])filters);
        if (channles == null || channles.length == 0) {
            return;
        }
        DynamicObject channel = channles[0];
        if (BTN_QUERYCHANNELCONFIG.equals(btnType)) {
            String config = channel.getString("config");
            this.getModel().setValue(CHANNELCONFIG, (Object)config);
            this.getView().showSuccessNotification("queryDone", Integer.valueOf(3000));
        } else {
            String config = (String)this.getModel().getValue(CHANNELCONFIG);
            if (WfUtils.isEmpty((String)config)) {
                this.getView().showErrorNotification("input value is null.");
                return;
            }
            JSONObject configJson = null;
            try {
                configJson = JSONObject.parseObject((String)config);
            }
            catch (Exception e) {
                this.getView().showErrorNotification(String.format("[%s] is not JSONObject format.", config));
                return;
            }
            String originalConfig = channel.getString("config");
            String newConfigStr = "";
            if (configJson != null && !configJson.isEmpty()) {
                HashMap newConfig = new HashMap(configJson.size());
                for (Map.Entry entry : configJson.entrySet()) {
                    newConfig.put(entry.getKey(), entry.getValue());
                }
                newConfigStr = SerializationUtils.toJsonString(newConfig);
                channel.set("config", (Object)newConfigStr);
                SaveServiceHelper.save((DynamicObject[])channles);
                boolean enable = channel.getBoolean("enable");
                String number = channel.getString("number");
                MsgServiceCache.refreshMsgChannelCacheInfo((String)number, (!enable ? 1 : 0) != 0);
            }
            this.getView().showSuccessNotification(String.format("PushDone, originalConfig:[%s], newConfig[%s]", originalConfig, newConfigStr), Integer.valueOf(5000));
        }
    }

    private void clearConcurrentThread(String keyOrLock) {
        String notify = String.format("clear %s success", keyOrLock);
        ConcurrentBizType bizType = ConcurrentBizType.MESSAGEQUANTITYSUMMARY;
        if (BTN_CLEARCONSURRENTKEY.equals(keyOrLock)) {
            MsgServiceCacheHelper.removeConcurrentDataSign((String)bizType.getType());
        } else {
            String key = "wf_dealConcurrentData_" + bizType.getType();
            DLockInfo lockInfo = DLock.getLockInfo((String)key);
            if (lockInfo != null) {
                DLock.forceClear((String[])new String[]{key});
            } else {
                notify = "";
            }
        }
        this.getView().showTipNotification(notify, Integer.valueOf(3000));
    }

    private void clearAllUserQuantitySummaryDataAndCache() {
        boolean isTruncate = Boolean.TRUE;
        int userSize = 0;
        String sql = "select fuserid userid from t_msg_quantitysum tmq where 1=1 group by fuserid;";
        try (DataSet queryDataSet = DB.queryDataSet((String)"query_all_qs_user", (DBRoute)DBRoute.workflow, (String)sql);){
            for (Row row : queryDataSet) {
                Long userId = row.getLong("userid");
                MsgServiceCacheHelper.removeMsgQuantitySummaryCache((Long)userId);
                ++userSize;
            }
        }
        catch (Exception e) {
            this.getView().showErrorNotification(WfUtils.getExceptionStacktrace((Throwable)e));
            isTruncate = Boolean.FALSE;
        }
        if (isTruncate) {
            String sql1 = "delete from t_msg_quantitysum;";
            DB.execute((DBRoute)DBRoute.workflow, (String)sql1);
            this.getView().showSuccessNotification(String.format("Clear User[%s] QuantitySummary RedisCache and TableData;", userSize), Integer.valueOf(3000));
            String description = String.format("user[%s] operation[%s]", RequestContext.get().getUserId(), "truncateQSTable");
            this.addOperateLog("clearAllUserQuantitySummaryDataAndCache", new MultiLangEnumBridge("\u6e05\u7406\u7edf\u8ba1\u8868", "MessageToolsPlugin_0", "bos-wf-message"), description);
        }
    }

    private void clearNavEntityNameCache() {
        String entityNameCache = MsgServiceCacheHelper.getMCEntityNameCache();
        this.getModel().setValue(NAVENTITYNAMEVALUE, (Object)entityNameCache);
        MsgServiceCacheHelper.removeMCEntityNameCache();
        this.getView().showSuccessNotification("success", Integer.valueOf(3000));
    }

    private void queryTenantAndDataBaseInfo() {
        RequestContext requestContext = RequestContext.get();
        String tenantId = requestContext.getTenantCode();
        String accountId = requestContext.getAccountId();
        this.getModel().setValue("tenantinfo", (Object)String.format("tenantId: [%s] and accountId: [%s]", tenantId, accountId));
    }

    private void handleMsgCache(String btnType) {
        Object key = this.getModel().getValue(CACHEKEY);
        if (key == null) {
            this.getView().showTipNotification("please input cacheKey.");
            return;
        }
        String keyStr = String.valueOf(key);
        String type = (String)this.getModel().getValue(CACHETYPE);
        String value = null;
        if ("String".equalsIgnoreCase(type)) {
            if (btnType.equalsIgnoreCase(BTN_QUERYCACHE)) {
                value = MsgServiceCacheHelper.getCache((String)keyStr);
            } else {
                MsgServiceCacheHelper.deleteCache((String)keyStr);
            }
        } else if ("hash".equalsIgnoreCase(type)) {
            String[] keys = keyStr.split(",");
            if (btnType.equalsIgnoreCase(BTN_QUERYCACHE)) {
                value = MsgServiceCacheHelper.getCache((String)keys[0], (String)keys[1]);
            } else {
                MsgServiceCacheHelper.deleteCache((String)keys[0], (String)keys[1]);
            }
        } else if ("set".equalsIgnoreCase(type)) {
            if (btnType.equalsIgnoreCase(BTN_QUERYCACHE)) {
                String[] vs = MsgServiceCacheHelper.getMessageCache().getSetValues(keyStr);
                StringBuilder sb = new StringBuilder();
                if (vs != null && vs.length > 0) {
                    for (String vsItem : vs) {
                        sb.append(vsItem).append(" | ");
                    }
                }
                value = sb.toString();
            } else {
                MsgServiceCacheHelper.deleteCache((String)keyStr);
            }
        } else if ("list".equalsIgnoreCase(type)) {
            if (btnType.equalsIgnoreCase(BTN_QUERYCACHE)) {
                String[] vs = MsgServiceCacheHelper.getMessageCache().getList(keyStr);
                StringBuilder sb = new StringBuilder();
                if (vs != null && vs.length > 0) {
                    for (String vsItem : vs) {
                        sb.append(vsItem).append(" | ");
                    }
                }
                value = sb.toString();
            } else {
                MsgServiceCacheHelper.deleteCache((String)keyStr);
            }
        }
        this.getModel().setValue(CACHEVALUE, (Object)value);
        this.getView().showSuccessNotification("query msg redis cache success");
    }

    private void perosnalSettingTopSourceIds(String opera) {
        Object qsUserValue;
        Object user = this.getModel().getValue(CHOOSEPSUSER);
        Long userId = null;
        userId = StringUtils.isBlank((Object)user) ? Long.valueOf(Long.parseLong(RequestContext.get().getUserId())) : Long.valueOf(Long.parseLong(((DynamicObject)user).getString("id")));
        if (DELETEPSTOP.equals(opera)) {
            MsgServiceCacheHelper.removeMsgPersonalSettingDataTopIdsCache((Long)userId);
        } else if (PUSHPSTOP.equals(opera)) {
            qsUserValue = this.getModel().getValue(QSPSTOPVALUE);
            MsgServiceCacheHelper.putMsgPersonalSettingDataTopIdsCache((Long)userId, (String)((String)qsUserValue));
        } else {
            qsUserValue = MsgServiceCacheHelper.getMsgPersonalSettingDataTopIdsCache((Long)userId);
            this.getModel().setValue(QSPSTOPVALUE, qsUserValue);
        }
        this.getView().showSuccessNotification(opera + " is successful");
        String description = String.format("user[%s] operation[%s] psTopSourceIds by operator[%s]", userId, opera, RequestContext.get().getUserId());
        this.addOperateLog("do perosnalSettingTopSourceIds", new MultiLangEnumBridge("\u5904\u7406\u4e2a\u4eba\u4e2d\u5fc3top\u6570\u636e", "MessageToolsPlugin_4", "bos-wf-message"), description);
    }

    private void quantitySummaryOpertion(String opera) {
        Object qsValue;
        Long operationUserId = null;
        Object chooseUser = this.getModel().getValue(CHOOSEUSER);
        operationUserId = StringUtils.isBlank((Object)chooseUser) ? Long.valueOf(Long.parseLong(RequestContext.get().getUserId())) : Long.valueOf(((DynamicObject)chooseUser).getLong("id"));
        if (BTN_DELETEQS.equals(opera)) {
            MsgServiceCacheHelper.removeMsgQuantitySummaryCache((Long)operationUserId);
            QFilter[] filters = new QFilter[]{new QFilter("userid", "=", (Object)operationUserId)};
            DeleteServiceHelper.delete((String)"msg_quantitysum", (QFilter[])filters);
        } else if (BTN_PUSHQS.equals(opera)) {
            qsValue = this.getModel().getValue(QSVALUE);
            MsgServiceCacheHelper.putMsgQuantitySummaryCache((Long)operationUserId, (String)String.valueOf(qsValue));
        } else {
            qsValue = MsgServiceCacheHelper.getMsgQuantitySummaryCache((Long)operationUserId);
            this.getModel().setValue(QSVALUE, qsValue);
        }
        String description = String.format("user[%s] operation[%s] quantitySummary by operator[%s]", operationUserId, opera, RequestContext.get().getUserId());
        this.getView().showSuccessNotification(description, Integer.valueOf(3000));
        this.addOperateLog("do quantitySummary", new MultiLangEnumBridge("\u5904\u7406\u7edf\u8ba1\u8868\u6570\u636e", "MessageToolsPlugin_5", "bos-wf-message"), description);
    }

    private void correctAllUserQuantitySummary() {
        String confirmTips = "This process is time-consuming. Are you sure you want to continue?";
        this.getView().showConfirm(confirmTips, MessageBoxOptions.OKCancel, ConfirmTypes.Default, new ConfirmCallBackListener("corrextAllUserQs"));
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if ("corrextAllUserQs".equals(callBackId) && messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            String sql = "select fuserid userid from t_msg_quantitysum tmq where 1=1 group by fuserid;";
            ArrayList<Long> userIds = new ArrayList<Long>();
            try (DataSet dataSet = DB.queryDataSet((String)"correctAllQuantitySummaryFromBizData", (DBRoute)DBRoute.workflow, (String)sql, null);){
                if (dataSet != null) {
                    Iterator iter = dataSet.iterator();
                    while (iter.hasNext()) {
                        userIds.add(((Row)iter.next()).getLong("userid"));
                    }
                }
            }
            catch (Exception e) {
                this.getView().showMessage(String.format("correctAllQuantitySummaryFromBizData and sql[%s], message[%s]", sql, MessageUtils.getExceptionStacktrace((Throwable)e)));
            }
            Long t1 = System.currentTimeMillis();
            MessageQuantitySummaryServcie service = MessageServiceUtil.getMessageQuantitySummaryService();
            service.correctQuantitySummaryFromBizData(userIds);
            Long t2 = System.currentTimeMillis();
            this.getView().showMessage(String.format("Correct All User QuantitySum Is Successful, User Size Is %s, Take Time %s ms", userIds.size(), t2 - t1));
            String description = String.format("correct all user messge quantitySummary by operator[%s]", RequestContext.get().getUserId());
            this.addOperateLog("correct all user quantitySummary", new MultiLangEnumBridge("\u6821\u6b63\u6240\u6709\u7528\u6237\u6d88\u606f\u6570\u91cf\u7edf\u8ba1", "MessageToolsPlugin_8", "bos-wf-message"), description);
        }
    }

    private void correctMsgQuantitySummary() {
        Long t1 = System.currentTimeMillis();
        Long correctUserId = null;
        Object correctUser = this.getModel().getValue(BTN_CORRECTUSER);
        correctUserId = StringUtils.isBlank((Object)correctUser) ? Long.valueOf(Long.parseLong(RequestContext.get().getUserId())) : Long.valueOf(((DynamicObject)correctUser).getLong("id"));
        QFilter f1 = new QFilter("type", "=", (Object)"messageQuantitySummary");
        QFilter f2 = new QFilter("state", "=", (Object)"create");
        QFilter f3 = new QFilter("data", "like", (Object)("%" + correctUserId + "%"));
        boolean exists = QueryServiceHelper.exists((String)"wf_concurrentdata", (QFilter[])new QFilter[]{f1, f2, f3});
        if (exists) {
            this.getView().showTipNotification(String.format("the concurrent data pool has %s data, cant correct qs!", correctUserId), Integer.valueOf(3000));
            return;
        }
        MessageQuantitySummaryServcie service = MessageServiceUtil.getMessageQuantitySummaryService();
        service.correctQuantitySummaryFromBizData(correctUserId);
        Long t2 = System.currentTimeMillis();
        this.getView().showMessage(String.format("Correct All User QuantitySum Is Successful, User Is %s, Take Time %sms", correctUserId, t2 - t1));
        String description = String.format("correct messge quantitySummary of user[%s] by operator[%s]", correctUserId, RequestContext.get().getUserId());
        this.addOperateLog("correct quantitySummary", new MultiLangEnumBridge("\u6821\u6b63\u7528\u6237\u6d88\u606f\u6570\u91cf\u7edf\u8ba1", "MessageToolsPlugin_9", "bos-wf-message"), description);
    }

    private void queryRedisCacheData(String btnNumber) {
        Object msgNumber = this.getModel().getValue("msgnumber");
        if (StringUtils.isBlank((Object)msgNumber)) {
            this.getView().showMessage("Please input target number");
            return;
        }
        Map<String, Object> cacheResult = null;
        if (btnNumber.equalsIgnoreCase(BTN_QUERYCHANNEL)) {
            cacheResult = MessageCacheUtils.queryChannelCacheData((String)msgNumber);
        } else if (btnNumber.equalsIgnoreCase(BTN_QUERYTYPE)) {
            cacheResult = MessageCacheUtils.queryTypeCacheData((String)msgNumber);
        } else if (btnNumber.equalsIgnoreCase(BTN_QUERYTPL)) {
            cacheResult = MessageCacheUtils.queryTemplateCacheData((String)msgNumber);
        }
        if (cacheResult != null && cacheResult.size() != 0) {
            this.getModel().setValue("msgkey", cacheResult.get("key"));
            this.getModel().setValue("msgvalue", cacheResult.get("value"));
        }
        String descirption = String.format("user[%s] operate [%s] by buttion [%s]", RequestContext.get().getUserId(), msgNumber, btnNumber);
        this.addOperateLog(btnNumber, new MultiLangEnumBridge("\u67e5\u8be2\u7f13\u5b58\u6570\u636e", "MessageToolsPlugin_7", "bos-wf-message"), descirption);
    }

    private void migrateDataByHandle() {
        MigrateDBData2WfFromSysImpl migrateData = new MigrateDBData2WfFromSysImpl();
        Map<String, Object> resMap = migrateData.beforeExecuteSql(null, null, null, null);
        String tableName = (String)resMap.get("tableName");
        String description = RequestContext.get().getUserName() + "[" + RequestContext.get().getUserId() + "] migrate sys data to wfs";
        this.addOperateLog(BTN_MIGRATEDATA, new MultiLangEnumBridge("\u624b\u52a8\u8fc1\u79fbsys\u5e93msg\u7684\u6570\u636e\u5230wfs\u5e93", "MessageToolsPlugin_10", "bos-wf-message"), description);
        this.getView().showMessage("migrate sys data to wfs that is successful, \r\n update table size is " + tableName.split(",").length + " this is table name: \r\n" + tableName);
    }

    private void clearRedisCache(String btnNumber) {
        Object msgNumber = null;
        if (btnNumber.equalsIgnoreCase(BTN_CLEARCHANNEL)) {
            msgNumber = this.getModel().getValue("channelnumber");
            MessageCacheUtils.clearMessageChannelCache((String)msgNumber);
        } else if (btnNumber.equalsIgnoreCase(BTN_CLEARTYPE)) {
            msgNumber = this.getModel().getValue("typenumber");
            MessageCacheUtils.clearMessageTypeCache((String)msgNumber);
        } else if (btnNumber.equalsIgnoreCase(BTN_CLEARTPL)) {
            msgNumber = this.getModel().getValue("tplnumber");
            MessageCacheUtils.clearMessageTemplateCache((String)msgNumber);
        }
        String description = String.format("user[%s] Clear Redis CacheData of %s is OK", RequestContext.get().getUserId(), msgNumber);
        this.addOperateLog("clearRedisCache", new MultiLangEnumBridge("\u6e05\u7406\u7f13\u5b58", "MessageToolsPlugin_11", "bos-wf-message"), description);
        this.getView().showMessage(description);
    }

    private void addOperateLog(String opKey, MultiLangEnumBridge opNameBridge, String operateDescription) {
        MessageUtils.addOperateLog((String)ENTITYNUMBER, (String)opKey, (MultiLangEnumBridge)opNameBridge, null, (Object[])new Object[]{operateDescription});
    }

    private void updateBillTypeAndBillName() {
        HashMap<String, LocaleString> updateBills = new HashMap<String, LocaleString>();
        ArrayList<String> faillist = new ArrayList<String>(UPDATEBILLTYPEENTITYARR.length);
        for (int i = 0; i < UPDATEBILLTYPEENTITYARR.length; ++i) {
            List<String> needUpdateBillNumbers = this.getNeedUpdateBilltypes(UPDATEBILLTYPEENTITYARR[i]);
            if (needUpdateBillNumbers.isEmpty()) continue;
            this.findBillNameByNumbers(needUpdateBillNumbers, updateBills);
            if (!updateBills.isEmpty() && !this.updateTable(UPDATEBILLTYPEENTITYARR[i], needUpdateBillNumbers, updateBills)) {
                faillist.add(UPDATEBILLTYPEENTITYARR[i]);
            }
            String description = String.format("user[%s] update billName of range[%s] and result[%s]", RequestContext.get().getUserId(), needUpdateBillNumbers.toString(), ((Object)updateBills).toString());
            this.addOperateLog("updateBillTypeAndBillName", new MultiLangEnumBridge("\u66f4\u65b0\u5355\u636e\u7c7b\u578b\u548c\u5355\u636e\u540d\u79f0\u5b57\u6bb5", "MessageToolsPlugin_6", "bos-wf-message"), description);
        }
        if (faillist.isEmpty()) {
            this.getView().showTipNotification("update billtype success");
        } else {
            this.getView().showErrorNotification(String.format("update billtype fail, fail tables is %s", ((Object)faillist).toString()));
        }
    }

    public List<String> getNeedUpdateBilltypes(String tableName) {
        String sql = String.format("select fentitynumber number from %s where fentitynumber != fbilltype group BY fentitynumber", "t_" + tableName);
        ArrayList<String> entityNumbers = new ArrayList<String>();
        try (DataSet ds = DB.queryDataSet((String)"MessageToolsPlugin.getNeedUpdateBilltype", (DBRoute)DBRoute.workflow, (String)sql);){
            Iterator iter = ds.iterator();
            if (iter.hasNext()) {
                entityNumbers.add(((Row)iter.next()).getString("number"));
            }
        }
        return entityNumbers;
    }

    private void findBillNameByNumbers(List<String> needUpdateBillNumbers, Map<String, LocaleString> updateBills) {
        int len = needUpdateBillNumbers.size();
        for (int i = 0; i < len; ++i) {
            if (!StringUtils.isBlank((Object)updateBills.get(needUpdateBillNumbers.get(i)))) continue;
            updateBills.put(needUpdateBillNumbers.get(i), WfUtils.getEntityNameByNumber((String)needUpdateBillNumbers.get(i)));
        }
    }

    private boolean updateTable(String dyobj, List<String> updateBilltypes, Map<String, LocaleString> updateBills) {
        try {
            String entityNameField;
            String selectFields;
            if ("wf_task".equals(dyobj) || "wf_hitaskinst".equals(dyobj)) {
                selectFields = TASK_SELECT;
                entityNameField = FIELD_TASKBILLNAME;
            } else {
                selectFields = EXECUTION_SELECT;
                entityNameField = FIELD_EXECUTIONBILLNAME;
            }
            QFilter filter = new QFilter(FIELD_ENTITYNUMBER, "in", updateBilltypes).and("billtype", "not in", updateBilltypes);
            DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)dyobj, (String)selectFields, (QFilter[])new QFilter[]{filter});
            ArrayList<DynamicObject> batchArray = new ArrayList<DynamicObject>(dynamicObjects.length);
            for (int i = 0; i < dynamicObjects.length; ++i) {
                dynamicObjects[i].set("billtype", dynamicObjects[i].get(FIELD_ENTITYNUMBER));
                dynamicObjects[i].set(entityNameField, (Object)updateBills.get(dynamicObjects[i].get(FIELD_ENTITYNUMBER)));
                batchArray.add(dynamicObjects[i]);
                if (batchArray.size() < 5000) continue;
                SaveServiceHelper.save((DynamicObject[])batchArray.toArray(new DynamicObject[0]));
                batchArray.clear();
            }
            SaveServiceHelper.save((DynamicObject[])batchArray.toArray(new DynamicObject[0]));
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private void updateAuthAndProtocol() {
        new UpdateMsgChannelImpl().beforeExecuteSql(null, null, null, null);
        this.getView().showSuccessNotification("pushDone", Integer.valueOf(3000));
    }
}

