/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.message.formplugin;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.msg.info.ParticipantInfo;
import kd.bos.workflow.engine.msg.info.TaskEntityInfo;
import kd.bos.workflow.message.service.impl.MessageCenterServiceImpl;

public class TaskModelApiTestPlugin
extends AbstractFormPlugin {
    private static final String BTN_CREATE = "create";
    private static final String BTN_DELETE = "delete";
    private static final String BTN_UPDATE = "update";
    private static final String BTN_COMPLATE = "complate";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{BTN_CREATE, BTN_DELETE, BTN_UPDATE, BTN_COMPLATE});
        BasedataEdit starterUserF7 = (BasedataEdit)this.getControl("starterid");
        starterUserF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            FormShowParameter parameter = beforeF7SelectEvent.getFormShowParameter();
            parameter.setCustomParam("externalUserType", (Object)"all");
        });
        BasedataEdit participantF7 = (BasedataEdit)this.getControl("participantinfo");
        participantF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            FormShowParameter parameter = beforeF7SelectEvent.getFormShowParameter();
            parameter.setCustomParam("externalUserType", (Object)"all");
        });
    }

    public void afterCreateNewData(EventObject e) {
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        String btnKey = source.getKey();
        try {
            Map<Object, Object> res = new HashMap();
            if (BTN_CREATE.equalsIgnoreCase(btnKey)) {
                res = this.createTask();
            } else if (BTN_DELETE.equalsIgnoreCase(btnKey)) {
                res = this.deleteTasks();
            } else if (BTN_UPDATE.equalsIgnoreCase(btnKey)) {
                res = this.updateParticipants();
            } else if (BTN_COMPLATE.equalsIgnoreCase(btnKey)) {
                res = this.complateTasks();
            }
            if (((Boolean)res.get("success")).booleanValue()) {
                this.getView().showSuccessNotification(String.format("invoke task api successfully and %s", res.get("data")));
            } else {
                this.getView().showErrorNotification((String)res.get("description"));
            }
        }
        catch (Exception e) {
            this.getView().showErrorNotification(WfUtils.getExceptionStacktrace((Throwable)e));
        }
    }

    private Map<String, Object> deleteTasks() {
        String taskIdStr = (String)this.getModel().getValue("taskids_delete");
        ArrayList<Long> taskIds = new ArrayList<Long>();
        if (!WfUtils.isEmpty((String)taskIdStr)) {
            String[] tIds;
            for (String tID : tIds = taskIdStr.split(",")) {
                taskIds.add(Long.parseLong(tID));
            }
        }
        MessageCenterServiceImpl messageCenterServiceImpl = new MessageCenterServiceImpl();
        return messageCenterServiceImpl.batchDeleteTasks(taskIds);
    }

    private Map<String, Object> updateParticipants() {
        String taskId = (String)this.getModel().getValue("taskid");
        String userIdStr = (String)this.getModel().getValue("userids");
        ArrayList<Long> userIds = new ArrayList<Long>();
        if (!WfUtils.isEmpty((String)userIdStr)) {
            String[] tIds;
            for (String tID : tIds = userIdStr.split(",")) {
                userIds.add(Long.parseLong(tID));
            }
        }
        MessageCenterServiceImpl messageCenterServiceImpl = new MessageCenterServiceImpl();
        return messageCenterServiceImpl.updateTaskParticipant(Long.parseLong(taskId), userIds);
    }

    private Map<String, Object> complateTasks() {
        String taskIdStr = (String)this.getModel().getValue("taskids1");
        ArrayList<Long> taskIds = new ArrayList<Long>();
        if (!WfUtils.isEmpty((String)taskIdStr)) {
            String[] tIds;
            for (String tID : tIds = taskIdStr.split(",")) {
                taskIds.add(Long.parseLong(tID));
            }
        }
        String userId = (String)this.getModel().getValue("userid");
        Object op = this.getModel().getValue("opinion");
        ILocaleString opinion = null;
        if (op != null) {
            opinion = (ILocaleString)op;
        }
        String param = (String)this.getModel().getValue("variables");
        JSONObject bodyJson = JSONObject.parseObject((String)param);
        Map m = (Map)JSON.toJavaObject((JSON)bodyJson, Map.class);
        MessageCenterServiceImpl messageCenterServiceImpl = new MessageCenterServiceImpl();
        return messageCenterServiceImpl.batchComplateTasks(taskIds, Long.parseLong(userId), opinion, m);
    }

    private Map<String, Object> createTask() {
        ILocaleString name = (ILocaleString)this.getModel().getValue("name");
        ILocaleString subject = (ILocaleString)this.getModel().getValue("subject");
        ILocaleString description = (ILocaleString)this.getModel().getValue("description");
        String endType = (String)this.getModel().getValue("endtype");
        Date dueDate = null;
        String taskCategory = (String)this.getModel().getValue("category");
        String formKey = (String)this.getModel().getValue("formkey");
        String mobileFormKey = (String)this.getModel().getValue("mobileformkey");
        boolean display = (Boolean)this.getModel().getValue("display");
        Long starterId = 0L;
        DynamicObject starter = (DynamicObject)this.getModel().getValue("starterid");
        if (starter != null) {
            starterId = (Long)starter.getPkValue();
        }
        String businessKey = (String)this.getModel().getValue("businesskey");
        String billNo = (String)this.getModel().getValue("billno");
        String entitynumber = "";
        DynamicObject entity = (DynamicObject)this.getModel().getValue("entitynumber");
        if (entity != null) {
            entitynumber = entity.getString("number");
        }
        String processingPage = (String)this.getModel().getValue("processingpage");
        String processingMobilePage = (String)this.getModel().getValue("processingMobilePage");
        String validate = (String)this.getModel().getValue("validate");
        JSONObject json = JSON.parseObject((String)validate);
        LinkedHashMap<String, Object> validateOperation = new LinkedHashMap<String, Object>();
        validateOperation.put("type", "");
        validateOperation.put("microservice", "");
        validateOperation.put("value", "");
        if (json != null && json.size() > 0) {
            Set entrys = validateOperation.entrySet();
            for (Map.Entry entry : entrys) {
                validateOperation.put((String)entry.getKey(), json.get(entry.getKey()));
            }
        }
        DynamicObjectCollection partInfos = (DynamicObjectCollection)this.getModel().getValue("ParticipantInfo");
        ArrayList<ParticipantInfo> participantInfos = new ArrayList<ParticipantInfo>();
        if (partInfos.size() > 0) {
            for (DynamicObject partInfo : partInfos) {
                Long userId = partInfo.getDynamicObject("fbasedataid").getLong("id");
                participantInfos.add(new ParticipantInfo(userId.longValue()));
            }
        }
        TaskEntityInfo taskEntityInfo = new TaskEntityInfo();
        taskEntityInfo.setName((ILocaleString)new LocaleString(name.getLocaleValue()));
        taskEntityInfo.setSubject((ILocaleString)new LocaleString(subject.getLocaleValue()));
        taskEntityInfo.setDescription((ILocaleString)new LocaleString(description.getLocaleValue()));
        taskEntityInfo.setEndType(endType);
        taskEntityInfo.setDueDate(dueDate);
        taskEntityInfo.setCategory(taskCategory);
        taskEntityInfo.setFormKey(formKey);
        taskEntityInfo.setMobileFormKey(mobileFormKey);
        taskEntityInfo.setDisplay(display);
        taskEntityInfo.setStarterId(starterId);
        taskEntityInfo.setBusinessKey(businessKey);
        taskEntityInfo.setBillNo(billNo);
        taskEntityInfo.setEntityNumber(entitynumber);
        taskEntityInfo.setProcessingPage(processingPage);
        taskEntityInfo.setProcessingMobilePage(processingMobilePage);
        if (StringUtils.isNotBlank(validateOperation.get("value"))) {
            taskEntityInfo.setValidateOperation(SerializationUtils.toJsonString(validateOperation));
        }
        taskEntityInfo.setParticipantInfos(participantInfos);
        MessageCenterServiceImpl messageCenterServiceImpl = new MessageCenterServiceImpl();
        return messageCenterServiceImpl.createTask(taskEntityInfo);
    }
}

