/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.message.service.api;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.IBillWebApiPlugin;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.api.ApiResult;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.workflow.engine.WfPermUtils;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.message.service.impl.MessageCenterServiceImpl;

public class GetMessageDatasApiService
implements IBillWebApiPlugin {
    private static Log logger = LogFactory.getLog(GetMessageDatasApiService.class);
    private static final String ENTITYNUMBER = "entityNumber";
    private static final String TAGS = "tags";
    private static final String TITLE = "title";
    private static final String MSGTYPE = "msgType";
    private static final String LINKMSGTYPE = "linkMsgType";
    private static final String UNREAD = "unread";
    private static final String START = "start";
    private static final String LIMIT = "limit";

    public ApiResult doCustomService(Map<String, Object> map) {
        logger.info(String.format("GetMessageDatasApiService-otherSystemStartInvokeApi-params%s", map.toString()));
        if (map.get(START) == null || Integer.parseInt(String.valueOf(map.get(START))) < 0 || map.get(LIMIT) == null || Integer.parseInt(String.valueOf(map.get(LIMIT))) < 0 || Integer.parseInt(String.valueOf(map.get(LIMIT))) > 10000) {
            return ApiResult.fail((String)ResManager.loadKDString((String)"\u53c2\u6570\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"GetMessageDatasApiService_0", (String)"bos-wf-message", (Object[])new Object[0]));
        }
        logger.debug("GetMessageDatasApiService-otherSystemStartInvokeApi");
        String userId = "";
        int start = 0;
        int limit = 0;
        HashMap<String, Object> filterPrarms = new HashMap<String, Object>();
        try {
            userId = WfUtils.isNotEmptyString((Object)map.get("userId")) ? map.get("userId").toString() : (WfUtils.isNotEmptyString((Object)map.get("userid")) ? map.get("userid").toString() : RequestContext.get().getUserId());
            if (RequestContext.get().getCurrUserId() != Long.parseLong(userId) && !WfPermUtils.hasMessageQueryPerm((String)"api_v1", (Long)Long.parseLong(userId))) {
                return ApiResult.fail((String)ResManager.loadKDString((String)"\u5f53\u524d\u8c03\u7528\u4eba\u4e0d\u5177\u5907\u6d88\u606f\u67e5\u8be2\u6743\u9650\u6216\u4e0d\u5c5e\u4e8e\u7528\u6237\u6388\u6743\u7684\u7ec4\u7ec7\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"GetMessageDatasApiService_2", (String)"bos-wf-message", (Object[])new Object[0]));
            }
            String entityNumber = "";
            String msgType = "";
            String linkMsgType = "all";
            if (WfUtils.isNotEmptyString((Object)map.get(ENTITYNUMBER))) {
                entityNumber = map.get(ENTITYNUMBER).toString();
            } else if (WfUtils.isNotEmptyString((Object)map.get("entitynumber"))) {
                entityNumber = map.get("entitynumber").toString();
            }
            if (WfUtils.isNotEmptyString((Object)map.get(MSGTYPE))) {
                msgType = map.get(MSGTYPE).toString();
            } else if (WfUtils.isNotEmptyString((Object)map.get("msgtype"))) {
                msgType = map.get("msgtype").toString();
            }
            if (WfUtils.isNotEmpty((String)msgType)) {
                boolean isMsgTypeExist = Boolean.FALSE;
                DynamicObject[] msgTypes = BusinessDataServiceHelper.load((String)"msg_type", (String)"id, number", null);
                if (msgTypes != null) {
                    for (DynamicObject typeObject : msgTypes) {
                        if (!typeObject.getString("number").equals(msgType)) continue;
                        isMsgTypeExist = Boolean.TRUE;
                        break;
                    }
                }
                if (!isMsgTypeExist) {
                    return ApiResult.fail((String)ResManager.loadKDString((String)"\u53c2\u6570\u683c\u5f0f\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"GetMessageDatasApiService_1", (String)"bos-wf-message", (Object[])new Object[0]));
                }
            }
            if (WfUtils.isNotEmptyString((Object)map.get(LINKMSGTYPE))) {
                linkMsgType = map.get(LINKMSGTYPE).toString();
            } else if (WfUtils.isNotEmptyString((Object)map.get("linkmsgtype"))) {
                linkMsgType = map.get("linkmsgtype").toString();
            }
            String tags = WfUtils.isNotEmptyString((Object)map.get("tag")) ? map.get("tag").toString() : "";
            String title = WfUtils.isNotEmptyString((Object)map.get(TITLE)) ? map.get(TITLE).toString() : "";
            boolean unread = WfUtils.isNotEmptyString((Object)map.get(UNREAD)) ? Boolean.parseBoolean(map.get(UNREAD).toString()) : Boolean.FALSE;
            filterPrarms.put(ENTITYNUMBER, entityNumber);
            filterPrarms.put(TAGS, tags);
            filterPrarms.put(MSGTYPE, msgType);
            filterPrarms.put(TITLE, title);
            filterPrarms.put(LINKMSGTYPE, linkMsgType);
            filterPrarms.put(UNREAD, unread);
            start = Integer.parseInt(map.get(START).toString());
            limit = Integer.parseInt(map.get(LIMIT).toString());
        }
        catch (Exception e) {
            return ApiResult.fail((String)ResManager.loadKDString((String)"\u53c2\u6570\u683c\u5f0f\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"GetMessageDatasApiService_1", (String)"bos-wf-message", (Object[])new Object[0]));
        }
        try {
            MessageCenterServiceImpl messageService = new MessageCenterServiceImpl();
            List<Map<String, Object>> messageDatas = messageService.getMessageByFilter(userId, start, limit, filterPrarms);
            return ApiResult.success(messageDatas);
        }
        catch (KDException e) {
            return ApiResult.ex((Throwable)e);
        }
    }
}

