/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.message.service.api;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import javax.validation.constraints.Size;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.message.mutilLange.MessageMultilangageUtils;
import kd.bos.openapi.common.custom.annotation.ApiController;
import kd.bos.openapi.common.custom.annotation.ApiGetMapping;
import kd.bos.openapi.common.custom.annotation.ApiMapping;
import kd.bos.openapi.common.custom.annotation.ApiParam;
import kd.bos.openapi.common.custom.annotation.ApiPostMapping;
import kd.bos.openapi.common.result.CustomApiResult;
import kd.bos.workflow.engine.WfPermUtils;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.msg.info.MessageInfo;
import kd.bos.workflow.engine.task.MessageCenterParams;
import kd.bos.workflow.message.service.MessageCenterService;
import kd.bos.workflow.message.service.api.MsgCenterErrCodeEnum;
import kd.bos.workflow.message.service.api.model.MessageInfoModel;
import kd.bos.workflow.message.service.util.MsgCenterAPIUtils;
import kd.bos.workflow.service.impl.ServiceFactory;

@ApiController(value="wftask", desc="\u6d88\u606f\u4e2d\u5fc3")
@ApiMapping(value="/")
public class MessageCenterController
implements Serializable {
    private static final long serialVersionUID = -4118963192488954558L;
    private static Log logger = LogFactory.getLog(MessageCenterController.class);
    private static MessageCenterService messageService;
    private static final String SUCCESS = "success";

    @ApiPostMapping(value="sendMessage", desc="\u53d1\u9001\u6d88\u606f")
    public CustomApiResult<Long> sendMessage(@ApiParam(value="messageInfo", required=true) @Valid @ApiParam(value="messageInfo", required=true) @Valid MessageInfoModel messageInfo) {
        try {
            if (!WfPermUtils.hasMessageHandlerPerm((String)"api_v2")) {
                return CustomApiResult.fail((String)MsgCenterErrCodeEnum.CODE_NOHASMESSAGEHANDLERPERM.getCode(), (String)MsgCenterErrCodeEnum.CODE_NOHASMESSAGEHANDLERPERM.getName());
            }
            if (!MsgCenterAPIUtils.checkMsgParam(messageInfo).booleanValue()) {
                return CustomApiResult.fail((String)MsgCenterErrCodeEnum.CODE_PARAMMISS.getCode(), (String)MsgCenterErrCodeEnum.CODE_PARAMMISS.getName());
            }
            if (!(MsgCenterAPIUtils.checkUserIds(messageInfo.getUserIds()).booleanValue() && MsgCenterAPIUtils.checkMsgType(messageInfo.getType()).booleanValue() && MsgCenterAPIUtils.checkEntityNumberForMsg(messageInfo.getEntityNumber()).booleanValue())) {
                return CustomApiResult.fail((String)MsgCenterErrCodeEnum.CODE_PARAMERROR.getCode(), (String)MsgCenterErrCodeEnum.CODE_PARAMERROR.getName());
            }
            Long temp = MessageCenterController.getMessageCenterService().sendMessage(this.buildMessageInfo(messageInfo));
            return CustomApiResult.success((Object)temp);
        }
        catch (Exception e) {
            logger.warn(String.format("send message occurred exception: %s", e));
            return CustomApiResult.fail((String)MsgCenterErrCodeEnum.CODE_SENDMESSAGE.getCode(), (String)MsgCenterErrCodeEnum.CODE_SENDMESSAGE.getName());
        }
    }

    @ApiGetMapping(value="getTaskAndMessageSummary", desc="\u83b7\u53d6\u4efb\u52a1\u548c\u6d88\u606f\u6c47\u603b")
    public CustomApiResult<List<Map<String, Object>>> getTaskAndMessageSummary(@ApiParam(value="\u6d88\u606f\u5f52\u5c5e\u4eba", required=true) @ApiParam(value="\u6d88\u606f\u5f52\u5c5e\u4eba", required=true) Long userId) {
        logger.debug(String.format("[request param] userId: %s", userId));
        try {
            if (RequestContext.get().getCurrUserId() != userId.longValue() && !WfPermUtils.hasMessageQueryPerm((String)"api_v2", (Long)userId)) {
                return CustomApiResult.fail((String)MsgCenterErrCodeEnum.CODE_NOHASMESSAGEQUERYPERM.getCode(), (String)MsgCenterErrCodeEnum.CODE_NOHASMESSAGEQUERYPERM.getName());
            }
            if (!MsgCenterAPIUtils.checkParamType(userId).booleanValue()) {
                return CustomApiResult.fail((String)MsgCenterErrCodeEnum.CODE_PARAMTYPEERROR.getCode(), (String)MsgCenterErrCodeEnum.CODE_PARAMTYPEERROR.getName());
            }
            ArrayList<Long> userIds = new ArrayList<Long>(1);
            userIds.add(userId);
            if (!MsgCenterAPIUtils.checkUserIds(userIds).booleanValue()) {
                return CustomApiResult.fail((String)MsgCenterErrCodeEnum.CODE_PARAMERROR.getCode(), (String)MsgCenterErrCodeEnum.CODE_PARAMERROR.getName());
            }
            return CustomApiResult.success((Object)MessageCenterController.getMessageCenterService().getMsgCenterCardOptions(String.valueOf(userId)));
        }
        catch (Exception e) {
            logger.warn(String.format("getMsgCenterCardOptions occurred exception: %s", e));
            return CustomApiResult.fail((String)MsgCenterErrCodeEnum.CODE_GETMSGCENTERCARDOPTIONS.getCode(), (String)MsgCenterErrCodeEnum.CODE_GETMSGCENTERCARDOPTIONS.getName());
        }
    }

    @ApiGetMapping(value="getUnReadMessageCount", desc="\u672a\u8bfb\u6d88\u606f\u6570\u91cf")
    public CustomApiResult<Long> getUnReadMessageCount(@ApiParam(value="\u6d88\u606f\u5f52\u5c5e\u4eba", required=true) @ApiParam(value="\u6d88\u606f\u5f52\u5c5e\u4eba", required=true) Long userId) {
        logger.debug(String.format("[request param] userId: %s", userId));
        try {
            if (RequestContext.get().getCurrUserId() != userId.longValue() && !WfPermUtils.hasMessageQueryPerm((String)"api_v2", (Long)userId)) {
                return CustomApiResult.fail((String)MsgCenterErrCodeEnum.CODE_NOHASMESSAGEQUERYPERM.getCode(), (String)MsgCenterErrCodeEnum.CODE_NOHASMESSAGEQUERYPERM.getName());
            }
            if (!MsgCenterAPIUtils.checkParamType(userId).booleanValue()) {
                return CustomApiResult.fail((String)MsgCenterErrCodeEnum.CODE_PARAMTYPEERROR.getCode(), (String)MsgCenterErrCodeEnum.CODE_PARAMTYPEERROR.getName());
            }
            ArrayList<Long> userIds = new ArrayList<Long>(1);
            userIds.add(userId);
            if (!MsgCenterAPIUtils.checkUserIds(userIds).booleanValue()) {
                return CustomApiResult.fail((String)MsgCenterErrCodeEnum.CODE_PARAMERROR.getCode(), (String)MsgCenterErrCodeEnum.CODE_PARAMERROR.getName());
            }
            return CustomApiResult.success((Object)MessageCenterController.getMessageCenterService().getUnReadMessageCount(String.valueOf(userId)));
        }
        catch (Exception e) {
            logger.warn(String.format("getUnReadMessageCount occurred exception: %s", e));
            return CustomApiResult.fail((String)MsgCenterErrCodeEnum.CODE_GETUNREADMESSAGECOUNT.getCode(), (String)MsgCenterErrCodeEnum.CODE_GETUNREADMESSAGECOUNT.getName());
        }
    }

    @ApiGetMapping(value="getUnReadMessage", desc="\u672a\u8bfb\u6d88\u606f\u6570\u636e")
    public CustomApiResult<List<Map<String, Object>>> getUnReadMessage(@ApiParam(value="\u6d88\u606f\u5f52\u5c5e\u4eba", required=true) @ApiParam(value="\u6d88\u606f\u5f52\u5c5e\u4eba", required=true) Long userId, @ApiParam(value="\u6d88\u606f\u6570\u91cf", required=true) @ApiParam(value="\u6d88\u606f\u6570\u91cf", required=true) int top) {
        logger.debug(String.format("[request param] userId: %s,top: %s", userId, top));
        try {
            if (RequestContext.get().getCurrUserId() != userId.longValue() && !WfPermUtils.hasMessageQueryPerm((String)"api_v2", (Long)userId)) {
                return CustomApiResult.fail((String)MsgCenterErrCodeEnum.CODE_NOHASMESSAGEQUERYPERM.getCode(), (String)MsgCenterErrCodeEnum.CODE_NOHASMESSAGEQUERYPERM.getName());
            }
            if (!MsgCenterAPIUtils.checkParamType(userId).booleanValue() || !MsgCenterAPIUtils.checkParamTypeForInt(top).booleanValue()) {
                return CustomApiResult.fail((String)MsgCenterErrCodeEnum.CODE_PARAMTYPEERROR.getCode(), (String)MsgCenterErrCodeEnum.CODE_PARAMTYPEERROR.getName());
            }
            ArrayList<Long> userIds = new ArrayList<Long>(1);
            userIds.add(userId);
            if (!MsgCenterAPIUtils.checkUserIds(userIds).booleanValue()) {
                return CustomApiResult.fail((String)MsgCenterErrCodeEnum.CODE_PARAMERROR.getCode(), (String)MsgCenterErrCodeEnum.CODE_PARAMERROR.getName());
            }
            if (top == 0) {
                return CustomApiResult.success(this.dealResult("message", Collections.EMPTY_LIST));
            }
            HashMap<String, Boolean> param = new HashMap<String, Boolean>();
            param.put("unread", true);
            List dealResult = MessageCenterController.getMessageCenterService().getMessageByFilter(String.valueOf(userId), 0, top, param);
            return CustomApiResult.success(this.dealResult("message", dealResult));
        }
        catch (Exception e) {
            logger.warn(String.format("getUnReadMessage occurred exception: %s", e));
            return CustomApiResult.fail((String)MsgCenterErrCodeEnum.CODE_GETUNREADMESSAGE.getCode(), (String)MsgCenterErrCodeEnum.CODE_GETUNREADMESSAGE.getName());
        }
    }

    @ApiPostMapping(value="deleteMessage", desc="\u6279\u91cf\u5220\u9664\u6d88\u606f")
    public CustomApiResult<Map<String, Object>> deleteMessage(@ApiParam(value="\u6d88\u606fID\u96c6\u5408", required=true) @Size(min=1, message="\u4e0d\u80fd\u4e3a\u7a7a") @ApiParam(value="\u6d88\u606fID\u96c6\u5408", required=true) @Size(min=1, message="\u4e0d\u80fd\u4e3a\u7a7a") List<Long> msgIds) {
        logger.debug(String.format("[request param] msgIds: %s", msgIds));
        try {
            if (!MsgCenterAPIUtils.checkIsHavePerm("delete", null, msgIds).booleanValue()) {
                return CustomApiResult.fail((String)MsgCenterErrCodeEnum.CODE_NOHAVEPERM.getCode(), (String)MsgCenterErrCodeEnum.CODE_NOHAVEPERM.getName());
            }
            if (!MsgCenterAPIUtils.checkMsgIds(msgIds).booleanValue()) {
                return CustomApiResult.fail((String)MsgCenterErrCodeEnum.CODE_PARAMERROR.getCode(), (String)MsgCenterErrCodeEnum.CODE_PARAMERROR.getName());
            }
            return CustomApiResult.success((Object)MessageCenterController.getMessageCenterService().deleteMessage(MsgCenterAPIUtils.castLongToObj(msgIds)));
        }
        catch (Exception e) {
            logger.warn(String.format("deleteMessage occurred exception: %s", e));
            return CustomApiResult.fail((String)MsgCenterErrCodeEnum.CODE_DELETEMESSAGE.getCode(), (String)MsgCenterErrCodeEnum.CODE_DELETEMESSAGE.getName());
        }
    }

    @ApiPostMapping(value="setMsgReadState", desc="\u8bbe\u7f6e\u6d88\u606f\u5df2\u8bfb")
    public CustomApiResult<String> setMsgReadState(@ApiParam(value="\u6d88\u606fID", required=true) @ApiParam(value="\u6d88\u606fID", required=true) Long msgId, @ApiParam(value="\u6d88\u606f\u63a5\u6536\u4ebaID", required=true) @ApiParam(value="\u6d88\u606f\u63a5\u6536\u4ebaID", required=true) Long userId) {
        logger.debug(String.format("[request param] msgId: %s,userId: %s", msgId, userId));
        try {
            ArrayList<Long> msgIds = new ArrayList<Long>(1);
            msgIds.add(msgId);
            ArrayList<Long> userIds = new ArrayList<Long>(1);
            userIds.add(userId);
            if (!MsgCenterAPIUtils.checkMsgIds(msgIds).booleanValue() || !MsgCenterAPIUtils.checkUserIds(userIds).booleanValue()) {
                return CustomApiResult.fail((String)MsgCenterErrCodeEnum.CODE_PARAMERROR.getCode(), (String)MsgCenterErrCodeEnum.CODE_PARAMERROR.getName());
            }
            if (!MsgCenterAPIUtils.checkIsHavePerm("updateReadStatusByUserId", userId, msgIds).booleanValue()) {
                return CustomApiResult.fail((String)MsgCenterErrCodeEnum.CODE_NOHAVEPERM.getCode(), (String)MsgCenterErrCodeEnum.CODE_NOHAVEPERM.getName());
            }
            ArrayList<Long> messageIds = new ArrayList<Long>(1);
            messageIds.add(msgId);
            if (!WfPermUtils.checkUserIsReceiver(messageIds, (Long)userId)) {
                return CustomApiResult.fail((String)MsgCenterErrCodeEnum.CODE_NOMATCH.getCode(), (String)MsgCenterErrCodeEnum.CODE_NOMATCH.getName());
            }
            MessageCenterController.getMessageCenterService().setMsgReadState(msgId, userIds);
            return CustomApiResult.success((Object)SUCCESS);
        }
        catch (Exception e) {
            logger.warn(String.format("setMsgReadState occurred exception: %s", e));
            return CustomApiResult.fail((String)MsgCenterErrCodeEnum.CODE_SETMSGREADSTATE.getCode(), (String)MsgCenterErrCodeEnum.CODE_SETMSGREADSTATE.getName());
        }
    }

    @ApiPostMapping(value="setMsgReadStateByMsgIds", desc="\u8bbe\u7f6e\u6d88\u606f\u5df2\u8bfb")
    public CustomApiResult<String> setMsgReadStateByMsgIds(@ApiParam(value="\u6d88\u606fID\u96c6\u5408", required=true) @Size(min=1, message="\u4e0d\u80fd\u4e3a\u7a7a") @ApiParam(value="\u6d88\u606fID\u96c6\u5408", required=true) @Size(min=1, message="\u4e0d\u80fd\u4e3a\u7a7a") List<Long> msgIds) {
        logger.debug(String.format("[request param] msgIds: %s", msgIds));
        try {
            if (!MsgCenterAPIUtils.checkIsHavePerm("updateReadStatus", null, msgIds).booleanValue()) {
                return CustomApiResult.fail((String)MsgCenterErrCodeEnum.CODE_NOHAVEPERM.getCode(), (String)MsgCenterErrCodeEnum.CODE_NOHAVEPERM.getName());
            }
            if (!MsgCenterAPIUtils.checkMsgIds(msgIds).booleanValue()) {
                return CustomApiResult.fail((String)MsgCenterErrCodeEnum.CODE_PARAMERROR.getCode(), (String)MsgCenterErrCodeEnum.CODE_PARAMERROR.getName());
            }
            MessageCenterController.getMessageCenterService().setMsgReadState(MsgCenterAPIUtils.castLongToObj(msgIds));
            return CustomApiResult.success((Object)SUCCESS);
        }
        catch (Exception e) {
            logger.warn(String.format("setMsgReadStateByMsgIds occurred exception: %s", e));
            return CustomApiResult.fail((String)MsgCenterErrCodeEnum.CODE_SETMSGREADSTATEBYMSGIDS.getCode(), (String)MsgCenterErrCodeEnum.CODE_SETMSGREADSTATEBYMSGIDS.getName());
        }
    }

    @ApiGetMapping(value="getToHandleTasksMessage", desc="\u83b7\u53d6\u5f85\u529e\u6570\u636e")
    public CustomApiResult<List<Map<String, Object>>> getToHandleTasksMessage(@ApiParam(value="\u7528\u6237ID", required=true) @ApiParam(value="\u7528\u6237ID", required=true) Long userId, @ApiParam(value="\u5f85\u529e\u6570\u91cf", required=true) @ApiParam(value="\u5f85\u529e\u6570\u91cf", required=true) int top) {
        logger.debug(String.format("[request param] userId: %s,top: %s", userId, top));
        try {
            if (RequestContext.get().getCurrUserId() != userId.longValue() && !WfPermUtils.hasToHandlerTaskQueryPerm((String)"api_v2", (Long)userId)) {
                return CustomApiResult.fail((String)MsgCenterErrCodeEnum.CODE_HASTOHANDLERTASKQUERYPERM.getCode(), (String)MsgCenterErrCodeEnum.CODE_HASTOHANDLERTASKQUERYPERM.getName());
            }
            if (!MsgCenterAPIUtils.checkParamType(userId).booleanValue() || !MsgCenterAPIUtils.checkParamTypeForInt(top).booleanValue()) {
                return CustomApiResult.fail((String)MsgCenterErrCodeEnum.CODE_PARAMTYPEERROR.getCode(), (String)MsgCenterErrCodeEnum.CODE_PARAMTYPEERROR.getName());
            }
            ArrayList<Long> userIds = new ArrayList<Long>(1);
            userIds.add(userId);
            if (!MsgCenterAPIUtils.checkUserIds(userIds).booleanValue()) {
                return CustomApiResult.fail((String)MsgCenterErrCodeEnum.CODE_PARAMERROR.getCode(), (String)MsgCenterErrCodeEnum.CODE_PARAMERROR.getName());
            }
            if (top == 0) {
                return CustomApiResult.success(this.dealResult("task", Collections.EMPTY_LIST));
            }
            MessageCenterParams messageCenterParams = new MessageCenterParams();
            messageCenterParams.setListFields(null);
            messageCenterParams.setStart(0);
            messageCenterParams.setLimit(top);
            HashMap<String, String> order = new HashMap<String, String>(1);
            order.put("createdate", "desc");
            messageCenterParams.setOrderByFields(order);
            Map result = MessageCenterController.getMessageCenterService().getToHandleTasks(messageCenterParams);
            List<Map<String, Object>> res = new ArrayList<Map<String, Object>>();
            if (result != null && result.get("data") != null) {
                res = (List)result.get("data");
            }
            return CustomApiResult.success(this.dealResult("task", res));
        }
        catch (Exception e) {
            logger.warn(String.format("getToHandleTasksMessage occurred exception: %s", e));
            return CustomApiResult.fail((String)MsgCenterErrCodeEnum.CODE_GETTOHANDLETASKSMESSAGE.getCode(), (String)MsgCenterErrCodeEnum.CODE_GETTOHANDLETASKSMESSAGE.getName());
        }
    }

    private List<Map<String, Object>> dealResult(String sourceType, List<Map<String, Object>> res) {
        ArrayList<Map<String, Object>> re = new ArrayList<Map<String, Object>>(res.size());
        for (Map<String, Object> objectMap : res) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            if ("task".equals(sourceType)) {
                map.put("id", objectMap.get("id").toString());
                String title = String.format(ResManager.loadKDString((String)"%1$s\u63d0\u4ea4\u7684%2$s", (String)"MessagePersonalSettingUtils_1", (String)"bos-message-common", (Object[])new Object[0]), objectMap.get("startname"), objectMap.get("entityname"));
                map.put("title", title);
                map.put("content", objectMap.get("subject"));
                map.put("handlestate", objectMap.get("handlestatedesc"));
                Date date = MessageMultilangageUtils.parseToUserZoneDate((Date)((Date)objectMap.get("createdate")), (boolean)false);
                map.put("time", date);
                map.put("timeCompare", date);
                re.add(map);
                continue;
            }
            map.put("id", objectMap.get("id"));
            map.put("title", objectMap.get("title"));
            map.put("content", objectMap.get("content"));
            map.put("handlestate", ResManager.loadKDString((String)"\u672a\u8bfb", (String)"MessagePersonalSettingUtils_2", (String)"bos-message-common", (Object[])new Object[0]));
            map.put("createdate", MessageMultilangageUtils.parseToUserZoneDate((Date)((Date)objectMap.get("createdate")), (boolean)false));
            map.put("createdateCompare", objectMap.get("createdate"));
            re.add(map);
        }
        return re;
    }

    @ApiGetMapping(value="getTaskCountByType", desc="\u83b7\u53d6\u4efb\u52a1\u6570\u91cf")
    public CustomApiResult<Long> getTaskCountByType(@ApiParam(value="\u7528\u6237ID", required=true) @ApiParam(value="\u7528\u6237ID", required=true) Long userId, @ApiParam(value="\u7c7b\u578b", required=true) @ApiParam(value="\u7c7b\u578b", required=true) String type) {
        logger.debug(String.format("[request param] userId: %s,type: %s", userId, type));
        try {
            if (RequestContext.get().getCurrUserId() != userId.longValue() && !WfPermUtils.hasToHandlerTaskQueryPerm((String)"api_v2", (Long)userId)) {
                return CustomApiResult.fail((String)MsgCenterErrCodeEnum.CODE_HASTOHANDLERTASKQUERYPERM.getCode(), (String)MsgCenterErrCodeEnum.CODE_HASTOHANDLERTASKQUERYPERM.getName());
            }
            if (!MsgCenterAPIUtils.checkParamType(userId).booleanValue()) {
                return CustomApiResult.fail((String)MsgCenterErrCodeEnum.CODE_PARAMTYPEERROR.getCode(), (String)MsgCenterErrCodeEnum.CODE_PARAMTYPEERROR.getName());
            }
            ArrayList<Long> userIds = new ArrayList<Long>(1);
            userIds.add(userId);
            if (!MsgCenterAPIUtils.checkUserIds(userIds).booleanValue()) {
                return CustomApiResult.fail((String)MsgCenterErrCodeEnum.CODE_PARAMERROR.getCode(), (String)MsgCenterErrCodeEnum.CODE_PARAMERROR.getName());
            }
            if (!MsgCenterAPIUtils.checkType(type).booleanValue()) {
                return CustomApiResult.fail((String)MsgCenterErrCodeEnum.CODE_PARAMERROR.getCode(), (String)MsgCenterErrCodeEnum.CODE_PARAMERROR.getName());
            }
            return CustomApiResult.success((Object)MessageCenterController.getMessageCenterService().getTaskCountByType(String.valueOf(userId), type));
        }
        catch (Exception e) {
            logger.warn(String.format("getTohandleTaskCountByType occurred exception: %s", e));
            return CustomApiResult.fail((String)MsgCenterErrCodeEnum.CODE_GETTOHANDLETASKCOUNTBYTYPE.getCode(), (String)MsgCenterErrCodeEnum.CODE_GETTOHANDLETASKCOUNTBYTYPE.getName());
        }
    }

    @ApiPostMapping(value="getMessageById", desc="\u6839\u636e\u6d88\u606fid\u83b7\u53d6\u6d88\u606f\u8be6\u60c5")
    public CustomApiResult<Map<String, Object>> getMessageById(@ApiParam(value="\u6d88\u606fID\u96c6\u5408", required=true) @Size(min=1, message="\u4e0d\u80fd\u4e3a\u7a7a") @ApiParam(value="\u6d88\u606fID\u96c6\u5408", required=true) @Size(min=1, message="\u4e0d\u80fd\u4e3a\u7a7a") List<Long> messageIds) {
        logger.debug(String.format("[request param] messageIds: %s", messageIds));
        try {
            if (!WfPermUtils.checkUserIsReceiver(messageIds, (Long)RequestContext.get().getCurrUserId()) && !WfPermUtils.hasMessageQueryPerm((String)"api_v2")) {
                return CustomApiResult.fail((String)MsgCenterErrCodeEnum.CODE_NOHASMESSAGEQUERYPERM.getCode(), (String)MsgCenterErrCodeEnum.CODE_NOHASMESSAGEQUERYPERM.getName());
            }
            Map<String, List<Long>> temp = MsgCenterAPIUtils.checkAndFilterMessageIds(messageIds);
            List<Long> errorIds = temp.get("errorIds");
            List<Long> rightIds = temp.get("rightIds");
            if (errorIds.size() == messageIds.size()) {
                return CustomApiResult.fail((String)MsgCenterErrCodeEnum.CODE_PARAMERROR.getCode(), (String)MsgCenterErrCodeEnum.CODE_PARAMERROR.getName());
            }
            return CustomApiResult.success((Object)MessageCenterController.getMessageCenterService().getMessageById(rightIds));
        }
        catch (Exception e) {
            logger.warn(String.format("getMessageById occurred exception: %s", e));
            return CustomApiResult.fail((String)MsgCenterErrCodeEnum.CODE_GETMESSAGEBYID.getCode(), (String)MsgCenterErrCodeEnum.CODE_GETMESSAGEBYID.getName());
        }
    }

    private MessageInfo buildMessageInfo(MessageInfoModel messageInfo) {
        MessageInfo ret = new MessageInfo();
        ret.setSource(messageInfo.getSource());
        ret.setBizDataId(messageInfo.getBizDataId());
        ret.setEntityNumber(messageInfo.getEntityNumber());
        LocaleString iLocaleMessageContent = new LocaleString();
        if (WfUtils.isEmpty((String)messageInfo.getContent()) || WfUtils.isEmpty((String)messageInfo.getMessageContent())) {
            ret.setContent(WfUtils.isEmpty((String)messageInfo.getContent()) ? messageInfo.getMessageContent() : messageInfo.getContent());
            iLocaleMessageContent.setLocaleValue(WfUtils.isEmpty((String)messageInfo.getMessageContent()) ? messageInfo.getContent() : messageInfo.getMessageContent());
        } else {
            ret.setContent(messageInfo.getContent());
            iLocaleMessageContent.setLocaleValue(messageInfo.getMessageContent());
        }
        ret.setMessageContent((ILocaleString)iLocaleMessageContent);
        LocaleString iLocaleMessageTitle = new LocaleString();
        iLocaleMessageTitle.setLocaleValue(messageInfo.getMessageTitle());
        ret.setMessageTitle((ILocaleString)iLocaleMessageTitle);
        ret.setContentUrl(messageInfo.getContentUrl());
        ret.setMobContentUrl(messageInfo.getMobContentUrl());
        ret.setNotifyType(messageInfo.getNotifyType());
        ret.setOperation(messageInfo.getOperation());
        ret.setParams(messageInfo.getParam());
        ret.setPubaccNumber(messageInfo.getPubaccNumber());
        ret.setSenderId(messageInfo.getSenderId());
        ret.setSenderName(messageInfo.getSenderName());
        ret.setSource(messageInfo.getSource());
        ret.setTag(messageInfo.getTag());
        ret.setTemplateNumber(messageInfo.getTemplateNumber());
        ret.setTplScene(messageInfo.getTplScene());
        ret.setType(messageInfo.getType());
        ret.setUserIds(messageInfo.getUserIds());
        return ret;
    }

    private static MessageCenterService getMessageCenterService() {
        if (null == messageService) {
            messageService = (MessageCenterService)ServiceFactory.getService((String)"MessageCenterService");
        }
        return messageService;
    }
}

