/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.message.service.datequery.api;

import java.util.ArrayList;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.cmd.task.dataquery.ProcessDataCollectorCmd;
import kd.bos.workflow.engine.impl.cmd.task.dataquery.params.EntityQueryParams;
import kd.bos.workflow.engine.impl.cmd.task.dataquery.params.ProcessDataEntityQueryParams;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;

public class GetMessageDataForApiCmd<T>
extends ProcessDataCollectorCmd<T> {
    Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    protected ProcessDataEntityQueryParams processDataEntityQueryParams;

    public T execute(CommandContext commandContext) {
        return (T)super.execute(commandContext);
    }

    protected void buildQueryFields(EntityQueryParams entityQueryParams) {
        super.buildQueryFields(entityQueryParams);
    }

    protected void buildOrderBy(EntityQueryParams entityQueryParams) {
        super.buildOrderBy(entityQueryParams);
    }

    protected void buildQFilters(EntityQueryParams entityQueryParams) {
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>();
        Map sqlFilter = this.processDataEntityQueryParams.getSqlFilterMap();
        if (sqlFilter != null && sqlFilter.size() > 0) {
            String linkMsgType;
            boolean unread;
            if (WfUtils.isNotEmpty((String)((String)sqlFilter.get("unread"))) && (unread = Boolean.parseBoolean((String)sqlFilter.get("unread")))) {
                qFilterList.add(new QFilter("readstate", "=", (Object)"unread"));
            }
            if (WfUtils.isNotEmpty((String)((String)sqlFilter.get("entityNumber")))) {
                qFilterList.add(new QFilter("entityNumber", "like", sqlFilter.get("entityNumber")));
            }
            if (WfUtils.isNotEmpty((String)((String)sqlFilter.get("tags")))) {
                qFilterList.add(new QFilter("tag", "like", (Object)((String)sqlFilter.get("tags") + "%")));
            }
            if (WfUtils.isNotEmpty((String)((String)sqlFilter.get("source")))) {
                qFilterList.add(new QFilter("source", "=", sqlFilter.get("source")));
            }
            if (WfUtils.isNotEmpty((String)((String)sqlFilter.get("title")))) {
                qFilterList.add(new QFilter("title", "like", (Object)((String)sqlFilter.get("title") + "%")));
            }
            if (WfUtils.isNotEmpty((String)((String)sqlFilter.get("msgId")))) {
                qFilterList.add(new QFilter("type", "=", (Object)Long.parseLong((String)sqlFilter.get("msgId"))));
            }
            if (WfUtils.isNotEmpty((String)(linkMsgType = (String)sqlFilter.get("linkMsgType")))) {
                if ("text".equalsIgnoreCase(linkMsgType)) {
                    qFilterList.add(new QFilter("contenturl", "is null", null).or("contenturl", "=", (Object)"").or("contenturl", "=", (Object)" "));
                } else if ("link".equalsIgnoreCase(linkMsgType)) {
                    qFilterList.add(new QFilter("contenturl", "is not null", null).and("contenturl", "!=", (Object)"").and("contenturl", "!=", (Object)" "));
                }
            }
        }
        entityQueryParams.getMainEntityQueryParams().setQFilter(qFilterList);
    }

    protected Object buildQueryResult(DynamicObjectCollection dynamicObjects) {
        return super.buildQueryResult(dynamicObjects);
    }

    protected boolean setMessageTypeId() {
        Map sqlFilter = this.processDataEntityQueryParams.getSqlFilterMap();
        if (sqlFilter != null && StringUtils.isNotBlank((CharSequence)((CharSequence)sqlFilter.get("msgType")))) {
            try {
                DynamicObject typeObject = BusinessDataServiceHelper.loadSingle((String)"msg_type", (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "=", sqlFilter.get("msgType"))});
                this.processDataEntityQueryParams.getSqlFilterMap().put("msgId", typeObject.getString("id"));
                return true;
            }
            catch (Exception e) {
                this.logger.info("getMessageDataForApi msgType is not exists,msgType is:" + (String)sqlFilter.get("msgType"));
                return false;
            }
        }
        return true;
    }
}

