/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.message.service.datequery.api;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.engine.impl.cmd.task.dataquery.params.EntityQueryParams;
import kd.bos.workflow.engine.impl.cmd.task.dataquery.params.ProcessDataEntityQueryParams;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.message.service.datequery.api.GetMessageDataForApiCmd;
import kd.bos.workflow.message.service.util.MessageOperateUtils;

public class GetMessageDataListForApiCmd
extends GetMessageDataForApiCmd<List<Map<String, Object>>> {
    private static final String SENDERNAME = "sendername";
    private static final String SENDER = "sender";
    private static final String MOBCONTENTURL = "mobcontenturl";
    private static final String CONTENTURL = "contenturl";
    private static final String CONTENT = "content";
    private static final String TITLE = "title";
    private static final String CREATEDATE = "createdate";
    private static final String READSTATE = "readstate";
    private static final String BIZDATAID = "bizdataid";
    private static final String ENTITYNUMBER = "entitynumber";

    public GetMessageDataListForApiCmd(ProcessDataEntityQueryParams processDataEntityQueryParams) {
        this.processDataEntityQueryParams = processDataEntityQueryParams;
    }

    @Override
    public List<Map<String, Object>> execute(CommandContext commandContext) {
        if (!this.setMessageTypeId()) {
            return null;
        }
        EntityQueryParams entityQueryParams = new EntityQueryParams();
        entityQueryParams.setUserId(this.processDataEntityQueryParams.getUserId());
        entityQueryParams.setMainEntityQueryParams(this.getMainEntityQueryObj("message"));
        entityQueryParams.setStart(this.processDataEntityQueryParams.getStart());
        entityQueryParams.setLimit(this.processDataEntityQueryParams.getLimit());
        this.buildQueryFields(entityQueryParams);
        this.buildQFilters(entityQueryParams);
        DynamicObjectCollection dynamicObjects = MessageOperateUtils.getMessageData(entityQueryParams);
        return this.buildQueryResult(dynamicObjects);
    }

    @Override
    protected void buildQueryFields(EntityQueryParams entityQueryParams) {
        String queryField = "messageid id,type,createdate,sender,entitynumber,bizdataid,readstate,title,content_summary,tag,sendername,contenturl";
        entityQueryParams.getMainEntityQueryParams().setQueryALLFields(queryField);
    }

    @Override
    protected void buildQFilters(EntityQueryParams entityQueryParams) {
        super.buildQFilters(entityQueryParams);
    }

    @Override
    protected List<Map<String, Object>> buildQueryResult(DynamicObjectCollection msgObjectCollection) {
        ArrayList<Map<String, Object>> msgData = new ArrayList<Map<String, Object>>();
        ArrayList<Long> msgIds = new ArrayList<Long>();
        if (msgObjectCollection != null && msgObjectCollection.size() > 0) {
            for (DynamicObject msgObject : msgObjectCollection) {
                HashMap<String, Object> msg = new HashMap<String, Object>();
                msgIds.add(msgObject.getLong("id"));
                msg.put("id", msgObject.get("id"));
                msg.put("type", msgObject.get("type"));
                msg.put(CREATEDATE, msgObject.get(CREATEDATE));
                msg.put(SENDER, msgObject.get(SENDER));
                msg.put(CONTENTURL, msgObject.get(CONTENTURL));
                msg.put(ENTITYNUMBER, msgObject.get(ENTITYNUMBER));
                msg.put(BIZDATAID, msgObject.get(BIZDATAID));
                msg.put(READSTATE, msgObject.get(READSTATE));
                msg.put(TITLE, msgObject.get(TITLE));
                msg.put("tag", msgObject.get("tag"));
                msg.put(SENDERNAME, msgObject.get(SENDERNAME));
                msgData.add(msg);
            }
        }
        try (DataSet ds = ORM.create().queryDataSet("getmessagedata", "wf_msg_message", "id,mobcontenturl,content", new QFilter[]{new QFilter("id", "in", msgIds)});){
            DynamicObjectCollection resultDynamicObjectCollection = ORM.create().toPlainDynamicObjectCollection(ds);
            for (DynamicObject message : resultDynamicObjectCollection) {
                for (Map map : msgData) {
                    if (!map.get("id").equals(message.getLong("id"))) continue;
                    map.put(MOBCONTENTURL, message.get(MOBCONTENTURL));
                    map.put(CONTENT, message.get(CONTENT));
                }
            }
        }
        return msgData;
    }
}

