/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.message.service.datequery.messsagecenter;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.form.FormMetadataCache;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.cmd.task.dataquery.params.EntityQueryParams;
import kd.bos.workflow.engine.impl.cmd.task.dataquery.params.ProcessDataEntityQueryParams;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.message.service.datequery.messsagecenter.GetMessageDataForMessageCenterCmd;
import kd.bos.workflow.message.service.util.MessageOperateUtils;

public class GetMessageDataListForMessageCenterCmd
extends GetMessageDataForMessageCenterCmd<DynamicObjectCollection> {
    public GetMessageDataListForMessageCenterCmd(ProcessDataEntityQueryParams processDataEntityQueryParams) {
        this.processDataEntityQueryParams = processDataEntityQueryParams;
    }

    @Override
    public DynamicObjectCollection execute(CommandContext commandContext) {
        EntityQueryParams entityQueryParams = new EntityQueryParams();
        entityQueryParams.setUserId(this.processDataEntityQueryParams.getUserId());
        entityQueryParams.setMainEntityQueryParams(this.getMainEntityQueryObj("message"));
        entityQueryParams.setStart(this.processDataEntityQueryParams.getStart());
        entityQueryParams.setLimit(this.processDataEntityQueryParams.getLimit());
        this.buildQueryFields(entityQueryParams);
        this.buildQFilters(entityQueryParams);
        this.buildOrderBy(entityQueryParams);
        DynamicObjectCollection re = MessageOperateUtils.getMessageData(entityQueryParams);
        return this.buildQueryResult(re);
    }

    protected void buildQueryFields(EntityQueryParams entityQueryParams) {
        entityQueryParams.getMainEntityQueryParams().setQueryALLFields(this.getMessageFields());
    }

    private String getMessageFields() {
        Map fields = FormMetadataCache.getListMeta((String)"wf_msg_message");
        if (fields == null || fields.size() == 0) {
            return null;
        }
        JSONObject objectMap = (JSONObject)JSON.parse((String)((String)fields.get("BillList")));
        if (objectMap == null) {
            return null;
        }
        JSONArray jsonArray = (JSONArray)objectMap.get((Object)"Items");
        JSONObject objects = null;
        for (int i = 0; i < jsonArray.size(); ++i) {
            JSONObject items = (JSONObject)jsonArray.get(i);
            if (!"gridview".equals(items.get((Object)"Key"))) continue;
            objects = items;
            break;
        }
        if (objects == null) {
            return null;
        }
        JSONArray arrays = (JSONArray)objects.get((Object)"Items");
        StringBuilder sql = new StringBuilder();
        List<String> ignoreFields = this.getNewField();
        for (int i = 0; i < arrays.size(); ++i) {
            JSONObject object = (JSONObject)arrays.get(i);
            if (ignoreFields.contains(object.get((Object)"ListFieldKey"))) continue;
            sql.append((String)object.get((Object)"ListFieldKey")).append(",");
        }
        sql.append("messageid id,type,entitynumber,bizdataid,config,sender");
        return sql.toString();
    }

    private List<String> getNewField() {
        ArrayList<String> fields = new ArrayList<String>(5);
        fields.add("seq");
        fields.add("fseq");
        fields.add("content");
        fields.add("mobcontenturl");
        fields.add("channels");
        fields.add("contenttag");
        return fields;
    }

    @Override
    protected void buildOrderBy(EntityQueryParams entityQueryParams) {
        String order = this.processDataEntityQueryParams.getOrderBy();
        if (WfUtils.isNotEmpty((String)order)) {
            entityQueryParams.getMainEntityQueryParams().setOrderBySql(order);
        }
    }

    @Override
    protected void buildQFilters(EntityQueryParams entityQueryParams) {
        super.buildQFilters(entityQueryParams);
    }

    protected DynamicObjectCollection buildQueryResult(DynamicObjectCollection dynamicObjects) {
        String readstate = (String)this.processDataEntityQueryParams.getSqlFilterMap().get("readstate");
        return this.delMessageState(dynamicObjects, readstate);
    }

    protected DynamicObjectCollection delMessageState(DynamicObjectCollection messageObjectCollection, String readstate) {
        for (DynamicObject messageObj : messageObjectCollection) {
            if (WfUtils.isNotEmpty((String)readstate) && ("unread".equals(readstate) || "read".equals(readstate))) {
                messageObj.set("readstate", (Object)readstate);
                continue;
            }
            if (messageObj.get("readstate") != null) continue;
            messageObj.set("readstate", (Object)"unread");
        }
        return messageObjectCollection;
    }
}

