/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.message.service.datequery.newapi;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.WorkflowFormService;
import kd.bos.workflow.engine.impl.cmd.task.dataquery.ProcessDataCollectorCmd;
import kd.bos.workflow.engine.impl.cmd.task.dataquery.params.EntityQueryParams;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.task.MessageCenterParams;
import kd.bos.workflow.message.service.DynamicFieldsService;

public class GetMessageDataForNewApiCmd<T>
extends ProcessDataCollectorCmd<T> {
    Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    protected String messageType;
    protected MessageCenterParams messageCenterParams;

    public T execute(CommandContext commandContext) {
        return (T)super.execute(commandContext);
    }

    protected void buildQueryFields(EntityQueryParams entityQueryParams) {
        ArrayList<String> listFields = new ArrayList<String>();
        if (this.messageCenterParams.getListFields() == null || this.messageCenterParams.getListFields().size() == 0) {
            List<String[]> fieldsList = DynamicFieldsService.create().getMessageListFislds();
            Iterator<String[]> iterator = fieldsList.iterator();
            while (iterator.hasNext()) {
                String[] arr = iterator.next();
                listFields.add(arr[1]);
            }
            this.messageCenterParams.setListFields(listFields);
        } else {
            for (String ob : this.messageCenterParams.getListFields()) {
                if (listFields.contains(ob)) continue;
                listFields.add(ob);
            }
        }
        if (entityQueryParams != null) {
            StringBuilder sql = new StringBuilder();
            if (listFields != null && listFields.size() > 0) {
                for (int i = 0; i < listFields.size(); ++i) {
                    if ("id".equals(listFields.get(i))) {
                        sql.append("messageid id");
                    } else {
                        sql.append((String)listFields.get(i));
                    }
                    if (i >= listFields.size() - 1) continue;
                    sql.append(",");
                }
            }
            entityQueryParams.getMainEntityQueryParams().setQueryALLFields(sql.toString());
        }
    }

    protected void buildOrderBy(EntityQueryParams entityQueryParams) {
        super.buildOrderBy(entityQueryParams);
    }

    protected void buildQFilters(EntityQueryParams entityQueryParams) {
        DynamicObject[] channelObjects;
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>();
        if (WfUtils.isNotEmpty((String)this.messageType) && (channelObjects = BusinessDataServiceHelper.load((String)"msg_type", (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)this.messageType)})) != null && channelObjects.length > 0) {
            qFilterList.add(new QFilter("type", "=", (Object)channelObjects[0].getLong("id")));
        }
        boolean isHaveReadState = false;
        List filters = this.getQfilter(this.messageCenterParams, this.messageType);
        if (filters != null && filters.size() > 0) {
            for (QFilter qFilter : filters) {
                String filterSchemeSql = qFilter.toString();
                if (!filterSchemeSql.contains("readstate")) continue;
                isHaveReadState = true;
                break;
            }
            qFilterList.addAll(filters);
        }
        if (!isHaveReadState) {
            qFilterList.add(new QFilter("readstate", "=", (Object)"unread"));
        }
        this.dealQFilterByQueryType("message", entityQueryParams, qFilterList);
    }

    protected Map<String, Object> buildQueryResult(DynamicObjectCollection dynamicObjects) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (dynamicObjects == null || dynamicObjects.size() == 0) {
            result.put("data", null);
            return result;
        }
        ArrayList res = new ArrayList();
        for (DynamicObject dynamicObject : dynamicObjects) {
            HashMap<String, Object> tmp = new HashMap<String, Object>(this.messageCenterParams.getListFields().size() + 1);
            for (String fieldName : this.messageCenterParams.getListFields()) {
                Object value = dynamicObject.get(fieldName);
                tmp.put(fieldName, value);
                if (!fieldName.equals("readstate")) continue;
                tmp.put("readstatedesc", this.getReadStateDesc(value == null ? "" : (String)value));
            }
            res.add(tmp);
        }
        result.put("data", res);
        return result;
    }

    private String getReadStateDesc(String readState) {
        switch (readState) {
            case "read": {
                return ResManager.loadKDString((String)"\u5df2\u8bfb", (String)"MessageCenterServiceImpl_12", (String)"bos-wf-message", (Object[])new Object[0]);
            }
            case "unread": {
                return ResManager.loadKDString((String)"\u672a\u8bfb", (String)"MessageCenterServiceImpl_13", (String)"bos-wf-message", (Object[])new Object[0]);
            }
        }
        return null;
    }

    protected Map<String, String> getFieldMappingRelationship() {
        HashMap<String, String> fieldMapping = new HashMap<String, String>();
        fieldMapping.put("id", "a.fid");
        fieldMapping.put("sendername", "a.fsendername");
        fieldMapping.put("title", "a.ftitle");
        fieldMapping.put("tag", "a.ftag");
        fieldMapping.put("readstate", "c.freadstate");
        fieldMapping.put("createdate", "c.fcreatedate");
        fieldMapping.put("content_summary", "a.fcontent_summary");
        fieldMapping.put("operation", "a.foperation");
        return fieldMapping;
    }

    protected Map<String, List<Object>> buildQFiltersToSql() {
        List filters = this.getQfilter(this.messageCenterParams, this.messageType);
        if (filters != null && filters.size() > 0) {
            return WorkflowFormService.create().buildMessageFilter(this.getFieldMappingRelationship(), filters);
        }
        return null;
    }

    protected Long getMessageType() {
        DynamicObject[] channelObjects = BusinessDataServiceHelper.load((String)"msg_type", (String)"id,name", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)this.messageType)});
        if (channelObjects == null || channelObjects.length == 0) {
            return null;
        }
        return channelObjects[0].getLong("id");
    }

    protected String getReadState(Map<String, List<Object>> filterSqlAndParams) {
        String readstate = "";
        if (filterSqlAndParams != null && filterSqlAndParams.size() > 0) {
            for (Map.Entry<String, List<Object>> entry : filterSqlAndParams.entrySet()) {
                if (entry.getKey().indexOf("readstate") <= -1) continue;
                readstate = "read";
                break;
            }
        }
        return WfUtils.isNotEmpty((String)readstate) ? readstate : "unread";
    }
}

