/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.message.service.datequery.newapi.singletable;

import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.workflow.engine.impl.cmd.task.dataquery.params.EntityQueryParams;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.task.MessageCenterParams;
import kd.bos.workflow.message.service.datequery.newapi.GetMessageDataForNewApiCmd;
import kd.bos.workflow.message.service.util.MessageOperateUtils;

public class GetMessageDataListForNewApiSingleTableCmd
extends GetMessageDataForNewApiCmd<Map<String, Object>> {
    public GetMessageDataListForNewApiSingleTableCmd(MessageCenterParams messageCenterParams, String messageType) {
        this.messageCenterParams = messageCenterParams;
        this.messageType = messageType;
    }

    @Override
    public Map<String, Object> execute(CommandContext commandContext) {
        EntityQueryParams entityQueryParams = new EntityQueryParams();
        entityQueryParams.setUserId(this.messageCenterParams.getUserId());
        entityQueryParams.setMainEntityQueryParams(this.getMainEntityQueryObj("message"));
        entityQueryParams.setStart(this.messageCenterParams.getStart());
        entityQueryParams.setLimit(this.messageCenterParams.getLimit());
        this.buildQueryFields(entityQueryParams);
        this.buildQFilters(entityQueryParams);
        this.buildOrderBy(entityQueryParams);
        DynamicObjectCollection objects = MessageOperateUtils.getMessageData(entityQueryParams);
        return this.buildQueryResult(objects);
    }

    @Override
    protected void buildQueryFields(EntityQueryParams entityQueryParams) {
        super.buildQueryFields(entityQueryParams);
    }

    @Override
    protected void buildOrderBy(EntityQueryParams entityQueryParams) {
        if (this.messageCenterParams.getOrderByFields() != null && this.messageCenterParams.getOrderByFields().size() > 0) {
            HashMap orderByFields = new HashMap(this.messageCenterParams.getOrderByFields().size());
            for (Map.Entry sql : this.messageCenterParams.getOrderByFields().entrySet()) {
                if ("id".equals(sql.getKey())) {
                    orderByFields.put("messageid", sql.getValue());
                    continue;
                }
                orderByFields.put((String)sql.getKey(), sql.getValue());
            }
            String orderBySql = this.orderByConvertToString(this.messageType, orderByFields);
            entityQueryParams.getMainEntityQueryParams().setOrderBySql(orderBySql);
        }
    }

    @Override
    protected void buildQFilters(EntityQueryParams entityQueryParams) {
        super.buildQFilters(entityQueryParams);
    }

    @Override
    protected Map<String, Object> buildQueryResult(DynamicObjectCollection dynamicObjects) {
        return super.buildQueryResult(dynamicObjects);
    }
}

