/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.message.service.impl;

import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.message.channel.cache.MsgServiceCacheHelper;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.workflow.engine.WfUtils;

public class ClearMessageQuantitySummaryServiceImpl
implements IUpgradeService {
    private static Log logger = LogFactory.getLog(ClearMessageQuantitySummaryServiceImpl.class);

    public Map<String, Object> beforeExecuteSql(String ver, String iteration, String dbKey, String sqlFileName) {
        boolean isTruncate = Boolean.TRUE;
        int userSize = 0;
        String sql = "select fuserid userid from t_msg_quantitysum tmq where 1=1 group by fuserid;";
        try (DataSet queryDataSet = DB.queryDataSet((String)"query_all_qs_user", (DBRoute)DBRoute.workflow, (String)sql);){
            for (Row row : queryDataSet) {
                Long userId = row.getLong("userid");
                MsgServiceCacheHelper.removeMsgQuantitySummaryCache((Long)userId);
                ++userSize;
            }
        }
        catch (Exception e) {
            logger.warn(String.format("clearAllUserQuantitySummaryDataAndCache, has error[%s]", WfUtils.getExceptionStacktrace((Throwable)e)));
            isTruncate = Boolean.FALSE;
        }
        if (isTruncate) {
            String sql1 = "delete from t_msg_quantitysum;";
            DB.execute((DBRoute)DBRoute.workflow, (String)sql1);
            logger.debug(String.format("Clear User[%s] QuantitySummary RedisCache and TableData;", userSize));
        }
        return null;
    }
}

