/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.message.service.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.message.utils.MessageUtils;
import kd.bos.message.utils.personalSetting.MessageBussinessInfo;
import kd.bos.message.utils.personalSetting.MessagePersonalSettingUtils;
import kd.bos.mq.MessageAcker;
import kd.bos.mq.MessageConsumer;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.msg.MessageServiceUtil;
import kd.bos.workflow.engine.msg.info.MessageInfo;
import kd.bos.workflow.engine.msg.quantitysum.MessageQuantitySummaryServcie;
import kd.bos.workflow.engine.msg.quantitysum.MessageQuantitySummaryUtils;
import kd.bos.workflow.message.api.IMessageCenterService;
import kd.bos.workflow.message.service.util.MessageOperateUtils;
import kd.bos.workflow.task.job.asyncexecutor.consumer.TaskJobConsumer;

public class MessageBussinessConsumer
implements MessageConsumer {
    private static Log logger = LogFactory.getLog(MessageBussinessConsumer.class);
    private static final String STR_MSGID = "msgId";
    private static final String STR_APPTYPE = "apptype";

    public void onMessage(Object body, String messageId, boolean resend, MessageAcker acker) {
        MessageBussinessInfo messageBussinessInfo = (MessageBussinessInfo)body;
        if (MessageBussinessInfo.Type.TASKMODELJOB.getNumber().equals(messageBussinessInfo.getType())) {
            TaskJobConsumer taskJobConsumer = new TaskJobConsumer();
            taskJobConsumer.onMessage(messageBussinessInfo.getData(), messageId, resend, acker);
        } else {
            try {
                this.handleMessage(messageBussinessInfo);
                acker.ack(messageId);
                logger.debug("mq consumer message over:" + messageId);
            }
            catch (Throwable e) {
                logger.warn("mq consumer message exception:" + MessageUtils.getExceptionStacktrace((Throwable)e));
                acker.discard(messageId);
            }
        }
    }

    private void handleMessage(MessageBussinessInfo messageBussinessInfo) {
        String type = messageBussinessInfo.getType();
        if (MessageBussinessInfo.Type.CORRECTAllQUANTITYSUMMARY.getNumber().equals(type)) {
            this.correctAllQuantitySummary();
        } else if (MessageBussinessInfo.Type.UPDATEPERSONALSETTINGDATAIDSCACHE.getNumber().equals(type)) {
            this.updatePersonSourceIdsCachse(messageBussinessInfo.getData());
        } else if (MessageBussinessInfo.Type.ASYNCSAVEMESSAGE.getNumber().equals(type)) {
            this.saveMessage((MessageInfo)messageBussinessInfo.getData());
        } else if (MessageBussinessInfo.Type.ASYNCMOVERECEIVERWHENDELETEMSG.getNumber().equals(type)) {
            this.moveMessageReceiver((List)messageBussinessInfo.getData());
        } else if (MessageBussinessInfo.Type.RECORDREADTIME.getNumber().equals(type)) {
            this.recordReadTime((Map)messageBussinessInfo.getData());
        } else if (MessageBussinessInfo.Type.DEALMESSAGE.getNumber().equals(type)) {
            this.dealMessage((Map)messageBussinessInfo.getData());
        }
    }

    private void correctAllQuantitySummary() {
        MessageQuantitySummaryServcie service = MessageServiceUtil.getMessageQuantitySummaryService();
        service.correctAllQuantitySummaryFromBizData(true);
    }

    private void dealMessage(Map<String, Object> data) {
        try {
            Long userId = (Long)data.get("userId");
            List messageIds = (List)data.get("messageIds");
            String channel = StringUtils.isNotBlank((Object)data.get("channel")) ? (String)data.get("channel") : null;
            Boolean isResend = StringUtils.isNotBlank((Object)data.get("isResend")) ? (Boolean)data.get("isResend") : Boolean.FALSE;
            MessageServiceUtil.getMessageService().dealMessage(messageIds, channel, userId, isResend);
        }
        catch (Exception e) {
            logger.warn("dealMessaage fail, because :" + e.getMessage());
        }
    }

    private void recordReadTime(Map<String, Object> map) {
        if (WfUtils.isNotEmptyForMap(map)) {
            try {
                MessageBussinessConsumer.recordReadTime((Long)map.get("taskId"), map.get(STR_MSGID), map.get(STR_APPTYPE));
            }
            catch (Exception e) {
                logger.error("recordReadTime is error, errorinfo is :" + e.getMessage());
            }
            if (map.get(STR_MSGID) != null) {
                ArrayList<Long> msgIds = new ArrayList<Long>(1);
                msgIds.add(Long.valueOf((String)map.get(STR_MSGID)));
                String channel = StringUtils.isNotBlank((Object)map.get(STR_APPTYPE)) ? (String)map.get(STR_APPTYPE) : null;
                MessageServiceUtil.getMessageService().dealMessage(msgIds, channel, Long.valueOf(RequestContext.get().getCurrUserId()), Boolean.FALSE);
            }
        }
    }

    private void moveMessageReceiver(List<Long> toAllMessageIds) {
        DynamicObject[] msgReceivers = MessageOperateUtils.moveMessageReceiver(toAllMessageIds, null, Boolean.TRUE);
        DynamicObject[] messages = null;
        try {
            messages = BusinessDataServiceHelper.load((String)"wf_msg_himessage", (String)"id,type,toall", (QFilter[])new QFilter[]{new QFilter("id", "in", toAllMessageIds)});
        }
        catch (Exception e) {
            logger.warn("query wf_msg_himessage object is error" + WfUtils.getExceptionStacktrace((Throwable)e));
        }
        if (messages != null && messages.length > 0) {
            MessageQuantitySummaryUtils.updateMessageQuantitySummary((DynamicObject[])msgReceivers, null, (String)"deleteMessge");
        }
    }

    private void saveMessage(MessageInfo messageInfo) {
        MessageOperateUtils.saveMessage(messageInfo);
    }

    private void updatePersonSourceIdsCachse(Object data) {
        Map personalSettingInfos = (Map)data;
        MessagePersonalSettingUtils.updatePersonSourceIdsCache((Map)personalSettingInfos);
    }

    public static void recordReadTime(Long taskId, Object msgId, Object apptype) {
        Date curDate = new Date();
        Long userId = Long.parseLong(RequestContext.get().getUserId());
        try {
            if (WfUtils.isNotEmpty((Long)taskId)) {
                logger.debug("recordReadTime.taskId is :" + taskId);
                String sql = "update t_wf_hiparticipant set freadtime = ? where ftaskid = ? and fuserid = ? and freadtime is null;";
                boolean executeResult = DB.execute((DBRoute)DBRoute.workflow, (String)sql, (Object[])new Object[]{curDate, taskId, userId});
                logger.debug("recordReadTime.updatehiparticipant, result is :" + executeResult);
                sql = "update t_wf_participant set freadtime = ? where ftaskid = ? and fuserid = ? and freadtime is null;";
                executeResult = DB.execute((DBRoute)DBRoute.workflow, (String)sql, (Object[])new Object[]{curDate, taskId, userId});
                logger.debug("recordReadTime.updateparticipant, result is :" + executeResult);
            }
        }
        catch (Exception e) {
            logger.error("recordReadTime is error, errorinfo is :" + e.getMessage());
        }
        if (msgId != null && apptype != null) {
            IMessageCenterService messageService = (IMessageCenterService)ServiceFactory.getService(IMessageCenterService.class);
            messageService.setMsgReadStateAndTerminalWay(Long.valueOf((String)msgId), userId, (String)apptype);
        }
    }
}

