/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.message.service.impl;

import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.message.api.MessageChannels;
import kd.bos.message.channel.MessageChannelUtils;
import kd.bos.message.channel.model.MsgChannelInfo;
import kd.bos.message.service.utils.FailMessageUtil;
import kd.bos.message.utils.MessageEventListenerUtils;
import kd.bos.message.utils.MessageEventType;
import kd.bos.message.utils.MessageUtils;
import kd.bos.mq.MessageAcker;
import kd.bos.mq.MessageConsumer;
import kd.bos.url.UrlService;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.util.ReflectUtil;
import kd.bos.workflow.engine.msg.AbstractMessageServiceHandler;
import kd.bos.workflow.engine.msg.MessageServiceConfig;
import kd.bos.workflow.engine.msg.MessageServiceUtil;
import kd.bos.workflow.engine.msg.MessageTypeEnum;
import kd.bos.workflow.engine.msg.info.MessageInfo;

public class MessageCenterConsumer
implements MessageConsumer {
    private static Log logger = LogFactory.getLog(MessageCenterConsumer.class);
    private static final String SUCCESS = "success";
    private static final String FAIL = "fail";
    private static final String[] CHANNELARRAY = new String[]{"yunzhijia", "yunzhijiaeco", "yunzhijiaup", "dingding", "sms", "weixinqy", "welink"};
    private static final String SERVICECLASS = "kd.bos.workflow.engine.msg.handler.MCenterServiceHandler";

    public void onMessage(Object body, String msgId, boolean resend, MessageAcker acker) {
        MessageInfo message = (MessageInfo)body;
        try {
            logger.debug("mcenterConsummer_messageId: " + message.getChannelMsgId() + " channel:" + message.getNotifyType() + " msgId: " + msgId);
            Map params = message.getParams();
            if (!params.containsKey("successSendUser")) {
                params.put("successSendUser", new ArrayList());
            }
            if (!params.containsKey("msgVerifyInfo")) {
                params.put("msgVerifyInfo", new HashMap());
            }
            params.put("userFilter", new HashMap());
            String channel = message.getNotifyType();
            boolean isDeleteMsgLog = false;
            String msgFailReason = null;
            if (MessageChannels.MC.getNumber().equals(channel)) {
                AbstractMessageServiceHandler serviceHandler = (AbstractMessageServiceHandler)ReflectUtil.instantiate((String)SERVICECLASS);
                serviceHandler.sendMessage(null, message);
                isDeleteMsgLog = true;
            } else if (MessageEventListenerUtils.interveneMsgSend((MessageInfo)message)) {
                MsgChannelInfo config = MessageChannelUtils.getChannelConfig((String)channel);
                if (config != null && ("sysnotice".equals(channel) || WfConfigurationUtil.isEnabled((String)channel))) {
                    AbstractMessageServiceHandler serviceHandler = this.getMessageServiceHandler(config);
                    message.setContentUrl(this.buildUrl(message.getContentUrl(), message, false, false));
                    HashMap<String, MsgChannelInfo> ps = new HashMap<String, MsgChannelInfo>(1);
                    ps.put("msgChannelInfo", config);
                    message.setMobContentUrl(this.buildUrl(message.getMobContentUrl(), message, serviceHandler.canDealMessage(message, ps), true));
                    this.wrapServiceHandler(serviceHandler, channel);
                    this.wrapMessage(message);
                    serviceHandler.sendMessage(null, message);
                    logger.debug("mcenterConsummer_send msg is ok, messageId:" + message.getId());
                    isDeleteMsgLog = !config.isLogenable();
                } else {
                    logger.debug("mcenterConsummer_" + channel + " is not enable, the msg of this channel not send");
                    msgFailReason = String.format("%s channel is not able", channel);
                }
            } else {
                logger.debug("mcenterConsummer_bizInterveneMsgSend, and MessgaeNotSend");
                msgFailReason = "bizInterveneMsgSend, not send";
            }
            acker.ack(msgId);
            this.adornMessageResult(message, isDeleteMsgLog, msgFailReason);
        }
        catch (Throwable e) {
            try {
                String msgFailReason = WfUtils.getExceptionStacktrace((Throwable)e);
                logger.info(String.format("mcenterConsummer_msg send fail reason: [%s]", msgFailReason));
                acker.discard(msgId);
                this.adornMessageResult(message, false, msgFailReason);
            }
            catch (Throwable e2) {
                logger.info(String.format("mcenterConsummer_throwable error: [%s]", WfUtils.getExceptionStacktrace((Throwable)e2)));
                acker.discard(msgId);
            }
        }
    }

    private void wrapServiceHandler(AbstractMessageServiceHandler serviceHandler, String channelNumber) {
        List configList = MessageServiceUtil.getMessageService().getMessageServiceConfigs();
        for (MessageServiceConfig config : configList) {
            if (!config.getServiceKey().equalsIgnoreCase(channelNumber)) continue;
            serviceHandler.setConfig(config);
            break;
        }
    }

    private Map<String, Object> getreTurnData(MessageInfo message, String state, String errorInfo, int retrySize) {
        HashMap<String, Object> subData = new HashMap<String, Object>();
        subData.put("state", state);
        subData.put("entityNumber", message.getEntityNumber());
        subData.put("notifyType", message.getNotifyType());
        subData.put("channelMsgId", message.getChannelMsgId());
        subData.put("retries", retrySize);
        if (errorInfo != null) {
            subData.put("errorinfo", errorInfo);
        }
        return subData;
    }

    private AbstractMessageServiceHandler getMessageServiceHandler(MsgChannelInfo config) {
        logger.debug("mcenterConsummer_channelServiceClass: " + config.getServiceclass());
        String serviceClass = config.getServiceclass().trim();
        String serviceClazz = serviceClass.endsWith(".java") ? serviceClass.substring(0, serviceClass.length() - 5) : serviceClass;
        return (AbstractMessageServiceHandler)ReflectUtil.instantiate((String)serviceClazz);
    }

    private void wrapMessage(MessageInfo message) {
        String allowHtmlATagChannels = WfConfigurationUtil.getAllowHtmlATagChannels();
        String[] allowHtmlTagChannelArr = StringUtils.isNotBlank((CharSequence)allowHtmlATagChannels) ? allowHtmlATagChannels.split(",") : new String[]{};
        String channel = message.getNotifyType();
        if (StringUtils.isNotBlank((CharSequence)channel)) {
            for (String allowChannel : allowHtmlTagChannelArr) {
                if (!allowChannel.equalsIgnoreCase(channel)) continue;
                message.getParams().put("temp_allowATag", true);
                MessageUtils.clearHtmlTags((MessageInfo)message);
                message.getParams().remove("temp_allowATag");
                return;
            }
            for (String c : CHANNELARRAY) {
                if (!c.equalsIgnoreCase(channel)) continue;
                MessageUtils.clearHtmlTags((MessageInfo)message);
                break;
            }
        }
    }

    private String buildUrl(String url, MessageInfo message, boolean canDealMessage, boolean isMob) {
        boolean isCurrentDomain = MessageServiceUtil.isCurrentDomain((String)url);
        try {
            if (WfUtils.isNotEmpty((String)url) && (isMob || MessageServiceUtil.isCurrentDomain((String)url))) {
                StringBuilder newUrl = new StringBuilder(url);
                if (!canDealMessage || "wfNode".equals(message.getSource()) || MessageTypeEnum.isExit((String)message.getTplScene()) || url.contains("wf_approvalpage_bac")) {
                    newUrl.append("&msgId=").append(message.getId());
                    if (!("dingding".equals(message.getNotifyType()) || "weixinqy".equals(message.getNotifyType()) || "welink".equals(message.getNotifyType()))) {
                        newUrl.append("&apptype=").append(message.getNotifyType());
                    }
                    return newUrl.toString();
                }
                if (isCurrentDomain) {
                    newUrl.append("&bscode=").append(message.getEntityNumber());
                }
                if (!isCurrentDomain || newUrl.toString().contains("mobile.html")) {
                    message.putParam("isOnlyMobile", "true");
                }
                String notifyType = message.getNotifyType();
                return MessageCenterConsumer.getYzjOutsideFormUrl(message.getId(), MessageServiceUtil.wrapSystemDomain((String)newUrl.toString(), (String)notifyType), notifyType);
            }
        }
        catch (Exception e) {
            logger.info("mcenterConsummer_buildUrl_\u751f\u6210url\u5931\u8d25" + e.getMessage());
        }
        return url;
    }

    private static String getYzjOutsideFormUrl(Long msgId, String businessUrl, String notifyType) {
        String[] parts = businessUrl.split("&");
        String bizApp = "";
        for (String part : parts) {
            if (!part.contains("app=")) continue;
            bizApp = part.split("=")[1];
            break;
        }
        logger.info(String.format("originalUrl app data: [%s]", bizApp));
        StringBuilder url = new StringBuilder();
        try {
            url.append(UrlService.getDomainContextUrl()).append("/integration/yzjShareOpen.do?formId=msg_openmessageurl&mb_formId=msg_openmessageurl_mobile&msgId=").append(msgId).append("&accountId=").append(RequestContext.get().getAccountId()).append("&businessUrl=").append(URLEncoder.encode(URLEncoder.encode(businessUrl, StandardCharsets.UTF_8.name()), StandardCharsets.UTF_8.name())).append("&src=wf");
            if (WfUtils.isNotEmpty((String)bizApp)) {
                url.append("&app=").append(bizApp);
            }
            if (!("dingding".equals(notifyType) || "weixinqy".equals(notifyType) || "welink".equals(notifyType))) {
                url.append("&apptype=").append(notifyType);
            }
        }
        catch (Exception e) {
            logger.info("mcenterConsummer_embellishTodoUrl_encodeUrl is error:" + e.getMessage());
            return businessUrl;
        }
        return url.toString();
    }

    private void adornMessageResult(MessageInfo message, boolean isDeleteMsgLog, String msgFailReason) {
        Map map = FailMessageUtil.updateFailMessage((MessageInfo)message, (boolean)isDeleteMsgLog, (String)msgFailReason);
        String resultState = msgFailReason == null ? SUCCESS : FAIL;
        MessageEventType eventType = msgFailReason == null ? MessageEventType.SUBSCRIBESUCCESSMSG : MessageEventType.SUBSCRIBEFAILMSG;
        int retrySize = map.get("retrysize") == null ? 0 : (Integer)map.get("retrysize");
        boolean isNoCodeFlow = "NoCodeFlow".equalsIgnoreCase(message.getSource());
        boolean isMCenterMsg = MessageChannels.MC.getNumber().equals(message.getNotifyType());
        if (isNoCodeFlow || !isMCenterMsg) {
            MessageEventListenerUtils.subscribeMsgResult((String)message.getType(), (String)message.getEntityNumber(), (MessageEventType)eventType, (Long)message.getId(), this.getreTurnData(message, resultState, msgFailReason, retrySize));
        }
    }
}

