/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.message.service.impl;

import com.alibaba.fastjson.JSONObject;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dlock.DLock;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDException;
import kd.bos.limiter.DuplicateLimiter;
import kd.bos.limiter.impl.ConcurrencyLimiter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.message.SendMessageContext;
import kd.bos.message.api.MessageChannels;
import kd.bos.message.channel.MessageChannelUtils;
import kd.bos.message.channel.cache.MsgServiceCacheHelper;
import kd.bos.message.service.utils.FailMessageUtil;
import kd.bos.message.utils.CustomTaskUtils;
import kd.bos.message.utils.MessageConfigurationUtil;
import kd.bos.message.utils.MessageUtils;
import kd.bos.message.utils.MsgCenterEventEnum;
import kd.bos.message.utils.SMSLicenseWhilteUtils;
import kd.bos.message.utils.personalSetting.MessageBussinessInfo;
import kd.bos.message.utils.personalSetting.MessageBussinessPublishUtil;
import kd.bos.message.utils.personalSetting.MessagePersonalSettingUtils;
import kd.bos.message.utils.personalSetting.PersonalSettingInfo;
import kd.bos.mq.MQFactory;
import kd.bos.mq.MessagePublisher;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.ReflectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.workflow.EventServiceHelper;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.bos.url.UrlService;
import kd.bos.workflow.api.MessageRequestInfo;
import kd.bos.workflow.engine.ProcessEngines;
import kd.bos.workflow.engine.TaskService;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfMultiLangUtils;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.cmd.task.dataquery.params.ProcessDataEntityQueryParams;
import kd.bos.workflow.engine.impl.concurrent.ConcurrentBizType;
import kd.bos.workflow.engine.impl.concurrent.ConcurrentDataService;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.persistence.entity.design.ModelType;
import kd.bos.workflow.engine.msg.MessageServiceConfig;
import kd.bos.workflow.engine.msg.MessageServiceUtil;
import kd.bos.workflow.engine.msg.MessageTypeEnum;
import kd.bos.workflow.engine.msg.info.ITaskMsg;
import kd.bos.workflow.engine.msg.info.MessageAttachment;
import kd.bos.workflow.engine.msg.info.MessageInfo;
import kd.bos.workflow.engine.msg.info.TaskEntityInfo;
import kd.bos.workflow.engine.msg.quantitysum.MessageQuantitySummaryCorrectUtils;
import kd.bos.workflow.engine.msg.quantitysum.MessageQuantitySummaryServcie;
import kd.bos.workflow.engine.msg.quantitysum.QuantitySummaryInfo;
import kd.bos.workflow.engine.msg.util.sysnotice.SystemNoticeCommonUtil;
import kd.bos.workflow.engine.msg.util.yzj.YunzhijiaCommonUtil;
import kd.bos.workflow.engine.task.BatchOperateResult;
import kd.bos.workflow.engine.task.MessageCenterParams;
import kd.bos.workflow.engine.task.TaskInfo;
import kd.bos.workflow.engine.task.center.util.NavigationTreeNode;
import kd.bos.workflow.engine.task.operation.CirculateOperationParam;
import kd.bos.workflow.engine.task.operation.CompleteOperationParam;
import kd.bos.workflow.engine.task.operation.DeleteOperationParam;
import kd.bos.workflow.engine.task.operation.TransferOperationParam;
import kd.bos.workflow.engine.task.operation.UpdateParticipantParam;
import kd.bos.workflow.exception.WFErrorCode;
import kd.bos.workflow.exception.WFMessageServiceException;
import kd.bos.workflow.message.api.SmsUsingQuantities;
import kd.bos.workflow.message.service.DynamicFieldsService;
import kd.bos.workflow.message.service.MessageCenterService;
import kd.bos.workflow.message.service.datequery.api.GetMessageDataListForApiCmd;
import kd.bos.workflow.message.service.datequery.messsagecenter.GetMessageDataCountForMessageCenterCmd;
import kd.bos.workflow.message.service.datequery.messsagecenter.GetMessageDataListForMessageCenterCmd;
import kd.bos.workflow.message.service.datequery.newapi.multipletable.GetMessageDataCountForNewApiMultipTableCmd;
import kd.bos.workflow.message.service.datequery.newapi.multipletable.GetMessageDataListForNewApiMultipTableCmd;
import kd.bos.workflow.message.service.datequery.newapi.singletable.GetMessageDataCountForNewApiSingleTableCmd;
import kd.bos.workflow.message.service.datequery.newapi.singletable.GetMessageDataListForNewApiSingleTableCmd;
import kd.bos.workflow.message.service.util.MessageOperateUtils;
import kd.bos.workflow.message.service.util.MsgCenterAPIUtils;
import kd.bos.workflow.task.service.TaskRuntimeService;

public class MessageCenterServiceImpl
implements MessageCenterService {
    private static Log logger = LogFactory.getLog(MessageCenterServiceImpl.class);
    private static final String BILLFORMID = "billFormId";
    private static final String COUNT = "count";
    private static final String UNREAD = "unread";
    private static final String MESSAGEMUTIL = "message_l";
    private static final String BFTAG = "b.ftag";
    private static final String LIKE = "like";
    private static final String MESSAGE = "message";
    private static final String NUMBER = "number";
    private static final String BIZDATAID = "bizdataid";
    private static final String ENTITYNUMBER = "entitynumber";
    private static final String CHANNELS = "channels";
    private static final String SENDERNAME = "sendername";
    private static final String SENDER = "sender";
    private static final String MOBCONTENTURL = "mobcontenturl";
    private static final String CONTENTURL = "contenturl";
    private static final String CONTENT = "content";
    private static final String TITLE = "title";
    private static final String MESSAGECONTENT = "messageContent";
    private static final String MESSAGETITLE = "messageTitle";
    private static final String CREATEDATE = "createdate";
    private static final String READSTATE = "readstate";
    private static final String MSGTYPE = "msg_type";
    private static final String MESSAGEENTITY = "bos-wf-message";
    private static final String MSGMESSAGEENTITY = "wf_msg_message";
    private static final String MSGRECEIVERENITTY = "wf_msg_receiver";
    private static final String MESSAGEID = "messageid";
    private static final String MOBLINKPARAMS = "mobLinkParams";
    private static final String FORMID = "formId";
    private static final String MOBILEENTITYNUMBER = "mobEntityNumber";
    private static final String PKID = "pkId";
    private static final String ISGENERATEMOBURL = "isGenerateMobUrl";
    private static final String NOTICE = "notice";
    private static final String SYSNOTICE = "sysnotice";
    private static final String TOALL2 = "toAll";
    private static final String USERID = "userId";
    private static final String SUCCESS = "success";
    private static final String SELECTPART = "select ";
    private static final String FTITLE = "ftitle";
    private static final String ACTIVITY = "activity";
    public static final String WF_CONFCENTER = "wf_confcenter";
    public static final String KEY_MESSAGE = "message";
    public static final String MSGCREATEDATE = "msg.sms.msgcreatedate";
    public static final String HIMSGCREATEDATE = "msg.sms.himsgcreatedate";
    public static final String FAILMSGCREATEDATE = "msg.sms.failmsgcreatedate";
    public static final Long GROUPID = 16L;
    private static final String RESULT = "result";
    private static final String DESCRIPTION = "description";
    private static final String MESSAGEIDSCHECKPASS = "messageIdsCheckPass";
    private static final String MESSAGEINFOSCHECKPASS = "messageInfosCheckPass";
    private static final String MESSAGEINFOSNOTPASS = "messageInfosNotPass";
    private static final String ISSMSCHECKLICENSE = "iscl";
    private static final String ISSMSVERIFICATIONCODE = "isSmsVerificationCode";
    private static final String LIMITERCODESCENE = "mcenter_sendMsg_limiter";
    private static final String LIMITERBIZSCENE = "channel";
    private static final String DUPLICATECODESCENE = "mcenter_sendMsg_duplicate";
    private static final String DUPLICATEBIZSCENE = "allBiz";
    private static final String[] messaeTypeArray = new String[]{"alarm", "message", "warning", "notice", "activity"};
    private static final String[] MOBURLPARAMS = new String[]{"isGenerateMobUrl", "formId", "mobEntityNumber", "pkId"};
    private static final int ASYNCSAVEMESSAGELIMIT = 20;
    private TaskService taskService;
    private static ThreadPool threadPool = ThreadPools.newFixedThreadPool((String)"messagecenter-readstate-pools", (int)4);
    private static final Map<String, Field> messageInfoFields = new HashMap<String, Field>();
    private static ReentrantLock lock = new ReentrantLock();

    public TaskInfo createBizTask(TaskEntityInfo taskEntityInfo) {
        return TaskRuntimeService.create().createBizTask(taskEntityInfo);
    }

    public BatchOperateResult completeBizTask(CompleteOperationParam completeOperationParam) {
        completeOperationParam.getVariables().put("terminal", "api");
        return TaskRuntimeService.create().completeBizTask(completeOperationParam);
    }

    public BatchOperateResult deleteBizTask(DeleteOperationParam deleteOperationParam) {
        return TaskRuntimeService.create().deleteBizTask(deleteOperationParam);
    }

    public BatchOperateResult transferBizTask(TransferOperationParam transferOperationParam) {
        return TaskRuntimeService.create().transferBizTask(transferOperationParam);
    }

    public BatchOperateResult updateParticipant(UpdateParticipantParam updateParticipantParam) {
        return TaskRuntimeService.create().updateParticipant(updateParticipantParam);
    }

    public BatchOperateResult circulateBizTask(CirculateOperationParam circulateOperationParam) {
        return TaskRuntimeService.create().circulateBizTask(circulateOperationParam);
    }

    @Override
    public DynamicObjectCollection getMessageDataByType(int start, int limit, String userId, Long typeId, String readstate, Map<String, Map<String, List<Object>>> filterSql, String orderby) {
        return MessageOperateUtils.getMessageData(start, limit, userId, null, typeId, readstate, filterSql, orderby);
    }

    @Override
    public long getMessageDataCountByType(String userId, Long typeId, String readstate, Map<String, Map<String, List<Object>>> filterSql) {
        return MessageOperateUtils.getMessageDataCount(userId, null, typeId, readstate, filterSql);
    }

    public DynamicObjectCollection findMessageByEntity(String userId, String entityNumber, String tags) {
        return MessageOperateUtils.getMessageData(0, 0, userId, entityNumber, null, null, this.dealTags4Sql(tags), null);
    }

    public long findMsgCountByEntity(String userId, String entityNumber, String tags) {
        return MessageOperateUtils.getMessageDataCount(userId, entityNumber, null, null, this.dealTags4Sql(tags));
    }

    public long getUnReadMessageCount(String userId) {
        MessageQuantitySummaryServcie service = MessageServiceUtil.getMessageQuantitySummaryService();
        List quantitySummaryInfos = service.getMsgQuantitySummary(Long.valueOf(userId), "msg");
        int count = this.getQuantitySummary(quantitySummaryInfos, "msg", null);
        return (long)count + 0L;
    }

    public List<Map<String, Object>> getUnReadMessage(String uid, int top) {
        return MessagePersonalSettingUtils.getToHandleTaskUnreadMessageData((Long)Long.parseLong(uid), (int)top, (PersonalSettingInfo.SourceTypeEnum)PersonalSettingInfo.SourceTypeEnum.MESSAGE);
    }

    public void setMsgReadState(Long msgId, List<Long> userIds) {
        ArrayList<Object> msgIds = new ArrayList<Object>(1);
        msgIds.add(msgId);
        for (Long userId : userIds) {
            this.setReadState(msgIds, "read", userId);
        }
    }

    public void setMsgReadState(List<Object> msgIds) {
        this.setReadState(msgIds, "read", null);
    }

    @Override
    public void setReadState(List<Object> msgIds, String state, Object userId) {
        try {
            int batchCount = 10000;
            int totalCount = msgIds.size();
            int pageCount = totalCount % batchCount != 0 ? totalCount / batchCount + 1 : totalCount / batchCount;
            CountDownLatch countDownLatch = new CountDownLatch(pageCount);
            for (int i = 0; i < pageCount; ++i) {
                int startIndex = i * batchCount;
                int endIndex = (i + 1) * batchCount > totalCount ? totalCount : (i + 1) * batchCount;
                List<Object> pageMessageIds = msgIds.subList(startIndex, endIndex);
                threadPool.execute(() -> {
                    TXHandle tx = TX.requiresNew();
                    try {
                        MessageOperateUtils.setMessageReadState(pageMessageIds, state, userId, null);
                        this.updateMessageRedStatusEvent(pageMessageIds, state, userId);
                    }
                    catch (Exception e) {
                        logger.error("MessageCenterServiceImpl#setReadState", (Throwable)e);
                        tx.markRollback();
                    }
                    finally {
                        if (null != countDownLatch) {
                            countDownLatch.countDown();
                        }
                        tx.close();
                    }
                }, RequestContext.get());
            }
            countDownLatch.await();
        }
        catch (Exception e) {
            logger.error("MessageCenterServiceImpl#setReadState", (Throwable)e);
        }
    }

    @Override
    public DynamicObject getMessageTypeById(Object pk) {
        DynamicObject msgObj = BusinessDataServiceHelper.loadSingle((Object)pk, (String)MSGMESSAGEENTITY, (String)"type,id,number");
        if (msgObj == null) {
            msgObj = BusinessDataServiceHelper.loadSingle((Object)pk, (String)"wf_msg_himessage", (String)"type,id,number");
        }
        DynamicObject typeObj = BusinessDataServiceHelper.loadSingle((Object)msgObj.get("type"), (String)MSGTYPE, (String)"id,number,category,name");
        return typeObj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteMessage(List<Long> messageIds, Long userId) {
        try (TXHandle tx = TX.requiresNew();){
            this.deleteMessageData(messageIds, userId);
            this.deleteMessageEvent(MsgCenterAPIUtils.castLongToObj(messageIds), userId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> deleteMessage(List<Object> msgIds) {
        ArrayList<Long> messageIds = new ArrayList<Long>();
        for (Object msgId : msgIds) {
            if (msgId instanceof String) {
                messageIds.add(Long.valueOf((String)msgId));
                continue;
            }
            messageIds.add((Long)msgId);
        }
        Map<String, Object> data = null;
        try (TXHandle tx = TX.requiresNew();){
            data = this.deleteMessageData(messageIds, null);
            this.deleteMessageEvent(msgIds, null);
        }
        return data;
    }

    private Map<String, Object> deleteMessageData(List<Long> msgIds, Long uId) {
        return MessageOperateUtils.deleteMessageData(msgIds, uId);
    }

    public void saveMessage(MessageInfo message) {
        try {
            this.saveMessageDate(message);
        }
        catch (Exception e) {
            logger.debug("saveMessageApi is error and description:" + WfUtils.getExceptionStacktrace((Throwable)e));
        }
    }

    private void saveMessageDate(MessageInfo message) throws Exception {
        List userIds = message.getUserIds();
        if (message instanceof MessageInfo && (message.isToAll() || userIds != null && userIds.size() >= 20)) {
            try {
                MessageBussinessInfo messageBussinessInfo = new MessageBussinessInfo();
                messageBussinessInfo.setType(MessageBussinessInfo.Type.ASYNCSAVEMESSAGE.getNumber());
                messageBussinessInfo.setData((Object)message);
                MessageBussinessPublishUtil.publishBizMessage((MessageBussinessInfo)messageBussinessInfo);
            }
            catch (Exception e) {
                throw new Exception(e);
            }
        } else {
            MessageOperateUtils.saveMessage(message);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Map<String, Object> batchSendMessages(List<MessageInfo> messageInfos) {
        if (messageInfos == null) return null;
        if (messageInfos.isEmpty()) {
            return null;
        }
        this.removeDuplicateMessage(messageInfos);
        if (messageInfos.isEmpty()) {
            String msg = ResManager.loadKDString((String)"\u8be5\u6d88\u606f\u56e0\u88ab\u5224\u5b9a\u4e3a\u91cd\u590d\u800c\u88ab\u4e22\u5f03\u3002", (String)"MessageCenterServiceImpl_8", (String)MESSAGEENTITY, (Object[])new Object[0]);
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("failMsgs", msg);
            data.put("error", "messageDuplication");
            return this.wrapMessageResult(false, msg, data);
        }
        if (!this.isNeedLimiter(messageInfos)) return this.batchSendMessageInfos(messageInfos);
        try (ConcurrencyLimiter limiter = ConcurrencyLimiter.acquire((String)LIMITERCODESCENE, (String)LIMITERBIZSCENE);){
            Map<String, Object> map = this.batchSendMessageInfos(messageInfos);
            return map;
        }
        catch (Exception e) {
            this.printLog(String.format("TheMessage [%s] call threw an error due to exceeding the traffic limit.", messageInfos.get(0).getTitle()));
            throw new WFMessageServiceException(null, WFErrorCode.sendMessageLimitedError(), null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Object> batchSendMessageInfos(List<MessageInfo> messageInfos) {
        SendMessageContext messageContext = new SendMessageContext(messageInfos);
        Map<String, Object> checkResults = this.checkMessageInfoNewVersion(messageInfos, messageContext);
        List messageIdsCheckPass = (List)checkResults.get(MESSAGEIDSCHECKPASS);
        List messageInfosCheckPass = (List)checkResults.get(MESSAGEINFOSCHECKPASS);
        Map messageInfosNotPass = (Map)checkResults.get(MESSAGEINFOSNOTPASS);
        if (messageInfosCheckPass.isEmpty()) {
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("failMsgs", messageInfosNotPass);
            return this.wrapMessageResult(false, ResManager.loadKDString((String)"\u53d1\u9001\u6d88\u606f\u5931\u8d25\uff0c\u6d88\u606f\u4fe1\u606f\u672a\u901a\u8fc7\u9a8c\u8bc1\u3002", (String)"MessageCenterServiceImpl_9", (String)MESSAGEENTITY, (Object[])new Object[0]), data);
        }
        String traceId = RequestContext.get().getTraceId();
        logger.debug(String.format("sendMessagesApi-start sendMessage, entityNumber[%s], bizdataid[%s], traceId[%s], msgSize[%s]", messageInfos.get(0).getEntityNumber(), messageInfos.get(0).getBizDataId(), traceId, messageInfos.size()));
        try (MessagePublisher publisher = null;){
            publisher = MQFactory.get().createSimplePublisher("workflow", "messagecenter_service");
            logger.debug(String.format("sendMessagesApi-begine save msglog size[%s]", messageInfosCheckPass.size()));
            int channelMessageSize = 0;
            ArrayList<MessageInfo> pageMessageInfos = new ArrayList<MessageInfo>();
            for (int i = 0; i < messageInfosCheckPass.size(); ++i) {
                MessageInfo message = (MessageInfo)messageInfosCheckPass.get(i);
                List<MessageInfo> channelMessageInfos = this.splitMessageInfo(message, messageContext);
                pageMessageInfos.addAll(channelMessageInfos);
                if (pageMessageInfos.size() >= 500) {
                    FailMessageUtil.saveFailMessage(pageMessageInfos, (SendMessageContext)messageContext);
                    for (MessageInfo channelMessage : pageMessageInfos) {
                        publisher.publish((Object)channelMessage);
                    }
                    channelMessageSize += pageMessageInfos.size();
                    pageMessageInfos.clear();
                    continue;
                }
                if (i != messageInfosCheckPass.size() - 1) continue;
                FailMessageUtil.saveFailMessage(pageMessageInfos, (SendMessageContext)messageContext);
                for (MessageInfo channelMessage : pageMessageInfos) {
                    publisher.publish((Object)channelMessage);
                }
                channelMessageSize += pageMessageInfos.size();
            }
            logger.debug(String.format("sendMessagesApi-start publish msg, msgInfo size[%s], channelMsgInfo size[%s]", messageInfosCheckPass.size(), channelMessageSize));
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("successMsgIds", messageIdsCheckPass);
            data.put("failMsgs", messageInfosNotPass);
            Map<String, Object> map = this.wrapMessageResult(true, ResManager.loadKDString((String)"\u6d88\u606f\u53d1\u9001\u6210\u529f\u3002", (String)"MessageCenterServiceImpl_10", (String)MESSAGEENTITY, (Object[])new Object[0]), data);
            return map;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Deprecated
    public long sendMessage(MessageInfo messageInfo) {
        ArrayList<MessageInfo> messageInfos = new ArrayList<MessageInfo>(1);
        messageInfos.add(messageInfo);
        this.removeDuplicateMessage(messageInfos);
        if (messageInfos.isEmpty()) {
            this.printLog(ResManager.loadKDString((String)"\u8be5\u6d88\u606f\u56e0\u88ab\u5224\u5b9a\u4e3a\u91cd\u590d\u800c\u88ab\u4e22\u5f03\u3002", (String)"MessageCenterServiceImpl_8", (String)MESSAGEENTITY, (Object[])new Object[0]));
            return 0L;
        }
        if (!this.isNeedLimiter(messageInfos)) return this.sendMessageInfo(messageInfos);
        try (ConcurrencyLimiter limiter = ConcurrencyLimiter.acquire((String)LIMITERCODESCENE, (String)LIMITERBIZSCENE);){
            long l = this.sendMessageInfo(messageInfos);
            return l;
        }
        catch (Exception e) {
            this.printLog(String.format("TheMessage [%s] call threw an error due to exceeding the traffic limit.", messageInfo.getTitle()));
            throw new WFMessageServiceException(null, WFErrorCode.sendMessageLimitedError(), null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Long sendMessageInfo(List<MessageInfo> messageInfos) {
        SendMessageContext messageContext = new SendMessageContext(messageInfos);
        MessageInfo messageInfo = messageInfos.get(0);
        Map<String, Object> checkResults = this.checkMessageInfoOldVersion(messageInfo, messageContext);
        if (checkResults != null && !((Boolean)checkResults.get(RESULT)).booleanValue()) {
            return 0L;
        }
        MessagePublisher publisher = null;
        TXHandle tx = TX.requiresNew();
        try {
            List<MessageInfo> channelMessageInfos = this.splitMessageInfo(messageInfo, messageContext);
            logger.debug("MessageCenterServiceImpl-- message save msgfail db");
            FailMessageUtil.saveFailMessage(channelMessageInfos, (SendMessageContext)messageContext);
            logger.debug("MessageCenterServiceImpl-- message publisher");
            publisher = MQFactory.get().createSimplePublisher("workflow", "messagecenter_service");
            for (MessageInfo channelMessage : channelMessageInfos) {
                publisher.publish((Object)channelMessage);
            }
        }
        catch (Exception e) {
            tx.markRollback();
        }
        finally {
            if (publisher != null) {
                publisher.close();
            }
            tx.close();
        }
        return messageInfo.getId();
    }

    private String buildMsgCommonUrl(MessageInfo message) {
        if (StringUtils.isNotBlank((CharSequence)message.getMobContentUrl()) || StringUtils.isBlank((Object)message.getParams()) || StringUtils.isBlank(message.getParams().get(MOBLINKPARAMS))) {
            return null;
        }
        Map mobLinkParams = (Map)message.getParams().get(MOBLINKPARAMS);
        Boolean isGenerateMobUrl = Boolean.valueOf(String.valueOf(mobLinkParams.get(ISGENERATEMOBURL)));
        if (!isGenerateMobUrl.booleanValue()) {
            return null;
        }
        StringBuilder msgUrl = new StringBuilder();
        msgUrl.append(UrlService.getDomainContextUrl());
        if (!UrlService.getDomainContextUrl().endsWith("/")) {
            msgUrl.append('/');
        }
        msgUrl.append("integration/yzjShareOpen.do?");
        msgUrl.append("formId=");
        if (StringUtils.isNotBlank(mobLinkParams.get(FORMID))) {
            msgUrl.append(mobLinkParams.get(FORMID));
        } else {
            msgUrl.append(message.getEntityNumber());
        }
        msgUrl.append("&mb_formId=");
        if (StringUtils.isNotBlank(mobLinkParams.get(MOBILEENTITYNUMBER))) {
            msgUrl.append(mobLinkParams.get(MOBILEENTITYNUMBER));
        } else {
            msgUrl.append(message.getEntityNumber());
        }
        msgUrl.append("&pkId=");
        if (StringUtils.isNotBlank(mobLinkParams.get(PKID))) {
            msgUrl.append(mobLinkParams.get(PKID));
        } else {
            msgUrl.append(message.getBizDataId());
        }
        msgUrl.append("&accountId=").append(RequestContext.get().getAccountId());
        for (Map.Entry entry : mobLinkParams.entrySet()) {
            boolean needAdd = true;
            for (int i = 0; i < MOBURLPARAMS.length; ++i) {
                if (!MOBURLPARAMS[i].equals(entry.getKey())) continue;
                needAdd = false;
                break;
            }
            if (!needAdd) continue;
            msgUrl.append("&").append((String)entry.getKey()).append("=");
            if (entry.getValue() instanceof String) {
                msgUrl.append(YunzhijiaCommonUtil.encode((String)String.valueOf(entry.getValue())));
                continue;
            }
            msgUrl.append(entry.getValue());
        }
        return msgUrl.toString();
    }

    private Map<String, Map<String, List<Object>>> dealTags4Sql(String tags) {
        HashMap filterSql = new HashMap();
        ArrayList<String> params = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        String[] tagCol = tags.split(",");
        if (tagCol.length != 1) {
            for (int i = 0; i < tagCol.length; ++i) {
                String tag = tagCol[i];
                if (!StringUtils.isNotBlank((CharSequence)tag)) continue;
                if (sb.length() > 0 && sb.toString().endsWith("OR ")) {
                    if (i == tagCol.length - 1) {
                        sb.append("( ").append(BFTAG).append(" ").append(LIKE).append(" ? ").append(")").append(")");
                    } else {
                        sb.append("( ").append(BFTAG).append(" ").append(LIKE).append(" ? ").append(") OR ");
                    }
                } else {
                    sb.append(" AND ").append("(( ").append(BFTAG).append(" ").append(LIKE).append(" ? ").append(") OR ");
                }
                params.add("%" + tag + "%");
            }
        } else if (StringUtils.isNotBlank((CharSequence)tagCol[0])) {
            sb.append(" AND ").append("( ").append(BFTAG).append(" ").append(LIKE).append(" ? ").append(") ");
            params.add("%" + tagCol[0] + "%");
        }
        filterSql.put(sb.toString(), params);
        HashMap<String, Map<String, List<Object>>> filterSqlMap = new HashMap<String, Map<String, List<Object>>>();
        if (!filterSql.isEmpty()) {
            filterSqlMap.put(MESSAGEMUTIL, filterSql);
        }
        return filterSqlMap;
    }

    @Override
    public List<NavigationTreeNode> getMsgNavigationNodes(String userId) {
        ArrayList<NavigationTreeNode> msgNodes = new ArrayList<NavigationTreeNode>();
        MessageQuantitySummaryServcie service = MessageServiceUtil.getMessageQuantitySummaryService();
        List quantitySummaryInfos = service.getMsgQuantitySummary(Long.valueOf(userId), "msg");
        DynamicObject[] msgTypes = BusinessDataServiceHelper.load((String)MSGTYPE, (String)"id, number, name, category", null);
        if (msgTypes != null && msgTypes.length > 0) {
            for (DynamicObject msgType : msgTypes) {
                if ("task".equals(msgType.get("category"))) continue;
                String lang = RequestContext.get().getLang().toString();
                String msgTypeName = (String)msgType.getLocaleString("name").get((Object)lang);
                NavigationTreeNode msgNode = new NavigationTreeNode();
                msgNode.setId(msgType.getString("id"));
                msgNode.setNumber(msgType.getString(NUMBER));
                msgNode.setName(msgTypeName);
                msgNode.setParentid("message");
                String number = msgNode.getNumber();
                msgNode.setCount(this.getQuantitySummary(quantitySummaryInfos, "msg", number));
                String ImgNumber = this.checkCustomType(number) ? "customtype" : number;
                msgNode.setImgSrc("private/wf/navigation/" + ImgNumber + ".png");
                msgNode.setHoverImgSrc("private/wf/navigation/" + ImgNumber + "_hover.png");
                msgNode.setCategory(NavigationTreeNode.NavigationMenuCategory.MESSAGE.getNumber());
                msgNodes.add(msgNode);
            }
        }
        Collections.sort(msgNodes, new Comparator<NavigationTreeNode>(){

            @Override
            public int compare(NavigationTreeNode node1, NavigationTreeNode node2) {
                Long nodeId1 = Long.parseLong(node1.getId());
                Long nodeId2 = Long.parseLong(node2.getId());
                if (nodeId1 < nodeId2) {
                    return -1;
                }
                if (nodeId1 > nodeId2) {
                    return 1;
                }
                return 0;
            }
        });
        return msgNodes;
    }

    private boolean checkCustomType(String typeNumber) {
        boolean isCustomType = Boolean.TRUE;
        if (StringUtils.isNotBlank((CharSequence)typeNumber)) {
            for (String messageType : messaeTypeArray) {
                if (!messageType.equalsIgnoreCase(typeNumber) || ACTIVITY.equalsIgnoreCase(typeNumber)) continue;
                isCustomType = Boolean.FALSE;
                break;
            }
        }
        return isCustomType;
    }

    private int getQuantitySummary(List<QuantitySummaryInfo> quantitySummaryInfos, String dataType, String billType) {
        MessageQuantitySummaryServcie service = MessageServiceUtil.getMessageQuantitySummaryService();
        return service.getQuantitySummaryCount(quantitySummaryInfos, dataType, billType);
    }

    public List<Map<String, Object>> getMsgCenterCardOptions(String userId) {
        ArrayList<Map<String, Object>> optionList = new ArrayList<Map<String, Object>>();
        MessageQuantitySummaryServcie service = MessageServiceUtil.getMessageQuantitySummaryService();
        List quantitySummaryInfos = service.getMsgQuantitySummary(Long.valueOf(userId), "mainPageCard");
        HashMap<String, Object> toHandle = new HashMap<String, Object>();
        toHandle.put("id", "toHandle");
        toHandle.put("name", ResManager.loadKDString((String)"\u5f85\u529e\u4efb\u52a1", (String)"MessageCenterServiceImpl_2", (String)MESSAGEENTITY, (Object[])new Object[0]));
        toHandle.put(FORMID, "wf_msg_center");
        toHandle.put(COUNT, this.getQuantitySummary(quantitySummaryInfos, "tohandle", null));
        toHandle.put(BILLFORMID, "wf_task");
        optionList.add(toHandle);
        HashMap<String, Object> handled = new HashMap<String, Object>();
        handled.put("id", "handled");
        handled.put("name", ResManager.loadKDString((String)"\u5df2\u529e\u4efb\u52a1", (String)"MessageCenterServiceImpl_3", (String)MESSAGEENTITY, (Object[])new Object[0]));
        handled.put(FORMID, "wf_msg_center");
        handled.put(COUNT, this.getQuantitySummary(quantitySummaryInfos, "handled", null));
        handled.put(BILLFORMID, "wf_hitaskinst");
        optionList.add(handled);
        HashMap<String, Object> toApply = new HashMap<String, Object>();
        toApply.put("id", "toApply");
        toApply.put("name", ResManager.loadKDString((String)"\u5728\u529e\u7533\u8bf7", (String)"MessageCenterServiceImpl_4", (String)MESSAGEENTITY, (Object[])new Object[0]));
        toApply.put(FORMID, "wf_msg_center");
        toApply.put(COUNT, this.getQuantitySummary(quantitySummaryInfos, "toapply", null));
        toApply.put(BILLFORMID, "wf_execution_tc");
        optionList.add(toApply);
        HashMap<String, Object> applyed = new HashMap<String, Object>();
        applyed.put("id", "applyed");
        applyed.put("name", ResManager.loadKDString((String)"\u5df2\u529e\u7533\u8bf7", (String)"MessageCenterServiceImpl_5", (String)MESSAGEENTITY, (Object[])new Object[0]));
        applyed.put(FORMID, "wf_msg_center");
        applyed.put(COUNT, this.getQuantitySummary(quantitySummaryInfos, "applyed", null));
        applyed.put(BILLFORMID, "wf_hiprocinst");
        optionList.add(applyed);
        List<Map<String, Object>> msgOfType = this.getCardOption(quantitySummaryInfos);
        optionList.addAll(msgOfType);
        return optionList;
    }

    private List<Map<String, Object>> getCardOption(List<QuantitySummaryInfo> quantitySummaryInfos) {
        ArrayList<Map<String, Object>> optionList = new ArrayList<Map<String, Object>>();
        DynamicObject[] msgTypes = BusinessDataServiceHelper.load((String)MSGTYPE, (String)"id, number, name, category", null);
        if (msgTypes != null && msgTypes.length > 0) {
            for (DynamicObject msgType : msgTypes) {
                if ("task".equals(msgType.get("category"))) continue;
                String lang = RequestContext.get().getLang().toString();
                String msgTypeName = (String)msgType.getLocaleString("name").get((Object)lang);
                HashMap<String, Object> option = new HashMap<String, Object>();
                option.put("id", msgType.getString("id"));
                option.put("name", msgTypeName);
                option.put(FORMID, "wf_msg_center");
                int msgNodeCount = this.getQuantitySummary(quantitySummaryInfos, "msg", msgType.getString(NUMBER));
                option.put(COUNT, msgNodeCount);
                option.put(BILLFORMID, MSGMESSAGEENTITY);
                optionList.add(option);
            }
        }
        int unreadCount = quantitySummaryInfos.stream().mapToInt(item -> "msg".equals(item.getDataType()) ? item.getQuantitysum() : 0).sum();
        HashMap<String, Object> unread = new HashMap<String, Object>();
        unread.put("id", UNREAD);
        unread.put("name", ResManager.loadKDString((String)"\u672a\u8bfb\u6d88\u606f", (String)"MessageCenterServiceImpl_6", (String)MESSAGEENTITY, (Object[])new Object[0]));
        unread.put(FORMID, "wf_msg_center");
        unread.put(COUNT, unreadCount);
        unread.put(BILLFORMID, MSGMESSAGEENTITY);
        optionList.add(unread);
        return optionList;
    }

    public List<String> getMessageTemplateByFilters(String type, String channel, String scene, String entityNumber) {
        ArrayList<String> templateList = new ArrayList<String>();
        List<ILocaleString> tpl = this.getMessageTemplateLocaleByFilters(type, channel, scene, entityNumber);
        if (tpl != null && tpl.size() > 0) {
            templateList.add(tpl.get(0).getLocaleValue());
        }
        return templateList;
    }

    public List<ILocaleString> getMessageTemplateLocaleByFilters(String type, String channel, String scene, String entityNumber) {
        return MessageUtils.getMessageTemplateLocale(null, (String)type, (String)channel, (String)scene, (String)entityNumber);
    }

    public String getChannelsOfMsgType(String type) {
        String channels = "";
        Map typeInfo = MessageUtils.getMessageTypeInfo((String)type);
        if (typeInfo != null && !typeInfo.isEmpty()) {
            channels = (String)typeInfo.get(CHANNELS);
        }
        return channels;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> retractMessage(Long messageId) {
        HashMap<String, Object> resultInfo = new HashMap<String, Object>();
        boolean retractOK = true;
        String msg = null;
        if (StringUtils.isBlank((Object)messageId)) {
            retractOK = false;
        } else {
            try (TXHandle tx = TX.requiresNew();){
                ArrayList<Object> msgIds = new ArrayList<Object>();
                msgIds.add(messageId);
                this.deleteMessage(msgIds);
                MainEntityType metMessage = EntityMetadataCache.getDataEntityType((String)MSGMESSAGEENTITY);
                DeleteServiceHelper.delete((IDataEntityType)metMessage, (Object[])new Object[]{messageId});
                DeleteServiceHelper.delete((String)MSGRECEIVERENITTY, (QFilter[])new QFilter[]{new QFilter(MESSAGEID, "=", (Object)messageId)});
            }
        }
        if (retractOK) {
            resultInfo.put("msg", SUCCESS);
        } else {
            resultInfo.put("msg", msg);
        }
        return resultInfo;
    }

    public List<Map<String, Object>> getMessageByFilter(String userId, String entityNumber, String tags, String msgType, boolean unread, int top) {
        HashMap<String, Object> filterParams = new HashMap<String, Object>();
        filterParams.put("entityNumber", entityNumber);
        filterParams.put("tags", tags);
        filterParams.put("msgType", msgType);
        filterParams.put(UNREAD, unread);
        int start = 0;
        int limit = top;
        return this.getMessageByFilter(userId, start, limit, filterParams);
    }

    public List<Map<String, Object>> getMessageByFilter(String userId, int start, int limit, Map<String, Object> filterParams) {
        if (!WfConfigurationUtil.isNotQueryByNewSql() && WfConfigurationUtil.isRepaireMsgReceiverComplete().booleanValue()) {
            HashMap<String, String> filterMap = new HashMap<String, String>(filterParams.size());
            for (Map.Entry<String, Object> entry : filterParams.entrySet()) {
                filterMap.put(entry.getKey(), String.valueOf(entry.getValue()));
            }
            ProcessDataEntityQueryParams processDataEntityQueryParams = new ProcessDataEntityQueryParams(Long.valueOf(userId), start, limit, "", "").setSqlFilterMap(filterMap);
            return new GetMessageDataListForApiCmd(processDataEntityQueryParams).execute(Context.getCommandContext());
        }
        ArrayList<Map<String, Object>> msgData = new ArrayList<Map<String, Object>>();
        DynamicObjectCollection msgObjectCollection = this.getMessageDataForApi(userId, start, limit, filterParams);
        if (msgObjectCollection != null && msgObjectCollection.size() > 0) {
            for (DynamicObject msgObject : msgObjectCollection) {
                HashMap<String, Object> msg = new HashMap<String, Object>();
                msg.put("id", msgObject.get("id"));
                msg.put("type", msgObject.get("type"));
                msg.put(CREATEDATE, msgObject.get(CREATEDATE));
                msg.put(SENDER, msgObject.get(SENDER));
                msg.put(CONTENTURL, msgObject.get(CONTENTURL));
                msg.put(MOBCONTENTURL, msgObject.get(MOBCONTENTURL));
                msg.put(ENTITYNUMBER, msgObject.get(ENTITYNUMBER));
                msg.put(BIZDATAID, msgObject.get(BIZDATAID));
                msg.put(READSTATE, msgObject.get(READSTATE));
                msg.put(TITLE, msgObject.get(TITLE));
                msg.put(CONTENT, msgObject.get(CONTENT));
                msg.put("tag", msgObject.get("tag"));
                msg.put(SENDERNAME, msgObject.get(SENDERNAME));
                msgData.add(msg);
            }
        }
        return msgData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DynamicObjectCollection getMessageDataForApi(String userId, int start, int limit, Map<String, Object> filterParams) {
        DynamicObjectCollection col;
        ArrayList<Object> paramList = new ArrayList<Object>();
        paramList.add(Long.valueOf(userId));
        paramList.add(RequestContext.get().getLang().toString());
        paramList.add(Long.valueOf(userId));
        boolean unread = (Boolean)filterParams.get(UNREAD);
        String entityNumber = (String)filterParams.get("entityNumber");
        String tags = (String)filterParams.get("tags");
        String source = (String)filterParams.get("source");
        String title = (String)filterParams.get(TITLE);
        String msgType = (String)filterParams.get("msgType");
        String linkMsgType = (String)filterParams.get("linkMsgType");
        String typeId = null;
        if (StringUtils.isNotBlank((CharSequence)msgType)) {
            try {
                DynamicObject typeObject = BusinessDataServiceHelper.loadSingle((String)MSGTYPE, (String)"id", (QFilter[])new QFilter[]{new QFilter(NUMBER, "=", (Object)msgType)});
                typeId = typeObject.getString("id");
            }
            catch (Exception e) {
                this.printLog("getMessageDataForApi msgType is not exists,msgType is:" + msgType);
                return null;
            }
        }
        String titleSQL = WfMultiLangUtils.getGeneralLangSQL((String)MSGMESSAGEENTITY, (String)"a", (String)"b", (String)FTITLE, (String)TITLE, (String)TITLE);
        String tagSQL = WfMultiLangUtils.getGeneralLangSQL((String)MSGMESSAGEENTITY, (String)"a", (String)"b", (String)"ftag", (String)"tag", (String)"tag");
        String senderNameSQL = WfMultiLangUtils.getGeneralLangSQL((String)MSGMESSAGEENTITY, (String)"a", (String)"b", (String)"fsendername", (String)SENDERNAME, (String)SENDERNAME);
        StringBuilder sql = new StringBuilder();
        sql.append(SELECTPART).append(limit == 0 ? "" : "top " + (start + limit));
        sql.append(" a.fid id, a.ftype type, a.fcreatedate createdate, a.fsender sender, a.fcontenturl contenturl, a.fmobcontenturl mobcontenturl, a.fentitynumber entitynumber, a.fbizdataid bizdataid, c.freadstate readstate, b.fcontent content, ");
        sql.append(titleSQL).append(", ").append(tagSQL).append(", ").append(senderNameSQL);
        sql.append(" from t_wf_msgreceiver c inner join t_wf_message a on c.fmessageid = a.fid and c.freceiverid = ?");
        if (unread) {
            sql.append(" and c.freadstate = 'unread'");
        }
        sql.append(" inner join t_wf_message_l b on a.fid = b.fid and b.flocaleid = ? ");
        sql.append(" where c.freceiverid = ? ");
        if (unread) {
            sql.append(" and c.freadstate = 'unread'");
        }
        if (StringUtils.isNotBlank((CharSequence)entityNumber)) {
            sql.append(" and a.fentitynumber like ? ");
            paramList.add(entityNumber + "%");
        }
        if (StringUtils.isNotBlank((CharSequence)tags)) {
            sql.append(" and b.ftag like ? ");
            paramList.add(tags + "%");
        }
        if (WfUtils.isNotEmpty((String)source)) {
            sql.append(" and a.fsource = ? ");
            paramList.add(source);
        }
        if (StringUtils.isNotBlank((CharSequence)title)) {
            sql.append(" and b.ftitle like ? ");
            paramList.add(title + "%");
        }
        if (StringUtils.isNotBlank((CharSequence)typeId)) {
            sql.append(" and a.ftype = ?");
            paramList.add(Long.valueOf(typeId));
        }
        if ("text".equalsIgnoreCase(linkMsgType)) {
            sql.append(" and (a.fcontenturl is null or a.fcontenturl = '' or a.fcontenturl = ' ') ");
        } else if ("link".equalsIgnoreCase(linkMsgType)) {
            sql.append(" and (a.fcontenturl is not null and a.fcontenturl != '' and a.fcontenturl != ' ') ");
        }
        sql.append(" order by a.fcreatedate desc; ");
        Object[] params = paramList.toArray();
        try (DataSet ds = DB.queryDataSet((String)"MessageCenter.wf_message.queryGridData", (DBRoute)DBRoute.workflow, (String)sql.toString(), (Object[])params);){
            col = limit == 0 ? ORM.create().toPlainDynamicObjectCollection(ds) : ORM.create().toPlainDynamicObjectCollection(ds, start, limit);
        }
        return col;
    }

    public List<Map<String, Object>> getToHandleTasksMessage(Long userId, Integer top) {
        return MessagePersonalSettingUtils.getToHandleTaskUnreadMessageData((Long)userId, (int)top, (PersonalSettingInfo.SourceTypeEnum)PersonalSettingInfo.SourceTypeEnum.TASK);
    }

    protected String createAlgoKey() {
        String methodName = Thread.currentThread().getStackTrace()[2].getMethodName();
        return new StringBuffer().append("bos.wf.").append(this.getClass().getName()).append(".").append(methodName).toString();
    }

    public Long getTaskCountByType(String userId, String dataType) {
        MessageQuantitySummaryServcie service = MessageServiceUtil.getMessageQuantitySummaryService();
        List quantitySummaryInfos = service.getMsgQuantitySummary(Long.valueOf(Long.parseLong(userId)), dataType);
        int count = this.getQuantitySummary(quantitySummaryInfos, dataType, null);
        return (long)count + 0L;
    }

    public void updateBadgeCount(List<Long> userIds) {
        HashSet<Long> userSets = new HashSet<Long>(userIds);
        MessageQuantitySummaryServcie service = MessageServiceUtil.getMessageQuantitySummaryService();
        service.updateUserAvatarBadge(userSets);
    }

    public void resendMessageByIds(List<Long> channelMsgIds) {
        FailMessageUtil.batchResendFailMessage(channelMsgIds, null);
    }

    public void resendMessageByMsgInfos(List<MessageInfo> messageInfos) {
        FailMessageUtil.batchResendFailMessage(null, messageInfos);
    }

    public Map<String, Object> updateChannelData(Map<String, Object> channelParam) {
        return MessageUtils.updateChannelData(channelParam);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> getMessageReadState(Long msgId) {
        HashMap<String, Object> messageReadData = new HashMap<String, Object>();
        StringBuilder sql = new StringBuilder();
        if (WfConfigurationUtil.isRepaireMsgReceiverComplete().booleanValue()) {
            sql.append("SELECT ");
            sql.append("b.fmessageid FID, b.FTOALL, b.FREADSTATE, b.FRECEIVERID, b.FREADTIME ");
            sql.append("FROM t_wf_msgreceiver b ");
            sql.append("WHERE b.fmessageid=?");
        } else {
            sql.append("SELECT ");
            sql.append("a.FID, a.FTOALL, b.FREADSTATE, b.FRECEIVERID, b.FREADTIME ");
            sql.append("FROM t_wf_message a LEFT JOIN t_wf_msgreceiver b ON a.FID=b.FMESSAGEID ");
            sql.append("WHERE a.FID=?");
        }
        Object[] params = new Object[]{msgId};
        try (DataSet dataSet = null;){
            ArrayList<Long> readReceiverIds = new ArrayList<Long>();
            ArrayList<Long> unreadReceiverIds = new ArrayList<Long>();
            dataSet = DB.queryDataSet((String)this.createAlgoKey(), (DBRoute)DBRoute.workflow, (String)sql.toString(), (Object[])params);
            if (dataSet != null) {
                for (Row row : dataSet) {
                    messageReadData.put(TOALL2, row.getBoolean("FTOALL"));
                    String readState = row.getString("FREADSTATE");
                    if ("read".equalsIgnoreCase(readState)) {
                        readReceiverIds.add(row.getLong("FRECEIVERID"));
                        continue;
                    }
                    if (!UNREAD.equalsIgnoreCase(readState)) continue;
                    unreadReceiverIds.add(row.getLong("FRECEIVERID"));
                }
                if (((Boolean)messageReadData.get(TOALL2)).booleanValue()) {
                    messageReadData.put("read", readReceiverIds);
                } else {
                    messageReadData.put("read", readReceiverIds);
                    messageReadData.put(UNREAD, unreadReceiverIds);
                }
                messageReadData.put("messageId", msgId);
            }
        }
        return messageReadData;
    }

    private void sendNoticeMessageByLoginUserMainLogic(Map.Entry<Long, DynamicObject> entry, Long userId) {
        Map c;
        DynamicObject msgData = entry.getValue();
        Long type = msgData.getLong("type");
        HashMap<String, Object> param = new HashMap<String, Object>();
        String config = msgData.getString("config");
        int showType = 1;
        long timeOut = SystemNoticeCommonUtil.TIMEOUT;
        String url = "";
        int duration = 0;
        String clickClassName = "";
        String noticeType = "";
        if (StringUtils.isNotBlank((CharSequence)config) && !(c = (Map)SerializationUtils.fromJsonString((String)config, Map.class)).isEmpty() && StringUtils.isNotBlank(c.get("systemNotice"))) {
            Map systemNotice = (Map)c.get("systemNotice");
            Object st = systemNotice.get("showType");
            if (st instanceof String) {
                showType = Integer.parseInt((String)st);
            } else if (st instanceof Integer) {
                showType = (Integer)st;
            }
            Object to = systemNotice.get("timeOut");
            if (to instanceof String) {
                timeOut = Long.parseLong((String)to);
            } else if (to instanceof Integer) {
                timeOut = (long)((Integer)to).intValue() + 0L;
            } else if (to instanceof Long) {
                timeOut = (Long)to;
            }
            if (StringUtils.isNotBlank(systemNotice.get("url"))) {
                url = (String)systemNotice.get("url");
            }
            if (StringUtils.isNotBlank(systemNotice.get("duration"))) {
                duration = (Integer)systemNotice.get("duration");
            }
            if (StringUtils.isNotBlank(systemNotice.get("clickClassName"))) {
                clickClassName = (String)systemNotice.get("clickClassName");
            }
            if (StringUtils.isNotBlank(systemNotice.get("noticeType"))) {
                noticeType = (String)systemNotice.get("noticeType");
            }
        }
        Date createDate = (Date)msgData.get(CREATEDATE);
        Long createTime = createDate.getTime();
        Long currentTime = System.currentTimeMillis();
        if (currentTime <= createTime + timeOut) {
            param.put("showType", showType);
            param.put("timeOut", timeOut);
            ILocaleString title = msgData.getLocaleString(TITLE);
            ILocaleString content = msgData.getLocaleString(CONTENT);
            param.put(CONTENT, WfUtils.isEmpty((ILocaleString)content) ? "" : content.toString());
            param.put(TITLE, WfUtils.isEmpty((ILocaleString)title) ? "" : title.toString());
            param.put(MESSAGETITLE, title);
            param.put(MESSAGECONTENT, content);
            param.put("accountId", RequestContext.get().getAccountId());
            ArrayList<Long> userIds = new ArrayList<Long>();
            userIds.add(userId);
            param.put(USERID, userIds);
            param.put(TOALL2, false);
            param.put("msgId", msgData.getLong("id"));
            param.put("url", url);
            param.put("duration", duration);
            param.put("clickClassName", clickClassName);
            if (WfUtils.isNotEmpty((String)noticeType)) {
                param.put("msgType", noticeType);
            } else if (type.equals(1223746113903789056L)) {
                param.put("msgType", ACTIVITY);
            } else if (type.equals(1005601617044585472L)) {
                param.put("msgType", NOTICE);
            }
            SystemNoticeCommonUtil.sendSystemNoticeMessage(param);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void analyseMsgReceiverData(Map<String, Object> map, Map<Long, DynamicObject> msgMap, Long userId) {
        Date endDate = new Date();
        Integer queryDays = this.getConfigCenterProperty(5, "message", "msg.notice.queryDays");
        Date startDate = new Date(System.currentTimeMillis() - (long)(queryDays * 24 * 3600) * 1000L);
        StringBuilder sql = new StringBuilder(SELECTPART);
        sql.append("c.fid receiverPkId, c.fmessageid id, c.ftype type, c.ftoall toall, c.fcreatedate createdate, c.ftitle title ");
        sql.append("from t_wf_msgreceiver c ");
        sql.append("where c.freceiverid = ? and c.fpopup = '1' ");
        sql.append("and c.fcreatedate >= ? and c.fcreatedate <= ? ");
        sql.append("and c.ftype in (1005601617044585472, 1223746113903789056) order by c.fcreatedate;");
        try (DataSet dataSet = null;){
            Object[] params = new Object[]{userId, startDate, endDate};
            dataSet = DB.queryDataSet((String)this.createAlgoKey(), (DBRoute)DBRoute.workflow, (String)sql.toString(), (Object[])params);
            if (dataSet != null) {
                Iterator iterator = dataSet.iterator();
                ArrayList<Long> receiverIds = new ArrayList<Long>();
                HashMap<Long, Long> idsMap = new HashMap<Long, Long>();
                while (iterator.hasNext()) {
                    Row msgData = (Row)iterator.next();
                    DynamicObject msgObj = BusinessDataServiceHelper.newDynamicObject((String)MSGMESSAGEENTITY);
                    msgObj.set("type", (Object)msgData.getLong("type"));
                    msgObj.set("toall", msgData.get("toall"));
                    msgObj.set(TITLE, msgData.get(TITLE));
                    msgObj.set(CREATEDATE, (Object)msgData.getDate(CREATEDATE));
                    msgObj.set("id", (Object)msgData.getLong("id"));
                    msgMap.put(msgData.getLong("id"), msgObj);
                    Long receiverPkId = msgData.getLong("receiverPkId");
                    receiverIds.add(receiverPkId);
                    idsMap.put(msgData.getLong("id"), receiverPkId);
                }
                Map<Long, String> titleMultiMap = this.queryMultiMsgReceiver(receiverIds);
                if (WfUtils.isNotEmptyForMap(msgMap) && WfUtils.isNotEmptyForMap(titleMultiMap)) {
                    for (Map.Entry<Long, DynamicObject> entry : msgMap.entrySet()) {
                        DynamicObject object = entry.getValue();
                        Long messageId = entry.getKey();
                        Long receiverPkId = (Long)idsMap.get(messageId);
                        String title = titleMultiMap.get(receiverPkId);
                        if (!WfUtils.isNotEmpty((String)title)) continue;
                        object.set(TITLE, (Object)title);
                    }
                }
            }
        }
    }

    private Integer getConfigCenterProperty(Integer defaultValue, String type, String key) {
        Integer confVal = 0;
        Object obj = MessageServiceUtil.getConfigCenterProperty((String)type, (String)key);
        if (obj != null) {
            confVal = Integer.parseInt((String)obj);
        }
        Integer resultVal = defaultValue;
        if (confVal > 0 && confVal < 30) {
            resultVal = confVal;
        }
        return resultVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<Long, String> queryMultiMsgReceiver(List<Long> receiverIds) {
        HashMap<Long, String> titleMultiMap = new HashMap<Long, String>();
        if (WfUtils.isEmptyForCollection(receiverIds)) {
            return titleMultiMap;
        }
        StringBuilder sql = new StringBuilder(SELECTPART);
        sql.append("b.fid id, b.ftitle title ");
        sql.append("from t_wf_msgreceiver_l b ");
        sql.append("where b.fid in (?) ");
        sql.append("and b.flocaleid = ").append("'").append(RequestContext.get().getLang()).append("' ;");
        try (DataSet dataSet = null;){
            String newSql = sql.toString().replaceAll("\\?", WfUtils.getQuestionMarkList((int)receiverIds.size()));
            dataSet = DB.queryDataSet((String)this.createAlgoKey(), (DBRoute)DBRoute.workflow, (String)newSql, (Object[])receiverIds.toArray());
            if (dataSet != null) {
                for (Row row : dataSet) {
                    titleMultiMap.put(row.getLong("id"), row.getString(TITLE));
                }
            }
        }
        return titleMultiMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void packageMsgData(Map<String, Object> map, Map<Long, DynamicObject> msgMap, List<Long> msgIds) {
        StringBuilder sql = new StringBuilder(SELECTPART);
        String contentSummarySQL = WfMultiLangUtils.getGeneralLangSQL((String)MSGMESSAGEENTITY, (String)"a", (String)"b", (String)"fcontent_summary", (String)"content_summary", (String)"content_summary");
        sql.append("a.fid id, a.fcontenturl contenturl, a.fconfig config, b.fcontent content, ");
        sql.append(contentSummarySQL).append(" ");
        sql.append("from t_wf_message a ");
        sql.append("inner join t_wf_message_l b on a.fid = b.fid and b.flocaleid = ").append("'").append(RequestContext.get().getLang()).append("' ");
        sql.append("where a.fid in (?) ");
        try (DataSet dataSet = null;){
            String newSql = sql.toString().replaceAll("\\?", WfUtils.getQuestionMarkList((int)msgIds.size()));
            dataSet = DB.queryDataSet((String)this.createAlgoKey(), (DBRoute)DBRoute.workflow, (String)newSql, (Object[])msgIds.toArray());
            if (dataSet != null) {
                for (Row msgData : dataSet) {
                    DynamicObject msgObj = msgMap.get(msgData.getLong("id"));
                    if (msgObj == null) continue;
                    msgObj.set(CONTENTURL, msgData.get(CONTENTURL));
                    msgObj.set("config", msgData.get("config"));
                    if (WfUtils.isEmptyString((Object)msgData.get(CONTENT))) {
                        msgObj.set(CONTENT, msgData.get("content_summary"));
                    } else {
                        msgObj.set(CONTENT, msgData.get(CONTENT));
                    }
                    msgMap.put(msgData.getLong("id"), msgObj);
                }
            }
        }
    }

    private boolean canCorrectQSInfos() {
        boolean useQS = !WfConfigurationUtil.diableUseQuantitySummary();
        boolean canCorrectQS = WfConfigurationUtil.canCorrectLoginUserQSInfos();
        return canCorrectQS && useQS;
    }

    private void gatherLoginUserData(Long userId) {
        try {
            if (!this.canCorrectQSInfos()) {
                return;
            }
            String loginUserSign = MsgServiceCacheHelper.getLoginUserSign((Long)userId);
            if (WfUtils.isNotEmpty((String)loginUserSign)) {
                return;
            }
            boolean isImmediatelyhandle = true;
            int userLoginSampleSpacing = 4;
            String config = WfConfigurationUtil.getLoginUserCorrectConfig();
            if (config != null) {
                String[] configs = config.split(",");
                userLoginSampleSpacing = Integer.parseInt(configs[0]);
                if (configs.length >= 5) {
                    isImmediatelyhandle = Boolean.parseBoolean(configs[4]);
                }
            }
            HashMap<String, Boolean> params = new HashMap<String, Boolean>();
            params.put("isImmediatelyhandle", isImmediatelyhandle);
            MsgServiceCacheHelper.putLoginUserSign((Long)userId, (int)(userLoginSampleSpacing * 3600));
            ConcurrentDataService concurrentDataService = ConcurrentDataService.create();
            concurrentDataService.gatherConcurrentData(userId, null, ConcurrentBizType.CORRECTLOGINUSERQSINFO, params);
        }
        catch (Exception ex) {
            this.printLog("correct_quantitySummaryInfo_hasException:" + WfUtils.getExceptionStacktrace((Throwable)ex));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> sendNoticeMessageByLoginUser(Long userId) {
        this.gatherLoginUserData(userId);
        Map<String, Object> map = new HashMap<String, Object>();
        HashMap<Long, DynamicObject> msgMap = new HashMap<Long, DynamicObject>();
        List<Object> msgIds = new ArrayList(1);
        if (WfConfigurationUtil.isRepaireMsgReceiverComplete().booleanValue()) {
            this.analyseMsgReceiverData(map, msgMap, userId);
            if (msgMap.isEmpty()) {
                return map;
            }
            msgIds = msgMap.keySet().stream().collect(Collectors.toList());
            this.packageMsgData(map, msgMap, msgIds);
        } else {
            StringBuilder sql = new StringBuilder(SELECTPART);
            Object[] objectArray = new Object[]{userId, RequestContext.get().getLang(), userId};
            String titleSQL = WfMultiLangUtils.getGeneralLangSQL((String)MSGMESSAGEENTITY, (String)"a", (String)"b", (String)FTITLE, (String)TITLE, (String)TITLE);
            String contentSummarySQL = WfMultiLangUtils.getGeneralLangSQL((String)MSGMESSAGEENTITY, (String)"a", (String)"b", (String)"fcontent_summary", (String)"content_summary", (String)"content_summary");
            sql.append("a.fid id, a.ftype type, a.ftoall toall, a.fcreatedate createdate, a.fcontenturl contenturl, a.fconfig config, b.fcontent content, ");
            sql.append(titleSQL).append(", ");
            sql.append(contentSummarySQL).append(" ");
            sql.append("from t_wf_msgreceiver c inner join t_wf_message a on c.fmessageid = a.fid and c.freceiverid = ? and c.fpopup = '1'");
            sql.append("inner join t_wf_message_l b on a.fid = b.fid and b.flocaleid = ? ");
            sql.append("where c.freceiverid = ? and c.fpopup = '1' ");
            sql.append("and a.ftype in (1005601617044585472, 1223746113903789056) order by a.fcreatedate;");
            try (DataSet dataSet = null;){
                dataSet = DB.queryDataSet((String)this.createAlgoKey(), (DBRoute)DBRoute.workflow, (String)sql.toString(), (Object[])objectArray);
                if (dataSet != null) {
                    for (Row msgData : dataSet) {
                        DynamicObject msgObj = BusinessDataServiceHelper.newDynamicObject((String)MSGMESSAGEENTITY);
                        msgObj.set("type", (Object)msgData.getLong("type"));
                        msgObj.set("toall", msgData.get("toall"));
                        msgObj.set(CONTENTURL, msgData.get(CONTENTURL));
                        msgObj.set("config", msgData.get("config"));
                        if (WfUtils.isEmptyString((Object)msgData.get(CONTENT))) {
                            msgObj.set(CONTENT, msgData.get("content_summary"));
                        } else {
                            msgObj.set(CONTENT, msgData.get(CONTENT));
                        }
                        msgObj.set(TITLE, msgData.get(TITLE));
                        msgObj.set(CREATEDATE, (Object)msgData.getDate(CREATEDATE));
                        msgObj.set("id", (Object)msgData.getLong("id"));
                        msgMap.put(msgData.getLong("id"), msgObj);
                    }
                    if (!msgMap.isEmpty()) {
                        msgIds = msgMap.keySet().stream().collect(Collectors.toList());
                    }
                }
            }
        }
        try {
            this.queryMultiContentByMsgIdAndPackage(msgIds, msgMap);
            for (Map.Entry entry : msgMap.entrySet()) {
                this.sendNoticeMessageByLoginUserMainLogic(entry, userId);
            }
            map = MessageUtils.wrapResult((String)SUCCESS, msgIds);
        }
        catch (Exception e) {
            this.printLog("sendNoticeMessageByLoginUser-queryDBHasException:" + WfUtils.getExceptionStacktrace((Throwable)e));
            map = MessageUtils.wrapResult((String)e.getMessage(), null);
        }
        return map;
    }

    private void queryMultiContentByMsgIdAndPackage(List<Long> msgIds, Map<Long, DynamicObject> msgMap) {
        if (WfUtils.isEmptyForCollection(msgIds)) {
            return;
        }
        try {
            Object[] dynamicObjects = BusinessDataServiceHelper.load((String)MSGMESSAGEENTITY, (String)"id, title, content", (QFilter[])new QFilter[]{new QFilter("id", "in", msgIds)}, (String)CREATEDATE);
            if (WfUtils.isEmptyForArrays((Object[])dynamicObjects)) {
                return;
            }
            for (Object obj : dynamicObjects) {
                DynamicObject msgObject = msgMap.get(obj.getLong("id"));
                msgObject.set(TITLE, obj.get(TITLE));
                msgObject.set(CONTENT, obj.get(CONTENT));
            }
        }
        catch (Exception e) {
            logger.info("queryTitleAndContentByMsgId:" + WfUtils.getExceptionStacktrace((Throwable)e));
        }
    }

    @Override
    public TaskService getTaskService() {
        if (this.taskService == null) {
            this.init();
        }
        if (this.taskService == null) {
            throw new KDException(WFErrorCode.workflowEngineUnStarted(), new Object[0]);
        }
        return this.taskService;
    }

    protected void init() {
        boolean canRunWf = WfConfigurationUtil.canRunWorkflow();
        if (!canRunWf) {
            throw new KDException(WFErrorCode.workflowEngineNotConfiguration(), new Object[0]);
        }
        try {
            if (!ProcessEngines.isInitialized()) {
                ProcessEngines.init();
            }
            this.taskService = ProcessEngines.getDefaultProcessEngine().getTaskService();
        }
        catch (KDException e) {
            throw e;
        }
        catch (Exception e) {
            throw new KDException((Throwable)e, WFErrorCode.engineStartErrored(), new Object[]{e.getMessage()});
        }
    }

    public Map<String, Object> createTask(TaskEntityInfo taskEntityInfo) {
        if (taskEntityInfo == null) {
            return CustomTaskUtils.getResult((Boolean)Boolean.FALSE, (String)"taskEntityInfo is null");
        }
        ILocaleString taskName = taskEntityInfo.getName();
        ILocaleString taskSubject = taskEntityInfo.getSubject();
        if (WfUtils.isEmpty((ILocaleString)taskName) || WfUtils.isEmpty((ILocaleString)taskSubject)) {
            return CustomTaskUtils.getResult((Boolean)Boolean.FALSE, (String)String.format("taskEntityInfo name[%s] or subject[%s] is null", taskName, taskSubject));
        }
        String taskCategory = taskEntityInfo.getCategory();
        Long starterId = taskEntityInfo.getStarterId();
        String entityNumber = taskEntityInfo.getEntityNumber();
        String businessKey = taskEntityInfo.getBusinessKey();
        String billno = taskEntityInfo.getBillNo();
        if (WfUtils.isEmpty((String)taskCategory) || WfUtils.isEmpty((Long)starterId) || WfUtils.isEmpty((String)entityNumber) || WfUtils.isEmpty((String)businessKey) || WfUtils.isEmpty((String)billno)) {
            return CustomTaskUtils.getResult((Boolean)Boolean.FALSE, (String)String.format("taskEntityInfo category[%s] or starterId[%s] or entityNumber[%s] or businessKey[%s], billno[%s] is null", taskCategory, starterId, entityNumber, businessKey, billno));
        }
        List participantInfos = taskEntityInfo.getParticipantInfos();
        if (participantInfos == null || participantInfos.size() == 0) {
            return CustomTaskUtils.getResult((Boolean)Boolean.FALSE, (String)"taskEntityInfo participants is empty");
        }
        TaskService taskService = this.getTaskService();
        return taskService.createTask(taskEntityInfo);
    }

    public Map<String, Object> batchComplateTasks(List<Long> taskIds, Long userId, ILocaleString opinion, Map<String, Object> variables) {
        if (taskIds == null || taskIds.size() == 0) {
            return CustomTaskUtils.getResult((Boolean)Boolean.FALSE, (String)"taskIds is empty");
        }
        if (WfUtils.isEmpty((ILocaleString)opinion)) {
            return CustomTaskUtils.getResult((Boolean)Boolean.FALSE, (String)"task opinion is empty");
        }
        if (userId == null) {
            String uId = RequestContext.get().getUserId();
            userId = Long.parseLong(uId);
        }
        if (variables == null) {
            variables = new HashMap<String, Object>();
        }
        variables.put("terminal", "api");
        TaskService taskService = this.getTaskService();
        String resultJson = taskService.batchCompleteCustomTask(taskIds, userId, opinion, Boolean.TRUE.booleanValue(), variables);
        return CustomTaskUtils.getResult((Boolean)Boolean.TRUE, (String)"task handle success", (String)resultJson);
    }

    public Map<String, Object> updateTaskParticipant(Long taskId, List<Long> userIds) {
        if (WfUtils.isEmpty((Long)taskId) || userIds == null || userIds.size() == 0) {
            return CustomTaskUtils.getResult((Boolean)Boolean.FALSE, (String)String.format("api parameter taskId[%s] or userIds[%s] is null", taskId, userIds));
        }
        Map res = null;
        try (DLock tlock = DLock.create((String)String.format("wf/updateparticipant/%s", taskId), (String)("updateParticipant[" + taskId + "]")).fastMode();){
            boolean lockSuccess = tlock.tryLock(60000L);
            if (lockSuccess) {
                this.taskService = this.getTaskService();
                res = this.taskService.adminTransferTasks(String.valueOf(taskId), WfUtils.listToString(userIds, (String)","), (ILocaleString)new LocaleString("transferByApi"), Boolean.valueOf(false));
            }
        }
        if (res == null) {
            return CustomTaskUtils.getResult((Boolean)Boolean.FALSE, (String)String.format("update task [%s] participant [%s] fail and details is %s", taskId, userIds, "res is null"), null);
        }
        String details = (String)res.get("details");
        if (WfUtils.isNotEmpty((String)details)) {
            return CustomTaskUtils.getResult((Boolean)Boolean.FALSE, (String)String.format("update task [%s] participant [%s] fail and details is %s", taskId, userIds, details), null);
        }
        return CustomTaskUtils.getResult((Boolean)Boolean.TRUE, (String)String.format("update task [%s] participant [%s] success", taskId, userIds), null);
    }

    public Map<String, Object> batchDeleteTasks(List<Long> taskIds) {
        if (taskIds == null || taskIds.size() == 0) {
            CustomTaskUtils.getResult((Boolean)Boolean.FALSE, (String)"invoke api fail for taskIds is empty");
        }
        this.taskService = this.getTaskService();
        return this.taskService.batchDeleteTasks(taskIds);
    }

    public Map<String, Object> builMessageUrl(String formId, String mobFormId, Long pkId, Map<String, Object> param) {
        StringBuilder msgUrl = new StringBuilder();
        if (StringUtils.isBlank((CharSequence)formId) || StringUtils.isBlank((Object)pkId) || StringUtils.isBlank((CharSequence)mobFormId)) {
            return MessageUtils.wrapResult((boolean)Boolean.FALSE, (String)ResManager.loadKDString((String)"\u7f3a\u5c11\u5fc5\u987b\u7684\u53c2\u6570", (String)"MessageCenterServiceImpl_7", (String)MESSAGEENTITY, (Object[])new Object[0]), null);
        }
        msgUrl.append(UrlService.getDomainContextUrl());
        if (!UrlService.getDomainContextUrl().endsWith("/")) {
            msgUrl.append('/');
        }
        msgUrl.append("integration/yzjShareOpen.do?");
        msgUrl.append("formId=");
        msgUrl.append(formId);
        msgUrl.append("&mb_formId=");
        msgUrl.append(mobFormId);
        msgUrl.append("&pkId=");
        msgUrl.append(pkId);
        msgUrl.append("&accountId=").append(RequestContext.get().getAccountId());
        if (param != null && !param.isEmpty()) {
            for (Map.Entry<String, Object> entry : param.entrySet()) {
                boolean needAdd = true;
                for (int i = 0; i < MOBURLPARAMS.length; ++i) {
                    if (!MOBURLPARAMS[i].equals(entry.getKey())) continue;
                    needAdd = false;
                    break;
                }
                if (!needAdd) continue;
                msgUrl.append("&").append(entry.getKey()).append("=");
                if (entry.getValue() instanceof String) {
                    msgUrl.append(YunzhijiaCommonUtil.encode((String)String.valueOf(entry.getValue())));
                    continue;
                }
                msgUrl.append(entry.getValue());
            }
        }
        return MessageUtils.wrapResult((String)SUCCESS, (Object)msgUrl.toString());
    }

    public void setMessagePopup(Long messageId, List<Long> userIds, boolean popupState) {
        logger.debug("MessageCenterServiceImpl_setMessagePopup messageId :" + messageId + ", userIds: " + userIds + ", popupState: " + popupState);
        if (messageId == null || messageId == 0L) {
            return;
        }
        if (userIds == null || userIds.isEmpty()) {
            return;
        }
        QFilter q1 = new QFilter(MESSAGEID, "=", (Object)messageId);
        QFilter q2 = new QFilter("receiverid", "in", userIds);
        QFilter[] filters = new QFilter[]{q1, q2};
        DynamicObject[] msgReceivers = BusinessDataServiceHelper.load((String)MSGRECEIVERENITTY, (String)"popup", (QFilter[])filters);
        if (msgReceivers != null && msgReceivers.length != 0) {
            for (DynamicObject msgReceiver : msgReceivers) {
                msgReceiver.set("popup", (Object)popupState);
            }
            SaveServiceHelper.save((DynamicObject[])msgReceivers);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMsgReadStateAndTerminalWay(Long msgId, Long userId, String terminalWay) {
        try (TXHandle tx = TX.requiresNew();){
            ArrayList<Object> msgIds = new ArrayList<Object>(1);
            msgIds.add(msgId);
            MessageOperateUtils.setMessageReadState(msgIds, "read", userId, terminalWay);
            this.updateMessageRedStatusEvent(msgIds, "read", userId);
        }
    }

    public void clearMsgPersonalTopIdsCache(Long userId) {
        if (userId != null && !userId.equals(0L)) {
            MsgServiceCacheHelper.removeMsgPersonalSettingDataTopIdsCacheAll((Long)userId);
        }
    }

    public SmsUsingQuantities getSmsUsingQuantitySummary() {
        return MessageOperateUtils.getSmsUsingQuantitySummary();
    }

    public List<Map<String, Object>> getUnreadActivityMessageByAppNum(Long userId, String ... apps) {
        Object[] params;
        ArrayList<Map<String, Object>> messageList = new ArrayList<Map<String, Object>>();
        Boolean repaireMsgReceiverComplete = MessageConfigurationUtil.isRepaireMsgReceiverComplete();
        String entityName = repaireMsgReceiverComplete != false ? MSGRECEIVERENITTY : MSGMESSAGEENTITY;
        String titleSQL = WfMultiLangUtils.getGeneralLangSQL((String)entityName, (String)"a", (String)"b", (String)FTITLE, (String)TITLE, (String)TITLE);
        String contentSQL = WfMultiLangUtils.getGeneralLangSQL((String)entityName, (String)"a", (String)"b", (String)"fcontent_summary", (String)"content_summary", (String)"content_summary");
        StringBuilder sql = new StringBuilder(SELECTPART);
        if (repaireMsgReceiverComplete.booleanValue()) {
            Date endDate = new Date();
            Integer queryDays = this.getConfigCenterProperty(5, "message", "msg.notice.queryDays");
            Date startDate = new Date(System.currentTimeMillis() - (long)(queryDays * 24 * 3600) * 1000L);
            StringBuilder sql1 = new StringBuilder("select fid from t_wf_msgreceiver where freceiverid = ? ");
            sql1.append(" and fcreatedate >= ? and fcreatedate <= ? ");
            sql1.append(" and ftype = 1223746113903789056 and fpopup = '1';");
            Object[] params1 = new Object[]{userId, startDate, endDate};
            ArrayList<Long> msgReceiverIds = new ArrayList<Long>(5);
            try (DataSet dataSet1 = DB.queryDataSet((String)this.createAlgoKey(), (DBRoute)DBRoute.workflow, (String)sql1.toString(), (Object[])params1);){
                for (Row row : dataSet1) {
                    msgReceiverIds.add(row.getLong("fid"));
                }
            }
            if (msgReceiverIds.isEmpty()) {
                return messageList;
            }
            sql.append("a.fmessageid id, a.ftype type, a.fcreatedate createdate, a.fconfig config, ");
            sql.append(contentSQL).append(", ").append(titleSQL).append(" ");
            sql.append("from t_wf_msgreceiver a inner join t_wf_msgreceiver_l b ");
            sql.append("on a.fid = b.fid and b.flocaleid = '").append(RequestContext.get().getLang()).append("' ");
            sql.append("where a.fid in (");
            for (int i = 0; i < msgReceiverIds.size(); ++i) {
                if (i == msgReceiverIds.size() - 1) {
                    sql.append("?) order by a.fid;");
                    continue;
                }
                sql.append("?,");
            }
            params = msgReceiverIds.toArray();
        } else {
            sql.append("a.fid id, a.ftype type, a.fcreatedate createdate, a.fconfig config, ");
            sql.append(contentSQL).append(", ").append(titleSQL).append(" ");
            sql.append("from t_wf_msgreceiver c inner join t_wf_message a on c.fmessageid = a.fid and c.freceiverid = ? and c.fpopup = '1' ");
            sql.append("inner join t_wf_message_l b on a.fid = b.fid and b.flocaleid = ? ");
            sql.append("where c.freceiverid = ? and c.fpopup = '1' and a.ftype = 1223746113903789056 order by a.fid;");
            params = new Object[]{userId, RequestContext.get().getLang(), userId};
        }
        HashSet<String> appSet = new HashSet<String>(Arrays.asList(apps));
        try (DataSet dataSet = DB.queryDataSet((String)this.createAlgoKey(), (DBRoute)DBRoute.workflow, (String)sql.toString(), (Object[])params);){
            for (Row row : dataSet) {
                Map c;
                HashMap<String, Object> message = new HashMap<String, Object>();
                message.put("id", row.getLong("id"));
                message.put(TITLE, row.getString(TITLE));
                message.put(CONTENT, row.getString("content_summary"));
                message.put("msgType", ACTIVITY);
                String config = row.getString("config");
                long timeOut = SystemNoticeCommonUtil.TIMEOUT;
                if (StringUtils.isNotBlank((CharSequence)config) && !(c = (Map)SerializationUtils.fromJsonString((String)config, Map.class)).isEmpty() && StringUtils.isNotBlank(c.get("systemNotice"))) {
                    Map systemNotice = (Map)c.get("systemNotice");
                    if (appSet != null && StringUtils.isNotBlank(systemNotice.get("appNum"))) {
                        String appNums = (String)systemNotice.get("appNum");
                        String[] targetApps = appNums.split(",");
                        HashSet<String> targetAppSet = new HashSet<String>(Arrays.asList(targetApps));
                        targetAppSet.retainAll(appSet);
                        if (targetAppSet.isEmpty()) continue;
                    }
                    Object st = systemNotice.get("showType");
                    Optional.ofNullable(st).ifPresent(y -> {
                        String showType = st instanceof String ? (String)st : String.valueOf(st);
                        message.put("showType", showType);
                    });
                    Object to = systemNotice.get("timeOut");
                    if (to instanceof String) {
                        timeOut = Long.parseLong((String)to);
                    } else if (to instanceof Integer) {
                        timeOut = (long)((Integer)to).intValue() + 0L;
                    } else if (to instanceof Long) {
                        timeOut = (Long)to;
                    }
                    message.put("timeOut", timeOut);
                    Optional.ofNullable(systemNotice.get("url")).ifPresent(z -> message.put("url", (String)systemNotice.get("url")));
                    Object durationValue = systemNotice.get("duration");
                    if (StringUtils.isNotBlank(durationValue)) {
                        int duration = 0;
                        if (durationValue instanceof String) {
                            duration = Integer.parseInt((String)durationValue);
                        } else if (durationValue instanceof Integer) {
                            duration = (Integer)durationValue;
                        }
                        message.put("duration", duration);
                    }
                }
                Date createDate = (Date)row.get(CREATEDATE);
                Long createTime = createDate.getTime();
                Long currentTime = System.currentTimeMillis();
                if (currentTime > createTime + timeOut) continue;
                messageList.add(message);
            }
        }
        catch (Exception e) {
            logger.debug("getUnreadActivityMessageByAppNum--queryDBHasException:" + e.getMessage());
        }
        return messageList;
    }

    public void updateToDoMsgContent(MessageServiceConfig config, ITaskMsg taskMsg) {
        MessageServiceUtil.updateToDoMsgContent((MessageServiceConfig)config, (ITaskMsg)taskMsg);
    }

    public void updateToDoMsgContent(MessageServiceConfig config, MessageInfo messageInfo) {
        MessageServiceUtil.updateToDoMsgContent((MessageServiceConfig)config, (MessageInfo)messageInfo);
    }

    public List<Map<String, Object>> getMessageData(MessageRequestInfo messageRequestInfo) {
        int start = messageRequestInfo.getStart();
        int limit = messageRequestInfo.getLimit();
        String entityNumber = messageRequestInfo.getEntityNumber() == null ? "" : messageRequestInfo.getEntityNumber();
        Long userId = messageRequestInfo.getUserId();
        String title = messageRequestInfo.getTitle() == null ? "" : messageRequestInfo.getTitle();
        String tag = messageRequestInfo.getTag() == null ? "" : messageRequestInfo.getTag();
        String msgType = messageRequestInfo.getMsgType() == null ? "" : messageRequestInfo.getMsgType();
        Boolean unread = messageRequestInfo.getUnread() == null ? Boolean.TRUE : messageRequestInfo.getUnread();
        String linkMsgType = messageRequestInfo.getLinkMsgType() == null ? "" : messageRequestInfo.getLinkMsgType();
        String userIdStr = WfUtils.isEmpty((Long)userId) ? RequestContext.get().getUserId() : String.valueOf(userId);
        HashMap<String, Object> filterPrarms = new HashMap<String, Object>(8);
        if (WfUtils.isNotEmpty((String)msgType)) {
            boolean isMsgTypeExist = Boolean.FALSE;
            DynamicObject[] msgTypes = BusinessDataServiceHelper.load((String)MSGTYPE, (String)"id, number", null);
            if (msgTypes != null) {
                for (DynamicObject typeObject : msgTypes) {
                    if (!typeObject.getString(NUMBER).equals(msgType)) continue;
                    isMsgTypeExist = Boolean.TRUE;
                    break;
                }
            }
            if (!isMsgTypeExist) {
                logger.debug("the params is error");
            }
        }
        filterPrarms.put(ENTITYNUMBER, entityNumber);
        filterPrarms.put("entityNumber", entityNumber);
        filterPrarms.put("tags", tag);
        filterPrarms.put("msgType", msgType);
        filterPrarms.put(TITLE, title);
        filterPrarms.put("linkMsgType", linkMsgType);
        filterPrarms.put(UNREAD, unread);
        if (ModelType.NoCodeFlow.name().equalsIgnoreCase(messageRequestInfo.getSource())) {
            filterPrarms.put("source", messageRequestInfo.getSource());
        }
        return this.getMessageByFilter(userIdStr, start, limit, filterPrarms);
    }

    private void updateMessageRedStatusEvent(List<Object> msgIds, String state, Object userId) throws Exception {
        HashMap<String, Object> paramMap = new HashMap<String, Object>(2);
        paramMap.put("msgIds", msgIds);
        paramMap.put(USERID, userId);
        paramMap.put("state", state);
        String paramJson = SerializationUtils.toJsonString(paramMap);
        try {
            EventServiceHelper.triggerEventSubscribe((String)MsgCenterEventEnum.UPDATE_MSG_RED_STATUS_EVT.getCode(), (String)paramJson);
        }
        catch (Exception e) {
            throw new Exception(e);
        }
    }

    private void deleteMessageEvent(List<Object> msgIds, Long userId) throws Exception {
        HashMap<String, Object> paramMap = new HashMap<String, Object>(1);
        paramMap.put("msgIds", msgIds);
        paramMap.put(USERID, userId);
        String paramJson = SerializationUtils.toJsonString(paramMap);
        try {
            EventServiceHelper.triggerEventSubscribe((String)MsgCenterEventEnum.DELETE_MSG_EVT.getCode(), (String)paramJson);
        }
        catch (Exception e) {
            throw new Exception(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> getMessageById(List<Long> messageIds) {
        HashMap<String, Object> ret = new HashMap<String, Object>(1);
        if (messageIds == null || messageIds.isEmpty()) {
            ret.put(ResManager.loadKDString((String)"\u53c2\u6570\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"MessageCenterErrorCode_24", (String)MESSAGEENTITY, (Object[])new Object[0]), null);
            return ret;
        }
        Map<String, List<Long>> temp = MsgCenterAPIUtils.checkAndFilterMessageIds(messageIds);
        List<Long> errorIds = temp.get("errorIds");
        List<Long> rightIds = temp.get("rightIds");
        if (errorIds.size() == messageIds.size()) {
            ret.put(ResManager.loadKDString((String)"\u53c2\u6570\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"MessageCenterErrorCode_24", (String)MESSAGEENTITY, (Object[])new Object[0]), null);
            return ret;
        }
        ArrayList<MessageInfo> messageInfos = new ArrayList<MessageInfo>();
        try (DataSet dataSet = null;){
            QFilter[] filters = null;
            filters = rightIds.size() == 1 ? new QFilter[]{new QFilter("id", "=", (Object)rightIds.get(0))} : new QFilter[]{new QFilter("id", "in", rightIds)};
            String selectFields = "id,title,content,sender,sendername,channels,config,type,contenturl,mobcontenturl,entitynumber,operation,bizdataid,tag,source,tplscene,toall,createdate";
            DynamicObject[] messages = BusinessDataServiceHelper.load((String)MSGMESSAGEENTITY, (String)selectFields, (QFilter[])filters);
            if (messages != null && messages.length > 0) {
                for (DynamicObject message : messages) {
                    messageInfos.add(MessageOperateUtils.db2MessageInfoConverter(message));
                }
                if (!messageInfos.isEmpty()) {
                    List<Long> userIds;
                    HashMap mssageReceiverImapping = new HashMap();
                    filters = rightIds.size() == 1 ? new QFilter[]{new QFilter(MESSAGEID, "=", (Object)rightIds.get(0))} : new QFilter[]{new QFilter(MESSAGEID, "in", rightIds)};
                    dataSet = QueryServiceHelper.queryDataSet((String)this.createAlgoKey(), (String)MSGRECEIVERENITTY, (String)"messageid,receiverid", (QFilter[])filters, null);
                    for (Row row : dataSet) {
                        Long messageId = row.getLong(MESSAGEID);
                        if (mssageReceiverImapping.containsKey(messageId)) {
                            ((List)mssageReceiverImapping.get(messageId)).add(row.getLong("receiverid"));
                            continue;
                        }
                        userIds = new ArrayList();
                        userIds.add(row.getLong("receiverid"));
                        mssageReceiverImapping.put(messageId, userIds);
                    }
                    for (MessageInfo messageInfo : messageInfos) {
                        userIds = (List)mssageReceiverImapping.get(messageInfo.getId());
                        if (userIds == null || userIds.isEmpty()) continue;
                        messageInfo.setUserIds(userIds);
                    }
                }
            }
        }
        ret.put("messageInfos", messageInfos);
        return ret;
    }

    public void updateWxqyPublicAuthorizeData(String config) {
        if (WfUtils.isEmpty((String)config)) {
            return;
        }
        try {
            DynamicObject channle;
            JSONObject data = JSONObject.parseObject((String)config);
            if (data.containsKey((Object)"eid") && data.containsKey((Object)"accountId") && data.containsKey((Object)"secret") && (channle = BusinessDataServiceHelper.loadSingle((String)"msg_channel", (String)"id, mobileappconfig, agentid", (QFilter[])new QFilter[]{new QFilter(NUMBER, "=", (Object)"kingdee_sky")})) != null) {
                String mobileAppConfig = channle.getString("mobileappconfig");
                if (WfUtils.isEmpty((String)mobileAppConfig)) {
                    channle.set("mobileappconfig", (Object)config);
                    channle.set("agentid", (Object)"11078");
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{channle});
                } else {
                    JSONObject channelMobConfig = JSONObject.parseObject((String)mobileAppConfig);
                    String eid = channelMobConfig.getString("eid");
                    if (eid.equalsIgnoreCase(data.getString("eid"))) {
                        channle.set("mobileappconfig", (Object)config);
                        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{channle});
                    }
                }
            }
        }
        catch (Exception e) {
            this.printLog(String.format("updateWxqyPublicAuthorizeData error[%s]", WfUtils.getExceptionStacktrace((Throwable)e)));
        }
    }

    public Long getNoCodeFlowMessageCount(String userId, String readState) {
        Long count = 0L;
        String sql = "select count(1) count from t_wf_msgreceiver a where a.fsource ='NoCodeFlow' and a.freceiverid = ? " + (WfUtils.isEmpty((String)readState) ? ";" : " and a.freadstate = ? ;");
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(Long.valueOf(userId));
        if (WfUtils.isNotEmpty((String)readState)) {
            params.add(readState);
        }
        try (DataSet ds = DB.queryDataSet((String)"wf_msgreceiver_queryCount", (DBRoute)DBRoute.workflow, (String)sql, (Object[])params.toArray());){
            Iterator iterator = ds.iterator();
            if (iterator.hasNext()) {
                count = ((Row)iterator.next()).getLong(COUNT);
            }
        }
        return count;
    }

    public Map<String, Object> getEnableChannel() {
        HashMap<String, Object> channels = new HashMap<String, Object>(10);
        DynamicObject[] objects = BusinessDataServiceHelper.load((String)"msg_channel", (String)"number,name", (QFilter[])new QFilter[]{new QFilter("enable", "=", (Object)Character.valueOf('1'))});
        if (objects != null && objects.length > 0) {
            for (DynamicObject obj : objects) {
                channels.put(obj.getString(NUMBER), obj.get("name"));
            }
        }
        return channels;
    }

    private Map<String, Object> checkMessageInfoOldVersion(MessageInfo messageInfo, SendMessageContext messageContext) {
        this.wrapMessageInfo(messageInfo, messageContext);
        Map<String, Object> checkResult = this.checkMessageInfo(messageInfo, false);
        if (!((Boolean)checkResult.get(RESULT)).booleanValue()) {
            logger.debug(String.format("sendMessageApi-checkNotOK, description:%s message:%s", checkResult.get(DESCRIPTION), messageInfo));
            return checkResult;
        }
        this.wrapSmsLicense(messageInfo);
        return null;
    }

    private Map<String, Object> checkMessageInfoNewVersion(List<MessageInfo> messageInfos, SendMessageContext messageContext) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        String traceId = RequestContext.get().getTraceId();
        ArrayList<Long> messageIdsCheckPass = new ArrayList<Long>(messageInfos.size());
        ArrayList<MessageInfo> messageInfosCheckPass = new ArrayList<MessageInfo>(messageInfos.size());
        HashMap<MessageInfo, String> messageInfosNotPass = new HashMap<MessageInfo, String>(messageInfos.size());
        for (MessageInfo messageInfo : messageInfos) {
            this.wrapMessageInfo(messageInfo, messageContext);
            Map<String, Object> checkResult = this.checkMessageMustInputProperties(messageInfo);
            if (!((Boolean)checkResult.get(RESULT)).booleanValue()) {
                logger.debug(String.format("sendMessagesApi-checkNotPass, traceId:[%s] description:[%s] message:%s", traceId, checkResult.get(DESCRIPTION), messageInfo));
                messageInfosNotPass.put(messageInfo, (String)checkResult.get(DESCRIPTION));
                continue;
            }
            checkResult = this.checkBatchMessageInfo(messageInfo, messageContext);
            if (!((Boolean)checkResult.get(RESULT)).booleanValue()) {
                logger.debug(String.format("sendMessagesApi-checkNotPass, traceId:[%s] description:[%s] message:%s", traceId, checkResult.get(DESCRIPTION), messageInfo));
                messageInfosNotPass.put(messageInfo, (String)checkResult.get(DESCRIPTION));
                continue;
            }
            this.wrapSmsLicense(messageInfo);
            messageInfosCheckPass.add(messageInfo);
            messageIdsCheckPass.add(messageInfo.getId());
        }
        resultMap.put(MESSAGEIDSCHECKPASS, messageIdsCheckPass);
        resultMap.put(MESSAGEINFOSCHECKPASS, messageInfosCheckPass);
        resultMap.put(MESSAGEINFOSNOTPASS, messageInfosNotPass);
        return resultMap;
    }

    private LocaleString wrapLocalStringProperty(Object property) {
        LocaleString ls = new LocaleString();
        if (property != null) {
            Map tmap = (Map)property;
            for (Map.Entry entry : tmap.entrySet()) {
                String key = (String)entry.getKey();
                Object value = entry.getValue();
                ls.setItem(key, (Object)((String)value));
            }
        }
        return ls;
    }

    private void wrapMessageInfo(MessageInfo message, SendMessageContext messageContext) {
        String mobUrl;
        Map entityMapping;
        MainEntityType mainEntityType;
        Map typeMapping;
        Map channelsCache;
        if (message.getMessageContent() != null && message.getMessageContent() instanceof OrmLocaleValue) {
            message.setMessageContent((ILocaleString)this.wrapLocalStringProperty(message.getMessageContent()));
        }
        if (message.getMessageTitle() != null && message.getMessageTitle() instanceof OrmLocaleValue) {
            message.setMessageTitle((ILocaleString)this.wrapLocalStringProperty(message.getMessageTitle()));
        }
        if (message.getMessageSenderName() != null && message.getMessageSenderName() instanceof OrmLocaleValue) {
            message.setMessageSenderName((ILocaleString)this.wrapLocalStringProperty(message.getMessageSenderName()));
        }
        if (message.getMessageTag() != null && message.getMessageTag() instanceof OrmLocaleValue) {
            message.setMessageTag((ILocaleString)this.wrapLocalStringProperty(message.getMessageTag()));
        }
        if (WfUtils.isEmpty((ILocaleString)message.getMessageContent()) && WfUtils.isNotEmpty((String)message.getContent())) {
            message.setMessageContent(WfMultiLangUtils.getMultiLangValue((String)message.getContent()));
        }
        if (WfUtils.isEmpty((ILocaleString)message.getMessageTitle()) && WfUtils.isNotEmpty((String)message.getTitle())) {
            message.setMessageTitle(WfMultiLangUtils.getMultiLangValue((String)message.getTitle()));
        }
        if (WfUtils.isEmpty((String)message.getType())) {
            message.setType("message");
        }
        String channelData = WfUtils.isEmpty((String)message.getNotifyType()) ? ((channelsCache = (Map)(typeMapping = messageContext.getTypeMapping()).get(message.getType())) != null ? this.wrapChannels((String)channelsCache.get(CHANNELS)) : "") : this.wrapChannels(message.getNotifyType());
        message.setNotifyType(channelData);
        if (message.isToAll() && (message.getUserIds() != null && !message.getUserIds().isEmpty() || !NOTICE.equalsIgnoreCase(message.getType()) && !ACTIVITY.equalsIgnoreCase(message.getType()) || !SYSNOTICE.equalsIgnoreCase(message.getNotifyType()))) {
            message.setToAll(Boolean.FALSE.booleanValue());
        }
        if (WfUtils.isEmpty((String)message.getSource()) && WfUtils.isNotEmpty((String)message.getEntityNumber()) && (mainEntityType = (MainEntityType)(entityMapping = messageContext.getEntityMapping()).get(message.getEntityNumber())) != null) {
            message.setSource(mainEntityType.getBizAppNumber());
        }
        if (WfUtils.isEmpty((String)message.getNestEntityNumber()) && WfUtils.isNotEmpty((String)message.getEntityNumber())) {
            message.setNestEntityNumber(message.getEntityNumber());
        }
        if (WfUtils.isEmpty((Long)message.getNestBillId()) && WfUtils.isNotEmpty((Long)message.getBizDataId())) {
            message.setNestBillId(message.getBizDataId());
        }
        if (WfUtils.isEmpty((String)message.getNestAppid()) && WfUtils.isNotEmpty((String)message.getSource())) {
            message.setNestAppid(message.getSource());
        }
        if (WfUtils.isEmpty((Long)message.getId())) {
            message.setId(Long.valueOf(DBServiceHelper.genGlobalLongId()));
        }
        if (WfUtils.isNotEmpty((String)(mobUrl = this.buildMsgCommonUrl(message)))) {
            message.setMobContentUrl(mobUrl);
        }
        if (WfUtils.isNotEmpty((String)message.getTplScene())) {
            String scene = message.getTplScene();
            if (MessageTypeEnum.isTaskMessageType((String)scene)) {
                message.setEntityNumber("wf_task");
            }
            if (MessageTypeEnum.isExecutionMessageType((String)scene)) {
                message.setEntityNumber("wf_hiprocinst");
            }
            if (MessageTypeEnum.isHisTaskMessageType((String)scene)) {
                message.setEntityNumber("wf_hitaskinst");
            }
        }
    }

    private String wrapChannels(String channels) {
        StringBuilder channelData = new StringBuilder();
        if (StringUtils.isBlank((CharSequence)channels)) {
            return "";
        }
        String[] cs = channels.split(",");
        for (int i = 0; i < cs.length; ++i) {
            if (!StringUtils.isNotBlank((CharSequence)cs[i].trim())) continue;
            if (i == cs.length - 1) {
                channelData.append(cs[i].trim());
                continue;
            }
            channelData.append(cs[i].trim()).append(",");
        }
        return channelData.toString();
    }

    private Map<String, Object> checkBatchMessageInfo(MessageInfo message, SendMessageContext messageContext) {
        Map entityMapping;
        Map senderMapping;
        if (WfUtils.isNotEmpty((Long)message.getSenderId()) && ((senderMapping = messageContext.getSenderMapping()) == null || !senderMapping.containsKey(message.getSenderId()))) {
            return MessageUtils.wrapResult((boolean)Boolean.FALSE, (String)"MessageCenterServiceImpl--senderId is unable in system", null);
        }
        if (WfUtils.isNotEmpty((String)message.getEntityNumber()) && ((entityMapping = messageContext.getEntityMapping()) == null || !entityMapping.containsKey(message.getEntityNumber()))) {
            return MessageUtils.wrapResult((boolean)Boolean.FALSE, (String)String.format("MessageCenterServiceImpl-- %s isnot exist", message.getEntityNumber()), null);
        }
        return this.checkMessageInfo(message, true);
    }

    private boolean isFindMCenterTemplate(MessageInfo message) {
        Map messageTpls;
        if (WfUtils.isNotEmpty((String)message.getTemplateNumber()) && !(messageTpls = MessageUtils.getMessageTemplateLocalByNumber((String)message.getTemplateNumber())).isEmpty()) {
            return true;
        }
        if (WfUtils.isNotEmpty((String)message.getEntityNumber()) && WfUtils.isNotEmpty((Long)message.getBizDataId())) {
            String entityNumber;
            String channel;
            String scene = message.getTplScene() != null ? message.getTplScene() : message.getBizType();
            String type = message.getType();
            Map messageTpls2 = MessageUtils.getMessageTemplateInfo(null, (String)type, (String)(channel = MessageChannels.MC.getNumber()), (String)scene, (String)(entityNumber = message.getEntityNumber()));
            if (!messageTpls2.isEmpty()) {
                return true;
            }
        }
        return false;
    }

    private Map<String, Object> checkMessageInfo(MessageInfo message, boolean isBatchApi) {
        List userIds = message.getUserIds();
        if (userIds == null || userIds.isEmpty()) {
            boolean toAll = message.isToAll();
            Map param = message.getParams();
            Object phone = param.get("phone");
            Object email = param.get("email");
            if (!toAll && StringUtils.isBlank(phone) && StringUtils.isBlank(email)) {
                return MessageUtils.wrapResult((boolean)Boolean.FALSE, (String)"sendMessageApiUserId is null", null);
            }
        }
        ILocaleString messageContent = message.getMessageContent();
        String content = message.getContent();
        if (WfUtils.isEmpty((ILocaleString)messageContent) && WfUtils.isEmpty((String)content)) {
            ILocaleString messageTitle = message.getMessageTitle();
            String title = message.getTitle();
            if (WfUtils.isEmpty((ILocaleString)messageTitle) && WfUtils.isEmpty((String)title)) {
                if (isBatchApi || !this.isFindMCenterTemplate(message)) {
                    return MessageUtils.wrapResult((boolean)Boolean.FALSE, (String)"sendMessageApiContent is null", null);
                }
            } else {
                message.setMessageContent(messageTitle);
                message.setContent(title);
            }
        }
        if (MessageUtils.isMessageContentBeyondLimit((ILocaleString)message.getMessageContent())) {
            return MessageUtils.wrapResult((boolean)Boolean.FALSE, (String)"MessageCenterServiceImpl--content size beyond limit", null);
        }
        MessageAttachment attachment = message.getAttachment();
        if (attachment != null) {
            List attachments = attachment.getAttachments();
            List attachmentNames = attachment.getAttachmentNames();
            if (attachments == null || attachmentNames == null || attachments.size() != attachmentNames.size()) {
                return MessageUtils.wrapResult((boolean)Boolean.FALSE, (String)"MessageCenterServiceImpl--the parameter of attachment is error. collection is null or size not equal", null);
            }
            if (MessageUtils.isAttachmentBeyondLimit((List)attachments)) {
                return MessageUtils.wrapResult((boolean)Boolean.FALSE, (String)"MessageCenterServiceImpl--attachment size beyond limit", null);
            }
        }
        return MessageUtils.wrapResult((boolean)Boolean.TRUE, (String)SUCCESS, null);
    }

    private void wrapSmsLicense(MessageInfo messageInfo) {
        Map params;
        String msgChannels = messageInfo.getNotifyType();
        if (msgChannels != null && msgChannels.contains("sms") && (params = messageInfo.getParams()) != null && params.get(ISSMSCHECKLICENSE) == null) {
            boolean isCheckLicense = SMSLicenseWhilteUtils.judgeLicense();
            params.put(ISSMSCHECKLICENSE, isCheckLicense);
            params.put(ISSMSVERIFICATIONCODE, isCheckLicense);
            messageInfo.setParams(params);
        }
    }

    private Map<String, Object> checkMessageMustInputProperties(MessageInfo message) {
        StringBuilder property = new StringBuilder();
        List userIds = message.getUserIds();
        if (userIds == null || userIds.isEmpty()) {
            Map param = message.getParams();
            if (!message.isToAll() && StringUtils.isBlank(param.get("phone")) && StringUtils.isBlank(param.get("email"))) {
                property.append(" userIds").append(" |");
            }
        }
        if (WfUtils.isEmpty((ILocaleString)message.getMessageContent())) {
            property.append(" messagecontent").append(" |");
        }
        if (WfUtils.isEmpty((ILocaleString)message.getMessageTitle())) {
            property.append(" messagetitle").append(" |");
        }
        if (WfUtils.isEmpty((String)message.getTag())) {
            property.append(" tag").append(" |");
        }
        if (WfUtils.isEmpty((Long)message.getSenderId()) && WfUtils.isEmpty((ILocaleString)message.getMessageSenderName())) {
            property.append(" senderId or messageSenderName").append(" |");
        }
        if (WfUtils.isEmpty((String)message.getEntityNumber()) && WfUtils.isEmpty((String)message.getSource())) {
            property.append(" entitynumber and source").append(" |");
        } else if (WfUtils.isNotEmpty((String)message.getEntityNumber()) && WfUtils.isEmpty((Long)message.getBizDataId())) {
            property.append(" bizDataId").append(" |");
        }
        if (WfUtils.isEmpty((String)message.getNestEntityNumber()) && WfUtils.isEmpty((String)message.getNestAppid())) {
            property.append(" nestEntityNumber and nestAppId").append(" |");
        } else if (WfUtils.isNotEmpty((String)message.getNestEntityNumber()) && WfUtils.isEmpty((Long)message.getNestBillId())) {
            property.append(" nestBillId").append(" |");
        }
        String properties = property.toString();
        if (WfUtils.isNotEmpty((String)properties)) {
            return MessageUtils.wrapResult((boolean)Boolean.FALSE, (String)String.format("messageInfo[%s] property is empty", properties.substring(0, properties.length() - 1)), null);
        }
        return MessageUtils.wrapResult((boolean)Boolean.TRUE, (String)SUCCESS, null);
    }

    private List<MessageInfo> splitMessageInfo(MessageInfo messageInfo, SendMessageContext messageContext) {
        ArrayList<MessageInfo> messageList = new ArrayList<MessageInfo>();
        String messageChannel = messageInfo.getNotifyType();
        if (messageChannel == null || MessageUtils.isEmpty((String)messageChannel.trim())) {
            messageList.add(this.clone(messageInfo, MessageChannels.MC.getNumber(), null));
            return messageList;
        }
        String channels = messageChannel.trim();
        String[] cs = channels.split(",");
        boolean hasMCenterChannel = false;
        for (String c : cs) {
            String channelTrim = c.trim();
            if (MessageUtils.isEmpty((String)channelTrim)) continue;
            if (c.equalsIgnoreCase(MessageChannels.MC.getNumber())) {
                hasMCenterChannel = true;
                messageList.add(this.clone(messageInfo, MessageChannels.MC.getNumber(), null));
                continue;
            }
            if (c.equalsIgnoreCase(SYSNOTICE) && !NOTICE.equals(messageInfo.getType()) && !ACTIVITY.equals(messageInfo.getType())) {
                logger.debug(String.format("sendMessage-wrapChannelMessage-\u4e0d\u5141\u8bb8\u9664\u516c\u544a\u4e4b\u5916\u7684\u6d88\u606f\u7c7b\u578b\u4f7f\u7528 \u7cfb\u7edf\u516c\u544a\u6e20\u9053:%s", messageChannel));
                continue;
            }
            messageList.add(this.clone(messageInfo, c, messageContext));
        }
        if (!hasMCenterChannel) {
            messageList.add(this.clone(messageInfo, MessageChannels.MC.getNumber(), null));
        }
        return messageList;
    }

    private MessageInfo clone(MessageInfo mcMessage, String channelNumber, SendMessageContext messageContext) {
        MessageInfo channelMessage = mcMessage.copy();
        ArrayList userIds = new ArrayList();
        if (mcMessage.getUserIds() != null) {
            userIds.addAll(mcMessage.getUserIds());
        }
        channelMessage.setUserIds(userIds);
        HashMap params = new HashMap();
        if (mcMessage.getParams() != null) {
            params.putAll(mcMessage.getParams());
        }
        channelMessage.setParams(params);
        channelMessage.setNotifyType(channelNumber);
        if (!MessageChannelUtils.isEmailChannel((String)channelNumber, (SendMessageContext)messageContext)) {
            channelMessage.setAttachment(null);
        }
        Long channelMsgId = DBServiceHelper.genGlobalLongId();
        if (MessageChannels.MC.getNumber().equals(channelNumber)) {
            channelMsgId = mcMessage.getId();
            channelMessage.putParam("originalNotifyType", mcMessage.getNotifyType());
        }
        channelMessage.setChannelMsgId(channelMsgId);
        return channelMessage;
    }

    public Map<String, Object> getMessageDatas(String messageType, MessageCenterParams messageCenterParams) {
        Map<String, Object> returnDate = this.checkQueryFields(messageType, messageCenterParams);
        if (returnDate != null && returnDate.size() > 0) {
            return returnDate;
        }
        if (WfUtils.isEmpty((Long)messageCenterParams.getUserId())) {
            messageCenterParams.setUserId(Long.valueOf(RequestContext.get().getCurrUserId()));
        }
        if (messageCenterParams.getLimit() == 0) {
            messageCenterParams.setLimit(20);
        }
        if (!WfConfigurationUtil.isNotQueryByNewSql() && WfConfigurationUtil.isRepaireMsgReceiverComplete().booleanValue()) {
            return new GetMessageDataListForNewApiSingleTableCmd(messageCenterParams, messageType).execute(Context.getCommandContext());
        }
        return new GetMessageDataListForNewApiMultipTableCmd(messageCenterParams, messageType).execute(Context.getCommandContext());
    }

    public Long getMessageDatasCount(String messageType, MessageCenterParams messageCenterParams) {
        Map<String, Object> returnDate = this.checkQueryparamsByCount(messageType, messageCenterParams);
        if (returnDate != null && returnDate.size() > 0) {
            return 0L;
        }
        if (messageCenterParams.getLimit() == 0) {
            messageCenterParams.setLimit(20);
        }
        if (!WfConfigurationUtil.isNotQueryByNewSql() && WfConfigurationUtil.isRepaireMsgReceiverComplete().booleanValue()) {
            return new GetMessageDataCountForNewApiSingleTableCmd(messageCenterParams, messageType).execute(Context.getCommandContext());
        }
        return new GetMessageDataCountForNewApiMultipTableCmd(messageCenterParams, messageType).execute(Context.getCommandContext());
    }

    public Map<String, Object> getToHandleTasks(MessageCenterParams messageCenterParams) {
        Map<String, Object> returnDate = this.checkQueryFields("toHandle", messageCenterParams);
        if (returnDate != null && returnDate.size() > 0) {
            return returnDate;
        }
        return this.getTaskService().getMessageCenterDatas("toHandle", messageCenterParams);
    }

    public Map<String, Object> getTransferTasks(String taskType, MessageCenterParams messageCenterParams) {
        Map<String, Object> returnDate = this.checkQueryFields(taskType, messageCenterParams);
        if (returnDate != null && returnDate.size() > 0) {
            return returnDate;
        }
        return this.getTaskService().getMessageCenterDatas(taskType, messageCenterParams);
    }

    public Map<String, Object> getDelegateTasks(String taskType, MessageCenterParams messageCenterParams) {
        Map<String, Object> returnDate = this.checkQueryFields(taskType, messageCenterParams);
        if (returnDate != null && returnDate.size() > 0) {
            return returnDate;
        }
        return this.getTaskService().getMessageCenterDatas(taskType, messageCenterParams);
    }

    public Map<String, Object> getHandledTasks(MessageCenterParams messageCenterParams) {
        Map<String, Object> returnDate = this.checkQueryFields("handled", messageCenterParams);
        if (returnDate != null && returnDate.size() > 0) {
            return returnDate;
        }
        return this.getTaskService().getMessageCenterDatas("handled", messageCenterParams);
    }

    public Map<String, Object> getToApplyProcess(MessageCenterParams messageCenterParams) {
        Map<String, Object> returnDate = this.checkQueryFields("toApply", messageCenterParams);
        if (returnDate != null && returnDate.size() > 0) {
            return returnDate;
        }
        return this.getTaskService().getMessageCenterDatas("toApply", messageCenterParams);
    }

    public Map<String, Object> getApplyedProcess(MessageCenterParams messageCenterParams) {
        Map<String, Object> returnDate = this.checkQueryFields("applyed", messageCenterParams);
        if (returnDate != null && returnDate.size() > 0) {
            return returnDate;
        }
        return this.getTaskService().getMessageCenterDatas("applyed", messageCenterParams);
    }

    public Long getToHandleTaskCount(MessageCenterParams messageCenterParams) {
        Map<String, Object> returnDate = this.checkQueryparamsByCount("toHandle", messageCenterParams);
        if (returnDate != null && returnDate.size() > 0) {
            return 0L;
        }
        return this.getTaskService().getMessageCenterDataCount("toHandle", messageCenterParams);
    }

    public Long getTransferTaskCount(String taskType, MessageCenterParams messageCenterParams) {
        Map<String, Object> returnDate = this.checkQueryparamsByCount(taskType, messageCenterParams);
        if (returnDate != null && returnDate.size() > 0) {
            return 0L;
        }
        return this.getTaskService().getMessageCenterDataCount(taskType, messageCenterParams);
    }

    public Long getDelegateTaskCount(String taskType, MessageCenterParams messageCenterParams) {
        Map<String, Object> returnDate = this.checkQueryparamsByCount(taskType, messageCenterParams);
        if (returnDate != null && returnDate.size() > 0) {
            return 0L;
        }
        return this.getTaskService().getMessageCenterDataCount(taskType, messageCenterParams);
    }

    public Long getHandledTaskCount(MessageCenterParams messageCenterParams) {
        Map<String, Object> returnDate = this.checkQueryparamsByCount("handled", messageCenterParams);
        if (returnDate != null && returnDate.size() > 0) {
            return 0L;
        }
        return this.getTaskService().getMessageCenterDataCount("handled", messageCenterParams);
    }

    public Long getToApplyProcessCount(MessageCenterParams messageCenterParams) {
        Map<String, Object> returnDate = this.checkQueryparamsByCount("toApply", messageCenterParams);
        if (returnDate != null && returnDate.size() > 0) {
            return 0L;
        }
        return this.getTaskService().getMessageCenterDataCount("toApply", messageCenterParams);
    }

    public Long getApplyedProcessCount(MessageCenterParams messageCenterParams) {
        Map<String, Object> returnDate = this.checkQueryparamsByCount("applyed", messageCenterParams);
        if (returnDate != null && returnDate.size() > 0) {
            return 0L;
        }
        return this.getTaskService().getMessageCenterDataCount("applyed", messageCenterParams);
    }

    private Map<String, Object> checkQueryparamsByCount(String queryType, MessageCenterParams messageCenterParams) {
        HashMap<String, Object> returnDate = new HashMap<String, Object>();
        String msg = "";
        if (messageCenterParams == null || WfUtils.isEmpty((String)queryType)) {
            msg = ResManager.loadKDString((String)"\u5fc5\u4f20\u53c2\u6570\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"MessageCenterServiceImpl_14", (String)MESSAGEENTITY, (Object[])new Object[0]);
            returnDate.put("message", msg);
            return returnDate;
        }
        List<Map<String, String>> currentFields = this.getTaskAndMessageFields(queryType);
        if (currentFields == null || currentFields.size() == 0) {
            msg = ResManager.loadKDString((String)"\u4f20\u5165\u7684\u67e5\u8be2\u7c7b\u578b\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"MessageCenterServiceImpl_15", (String)MESSAGEENTITY, (Object[])new Object[0]);
            returnDate.put("message", msg);
            return returnDate;
        }
        return returnDate;
    }

    private Map<String, Object> checkQueryFields(String queryType, MessageCenterParams messageCenterParams) {
        HashMap<String, Object> returnDate = new HashMap<String, Object>();
        String msg = "";
        if (WfUtils.isEmpty((String)queryType)) {
            msg = ResManager.loadKDString((String)"\u5fc5\u4f20\u53c2\u6570\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"MessageCenterServiceImpl_14", (String)MESSAGEENTITY, (Object[])new Object[0]);
            returnDate.put("message", msg);
            return returnDate;
        }
        List<Map<String, String>> currentFields = this.getTaskAndMessageFields(queryType);
        if (currentFields == null || currentFields.size() == 0) {
            msg = ResManager.loadKDString((String)"\u4f20\u5165\u7684\u67e5\u8be2\u7c7b\u578b\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"MessageCenterServiceImpl_15", (String)MESSAGEENTITY, (Object[])new Object[0]);
            returnDate.put("message", msg);
            return returnDate;
        }
        ArrayList<String> currentFieldList = new ArrayList<String>(currentFields.size());
        for (Map<String, String> map : currentFields) {
            currentFieldList.add(map.get("fieldKey"));
        }
        StringBuilder message = new StringBuilder();
        if (messageCenterParams.getListFields() != null) {
            for (String field : messageCenterParams.getListFields()) {
                if (currentFieldList.contains(field)) continue;
                message.append(field).append("\u3001");
            }
        }
        if (message.length() > 0) {
            msg = String.format(ResManager.loadKDString((String)"\u5f53\u524d\u67e5\u8be2\u5b57\u6bb5\u5b58\u5728\u4e0d\u662f\u5217\u8868\u5b57\u6bb5\uff1a%s", (String)"MessageCenterServiceImpl_16", (String)MESSAGEENTITY, (Object[])new Object[0]), message.toString());
            returnDate.put("message", msg);
            return returnDate;
        }
        return returnDate;
    }

    public List<Map<String, String>> getTaskAndMessageFields(String formKey) {
        List<String[]> fields;
        switch (formKey) {
            case "toHandle": {
                fields = DynamicFieldsService.create().getToHandleTaskListFislds(null);
                break;
            }
            case "transferToHandle": {
                fields = DynamicFieldsService.create().getToHandleTaskListFislds("transfer");
                break;
            }
            case "transferHandled": {
                fields = DynamicFieldsService.create().getHandleTaskListFislds("transfer");
                break;
            }
            case "delegateToHandle": {
                fields = DynamicFieldsService.create().getToHandleTaskListFislds("delegate");
                break;
            }
            case "delegateHandled": {
                fields = DynamicFieldsService.create().getHandleTaskListFislds("delegate");
                break;
            }
            case "handled": {
                fields = DynamicFieldsService.create().getHandleTaskListFislds(null);
                break;
            }
            case "toApply": {
                fields = DynamicFieldsService.create().getExecutionListFislds();
                break;
            }
            case "applyed": {
                fields = DynamicFieldsService.create().getHistoricProcessInstanceListFislds();
                break;
            }
            case "message": 
            case "activity": 
            case "alarm": 
            case "notice": 
            case "warning": {
                fields = DynamicFieldsService.create().getMessageListFislds();
                break;
            }
            default: {
                return null;
            }
        }
        if (fields == null) {
            return null;
        }
        ArrayList<Map<String, String>> fieldList = new ArrayList<Map<String, String>>(fields.size());
        for (String[] arr : fields) {
            HashMap<String, String> map = new HashMap<String, String>(2);
            map.put("fieldName", arr[0]);
            map.put("fieldKey", arr[1]);
            fieldList.add(map);
        }
        return fieldList;
    }

    public List<Map<String, Object>> getTaskAndMessageCategory() {
        return DynamicFieldsService.create().getTaskAndMessageMenu();
    }

    public List<Map<String, Object>> getUserFilterSchemes(String formId) {
        return DynamicFieldsService.create().getListFilterScheme(formId);
    }

    @Override
    public DynamicObjectCollection getMessageDataList(ProcessDataEntityQueryParams processDataEntityQueryParams) {
        return new GetMessageDataListForMessageCenterCmd(processDataEntityQueryParams).execute(Context.getCommandContext());
    }

    @Override
    public Long getMessageDataCount(ProcessDataEntityQueryParams processDataEntityQueryParams) {
        return new GetMessageDataCountForMessageCenterCmd(processDataEntityQueryParams).execute(Context.getCommandContext());
    }

    public List<Map<String, Object>> getMsgCenterCardOptions(String userId, List<String> itemKey) {
        if (itemKey.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Map<String, Object>> optionList = new ArrayList<Map<String, Object>>();
        MessageQuantitySummaryServcie service = MessageServiceUtil.getMessageQuantitySummaryService();
        List quantitySummaryInfos = service.getMsgQuantitySummaryByItemKey(Long.valueOf(userId), "mainPageCard", itemKey);
        ArrayList<String> messageInfos = new ArrayList<String>(itemKey.size());
        for (String key : itemKey) {
            if (key.equalsIgnoreCase("tohandle")) {
                this.buildToHandleCard(optionList, quantitySummaryInfos, false);
            }
            if (key.equalsIgnoreCase("handled")) {
                this.buildHandledCard(optionList, quantitySummaryInfos, false);
            }
            if (key.equalsIgnoreCase("toapply")) {
                this.buildToApplyCard(optionList, quantitySummaryInfos, false);
            }
            if (key.equalsIgnoreCase("applyed")) {
                this.buildApplyedCard(optionList, quantitySummaryInfos, false);
            }
            if (!key.equalsIgnoreCase(UNREAD) && !MessageQuantitySummaryCorrectUtils.isNumeric((String)key)) continue;
            messageInfos.add(key);
        }
        if (messageInfos.size() > 0) {
            this.buildCardOfMsg(optionList, quantitySummaryInfos, messageInfos);
        }
        return optionList;
    }

    private void buildToHandleCard(List<Map<String, Object>> optionList, List<QuantitySummaryInfo> quantitySummaryInfos, Boolean isQueryForMsgType) {
        HashMap<String, Object> toHandle = new HashMap<String, Object>();
        toHandle.put("id", "toHandle");
        toHandle.put("name", ResManager.loadKDString((String)"\u5f85\u529e\u4efb\u52a1", (String)"MessageCenterServiceImpl_2", (String)MESSAGEENTITY, (Object[])new Object[0]));
        toHandle.put(FORMID, "wf_msg_center");
        if (!isQueryForMsgType.booleanValue()) {
            toHandle.put(COUNT, this.getQuantitySummary(quantitySummaryInfos, "tohandle", null));
        }
        toHandle.put(BILLFORMID, "wf_task");
        optionList.add(toHandle);
    }

    private void buildHandledCard(List<Map<String, Object>> optionList, List<QuantitySummaryInfo> quantitySummaryInfos, Boolean isQueryForMsgType) {
        HashMap<String, Object> handled = new HashMap<String, Object>();
        handled.put("id", "handled");
        handled.put("name", ResManager.loadKDString((String)"\u5df2\u529e\u4efb\u52a1", (String)"MessageCenterServiceImpl_3", (String)MESSAGEENTITY, (Object[])new Object[0]));
        handled.put(FORMID, "wf_msg_center");
        if (!isQueryForMsgType.booleanValue()) {
            handled.put(COUNT, this.getQuantitySummary(quantitySummaryInfos, "handled", null));
        }
        handled.put(BILLFORMID, "wf_hitaskinst");
        optionList.add(handled);
    }

    private void buildToApplyCard(List<Map<String, Object>> optionList, List<QuantitySummaryInfo> quantitySummaryInfos, Boolean isQueryForMsgType) {
        HashMap<String, Object> toApply = new HashMap<String, Object>();
        toApply.put("id", "toApply");
        toApply.put("name", ResManager.loadKDString((String)"\u5728\u529e\u7533\u8bf7", (String)"MessageCenterServiceImpl_4", (String)MESSAGEENTITY, (Object[])new Object[0]));
        toApply.put(FORMID, "wf_msg_center");
        if (!isQueryForMsgType.booleanValue()) {
            toApply.put(COUNT, this.getQuantitySummary(quantitySummaryInfos, "toapply", null));
        }
        toApply.put(BILLFORMID, "wf_execution_tc");
        optionList.add(toApply);
    }

    private void buildApplyedCard(List<Map<String, Object>> optionList, List<QuantitySummaryInfo> quantitySummaryInfos, Boolean isQueryForMsgType) {
        HashMap<String, Object> applyed = new HashMap<String, Object>();
        applyed.put("id", "applyed");
        applyed.put("name", ResManager.loadKDString((String)"\u5df2\u529e\u7533\u8bf7", (String)"MessageCenterServiceImpl_5", (String)MESSAGEENTITY, (Object[])new Object[0]));
        applyed.put(FORMID, "wf_msg_center");
        if (!isQueryForMsgType.booleanValue()) {
            applyed.put(COUNT, this.getQuantitySummary(quantitySummaryInfos, "applyed", null));
        }
        applyed.put(BILLFORMID, "wf_hiprocinst");
        optionList.add(applyed);
    }

    private void buildUnReadCard(List<Map<String, Object>> optionList) {
        HashMap<String, String> unread = new HashMap<String, String>();
        unread.put("id", UNREAD);
        unread.put("name", ResManager.loadKDString((String)"\u672a\u8bfb\u6d88\u606f", (String)"MessageCenterServiceImpl_6", (String)MESSAGEENTITY, (Object[])new Object[0]));
        unread.put(FORMID, "wf_msg_center");
        unread.put(BILLFORMID, MSGMESSAGEENTITY);
        optionList.add(unread);
    }

    public List<Map<String, Object>> getMsgCenterCardType(String userId) {
        ArrayList<Map<String, Object>> ret = new ArrayList<Map<String, Object>>(8);
        this.buildToHandleCard(ret, null, true);
        this.buildHandledCard(ret, null, true);
        this.buildToApplyCard(ret, null, true);
        this.buildApplyedCard(ret, null, true);
        this.buildUnReadCard(ret);
        DynamicObject[] msgTypeCollection = BusinessDataServiceHelper.load((String)MSGTYPE, (String)"id, category,name", null);
        if (msgTypeCollection != null && msgTypeCollection.length > 0) {
            String lang = RequestContext.get().getLang().toString();
            for (DynamicObject dyn : msgTypeCollection) {
                HashMap<String, String> msgTypeMap = new HashMap<String, String>(msgTypeCollection.length);
                if ("task".equals(dyn.get("category"))) continue;
                String msgTypeName = (String)dyn.getLocaleString("name").get((Object)lang);
                msgTypeMap.put("id", dyn.getString("id"));
                msgTypeMap.put("name", msgTypeName);
                msgTypeMap.put(FORMID, "wf_msg_center");
                msgTypeMap.put(BILLFORMID, MSGMESSAGEENTITY);
                ret.add(msgTypeMap);
            }
        }
        return ret;
    }

    private List<Map<String, Object>> buildCardOfMsg(List<Map<String, Object>> optionList, List<QuantitySummaryInfo> quantitySummaryInfos, List<String> messageInfos) {
        if (messageInfos.size() > 0) {
            DynamicObject[] msgTypes = BusinessDataServiceHelper.load((String)MSGTYPE, (String)"id, number, name, category", null);
            if (msgTypes != null && msgTypes.length > 0) {
                for (String msgTypeId : messageInfos) {
                    for (DynamicObject msgType : msgTypes) {
                        if ("task".equals(msgType.get("category")) || !msgTypeId.equals(msgType.getString("id"))) continue;
                        String lang = RequestContext.get().getLang().toString();
                        String msgTypeName = (String)msgType.getLocaleString("name").get((Object)lang);
                        HashMap<String, Object> option = new HashMap<String, Object>();
                        option.put("id", msgType.getString("id"));
                        option.put("name", msgTypeName);
                        option.put(FORMID, "wf_msg_center");
                        int msgNodeCount = this.getQuantitySummary(quantitySummaryInfos, "msg", msgType.getString(NUMBER));
                        option.put(COUNT, msgNodeCount);
                        option.put(BILLFORMID, MSGMESSAGEENTITY);
                        optionList.add(option);
                    }
                }
            }
            if (messageInfos.contains(UNREAD)) {
                quantitySummaryInfos = quantitySummaryInfos.stream().filter(r -> r.getBillType() != null).filter(r -> !r.getBillType().equals("")).filter(r -> !r.getBillType().equals("0")).collect(Collectors.toList());
                int unreadCount = quantitySummaryInfos.stream().mapToInt(item -> "msg".equals(item.getDataType()) ? item.getQuantitysum() : 0).sum();
                HashMap<String, Object> unread = new HashMap<String, Object>();
                unread.put("id", UNREAD);
                unread.put("name", ResManager.loadKDString((String)"\u672a\u8bfb\u6d88\u606f", (String)"MessageCenterServiceImpl_6", (String)MESSAGEENTITY, (Object[])new Object[0]));
                unread.put(FORMID, "wf_msg_center");
                unread.put(COUNT, unreadCount);
                unread.put(BILLFORMID, MSGMESSAGEENTITY);
                optionList.add(unread);
            }
        }
        return optionList;
    }

    private Map<String, Object> wrapMessageResult(boolean success, String description) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("failMsgs", description);
        return this.wrapMessageResult(success, description, data);
    }

    private Map<String, Object> wrapMessageResult(boolean success, String description, Map<String, Object> data) {
        HashMap<String, Object> sendMsgResult = new HashMap<String, Object>();
        sendMsgResult.put(SUCCESS, success);
        sendMsgResult.put(DESCRIPTION, description);
        sendMsgResult.put("data", data);
        return sendMsgResult;
    }

    private List<MessageInfo> removeDuplicateMessage(List<MessageInfo> messageInfos) {
        try {
            String duplicateConfigs = MessageConfigurationUtil.getDuplicateConfigs();
            String[] configs = duplicateConfigs.split("-");
            boolean duplicateEnable = Boolean.parseBoolean(configs[0]);
            if (!duplicateEnable) {
                return messageInfos;
            }
            if (configs.length < 3) {
                return messageInfos;
            }
            int timeout = Integer.parseInt(configs[1]);
            if ((long)timeout == 0L) {
                timeout = 30;
            }
            String eigenvaleus = configs[2];
            String[] evs = eigenvaleus.split(",");
            HashMap<String, List<MessageInfo>> duplicateMessageInfos = new HashMap<String, List<MessageInfo>>();
            Iterator<MessageInfo> iterator = messageInfos.iterator();
            while (iterator.hasNext()) {
                boolean isUnique;
                MessageInfo messageInfo = iterator.next();
                String uniqueId = this.getDuplicateUniqueId(messageInfo, evs);
                if (WfUtils.isEmpty((String)uniqueId) || (isUnique = DuplicateLimiter.acquire((String)DUPLICATECODESCENE, (String)DUPLICATEBIZSCENE, (String)uniqueId, (long)timeout))) continue;
                iterator.remove();
                if (duplicateMessageInfos.containsKey(uniqueId)) {
                    ((List)duplicateMessageInfos.get(uniqueId)).add(messageInfo);
                } else {
                    ArrayList<MessageInfo> msgInfos = new ArrayList<MessageInfo>();
                    msgInfos.add(messageInfo);
                    duplicateMessageInfos.put(uniqueId, msgInfos);
                }
                logger.info("message duplicate.");
            }
            this.insertDuplicateLogs(duplicateMessageInfos);
        }
        catch (Exception e) {
            this.printLog(String.format("removeDuplicateMessage function is error: %s", WfUtils.getExceptionStacktrace((Throwable)e)));
        }
        return messageInfos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertDuplicateLogs(Map<String, List<MessageInfo>> duplicateMessageInfos) {
        ArrayList msgDuplicatelogs = new ArrayList();
        Set<Map.Entry<String, List<MessageInfo>>> entries = duplicateMessageInfos.entrySet();
        for (Map.Entry<String, List<MessageInfo>> entry : entries) {
            String uniqueId = entry.getKey();
            List<MessageInfo> messageInfos = entry.getValue();
            messageInfos.stream().forEach(messageInfo -> {
                DynamicObject msgDuplicatelog = BusinessDataServiceHelper.newDynamicObject((String)"msg_duplicatelog");
                List userIds = messageInfo.getUserIds();
                if (userIds == null) {
                    Map param = messageInfo.getParams();
                    List receiver = (List)param.get("phone");
                    if (param.get("email") != null) {
                        receiver = (List)param.get("email");
                    }
                    if (receiver != null) {
                        msgDuplicatelog.set("receiver", (Object)String.join((CharSequence)",", receiver));
                    }
                } else {
                    List receiverIds = userIds.stream().map(item -> String.valueOf(item)).collect(Collectors.toList());
                    msgDuplicatelog.set("receiver", (Object)String.join((CharSequence)",", receiverIds));
                }
                Object content = WfUtils.isNotEmpty((String)messageInfo.getContent()) ? new LocaleString(messageInfo.getContent()) : messageInfo.getMessageContent();
                Object title = WfUtils.isNotEmpty((String)messageInfo.getTitle()) ? new LocaleString(messageInfo.getTitle()) : messageInfo.getMessageTitle();
                msgDuplicatelog.set(TITLE, (Object)WfUtils.subILocaleString((ILocaleString)title, (int)400));
                msgDuplicatelog.set(CONTENT, (Object)WfUtils.subILocaleString((ILocaleString)content, (int)500));
                msgDuplicatelog.set("tag", (Object)messageInfo.getMessageTag());
                msgDuplicatelog.set(SENDER, (Object)(WfUtils.isNotEmpty((Long)messageInfo.getSenderId()) ? String.valueOf(messageInfo.getSenderId()) : ""));
                msgDuplicatelog.set("duplicateid", (Object)uniqueId);
                msgDuplicatelog.set("duplicatedate", (Object)WfUtils.now());
                msgDuplicatelogs.add(msgDuplicatelog);
            });
        }
        if (!msgDuplicatelogs.isEmpty()) {
            try (TXHandle tx = TX.requiresNew();){
                SaveServiceHelper.save((DynamicObject[])msgDuplicatelogs.toArray(new DynamicObject[0]));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeFieldCache() {
        try {
            Field[] declaredFields;
            lock.lock();
            if (!messageInfoFields.isEmpty()) {
                return;
            }
            Class<MessageInfo> messageInfoClzss = MessageInfo.class;
            for (Field field : declaredFields = messageInfoClzss.getDeclaredFields()) {
                ReflectionUtils.makeAccessible((Field)field);
                messageInfoFields.put(field.getName(), field);
            }
        }
        catch (Exception e) {
            this.printErrorLog("initializeFieldCache error:" + WfUtils.getExceptionStacktrace((Throwable)e));
        }
        finally {
            lock.unlock();
        }
    }

    private String getDuplicateUniqueId(MessageInfo messageInfo, String[] eigenvalues) {
        if (eigenvalues == null || eigenvalues.length == 0) {
            return null;
        }
        if (messageInfoFields.isEmpty()) {
            this.initializeFieldCache();
        }
        StringBuilder fieldValue = new StringBuilder();
        for (String eigenvalue : eigenvalues) {
            Field targetField;
            if (WfUtils.isEmpty((String)eigenvalue) || (targetField = messageInfoFields.get(eigenvalue)) == null) continue;
            try {
                Collection values;
                Object value = targetField.get(messageInfo);
                if (TITLE.equals(eigenvalue) && WfUtils.isEmpty((String)((String)value))) {
                    ILocaleString messageTitle = messageInfo.getMessageTitle();
                    if (messageTitle != null) {
                        values = messageTitle.values();
                        for (String v : values) {
                            value = value + v;
                        }
                    }
                } else if (CONTENT.equals(eigenvalue) && WfUtils.isEmpty((String)((String)value))) {
                    ILocaleString messageContent = messageInfo.getMessageContent();
                    if (messageContent != null) {
                        values = messageContent.values();
                        for (String v : values) {
                            value = value + v;
                        }
                    }
                } else if (MESSAGETITLE.equals(eigenvalue) && WfUtils.isEmpty((ILocaleString)((ILocaleString)value))) {
                    value = messageInfo.getTitle();
                } else if (MESSAGECONTENT.equals(eigenvalue) && WfUtils.isEmpty((ILocaleString)((ILocaleString)value))) {
                    value = messageInfo.getContent();
                } else if ("userIds".equalsIgnoreCase(eigenvalue) && WfUtils.isNotNullObject((Object)value)) {
                    List userIds = (List)value;
                    Collections.sort(userIds);
                    value = WfUtils.listToString((Collection)userIds, (String)",");
                } else if ("notifyType".equalsIgnoreCase(eigenvalue) && WfUtils.isNotNullObject((Object)value)) {
                    String notifyType = (String)value;
                    Object[] nts = notifyType.split(",");
                    Arrays.sort(nts);
                    value = String.join((CharSequence)",", (CharSequence[])nts);
                }
                if (value == null) continue;
                if (value instanceof ILocaleString) {
                    ILocaleString propertyValue = (ILocaleString)value;
                    values = propertyValue.values();
                    for (String v : values) {
                        value = value + v;
                    }
                }
                fieldValue.append(value);
            }
            catch (IllegalAccessException e) {
                this.printErrorLog(String.format("getDuplicateUniqueId has error: %s", WfUtils.getExceptionStacktrace((Throwable)e)));
            }
        }
        if (WfUtils.isNotEmpty((String)fieldValue.toString())) {
            return String.valueOf(fieldValue.toString().hashCode());
        }
        return null;
    }

    private boolean isNeedLimiter(List<MessageInfo> messageInfos) {
        boolean isLimited = false;
        try {
            String limiterConfigs = MessageConfigurationUtil.getLimiterConfigs();
            String[] configs = limiterConfigs.split("-");
            boolean limiterEnable = Boolean.parseBoolean(configs[0]);
            if (!limiterEnable) {
                return isLimited;
            }
            if (configs.length < 2) {
                return isLimited;
            }
            Set targetNotifyTypes = MessageUtils.split((String)configs[1], (String)",");
            HashSet messageNotifyTypes = new HashSet();
            HashSet<String> types = new HashSet<String>();
            for (MessageInfo messageInfo : messageInfos) {
                String notifyType = messageInfo.getNotifyType();
                if (WfUtils.isNotEmpty((String)notifyType)) {
                    messageNotifyTypes.addAll(MessageUtils.split((String)notifyType, (String)","));
                    continue;
                }
                types.add(messageInfo.getType());
            }
            if (!types.isEmpty()) {
                try {
                    for (String type : types) {
                        Map typsInfos = MessageUtils.getMessageTypeInfo((String)type);
                        messageNotifyTypes.addAll(MessageUtils.split((String)((String)typsInfos.get(CHANNELS)), (String)","));
                    }
                }
                catch (Exception e) {
                    this.printErrorLog(String.format("isLimitedMessage-type: %s", MessageUtils.getExceptionStacktrace((Throwable)e)));
                }
            }
            messageNotifyTypes.retainAll(targetNotifyTypes);
            if (!messageNotifyTypes.isEmpty()) {
                isLimited = true;
            }
        }
        catch (Exception e) {
            this.printErrorLog(String.format("isLimitedMessage has error: %s", WfUtils.getExceptionStacktrace((Throwable)e)));
        }
        this.printLog(String.format("isLimitedMessage-isNeed[%s]", isLimited));
        return isLimited;
    }

    private void printLog(String info) {
        logger.warn(info);
    }

    private void printErrorLog(String info) {
        logger.error(info);
    }
}

