/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.message.service.impl;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.encrypt.Encrypters;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.message.channel.cache.MsgServiceCache;
import kd.bos.message.channel.model.MsgChannelInfo;
import kd.bos.message.service.MessageCommonService;
import kd.bos.message.service.utils.FailMessageUtil;
import kd.bos.message.utils.MessageConfigurationUtil;
import kd.bos.message.utils.MessageSystemParamterUtils;
import kd.bos.message.utils.MessageUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.license.LicenseServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.HttpClientUtils;

public class MessageCommonServiceImpl
implements MessageCommonService {
    private static Log logger = LogFactory.getLog(MessageCommonServiceImpl.class);
    private static final int ONETIMESIZE = 200;
    private static final int MSGRESTIRES = 3;
    private static final String CREATEDATE = "createdate";
    private static final String SMSIDRECORD = "wf_smsinfo";
    private static final String SMSUSINGQUANTITY = "wf_smsusingquantity";
    private static final String SMSID = "smsid";
    private static final String MODIFYDATE = "modifydate";
    private static final String SMSNUMBER = "smsNumber";
    private static final String RETRYNUMBER = "retryNumber";
    private static final String STATE = "state";
    private static final String PERMITENDDATE = "permitEndDate";
    private static final String PREFIX = "d@f*g:";
    private static final Long GROUPID = 16L;

    public void handleFailMessages() {
        try {
            this.batchSendFailMessage();
        }
        catch (Exception e) {
            logger.error("batchSendFailMessage-error:" + MessageUtils.getExceptionStacktrace((Throwable)e));
        }
        try {
            this.saveSmsUsingQuantities();
        }
        catch (Exception e) {
            logger.error("saveSmsUsingQuantities-error:" + MessageUtils.getExceptionStacktrace((Throwable)e));
        }
    }

    private void batchSendFailMessage() {
        int resendRange = MessageSystemParamterUtils.getFailMsgResendRange();
        long limitTime = System.currentTimeMillis() - (long)(resendRange * 24) * 3600L * 1000L;
        Date limitDate = new Date(limitTime);
        QFilter f3 = new QFilter(CREATEDATE, ">=", (Object)limitDate);
        QFilter f1 = new QFilter(STATE, "in", (Object)new String[]{"fail", "dealfail"});
        QFilter f2 = new QFilter("retry", "<", (Object)3);
        QFilter[] filters = new QFilter[]{f3, f1, f2};
        ArrayList<Long> failMsgIdList = new ArrayList<Long>();
        try {
            DynamicObject[] failMsgDo = BusinessDataServiceHelper.load((String)"wf_msg_failmessage", (String)"id", (QFilter[])filters, (String)MODIFYDATE, (int)200);
            if (failMsgDo != null && failMsgDo.length > 0) {
                for (DynamicObject dynamicObject : failMsgDo) {
                    failMsgIdList.add(dynamicObject.getLong("id"));
                }
                FailMessageUtil.batchResendFailMessage(failMsgIdList, null);
            }
        }
        catch (Exception e) {
            logger.warn("batchSendFailMessage-find exception:" + e.getMessage());
        }
    }

    private void saveSmsUsingQuantities() {
        try (TXHandle tx = TX.requiresNew((String)"saveSmsUsingQuantities");){
            Map<String, Object> map;
            List smsInfos;
            block27: {
                Map<String, Object> queryResult = this.querySmsInfo();
                long smsSuccessDiffCount = (Long)queryResult.get("smsSuccessDiffCount");
                smsInfos = (List)queryResult.get("smsInfos");
                if (smsSuccessDiffCount == 0L) {
                    if (!smsInfos.isEmpty()) {
                        SaveServiceHelper.save((DynamicObject[])smsInfos.toArray(new DynamicObject[0]));
                    }
                    return;
                }
                map = this.querySmsUsingQuantity(smsSuccessDiffCount);
                if (!map.isEmpty()) break block27;
                return;
            }
            try {
                Object smsObj = map.get("smsObj");
                Object smsAddObj = map.get("smsAddObj");
                ArrayList<DynamicObject> objList = new ArrayList<DynamicObject>(2);
                if (smsObj != null) {
                    objList.add((DynamicObject)smsObj);
                }
                if (smsAddObj != null) {
                    objList.add((DynamicObject)smsAddObj);
                }
                if (!objList.isEmpty()) {
                    SaveServiceHelper.save((DynamicObject[])objList.toArray(new DynamicObject[0]));
                    if (!smsInfos.isEmpty()) {
                        SaveServiceHelper.save((DynamicObject[])smsInfos.toArray(new DynamicObject[0]));
                    }
                }
            }
            catch (Exception e) {
                tx.markRollback();
                logger.error("saveSmsUsingQuantities is error, errorinfo is :" + MessageUtils.getExceptionStacktrace((Throwable)e));
            }
        }
    }

    private Map<String, Object> querySmsInfo() {
        DynamicObject[] objs;
        HashMap<String, Object> result = new HashMap<String, Object>();
        MsgChannelInfo msgChannelInfo = MsgServiceCache.getMsgChannel((String)"sms");
        long smsSuccessDiffCount = 0L;
        if (msgChannelInfo == null) {
            result.put("smsSuccessDiffCount", smsSuccessDiffCount);
            result.put("smsInfos", Collections.emptyList());
            return result;
        }
        ArrayList<DynamicObject> smsInfos = new ArrayList<DynamicObject>(100);
        String clientId = msgChannelInfo.getClientid();
        String clientSecret = msgChannelInfo.getClientsecret();
        int days = MessageConfigurationUtil.getQuerySmsInfoDays();
        logger.debug("saveSmsUsingQuantities-queryDays:" + days);
        Date currentDate = new Date();
        Calendar ca = Calendar.getInstance();
        ca.setTime(new Date());
        ca.add(5, -days);
        QFilter q1 = new QFilter(CREATEDATE, ">", (Object)ca.getTime());
        QFilter q2 = new QFilter(CREATEDATE, "<", (Object)currentDate);
        QFilter q3 = new QFilter(RETRYNUMBER, "<", (Object)3);
        List<Integer> statelist = Arrays.asList(0, 2);
        QFilter q4 = new QFilter(STATE, "in", statelist);
        for (DynamicObject dynamicObject : objs = BusinessDataServiceHelper.load((String)SMSIDRECORD, (String)"smsid, retryNumber, modifydate, state", (QFilter[])new QFilter[]{q1, q2, q3, q4}, (String)CREATEDATE, (int)100)) {
            long smsid = (Long)dynamicObject.get(SMSID);
            logger.debug("saveSmsUsingQuantities-smsid:" + smsid);
            boolean smsPullResult = MessageCommonServiceImpl.smsPullResult(smsid, clientId, clientSecret);
            if (smsPullResult) {
                dynamicObject.set(STATE, (Object)1);
                ++smsSuccessDiffCount;
            } else {
                dynamicObject.set(STATE, (Object)2);
                int retryNumber = dynamicObject.getInt(RETRYNUMBER);
                dynamicObject.set(RETRYNUMBER, (Object)(retryNumber + 1));
            }
            dynamicObject.set(MODIFYDATE, (Object)TimeServiceHelper.now());
            smsInfos.add(dynamicObject);
        }
        result.put("smsSuccessDiffCount", smsSuccessDiffCount);
        result.put("smsInfos", smsInfos);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Object> querySmsUsingQuantity(long smsSuccessDiffCount) {
        HashMap<String, Object> resMap;
        block13: {
            resMap = new HashMap<String, Object>();
            DynamicObject smsObj = null;
            DynamicObject smsAddObj = null;
            try {
                DynamicObject[] smsObjs = BusinessDataServiceHelper.load((String)SMSUSINGQUANTITY, (String)"id, smsNumber, permitEndDate", null, (String)"permitEndDate desc", (int)1);
                if (smsObjs != null && smsObjs.length > 0) {
                    long smsCount = 0L;
                    smsObj = smsObjs[0];
                    Date permitEndDate = smsObj.getDate(PERMITENDDATE);
                    String smsNumber = smsObj.getString(SMSNUMBER);
                    try {
                        smsNumber = smsNumber.startsWith(PREFIX) ? Encrypters.decode((String)smsNumber) : smsNumber;
                        smsCount = smsSuccessDiffCount + (MessageUtils.isNotEmpty((String)smsNumber) ? Long.parseLong(smsNumber) : 0L);
                        logger.debug("querySmsUsingQuantity-usedNum:" + smsCount);
                    }
                    catch (Exception e) {
                        logger.error("querySmsUsingQuantity is error, errorinfo is : smsUsedNumber is Destroyed");
                    }
                    if (smsCount != 0L) {
                        smsObj.set(SMSNUMBER, (Object)Encrypters.encode((String)String.valueOf(smsCount)));
                    }
                    long currentTime = System.currentTimeMillis();
                    if (permitEndDate == null || permitEndDate.getTime() <= currentTime) {
                        permitEndDate = MessageCommonServiceImpl.getPermitEndDate();
                        logger.debug("saveSmsUsingQuantities-getPermitEndDate:" + permitEndDate);
                        if (permitEndDate != null && permitEndDate.getTime() > currentTime) {
                            smsCount = 0L;
                            smsAddObj = BusinessDataServiceHelper.newDynamicObject((String)SMSUSINGQUANTITY);
                            smsAddObj.set(PERMITENDDATE, (Object)permitEndDate);
                            smsAddObj.set(SMSNUMBER, (Object)Encrypters.encode((String)String.valueOf(smsCount)));
                            logger.debug("saveSmsUsingQuantities-reload, isExpired : true");
                        }
                    }
                } else {
                    Date permitEndDate = MessageCommonServiceImpl.getPermitEndDate();
                    logger.debug("saveSmsUsingQuantities-getPermitEndDate:" + permitEndDate);
                    if (permitEndDate != null) {
                        smsObj = BusinessDataServiceHelper.newDynamicObject((String)SMSUSINGQUANTITY);
                        smsObj.set(PERMITENDDATE, (Object)permitEndDate);
                        smsObj.set(SMSNUMBER, (Object)Encrypters.encode((String)String.valueOf(smsSuccessDiffCount)));
                    }
                }
                resMap.put("smsObj", smsObj);
            }
            catch (Exception e) {
                logger.warn("saveSmsUsingQuantities-loadsmsusingquantity is error:" + MessageUtils.getExceptionStacktrace((Throwable)e));
                break block13;
            }
            finally {
                resMap.put("smsObj", smsObj);
                resMap.put("smsAddObj", smsAddObj);
            }
            resMap.put("smsAddObj", smsAddObj);
        }
        return resMap;
    }

    private static boolean smsPullResult(long smsId, String clientId, String clientSecret) {
        JSONObject pushSmsResult;
        boolean result = false;
        HashMap<String, String> header = new HashMap<String, String>(2);
        header.put("X-Api-ClientID", clientId);
        header.put("X-Api-ClientSecret", clientSecret);
        HashMap<String, Long> pullParams = new HashMap<String, Long>();
        pullParams.put(SMSID, smsId);
        String str = HttpClientUtils.get((String)MessageConfigurationUtil.getPullSmsUrl(), header, pullParams);
        if (MessageUtils.isNotEmpty((String)str) && 0 == (pushSmsResult = JSONObject.parseObject((String)str)).getInteger("errcode")) {
            result = true;
        }
        return result;
    }

    private static Date getPermitEndDate() {
        Date permitEndDate = LicenseServiceHelper.getExpireDateByGroup((Long)GROUPID);
        logger.debug("LicenseServiceHelper.getExpireDateByGroup-permitEndDate:" + permitEndDate);
        return permitEndDate;
    }
}

