/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.message.service.impl;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.cache.CacheKeyUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.workflow.engine.WfUtils;

public class MigrateDBData2WfFromSysImpl
implements IUpgradeService {
    private static final String CHANNELTABLE = "t_msg_channel";
    private static final String TYPETABLE = "t_msg_type";
    private static Log logger = LogFactory.getLog(MigrateDBData2WfFromSysImpl.class);

    public Map<String, Object> beforeExecuteSql(String arg0, String arg1, String arg2, String arg3) {
        HashMap<String, Object> resMap = new HashMap<String, Object>();
        String tn = this.executeMigrateData(resMap);
        resMap.put("tableName", tn.substring(0, tn.length() - 1));
        return resMap;
    }

    private String executeMigrateData(Map<String, Object> resMap) {
        ArrayList<String> channelCollection = new ArrayList();
        StringBuilder tn = new StringBuilder();
        String channel_fields = "FID,FNUMBER,FCATEGORY,FMOBILEAPP,FSMTPHOST,FSMTPPORT,FUSERNAME,FPASSWORD,FFROMACCOUNT,FSMSAPIURL,FSMSCODE,FCLIENTID,FCLIENTSECRET,FMOBILEAPPCONFIG,FENABLE,FCREATEDATE,FMODIFYDATE,FSERVICECLASS,FCORPID,FAGENTID,FAPPKEY,FAPPSECRET,FISHASDINGTPL,FTPLPROCESSCODE,FTPLNAME,FDOMAIN";
        channelCollection = this.updateData(CHANNELTABLE, channel_fields, tn);
        String channel_l_fields = "FPKID, FID, FLOCALEID, FNAME, FFROMUSERNAME";
        this.updateData("t_msg_channel_l", channel_l_fields, tn);
        String pubacc_fields = "FID, FNUMBER, FCODE, FKEY";
        this.updateData("t_msg_pubacc", pubacc_fields, tn);
        String pubacc_l_fields = "FPKID, FID, FLOCALEID, FNAME, FDESCRIPTION";
        this.updateData("t_msg_pubacc_l", pubacc_l_fields, tn);
        String selectScene_fields = "FPKID, FID, FBASEDATAID";
        this.updateData("t_msg_selectscene", selectScene_fields, tn);
        String srvcfg_fields = "FID,FSMTPHOST,FSMTPPORT,FUSERNAME,FPASSWORD,FFROMACCOUNT,FSMSAPIURL,FCLIENTID,FCLIENTSECRET,FSMSCODE,FPUBACCAPIURL,FCONSUMER";
        this.updateData("t_msg_srvcfg", srvcfg_fields, tn);
        String srvcfg_l_fields = "FPKID, FID, FLOCALEID, FFROMUSERNAME";
        this.updateData("t_msg_srvcfg_l", srvcfg_l_fields, tn);
        String template_fields = "FID,FMSGTYPE,FMSGCHANNEL,FMSGSCENE,FMSGTEMPLATE,FMSGENTITY,FCREATEDATE,FMODIFYDATE";
        this.updateData("t_msg_template", template_fields, tn);
        String template_l_fields = "FPKID, FID, FLOCALEID, FMSGSCENENAME";
        this.updateData("t_msg_template_l", template_l_fields, tn);
        String tplSecene_fields = "FID, FNUMBER, FENTITYNUMBER";
        this.updateData("t_msg_tplscene", tplSecene_fields, tn);
        String tplScene_l_fields = "FPKID, FID, FLOCALEID, FNAME";
        this.updateData("t_msg_tplscene_l", tplScene_l_fields, tn);
        String type_fields = "FID, FNUMBER, FCATEGORY, FCHANNELS, FCREATEDATE, FMODIFYDATE";
        this.updateData(TYPETABLE, type_fields, tn);
        String type_l_fields = "FPKID, FID, FLOCALEID, FNAME, FCHANNELNAME";
        this.updateData("t_msg_type_l", type_l_fields, tn);
        this.clearCache(CHANNELTABLE, channelCollection);
        this.clearCache(TYPETABLE, null);
        return tn.toString();
    }

    private List<String> updateData(String table, String fields, StringBuilder tn) {
        ArrayList<String> numberCollection = new ArrayList<String>();
        DynamicObjectCollection doCol = this.queryData(table, fields);
        if (doCol != null && doCol.size() != 0) {
            String s = "TRUNCATE TABLE " + table + ";";
            DB.execute((DBRoute)DBRoute.workflow, (String)s);
            logger.debug(table + " start migrate data to wfs");
            for (int j = 0; j < doCol.size(); ++j) {
                DynamicObject doData = (DynamicObject)doCol.get(j);
                this.updateTableData(doData, table, fields, numberCollection);
            }
            logger.debug(table + "end migrate data");
        } else {
            logger.debug(table + "not need migrate, original table data is empty");
        }
        tn.append(table).append(",");
        return numberCollection;
    }

    private void updateTableData(DynamicObject doData, String table, String fields, List<String> numberCollection) {
        String[] properties = fields.split(",");
        StringBuilder sb = new StringBuilder();
        sb.append("INSERT INTO ").append(table).append(" (").append(fields).append(") VALUES ");
        sb.append("( ");
        for (int i = 0; i < properties.length; ++i) {
            String value = "";
            if (properties[i].trim().equalsIgnoreCase("FCREATEDATE") || properties[i].trim().equalsIgnoreCase("FMODIFYDATE")) {
                SimpleDateFormat tempDate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                String datetime = tempDate.format(doData.getDate(properties[i].trim()));
                value = "{ts'" + datetime + "'}";
            } else {
                if (CHANNELTABLE.equalsIgnoreCase(table) && "FNUMBER".equalsIgnoreCase(properties[i].trim())) {
                    numberCollection.add(doData.getString(properties[i].trim()));
                }
                String v = WfUtils.isEmptyString((Object)doData.get(properties[i].trim())) ? " " : doData.get(properties[i].trim());
                value = "'" + v + "'";
            }
            if (i != properties.length - 1) {
                sb.append((Object)value).append(", ");
                continue;
            }
            sb.append((Object)value);
        }
        sb.append(" )");
        boolean ds = DB.execute((DBRoute)DBRoute.workflow, (String)sb.toString(), null);
        if (!ds) {
            sb.append("--migrate data is error and the table is:");
            sb.append(table);
            logger.debug(sb.toString());
        }
    }

    private DynamicObjectCollection queryData(String table, String fields) {
        StringBuilder sb = new StringBuilder();
        sb.append("select ").append(fields).append(" from ").append(table);
        DynamicObjectCollection col = null;
        try (DataSet ds = DB.queryDataSet((String)"MessageCenter.MigrateMCdb2wfImpl.queryData", (DBRoute)DBRoute.basedata, (String)sb.toString(), null);){
            col = ORM.create().toPlainDynamicObjectCollection(ds);
        }
        logger.debug(table + " query data from sys over");
        return col;
    }

    private void clearCache(String table, List<String> numberCollection) {
        try {
            if (CHANNELTABLE.equalsIgnoreCase(table)) {
                if (numberCollection == null || numberCollection.size() == 0) {
                    return;
                }
                String type = "BS_MESSAGE_SERVICE__CFG_" + CacheKeyUtil.getAcctId();
                String[] numbers = new String[numberCollection.size()];
                for (int i = 0; i < numberCollection.size(); ++i) {
                    numbers[i] = numberCollection.get(i);
                }
                DistributeSessionlessCache channelCache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("MESSAGE_SERVICE", new DistributeCacheHAPolicy());
                channelCache.remove(type, numbers);
            } else if (TYPETABLE.equalsIgnoreCase(table)) {
                DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("", new DistributeCacheHAPolicy());
                String prefixKey = RequestContext.get().getAccountId() + "&&msg.type&&";
                List typeKeys = cache.getKeysWithPrefix(prefixKey);
                String[] keys = new String[typeKeys.size()];
                for (int i = 0; i < typeKeys.size(); ++i) {
                    keys[i] = (String)typeKeys.get(i);
                }
                cache.remove(keys);
            }
        }
        catch (Exception e) {
            logger.warn("clearCache is fail the table is " + table + " and the reason:" + e.getMessage());
        }
    }

    public Map<String, Object> afterExecuteSql(String arg0, String arg1, String arg2, String arg3) {
        return null;
    }
}

