/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.message.service.impl;

import com.alibaba.fastjson.JSONObject;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.message.service.util.MessageCacheUtils;

public class UpdateMsgChannelImpl
implements IUpgradeService {
    private static Log logger = LogFactory.getLog(UpdateMsgChannelImpl.class);
    private static final String SMTP_NO = "no";
    private static final String SMTP_SSL = "ssl";
    private static final String SMTP_TLS = "tls";
    private static final String SMTP_TLS_SSL = "all";
    private static final String MSG_CHANNEL = "msg_channel";

    public Map<String, Object> beforeExecuteSql(String arg0, String arg1, String arg2, String arg3) {
        try {
            QFilter q1 = new QFilter("category", "=", (Object)"email");
            DynamicObject[] objs = BusinessDataServiceHelper.load((String)MSG_CHANNEL, (String)"id,smtpport,tls,mobileappconfig,enable", (QFilter[])new QFilter[]{q1});
            if (objs == null || objs.length == 0) {
                return null;
            }
            for (DynamicObject msgChannel : objs) {
                String config = msgChannel.getString("mobileappconfig");
                JSONObject jsonConfig = new JSONObject();
                if (WfUtils.isNotEmpty((String)config)) {
                    jsonConfig = JSONObject.parseObject((String)config);
                }
                jsonConfig.put("smtpProtocol", (Object)this.getSmtpProtocol(msgChannel.getString("smtpport"), msgChannel.getBoolean(SMTP_TLS)));
                jsonConfig.put("auth", (Object)Boolean.TRUE);
                msgChannel.set("mobileappconfig", (Object)jsonConfig.toJSONString());
                SaveServiceHelper.update((DynamicObject)msgChannel);
                MessageCacheUtils.clearMessageChannelCache("email");
            }
            logger.info("UpdateMsgChannelImpl update msgChannel is success");
        }
        catch (Exception e) {
            logger.info(String.format("UpdateMsgChannelImpl update msgChannel is exception and error is %s", e.getMessage()));
        }
        return null;
    }

    private String getSmtpProtocol(String smtpPort, boolean isTls) {
        String smtpProtocol = "";
        smtpProtocol = "465".equalsIgnoreCase(smtpPort) ? (isTls ? SMTP_TLS_SSL : SMTP_SSL) : (isTls ? SMTP_TLS : SMTP_NO);
        return smtpProtocol;
    }

    public Map<String, Object> afterExecuteSql(String arg0, String arg1, String arg2, String arg3) {
        return null;
    }
}

