/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.message.service.impl;

import java.util.ArrayList;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.service.upgrade.IUpgradeService;

public class UpdateMsgTemplateDataImpl
implements IUpgradeService {
    private static Log logger = LogFactory.getLog(UpdateMsgTemplateDataImpl.class);

    public Map<String, Object> beforeExecuteSql(String arg0, String arg1, String arg2, String arg3) {
        try {
            String sql = "select FID, FMSGSCENE, FMSGTEMPLATE from t_msg_template where fmsgentity='wf_task' and fmsgchannel = 'email';";
            DynamicObjectCollection templateDatas = this.queryData(sql);
            if (templateDatas != null) {
                ArrayList<String> cacheKeyList = new ArrayList<String>(templateDatas.size());
                for (DynamicObject templateData : templateDatas) {
                    String tpl = templateData.getString("FMSGTEMPLATE");
                    if (!this.isNeedUpdate(tpl)) continue;
                    Long tplId = templateData.getLong("FID");
                    String filterSql = String.format(" fid = '%s'", tplId);
                    this.updateData(tpl, "t_msg_template", filterSql);
                    String sql_l = String.format("select FID, FLOCALEID, FMSGTEMPLATE from t_msg_template_l where fid = '%s';", tplId);
                    DynamicObjectCollection templateDatas_l = this.queryData(sql_l);
                    if (templateDatas_l != null) {
                        for (DynamicObject templateData_l : templateDatas_l) {
                            String tpl_l = templateData_l.getString("FMSGTEMPLATE");
                            if (!this.isNeedUpdate(tpl_l)) continue;
                            String localeId = templateData_l.getString("FLOCALEID");
                            String filterSql_l = String.format(" fid = '%s' and flocaleid = '%s'", tplId, localeId);
                            this.updateData(tpl_l, "t_msg_template_l", filterSql_l);
                        }
                    }
                    String cacheKey = this.getCacheKey("task", "email", templateData.getString("fmsgscene"), "wf_task");
                    cacheKeyList.add(cacheKey);
                }
                if (cacheKeyList.size() != 0) {
                    DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("", new DistributeCacheHAPolicy());
                    cache.remove(cacheKeyList.toArray(new String[0]));
                }
                logger.info("update data from wfs over");
            }
        }
        catch (Exception e) {
            logger.info(String.format("update template is exception and error is %s", e.getMessage()));
        }
        return null;
    }

    private DynamicObjectCollection queryData(String sql) {
        DynamicObjectCollection col = null;
        try (DataSet ds = DB.queryDataSet((String)"MessageCenter.UpdateMsgTemplateDataImpl.queryData", (DBRoute)DBRoute.workflow, (String)sql, null);){
            col = ORM.create().toPlainDynamicObjectCollection(ds);
        }
        catch (Exception e) {
            logger.info(String.format("sql: %s query data from wfs is error and the description is %s", sql, e.getMessage()));
        }
        logger.info(String.format("sql: %s query data from wfs over", sql));
        return col;
    }

    private boolean isNeedUpdate(String tpl) {
        boolean isNeedUpdate = false;
        if (StringUtils.isNotBlank((CharSequence)tpl)) {
            String element1 = "<span style=font-weight: bold;>{model.assignee}</span>\uff0c";
            String element2 = "<span style=font-weight: bold;>{model.assignee}</span>,";
            String element3 = "<span style = font-weight: bold;> {model.assignee} </ span> ";
            String element4 = "<span style=font-weight: bold;> {model.assignee} </span>,";
            if (tpl.contains(element1) || tpl.contains(element2) || tpl.contains(element3) || tpl.contains(element4)) {
                isNeedUpdate = true;
            }
        }
        return isNeedUpdate;
    }

    private void updateData(String msgTpl, String tableName, String filterSql) {
        if (StringUtils.isNotBlank((CharSequence)msgTpl)) {
            String element1 = "<span style=font-weight: bold;>{model.assignee}</span>\uff0c";
            String element2 = "<span style=font-weight: bold;>{model.assignee}</span>,";
            String element3 = "<span style = font-weight: bold;> {model.assignee} </ span> ";
            String element4 = "<span style=font-weight: bold;> {model.assignee} </span>,";
            String tpl = "";
            tpl = msgTpl.contains(element1) ? msgTpl.replace(element1, "") : (msgTpl.contains(element2) ? msgTpl.replace(element2, "") : (msgTpl.contains(element3) ? (msgTpl.contains("Hello") ? msgTpl.replace(element3, "") : msgTpl.replace(element3, "Hello")) : (msgTpl.contains(element4) ? msgTpl.replace(element4, "") : msgTpl)));
            if (tpl.contains("'")) {
                tpl = tpl.replace("'", "");
            }
            String sql = String.format("UPDATE %s SET FMSGTEMPLATE = '%s' WHERE %s;", tableName, tpl, filterSql);
            try {
                DB.execute((DBRoute)DBRoute.workflow, (String)sql, null);
                logger.info(String.format("sql: %s update data from wfs over", sql));
            }
            catch (Exception e) {
                logger.info(String.format("sql: %s update data from wfs is error and description is %s", sql, e.getMessage()));
            }
        }
    }

    private String getCacheKey(String ... args) {
        StringBuilder sb = new StringBuilder();
        sb.append(RequestContext.get().getAccountId()).append('_');
        for (int i = 0; i < args.length; ++i) {
            sb.append(args[i]).append('_');
        }
        return sb.substring(0, sb.length() - 1);
    }

    public Map<String, Object> afterExecuteSql(String arg0, String arg1, String arg2, String arg3) {
        return null;
    }
}

