/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.message.service.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.service.upgrade.IUpgradeService;

public class UpdateMsgTemplateNumberImpl
implements IUpgradeService {
    private static Log logger = LogFactory.getLog(UpdateMsgTemplateNumberImpl.class);

    public Map<String, Object> beforeExecuteSql(String ver, String iteration, String dbKey, String sqlFileName) {
        this.updateTempplateData();
        this.updateSceneData();
        return null;
    }

    private void updateSceneData() {
        String sql = "update t_msg_tplscene set fcreatedate = {ts '2020-08-19 21:36:41'}, fmodifydate = {ts '2020-08-19 21:36:41'} where fispreinsdata='1';";
        try {
            DB.execute((DBRoute)DBRoute.workflow, (String)sql);
        }
        catch (Exception e) {
            logger.info(String.format("update scene data from wfs is error and description is %s", e.getMessage()));
        }
    }

    private void updateTempplateData() {
        String sql1 = "select fid from t_msg_template where FNAME=' ' order by fcreatedate;";
        DynamicObjectCollection tplCollection = this.queryData(sql1);
        if (tplCollection != null && tplCollection.size() != 0) {
            ArrayList<Long> tplIds = new ArrayList<Long>(tplCollection.size());
            if (tplCollection != null && tplCollection.size() != 0) {
                for (DynamicObject tpl : tplCollection) {
                    tplIds.add(tpl.getLong("fid"));
                }
            }
            int batchCount = 50;
            int totalCount = tplIds.size();
            int pageCount = totalCount % batchCount != 0 ? totalCount / batchCount + 1 : totalCount / batchCount;
            try {
                for (int i = 0; i < pageCount; ++i) {
                    int startIndex = i * batchCount;
                    int endIndex = (i + 1) * batchCount > totalCount ? totalCount : (i + 1) * batchCount;
                    List<Long> tplIds_sub = tplIds.subList(startIndex, endIndex);
                    List<Object[]> tpl_params = this.getParams(tplIds_sub, startIndex, Boolean.FALSE);
                    List<Object[]> tpl_l_params = this.getParams(tplIds_sub, startIndex, Boolean.TRUE);
                    if (tpl_params.size() != 0) {
                        String sql2 = "UPDATE t_msg_template set FNAME=?, FNUMBER=? where FID=? and FNAME=' ';";
                        this.executeSql(sql2, tpl_params);
                    }
                    if (tpl_l_params.size() == 0) continue;
                    String sql3 = "UPDATE t_msg_template_l set FNAME=? where FID=? and FNAME=' ';";
                    this.executeSql(sql3, tpl_l_params);
                }
            }
            catch (Exception e) {
                logger.info(String.format("update tpl data from wfs is error and description is %s", e.getMessage()));
            }
        }
    }

    private void executeSql(String sql, List<Object[]> params) {
        DB.executeBatch((DBRoute)DBRoute.workflow, (String)sql, params);
    }

    private List<Object[]> getParams(List<Long> tplIds, int index, boolean isMutilLanguage) {
        String number = "MSGTPL";
        ArrayList<Object[]> tpl_params = new ArrayList<Object[]>();
        for (Long id : tplIds) {
            String standard = number + ++index;
            if (isMutilLanguage) {
                Object[] param_tpl_l = new Object[]{standard, id};
                tpl_params.add(param_tpl_l);
                continue;
            }
            Object[] param_tpl = new Object[]{standard, standard, id};
            tpl_params.add(param_tpl);
        }
        return tpl_params;
    }

    private DynamicObjectCollection queryData(String sql) {
        DynamicObjectCollection col = null;
        try (DataSet ds = DB.queryDataSet((String)"MessageCenter.UpdateMsgTemplateNumberImpl.queryData", (DBRoute)DBRoute.workflow, (String)sql, null);){
            col = ORM.create().toPlainDynamicObjectCollection(ds);
        }
        catch (Exception e) {
            logger.info(String.format("sql: %s query data from wfs is error and the description is %s", sql, e.getMessage()));
        }
        return col;
    }
}

