/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.message.service.schedule;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.msg.info.ParticipantInfo;
import kd.bos.workflow.engine.msg.info.TaskEntityInfo;
import kd.bos.workflow.message.service.impl.MessageCenterServiceImpl;

public class BatchCreateTaskSchedule
extends AbstractTask {
    protected static Log logger = LogFactory.getLog(BatchCreateTaskSchedule.class);

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        int limit = Integer.parseInt((String)map.get("limit"));
        String entitynumber = (String)map.get("entitynumber");
        int shang = Integer.parseInt((String)map.get("shang"));
        logger.debug(String.format("%s-%s-%s", limit, entitynumber, shang));
        this.seperateBillAndUser(limit, entitynumber, shang);
        logger.debug("finished.");
    }

    private void seperateBillAndUser(int limit, String entitynumber, int shang) {
        List<Map<String, Object>> nextBills = this.getNextBatchBill(limit, entitynumber);
        List<Long> nextUserIds = this.getNextBatchUser(limit);
        logger.debug("size of bill:" + nextBills.size());
        logger.debug("size of user:" + nextUserIds.size());
        int step = 0;
        int totalcount = 0;
        int size = nextUserIds.size() - 1;
        if (size == 0 || size < 0) {
            return;
        }
        if (nextBills == null || nextBills.isEmpty()) {
            logger.debug("bill is finished.");
        }
        for (Map<String, Object> map : nextBills) {
            Long id = (Long)map.get("id");
            String billno = (String)map.get("billno");
            for (int i = 0; i < shang; ++i) {
                int lastIndex = step + 2;
                if (lastIndex >= size) {
                    lastIndex = size;
                }
                ArrayList<Long> uids = new ArrayList<Long>(2);
                for (int j = step; j < lastIndex; ++j) {
                    uids.add(nextUserIds.get(j));
                }
                this.createTask(String.valueOf(id), billno, totalcount, uids, entitynumber);
                step = lastIndex == size ? 0 : lastIndex;
                if (++totalcount % 100 != 0) continue;
                logger.debug("has created task:" + totalcount);
            }
        }
    }

    public List<Map<String, Object>> getNextBatchBill(int limit, String entitynumber) {
        ArrayList<Map<String, Object>> userId = new ArrayList<Map<String, Object>>();
        long lastBillId = this.getLastBillId();
        logger.info("last billid:" + lastBillId);
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"yyy", (String)entitynumber, (String)"id,billno", (QFilter[])new QFilter[]{new QFilter("id,billno", ">=", (Object)lastBillId)}, null, (int)limit);){
            while (ds.hasNext()) {
                Row row = ds.next();
                long id = row.getLong("id");
                String billno = row.getString("billno");
                HashMap<String, Object> single = new HashMap<String, Object>();
                single.put("id", id);
                single.put("billno", billno);
                userId.add(single);
                lastBillId = id;
            }
        }
        this.saveLastBillId(lastBillId);
        return userId;
    }

    private void saveLastBillId(long lastBillId) {
        this.updateConfCenterValue("wf.batchtask.lastBillId", lastBillId);
    }

    public List<Long> getNextBatchUser(int limit) {
        ArrayList<Long> userId = new ArrayList<Long>();
        long lastUserId = this.getLastUserId();
        logger.info("last userid:" + lastUserId);
        int size = 0;
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"xxx", (String)"bos_user", (String)"id", (QFilter[])new QFilter[]{new QFilter("id", ">=", (Object)lastUserId), new QFilter("number", "like", (Object)"PF%")}, null, (int)limit);){
            while (ds.hasNext()) {
                Row row = ds.next();
                long id = row.getLong("id");
                userId.add(id);
                lastUserId = id;
                ++size;
            }
        }
        if (size == 0) {
            lastUserId = 0L;
        }
        this.saveLastUserId(lastUserId);
        return userId;
    }

    private void saveLastUserId(long lastUserId) {
        this.updateConfCenterValue("wf.batchtask.lastUserId", lastUserId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateConfCenterValue(String key, Object value) {
        try (TXHandle handle = TX.requiresNew();){
            QFilter selectValueFilter = new QFilter("key", "=", (Object)key);
            QFilter[] selectValueFilters = new QFilter[]{selectValueFilter};
            DynamicObject dnyObj = BusinessDataServiceHelper.loadSingle((String)"wf_confcenter", (String)"id,value", (QFilter[])selectValueFilters);
            if (dnyObj == null) {
                dnyObj = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"wf_confcenter"));
                dnyObj.set("key", (Object)key);
            }
            dnyObj.set("value", value);
            DynamicObject[] dynObjs = new DynamicObject[]{dnyObj};
            SaveServiceHelper.save((DynamicObject[])dynObjs);
        }
    }

    public Long createTask(String bk, String billno, long index, List<Long> userIds, String entitynumber) {
        TaskEntityInfo taskEntityInfo = new TaskEntityInfo();
        LocaleString name = new LocaleString(ResManager.loadKDString((String)"\u7528\u8f66\u7533\u8bf7%s", (String)"BatchCreateTaskSchedule_0", (String)"bos-wf-message", (Object[])new Object[]{index}));
        taskEntityInfo.setName((ILocaleString)name);
        taskEntityInfo.setSubject((ILocaleString)new LocaleString(billno + index));
        taskEntityInfo.setDescription((ILocaleString)name);
        taskEntityInfo.setEndType("all");
        taskEntityInfo.setDueDate(null);
        taskEntityInfo.setCategory("CRMTask");
        taskEntityInfo.setFormKey(entitynumber);
        taskEntityInfo.setMobileFormKey(entitynumber);
        taskEntityInfo.setDisplay(true);
        taskEntityInfo.setStarterId(userIds.get(0));
        taskEntityInfo.setBusinessKey(bk);
        taskEntityInfo.setBillNo(billno + index);
        taskEntityInfo.setEntityNumber(entitynumber);
        taskEntityInfo.setProcessingPage("msg_approvalpage_crm");
        taskEntityInfo.setProcessingMobilePage("wf_approvalpagemobile_bac");
        ArrayList<ParticipantInfo> participantInfos = new ArrayList<ParticipantInfo>();
        if (userIds.size() > 0) {
            for (Long partInfo : userIds) {
                participantInfos.add(new ParticipantInfo(partInfo.longValue()));
            }
        }
        taskEntityInfo.setParticipantInfos(participantInfos);
        MessageCenterServiceImpl messageCenterServiceImpl = new MessageCenterServiceImpl();
        Map<String, Object> ret = messageCenterServiceImpl.createTask(taskEntityInfo);
        if (ret != null) {
            return (Long)ret.get("taskId");
        }
        return 0L;
    }

    public Long getLastUserId() {
        Object lastuserid = WfConfigurationUtil.getConfigCenterVal((String)"wf.batchtask.lastUserId");
        return lastuserid != null ? Long.parseLong(lastuserid.toString()) : 0L;
    }

    public Long getLastBillId() {
        Object lastuserid = WfConfigurationUtil.getConfigCenterVal((String)"wf.batchtask.lastBillId");
        return lastuserid != null ? Long.parseLong(lastuserid.toString()) : 0L;
    }
}

