/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.message.service.schedule;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.workflow.engine.WfDBUtils;
import kd.bos.workflow.engine.impl.clean.cleaner.DefaultRegularTimeCleaner;
import kd.bos.workflow.engine.impl.clean.model.CleanTaskConfigParam;

public class ClearHiMessageDataTask
extends DefaultRegularTimeCleaner {
    private static Log log = LogFactory.getLog(DefaultRegularTimeCleaner.class);
    private static final String MESSAGEID = "messageid";
    private static final String ID = "id";

    protected void findAndCleanData(CleanTaskConfigParam configParam, Date seekDate, Date maxCleanDate) {
        int disposeTotal;
        int limitQuantity = configParam.getLimitQuantity() == 0 ? 5000000 : configParam.getLimitQuantity();
        int stepLimitQuantity = configParam.getStepLimitQuantity() == 0 || configParam.getStepLimitQuantity() > 50000 ? 50000 : configParam.getStepLimitQuantity();
        int cleanCount = 0;
        int loopCount = 0;
        while ((cleanCount = (disposeTotal = this.executeEverySegment(configParam, stepLimitQuantity, seekDate, maxCleanDate)) + cleanCount) < limitQuantity && ++loopCount <= 10000) {
        }
        log.info(String.format("ClearHiMessageDataTask \u6309\u4fdd\u7559\u65f6\u95f4\u6e05\u7406\u4e3b\u5b9e\u4f53[%s]\u5171\u6e05\u7406[%s]\u6761\u6570\u636e", configParam.getMainEntityNumber(), cleanCount));
    }

    protected void updateStartingDate(CleanTaskConfigParam configParam) {
    }

    protected int executeEverySegment(CleanTaskConfigParam configParam, int everytimeCount, Date seekDate, Date maxCleanDate) {
        int stepLength = configParam.getStepLength() == 0 ? 3 : configParam.getStepLength();
        Date endingDate = this.getTargetTime(seekDate, stepLength);
        if (endingDate.after(maxCleanDate)) {
            endingDate = maxCleanDate;
        }
        ArrayList<QFilter> filters = new ArrayList<QFilter>(10);
        filters.add(new QFilter(configParam.getSeekFieldName(), "<=", (Object)endingDate));
        filters.add(new QFilter(configParam.getSeekFieldName(), ">=", (Object)seekDate));
        HashSet<Object> messageIds = new HashSet<Object>(16);
        ArrayList<Object> receiverPkIds = new ArrayList<Object>(10);
        int i = 0;
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"ClearHiMessageDataTask.executeEverySegment", (String)configParam.getMainEntityNumber(), (String)"id,messageid", (QFilter[])filters.toArray(new QFilter[0]), null, (int)everytimeCount);){
            if (!dataSet.isEmpty()) {
                Iterator iterator = dataSet.iterator();
                while (iterator.hasNext()) {
                    boolean isEnd;
                    ++i;
                    Row row = dataSet.next();
                    Long messageId = row.getLong(MESSAGEID);
                    receiverPkIds.add(row.get(ID));
                    messageIds.add(messageId);
                    boolean bl = isEnd = !iterator.hasNext();
                    if (i % 2000 != 0 && !isEnd) continue;
                    this.deleteData(messageIds, receiverPkIds);
                    receiverPkIds.clear();
                    messageIds.clear();
                }
            }
        }
        log.debug(String.format("ClearHiMessageDataTask \u6309\u4fdd\u7559\u65f6\u95f4\u6e05\u7406\u4e3b\u5b9e\u4f53[%s]\u5206\u6279\u6b21\u6e05\u7406\uff0c\u672c\u6279\u6b21\u5171\u6e05\u7406[%s]\u6761\u6570\u636e", configParam.getMainEntityNumber(), i));
        return i;
    }

    private void deleteData(Set<Object> messageIds, List<Object> receiverPkIds) {
        String deleteSQL = "Delete from t_wf_himsgreceiver where fid in (?) ;";
        WfDBUtils.executeBatchDeleteByIn((String)deleteSQL, receiverPkIds, (Integer)2000, (boolean)true);
        deleteSQL = "Delete from t_wf_himsgreceiver_l where fid in (?) ;";
        WfDBUtils.executeBatchDeleteByIn((String)deleteSQL, receiverPkIds, (Integer)2000, (boolean)true);
        deleteSQL = "Delete from t_wf_himessage where fid in (?) ;";
        WfDBUtils.executeBatchDeleteByIn((String)deleteSQL, new ArrayList<Object>(messageIds), (Integer)2000, (boolean)true);
        deleteSQL = "Delete from t_wf_himessage_l where fid in (?) ;";
        WfDBUtils.executeBatchDeleteByIn((String)deleteSQL, new ArrayList<Object>(messageIds), (Integer)2000, (boolean)true);
    }
}

