/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.message.service.schedule;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.workflow.engine.WfUtils;

public class ClearMessageDataTask
extends AbstractTask {
    protected Log logger = LogFactory.getLog((String)((Object)((Object)this)).getClass().getName());
    private static final int RETENTIONDAYS = 7;
    private static final int DELETEBATCHSIZE = 10000;
    private static final String PARAM_DAYS = "pdays";
    private static final String PARAM_BATCH = "pbatch";

    public void execute(RequestContext context, Map<String, Object> param) throws KDException {
        Integer day = 7;
        Integer batchSize = 10000;
        if (param != null && !param.isEmpty()) {
            day = StringUtils.isNotBlank((Object)param.get(PARAM_DAYS)) ? Integer.valueOf((String)param.get(PARAM_DAYS)) : day;
            batchSize = StringUtils.isNotBlank((Object)param.get(PARAM_BATCH)) ? Integer.valueOf((String)param.get(PARAM_BATCH)) : batchSize;
        }
        this.removeMessageTableData(day, batchSize);
    }

    private void removeMessageTableData(Integer day, Integer batchSize) {
        Date startDate = new Date(System.currentTimeMillis() - (long)(day * 24 * 3600) * 1000L);
        String querySql = String.format("SELECT TOP %s FID FROM t_wf_message WHERE fcreatedate < ?", batchSize);
        List ids = (List)DB.query((DBRoute)DBRoute.workflow, (String)querySql, (Object[])new Object[]{startDate}, (ResultSetHandler)new ResultSetHandler<List<Object[]>>(){

            public List<Object[]> handle(ResultSet rs) throws SQLException {
                ArrayList<Object[]> ret = new ArrayList<Object[]>(16);
                while (rs.next()) {
                    Object[] t = new Object[]{rs.getLong("FID")};
                    ret.add(t);
                }
                return ret;
            }
        });
        String deleteSQL = "Delete from t_wf_message where FID=? ";
        WfUtils.executeBatch((String)deleteSQL, (List)ids, (Integer)2000);
        deleteSQL = "Delete from t_wf_message_l where FID=? ";
        WfUtils.executeBatch((String)deleteSQL, (List)ids, (Integer)2000);
        deleteSQL = "Delete from t_wf_msgreceiver where FMESSAGEID=? ";
        WfUtils.executeBatch((String)deleteSQL, (List)ids, (Integer)2000);
    }
}

