/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.message.service.schedule;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.message.utils.MessageSystemParamterUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.clean.calculator.CleanDataCalculator;
import kd.bos.workflow.engine.msg.MessageServiceUtil;
import kd.bos.workflow.engine.msg.quantitysum.MessageQuantitySummaryUtils;
import kd.bos.workflow.exception.WFErrorCode;
import kd.bos.workflow.exception.WFMessageServiceException;

public class DeleteMessageTask
extends AbstractTask {
    private static Log log = LogFactory.getLog(DeleteMessageTask.class);
    private static final String WF_MSG_MESSAGE = "wf_msg_message";
    private static final String WF_MSG_RECEIVER = "wf_msg_receiver";
    private static final String WF_MSG_FAILMESSAGE = "wf_msg_failmessage";
    private static final String WF_MSG_HIMESSAGE = "wf_msg_himessage";
    private static final String WF_MSG_HIRECEIVER = "wf_msg_hireceiver";
    private static final String WF_MSG_HIFAILMESSAGE = "wf_msg_hifailmessage";
    private static final String TYPE = "message";
    private static final Integer TIMES = 20;
    private static final Integer CALLSTEP = 30;
    private static final Integer MAXDELNUM = 50000;
    private static final Integer SAVENUM = 100;
    private static final Integer MSGRECEIVERNUM = 2000;
    private static final String ID = "id";
    private static final String MESSAGEID = "messageid";
    private static final String CREATEDATE = "createdate";
    private static final String DELETEDATE = "deletedate";
    private static final String DELETEREASON = "deletereason";

    public void execute(RequestContext context, Map<String, Object> param) throws KDException {
        try {
            Integer msgSaveDate = MessageSystemParamterUtils.getMsgSaveDate();
            if (msgSaveDate == null || msgSaveDate == 0) {
                log.debug("DeleteMessageTask \u8bf7\u5728\u914d\u7f6e\u5de5\u5177\u4e2d\u8bbe\u7f6e\u6d88\u606f\u4fdd\u7559\u65f6\u95f4");
                return;
            }
            Integer callStep = this.getConfigCenterProperty(CALLSTEP, TYPE, "callStep");
            Integer maxDelNum = this.getConfigCenterProperty(MAXDELNUM, TYPE, "maxDelNum");
            log.info(String.format("DeleteMessageTask msgSaveDate =[%s], callStep = [%s], maxDelNum = [%s]", msgSaveDate, callStep, maxDelNum));
            if (callStep == 0 || maxDelNum == 0) {
                log.debug("DeleteMessageTask wf_confcenter \u6700\u5927\u5220\u9664\u6570\u91cf\u6216\u4e00\u6b21\u8c03\u7528\u6b65\u957f\u672a\u8bbe\u7f6e");
                return;
            }
            Integer days = msgSaveDate * 30;
            if (WfUtils.isNotEmptyForMap(param) && WfUtils.isNotEmptyString((Object)param.get("msgSaveDateParam"))) {
                days = Integer.parseInt((String)param.get("msgSaveDateParam"));
            }
            Integer times = this.getConfigCenterProperty(TIMES, TYPE, "msg.deletemessage.times");
            String cleanMode = MessageSystemParamterUtils.getCleanMode();
            log.info(String.format("DeleteMessageTask times = [%s], days = [%s], cleanMode==[%s]", times, days, cleanMode));
            for (int i = 0; i < times && !this.deleteMessage(days, callStep, maxDelNum, cleanMode, null).booleanValue(); ++i) {
            }
        }
        catch (Exception e) {
            log.error("DeleteMessageTask \u6d88\u606f\u81ea\u52a8\u5316\u6e05\u7406\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0=" + WfUtils.getExceptionStacktrace((Throwable)e));
        }
        try (TXHandle tx = TX.requiresNew((String)"DeleteMessageTask_deleteHiMessage");){
            CleanDataCalculator.create().executeTimingCleaners("wf_message");
        }
    }

    protected Boolean deleteMessage(Integer days, Integer callStep, Integer maxDelNum, String cleanMode, List<Long> receiverIds) throws ParseException {
        DynamicObjectCollection cl = null;
        try {
            cl = WfUtils.isNotEmptyForCollection(receiverIds) ? QueryServiceHelper.query((String)WF_MSG_RECEIVER, (String)CREATEDATE, (QFilter[])new QFilter[]{new QFilter("receiverid", "in", receiverIds)}, (String)"createdate asc", (int)1) : QueryServiceHelper.query((String)WF_MSG_RECEIVER, (String)CREATEDATE, null, (String)"createdate asc", (int)1);
        }
        catch (Exception e) {
            log.warn("deleteMessage queryEarliestCreateDate error : " + WfUtils.getExceptionStacktrace((Throwable)e));
            throw new WFMessageServiceException((Throwable)e, WFErrorCode.findBussinessObjectError(), new Object[]{e.getMessage()});
        }
        if (WfUtils.isEmptyForCollection((Collection)cl)) {
            return Boolean.TRUE;
        }
        String earliestCreateDate = ((DynamicObject)cl.get(0)).getString(CREATEDATE);
        log.debug("deleteMessage earliestCreateDate = " + earliestCreateDate);
        Date deadlineDate = this.getDeadlineDate(days, callStep, earliestCreateDate);
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date earlyDate = format.parse(earliestCreateDate);
        if (earlyDate.compareTo(deadlineDate) > 0) {
            return Boolean.TRUE;
        }
        try (TXHandle tx = TX.requiresNew((String)"DeleteMessageTask_deleteMessage");){
            Set<Long> messageIds = this.queryMessageIdsFromMsgReceiver(deadlineDate, maxDelNum, cleanMode, receiverIds);
            if (WfUtils.isEmptyForCollection(messageIds)) {
                Boolean bl = Boolean.FALSE;
                return bl;
            }
            if ("move".equalsIgnoreCase(cleanMode)) {
                QFilter[] q1 = new QFilter[]{new QFilter(MESSAGEID, "in", messageIds)};
                this.moveData(WF_MSG_FAILMESSAGE, WF_MSG_HIFAILMESSAGE, MESSAGEID, q1, messageIds);
                QFilter[] q2 = new QFilter[]{new QFilter(ID, "in", messageIds)};
                this.moveData(WF_MSG_MESSAGE, WF_MSG_HIMESSAGE, ID, q2, messageIds);
            } else {
                this.deleteData(WF_MSG_FAILMESSAGE, messageIds, MESSAGEID);
                this.deleteData(WF_MSG_MESSAGE, messageIds, ID);
            }
        }
        return Boolean.FALSE;
    }

    private Date getDeadlineDate(Integer days, Integer callStep, String earliestCreateDate) throws ParseException {
        Date endDate = DeleteMessageTask.plusDay(callStep, earliestCreateDate);
        Date criticalDate = new Date(System.currentTimeMillis() - (long)(days * 24 * 3600) * 1000L);
        Date startDate = null;
        startDate = endDate.compareTo(criticalDate) >= 0 ? criticalDate : endDate;
        log.info(String.format("deleteMessage endDate=[%s], criticalDate=[%s], startDate=[%s]", endDate, criticalDate, criticalDate));
        return startDate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<Long> queryMessageIdsFromMsgReceiver(Date deadlineDate, Integer maxDelNum, String cleanMode, List<Long> receiverIds) {
        DataSet ds = null;
        Long lastMessageId = 0L;
        HashSet<Long> messageIds = new HashSet<Long>();
        HashSet<Long> receiverPkids = new HashSet<Long>(maxDelNum);
        try {
            QFilter q1 = new QFilter(CREATEDATE, "<", (Object)deadlineDate);
            QFilter[] filters = new QFilter[]{q1};
            if (WfUtils.isNotEmptyForCollection(receiverIds)) {
                QFilter q2 = new QFilter("receiverid", "in", receiverIds);
                filters = new QFilter[]{q1, q2};
            }
            if (!(ds = QueryServiceHelper.queryDataSet((String)this.createAlgoKey(), (String)WF_MSG_RECEIVER, (String)"id,messageid", (QFilter[])filters, (String)MESSAGEID, (int)maxDelNum)).isEmpty()) {
                for (Row row : ds) {
                    receiverPkids.add(row.getLong(ID));
                    Long messageId = row.getLong(MESSAGEID);
                    messageIds.add(messageId);
                    lastMessageId = messageId;
                }
            }
        }
        finally {
            if (ds != null) {
                ds.close();
            }
        }
        if (WfUtils.isEmptyForCollection(receiverPkids) || WfUtils.isEmptyForCollection(messageIds)) {
            return messageIds;
        }
        QFilter[] qFilters = new QFilter[]{new QFilter(ID, "in", receiverPkids)};
        this.updateMessageQuantitySummary(messageIds, qFilters);
        if ("move".equalsIgnoreCase(cleanMode)) {
            this.moveData(WF_MSG_RECEIVER, WF_MSG_HIRECEIVER, MESSAGEID, qFilters, messageIds);
        } else {
            this.deleteData(WF_MSG_RECEIVER, receiverPkids, ID);
        }
        Boolean isRemoveLastMsgId = QueryServiceHelper.exists((String)WF_MSG_RECEIVER, (QFilter[])new QFilter[]{new QFilter(MESSAGEID, "=", (Object)lastMessageId)});
        if (isRemoveLastMsgId.booleanValue()) {
            messageIds.remove(lastMessageId);
        }
        return messageIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateMessageQuantitySummary(Set<Long> messageIds, QFilter[] qFilters) {
        if (WfUtils.isEmptyForCollection(messageIds)) {
            return;
        }
        DataSet receiverDS = null;
        Object msgDS = null;
        try {
            receiverDS = QueryServiceHelper.queryDataSet((String)this.createAlgoKey(), (String)WF_MSG_RECEIVER, (String)"messageId, readstate, receiverid, type", (QFilter[])qFilters, null);
            if (!receiverDS.isEmpty()) {
                int count = 0;
                Iterator iterator = receiverDS.iterator();
                ArrayList<DynamicObject> objList = new ArrayList<DynamicObject>(messageIds.size());
                while (iterator.hasNext()) {
                    Row row = (Row)iterator.next();
                    DynamicObject entityObj = BusinessDataServiceHelper.newDynamicObject((String)WF_MSG_RECEIVER);
                    entityObj.set("messageId", row.get("messageId"));
                    entityObj.set("readstate", row.get("readstate"));
                    entityObj.set("receiverid", row.get("receiverid"));
                    entityObj.set("type", row.get("type"));
                    objList.add(entityObj);
                    if (count == MSGRECEIVERNUM) {
                        if (WfUtils.isNotEmptyForCollection(objList)) {
                            MessageQuantitySummaryUtils.updateMessageQuantitySummary((DynamicObject[])objList.toArray(new DynamicObject[0]), null, (String)"deleteMessge");
                        }
                        objList.clear();
                        count = 0;
                        continue;
                    }
                    ++count;
                }
                if (count > 0 && WfUtils.isNotEmptyForCollection(objList)) {
                    MessageQuantitySummaryUtils.updateMessageQuantitySummary((DynamicObject[])objList.toArray(new DynamicObject[0]), null, (String)"deleteMessge");
                }
            }
        }
        finally {
            if (receiverDS != null) {
                receiverDS.close();
            }
            if (msgDS != null) {
                msgDS.close();
            }
        }
    }

    private void deleteData(String entityName, Set<Long> ids, String selectProperties) {
        int count = 0;
        ArrayList<Long> deleteIds = new ArrayList<Long>(ids.size());
        for (Long id : ids) {
            deleteIds.add(id);
            if (count == 1000) {
                if (WfUtils.isNotEmptyForCollection(deleteIds)) {
                    DeleteServiceHelper.delete((String)entityName, (QFilter[])new QFilter[]{new QFilter(selectProperties, "in", deleteIds)});
                }
                deleteIds.clear();
                count = 0;
                continue;
            }
            ++count;
        }
        if (count > 0 && WfUtils.isNotEmptyForCollection(deleteIds)) {
            DeleteServiceHelper.delete((String)entityName, (QFilter[])new QFilter[]{new QFilter(selectProperties, "in", deleteIds)});
            deleteIds.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void moveData(String entityName, String hiEntityName, String selectProperties, QFilter[] qFilters, Set<Long> messageIds) {
        this.cleanGcData(entityName, hiEntityName, selectProperties, qFilters, messageIds);
        if (WfUtils.isEmptyForCollection(messageIds)) {
            return;
        }
        try (DataSet ds = null;){
            String columns = this.getSelectProperties(entityName);
            ds = QueryServiceHelper.queryDataSet((String)this.createAlgoKey(), (String)entityName, (String)columns, (QFilter[])qFilters, (String)CREATEDATE);
            if (!ds.isEmpty()) {
                int count = 0;
                Iterator iterator = ds.iterator();
                ArrayList<DynamicObject> objList = new ArrayList<DynamicObject>(messageIds.size());
                HashSet<Long> messageIdsForDelete = new HashSet<Long>(messageIds.size());
                while (iterator.hasNext()) {
                    String[] strArray;
                    Row row = (Row)iterator.next();
                    DynamicObject hiEntityObj = BusinessDataServiceHelper.newDynamicObject((String)hiEntityName);
                    for (String str : strArray = columns.split(",")) {
                        Object val = row.get(str);
                        if (val != null) {
                            if ("channelcontent".equals(str) || "content".equals(str) || "content_summary".equals(str) || "contenttag".equals(str)) {
                                if (val instanceof OrmLocaleValue) {
                                    val = WfUtils.subILocaleString((ILocaleString)((OrmLocaleValue)val), (int)1900);
                                } else if (val instanceof String) {
                                    val = WfUtils.subStringForMax((String)((String)val), (int)1900);
                                }
                            }
                            if (!WF_MSG_RECEIVER.equalsIgnoreCase(entityName) && selectProperties.equals(str)) {
                                messageIdsForDelete.add((Long)val);
                            }
                        }
                        hiEntityObj.set(str, val);
                    }
                    hiEntityObj.set(DELETEDATE, (Object)WfUtils.now());
                    hiEntityObj.set(DELETEREASON, (Object)"1");
                    objList.add(hiEntityObj);
                    if (count == SAVENUM) {
                        if (WfUtils.isNotEmptyForCollection(objList)) {
                            SaveServiceHelper.save((DynamicObject[])objList.toArray(new DynamicObject[0]));
                            if (WF_MSG_RECEIVER.equalsIgnoreCase(entityName)) {
                                DeleteServiceHelper.delete((String)entityName, (QFilter[])qFilters);
                            } else {
                                DeleteServiceHelper.delete((String)entityName, (QFilter[])new QFilter[]{new QFilter(selectProperties, "in", messageIdsForDelete)});
                            }
                        }
                        objList.clear();
                        messageIdsForDelete.clear();
                        count = 0;
                        continue;
                    }
                    ++count;
                }
                if (count > 0 && WfUtils.isNotEmptyForCollection(objList)) {
                    SaveServiceHelper.save((DynamicObject[])objList.toArray(new DynamicObject[0]));
                    if (WF_MSG_RECEIVER.equalsIgnoreCase(entityName)) {
                        DeleteServiceHelper.delete((String)entityName, (QFilter[])qFilters);
                    } else {
                        DeleteServiceHelper.delete((String)entityName, (QFilter[])new QFilter[]{new QFilter(selectProperties, "in", messageIdsForDelete)});
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanGcData(String entityName, String hiEntityName, String selectProperties, QFilter[] qFilters, Set<Long> messageIds) {
        try (DataSet ds = null;){
            HashSet<Long> deleteMsgIds = new HashSet<Long>(messageIds.size());
            ds = QueryServiceHelper.queryDataSet((String)this.createAlgoKey(), (String)hiEntityName, (String)selectProperties, (QFilter[])qFilters, null);
            if (!ds.isEmpty()) {
                for (Row row : ds) {
                    if (!WfUtils.isNotEmptyForCollection(messageIds)) continue;
                    messageIds.remove(row.get(selectProperties));
                    deleteMsgIds.add((Long)row.get(selectProperties));
                }
            }
            if (WfUtils.isNotEmptyForCollection(deleteMsgIds)) {
                DeleteServiceHelper.delete((String)entityName, (QFilter[])new QFilter[]{new QFilter(selectProperties, "in", deleteMsgIds)});
            }
        }
    }

    private String getSelectProperties(String entityName) {
        DynamicObject obj = BusinessDataServiceHelper.newDynamicObject((String)entityName);
        DataEntityPropertyCollection propertyCollection = obj.getDataEntityType().getProperties();
        StringBuilder columns = new StringBuilder();
        for (IDataEntityProperty iDataEntityProperty : propertyCollection) {
            if (!WfUtils.isNotEmpty((String)iDataEntityProperty.getName()) || !WfUtils.isNotEmpty((String)iDataEntityProperty.getAlias()) || "contenttag".equalsIgnoreCase(iDataEntityProperty.getName())) continue;
            columns.append(iDataEntityProperty.getName()).append(",");
        }
        return this.removeCommas(columns);
    }

    private Integer getConfigCenterProperty(Integer defaultValue, String type, String key) {
        Integer confVal = 0;
        Object obj = MessageServiceUtil.getConfigCenterProperty((String)type, (String)key);
        if (obj != null) {
            confVal = Integer.parseInt((String)obj);
        }
        Integer resultVal = defaultValue;
        if (confVal > 0 && confVal < resultVal) {
            resultVal = confVal;
        }
        return resultVal;
    }

    public static Date plusDay(int num, String newDate) throws ParseException {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date currdate = format.parse(newDate);
        Calendar ca = Calendar.getInstance();
        ca.setTime(currdate);
        ca.add(5, num);
        currdate = ca.getTime();
        return currdate;
    }

    private String removeCommas(StringBuilder sb) {
        String str = "";
        if (WfUtils.isNotEmptyString((Object)sb)) {
            str = sb.toString();
            str = str.length() != 0 ? str.substring(0, str.length() - 1) : "";
        }
        return str;
    }

    protected String createAlgoKey() {
        String methodName = Thread.currentThread().getStackTrace()[2].getMethodName();
        return new StringBuffer().append("bos.wf.").append(((Object)((Object)this)).getClass().getName()).append(".").append(methodName).toString();
    }
}

