/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.message.service.schedule;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.message.service.schedule.DeleteMessageTask;
import org.apache.commons.beanutils.ConvertUtils;

public class DeleteSomeoneMessageTask
extends DeleteMessageTask {
    private static Log log = LogFactory.getLog(DeleteSomeoneMessageTask.class);

    @Override
    public void execute(RequestContext context, Map<String, Object> param) throws KDException {
        try {
            if (WfUtils.isEmptyForMap(param) || WfUtils.isEmptyString((Object)param.get("receiverIds"))) {
                log.debug("DeleteSomeoneMessageTask param or receiverIds is null");
                return;
            }
            Object receiverIdsObj = param.get("receiverIds");
            log.debug("DeleteSomeoneMessageTask receiverIds is :" + receiverIdsObj);
            Long[] convert = (Long[])ConvertUtils.convert((String[])receiverIdsObj.toString().split(","), Long.class);
            List<Long> receiverIds = Arrays.asList(convert);
            Integer msgSaveDate = 30;
            if (WfUtils.isNotEmptyString((Object)param.get("msgSaveDate"))) {
                msgSaveDate = Integer.parseInt((String)param.get("msgSaveDate"));
            }
            log.debug("DeleteSomeoneMessageTask msgSaveDate is :" + msgSaveDate);
            Integer callStep = 30;
            if (WfUtils.isNotEmptyString((Object)param.get("callStep"))) {
                callStep = Integer.parseInt((String)param.get("callStep"));
            }
            log.debug("DeleteSomeoneMessageTask callStep is :" + callStep);
            Integer maxDelNum = 4000;
            if (WfUtils.isNotEmptyString((Object)param.get("maxDelNum"))) {
                maxDelNum = this.getVal(50000, Integer.parseInt((String)param.get("maxDelNum")));
            }
            log.debug("DeleteSomeoneMessageTask maxDelNum is :" + maxDelNum);
            Integer times = 20;
            if (WfUtils.isNotEmptyString((Object)param.get("times"))) {
                times = this.getVal(20, Integer.parseInt((String)param.get("times")));
            }
            log.debug("DeleteSomeoneMessageTask times is :" + times);
            String cleanMode = "delete";
            if (WfUtils.isNotEmptyString((Object)param.get("cleanMode"))) {
                cleanMode = (String)param.get("cleanMode");
            }
            log.debug("DeleteSomeoneMessageTask cleanMode is :" + cleanMode);
            for (int i = 0; i < times && !this.deleteMessage(msgSaveDate, callStep, maxDelNum, cleanMode, receiverIds).booleanValue(); ++i) {
            }
        }
        catch (Exception e) {
            log.warn("DeleteSomeoneMessageTask is error,errorInfo=" + WfUtils.getExceptionStacktrace((Throwable)e));
        }
    }

    private Integer getVal(Integer maxVal, Integer confVal) {
        Integer resultVal = maxVal;
        if (confVal > 0 && confVal < resultVal) {
            resultVal = confVal;
        }
        return resultVal;
    }
}

