/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.message.service.util;

import com.alibaba.fastjson.JSONArray;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.form.FormMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.message.channel.MessageChannelUtils;
import kd.bos.message.channel.cache.MsgServiceCache;
import kd.bos.message.channel.cache.MsgServiceCacheHelper;
import kd.bos.message.channel.cache.MsgServiceCacheMrg;
import kd.bos.message.channel.model.MsgChannelInfo;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.workflow.engine.WfUtils;

public class MessageCacheUtils {
    private static final String VALUE = "value";
    private static Log logger = LogFactory.getLog(MessageCacheUtils.class);

    public static void clearMessageChannelCache(String number) {
        MessageChannelUtils.clearMsgChannelTagKeyInCache();
        String type = MsgServiceCacheMrg.getType4ServiceCfg();
        if (StringUtils.isNotBlank((CharSequence)number)) {
            MsgServiceCacheMrg.clearCache((String)type, (String)number);
        } else {
            MsgServiceCacheMrg.clearCache((String)type);
            logger.info("MessageCacheUtils--update channel cache success");
        }
    }

    public static void clearMessageTypeCache(String number) {
        if (StringUtils.isNotBlank((CharSequence)number)) {
            MsgServiceCacheHelper.removeMessageTypeCache((String)number);
        } else {
            String sql2 = "select fnumber from t_msg_type;";
            DynamicObjectCollection typeCollection = MessageCacheUtils.QueryData(sql2);
            if (typeCollection != null && typeCollection.size() > 0) {
                for (DynamicObject typeObj : typeCollection) {
                    MsgServiceCacheHelper.removeMessageTypeCache((String)typeObj.getString("fnumber"));
                }
                logger.info("MessageCacheUtils--update type cache success");
            }
        }
    }

    public static void clearMessageTemplateCache(String filters) {
        if (StringUtils.isNotBlank((CharSequence)filters)) {
            String deleteCacheKeys = null;
            if (filters.split(",").length == 1) {
                deleteCacheKeys = MsgServiceCacheHelper.getTemplateCacheKey((String)filters);
            } else {
                String[] filterList = filters.split(",");
                deleteCacheKeys = MsgServiceCacheHelper.getTemplateCacheKey((String)filterList[0], (String)filterList[1], (String)filterList[2], (String)filterList[3]);
            }
            MsgServiceCacheHelper.deleteCache((String)deleteCacheKeys);
            StringBuilder sql = new StringBuilder("select fnumber, fmsgtype, fmsgchannel, fmsgscene, fmsgentity from t_msg_template ");
            if (filters.split(",").length == 1) {
                sql.append("where fnumber = '");
                sql.append(filters);
                sql.append("';");
            } else {
                String[] filterList = filters.split(",");
                sql.append("where fmsgtype = '");
                sql.append(filterList[0]);
                sql.append("' and fmsgchannel = '");
                sql.append(filterList[1]);
                sql.append("' and fmsgentity = '");
                sql.append(filterList[3]);
                sql.append("' and fmsgscene like ");
                sql.append("'%").append(filterList[2]).append("%';");
            }
            DynamicObjectCollection typeCollection = MessageCacheUtils.QueryData(sql.toString());
            if (typeCollection != null && typeCollection.size() != 0) {
                DynamicObject tplObj = (DynamicObject)typeCollection.get(0);
                if (filters.split(",").length == 1) {
                    String scenes = tplObj.getString("fmsgscene");
                    String type = tplObj.getString("fmsgtype");
                    String channel = tplObj.getString("fmsgchannel");
                    String entityNumber = tplObj.getString("fmsgentity");
                    JSONArray cacheKeys = new JSONArray();
                    if (StringUtils.isNotBlank((CharSequence)scenes)) {
                        String[] sceneArray = scenes.split(",");
                        for (int i = 0; i < sceneArray.length; ++i) {
                            cacheKeys.add((Object)MsgServiceCacheHelper.getTemplateCacheKey((String)type, (String)channel, (String)sceneArray[i], (String)entityNumber));
                        }
                    }
                    if (cacheKeys.size() != 0) {
                        String[] ks = (String[])cacheKeys.toArray((Object[])new String[0]);
                        MsgServiceCacheHelper.deleteCache((String[])ks);
                    }
                } else {
                    String k = MsgServiceCacheHelper.getTemplateCacheKey((String)tplObj.getString("fnumber"));
                    MsgServiceCacheHelper.deleteCache((String)k);
                }
            }
        }
    }

    public static Map<String, Object> queryChannelCacheData(String number) {
        HashMap<String, Object> res = new HashMap<String, Object>();
        String key = MsgServiceCacheMrg.getType4ServiceCfg() + " " + number;
        MsgChannelInfo msgChannelInfo = MsgServiceCache.getMsgChannel((String)number);
        res.put("key", key);
        res.put(VALUE, SerializationUtils.toJsonString((Object)msgChannelInfo));
        return res;
    }

    public static Map<String, Object> queryTypeCacheData(String number) {
        HashMap<String, Object> res = new HashMap<String, Object>();
        String key = MsgServiceCacheHelper.getTypeCahceKey((String)number);
        String typeCacheData = MsgServiceCacheHelper.getMessageTypeCache((String)number);
        res.put("key", key);
        res.put(VALUE, typeCacheData);
        return res;
    }

    public static Map<String, Object> queryTemplateCacheData(String number) {
        String sql;
        DynamicObjectCollection tplCollection;
        HashMap<String, Object> res = new HashMap<String, Object>();
        String k1 = MsgServiceCacheHelper.getTemplateCacheKey((String)number);
        String v1 = MsgServiceCacheHelper.getTemplateCache((String)number);
        StringBuilder key = new StringBuilder();
        StringBuilder value = new StringBuilder();
        if (StringUtils.isNotBlank((CharSequence)v1)) {
            key.append("k1=");
            key.append(k1);
            key.append("  ");
            value.append("v1=");
            value.append(v1);
            value.append("  ");
        }
        if ((tplCollection = MessageCacheUtils.QueryData(sql = "select fnumber, fmsgtype, fmsgchannel, fmsgscene, fmsgentity from t_msg_template where fnumber = '" + number + "';")) != null && tplCollection.size() != 0) {
            DynamicObject tplObj = (DynamicObject)tplCollection.get(0);
            String scenes = tplObj.getString("fmsgscene");
            String type = tplObj.getString("fmsgtype");
            String channel = tplObj.getString("fmsgchannel");
            String entityNumber = tplObj.getString("fmsgentity");
            JSONArray cacheKeys = new JSONArray();
            if (StringUtils.isNotBlank((CharSequence)scenes)) {
                int i;
                String[] sceneArray = scenes.split(",");
                for (i = 0; i < sceneArray.length; ++i) {
                    cacheKeys.add((Object)MsgServiceCacheHelper.getTemplateCacheKey((String)type, (String)channel, (String)sceneArray[i], (String)entityNumber));
                }
                for (i = 0; i < cacheKeys.size(); ++i) {
                    String k = cacheKeys.getString(i);
                    String v = MsgServiceCacheHelper.getCache((String)k);
                    if (!StringUtils.isNotBlank((CharSequence)v)) continue;
                    key.append("k");
                    key.append(i + 2);
                    key.append("=");
                    key.append(k);
                    key.append("  ");
                    value.append("v");
                    value.append(i + 2);
                    value.append("=");
                    value.append(v);
                    value.append("  ");
                }
            }
        }
        res.put("key", key.toString());
        res.put(VALUE, value.toString());
        return res;
    }

    private static DynamicObjectCollection QueryData(String sql) {
        DynamicObjectCollection col = null;
        try (DataSet ds = DB.queryDataSet((String)"MessageCenter.ClearMsgCacheImpl.queryData", (DBRoute)DBRoute.workflow, (String)sql, null);){
            col = ORM.create().toPlainDynamicObjectCollection(ds);
        }
        catch (Exception e) {
            logger.info(String.format("sql: %s query data from wfs is error and the description is %s", sql, e.getMessage()));
        }
        logger.info(String.format("sql: %s query data from wfs over", sql));
        return col;
    }

    public static String getCheckRightAppId(String formNumber) {
        String ret = "";
        if (WfUtils.isEmpty((String)formNumber)) {
            return ret;
        }
        String key = MsgServiceCacheHelper.getCheckRightAppIdCache((String)formNumber);
        if (WfUtils.isEmpty((String)key)) {
            QFilter qFilter = new QFilter("formnumber", "=", (Object)formNumber);
            DynamicObjectCollection configs = QueryServiceHelper.query((String)"wf_verification", (String)"appnumber", (QFilter[])new QFilter[]{qFilter});
            if (WfUtils.isNotEmptyForCollection((Collection)configs)) {
                DynamicObject config = (DynamicObject)configs.get(0);
                if (config != null) {
                    ret = config.getString("appnumber");
                }
            } else {
                String entityNum = FormMetadataCache.getFormConfig((String)formNumber).getEntityTypeId();
                ret = EntityMetadataCache.getDataEntityType((String)entityNum).getBizAppNumber();
            }
            MsgServiceCacheHelper.putCheckRightAppIdCache((String)formNumber, (String)ret);
        } else {
            ret = key;
        }
        return ret;
    }

    public static void cleanCheckRightAppIdCache(String formNumber) {
        MsgServiceCacheHelper.removeCheckRightAppIdCache((String)formNumber);
    }
}

