/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.message.service.util;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dc.api.model.Account;
import kd.bos.dc.utils.AccountUtils;
import kd.bos.encrypt.Encrypters;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.message.service.utils.FailMessageUtil;
import kd.bos.message.utils.MessageAttachmentUtils;
import kd.bos.message.utils.MessageUtils;
import kd.bos.message.utils.personalSetting.MessageBussinessInfo;
import kd.bos.message.utils.personalSetting.MessageBussinessPublishUtil;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfMultiLangUtils;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.cmd.task.dataquery.params.EntityQueryParams;
import kd.bos.workflow.engine.msg.MessageServiceUtil;
import kd.bos.workflow.engine.msg.info.MessageInfo;
import kd.bos.workflow.engine.msg.quantitysum.MessageQuantitySummaryServcie;
import kd.bos.workflow.engine.msg.quantitysum.MessageQuantitySummaryUtils;
import kd.bos.workflow.message.api.SmsUsingQuantities;
import kd.bos.workflow.service.impl.ServiceFactory;
import kd.bos.workflow.service.impl.WorkflowServiceImpl;
import org.jsoup.Jsoup;

public class MessageOperateUtils {
    private static Log logger = LogFactory.getLog(MessageOperateUtils.class);
    private static final String MSGMESSAGEENTITY = "wf_msg_message";
    private static final String MSGRECEIVERENITTY = "wf_msg_receiver";
    private static final String MSGFAILMESSAGE = "wf_msg_failmessage";
    private static final String TITLE = "title";
    private static final String CONTENT = "content";
    private static final String CONTENTSUMMARY = "content_summary";
    private static final String CREATEDATE = "createdate";
    private static final String MODIFYDATE = "modifydate";
    private static final String READTIME = "readtime";
    private static final String READSTATE = "readstate";
    private static final String TERMINALWAY = "terminalway";
    private static final String MESSAGEID = "messageid";
    private static final String RECEIVERID = "receiverid";
    private static final String DELETE = "delete";
    private static final String TOALL = "toall";
    private static final String BIZDATAID = "bizdataid";
    private static final String SENDTIME = "sendtime";
    private static final String ENTITYNUMBER = "entitynumber";
    private static final String OPENATION = "operation";
    private static final String CHANNELS = "channels";
    private static final String SENDERNAME = "sendername";
    private static final String SENDER = "sender";
    private static final String MOBCONTENTURL = "mobcontenturl";
    private static final String CONTENTURL = "contenturl";
    private static final String SUCCESS = "success";
    private static final String MESSAGECENTERCOUNT = "MessageCenter.wf_message.count";
    private static final String MSGRECEIVER = "msgreceiver";
    private static final String COUNT = "count";
    private static final String UNREAD = "unread";
    private static final String MESSAGEMUTIL = "message_l";
    private static final String MESSAGE = "message";
    private static final String FTITLE = "ftitle";
    private static final String NOTICE = "notice";
    private static final String SYSNOTICE = "sysnotice";
    private static final String ACTIVITY = "activity";
    private static final String POPUP = "popup";

    public static void saveMessage(MessageInfo message) {
        List<Long> needRefreshCacheUserIds = MessageOperateUtils.getNeedRefreshCacheUserIds(message);
        MessageOperateUtils.saveMessageInfo(message, needRefreshCacheUserIds);
    }

    private static List<Long> getNeedRefreshCacheUserIds(MessageInfo message) {
        if (!message.isToAll()) {
            return message.getUserIds();
        }
        return null;
    }

    private static void saveMessageInfo(MessageInfo message, List<Long> needRefreshCacheUserIds) {
        try (TXHandle tx = TX.requiresNew((String)"MessageCenterServiceImpl_savemessage");){
            Object tempContent = message.getParams().remove("tempContent");
            try {
                DynamicObject msgObj = BusinessDataServiceHelper.newDynamicObject((String)MSGMESSAGEENTITY);
                ILocaleString messageTitle = message.getMessageTitle();
                if (WfUtils.isEmpty((ILocaleString)messageTitle)) {
                    messageTitle = new LocaleString(message.getTitle());
                }
                ILocaleString messageTitleRepair = WfUtils.subILocaleString((ILocaleString)messageTitle, (int)500);
                msgObj.set(TITLE, (Object)messageTitleRepair);
                ILocaleString messageContent = message.getMessageContent();
                if (WfUtils.isNotEmpty((ILocaleString)messageContent)) {
                    LocaleString ret = new LocaleString();
                    for (Object key : messageContent.keySet()) {
                        ret.put(key, messageContent.get(key));
                    }
                    msgObj.set(CONTENT, (Object)ret);
                    if (WfUtils.isNotEmpty((ILocaleString)ret)) {
                        LocaleString contentTag = new LocaleString();
                        for (String key : ret.keySet()) {
                            String value = (String)ret.get((Object)key);
                            if (value.length() > 255) {
                                value = value.substring(0, 254);
                            }
                            contentTag.put((Object)key, (Object)value);
                        }
                        msgObj.set(CONTENTSUMMARY, (Object)contentTag);
                    }
                } else {
                    msgObj.set(CONTENT, (Object)message.getContent());
                    if (WfUtils.isNotEmpty((String)message.getContent())) {
                        String contentTag = message.getContent();
                        if (contentTag.length() > 255) {
                            contentTag = contentTag.substring(0, 254);
                        }
                        msgObj.set(CONTENTSUMMARY, (Object)contentTag);
                    }
                }
                ILocaleString messageTag = message.getMessageTag();
                if (WfUtils.isNotEmpty((ILocaleString)messageTag)) {
                    msgObj.set("tag", (Object)messageTag);
                } else {
                    msgObj.set("tag", (Object)message.getTag());
                }
                msgObj.set("id", (Object)message.getId());
                msgObj.set(CONTENTURL, (Object)message.getContentUrl());
                msgObj.set(MOBCONTENTURL, (Object)message.getMobContentUrl());
                msgObj.set(SENDER, (Object)(message.getSenderId() == null ? "0" : String.valueOf(message.getSenderId())));
                msgObj.set(SENDERNAME, (Object)FailMessageUtil.getSenderName((MessageInfo)message));
                msgObj.set(SENDTIME, (Object)message.getSendTime());
                msgObj.set(OPENATION, (Object)message.getOperation());
                msgObj.set(CREATEDATE, (Object)WfUtils.now());
                msgObj.set(MODIFYDATE, (Object)WfUtils.now());
                msgObj.set(TOALL, (Object)message.isToAll());
                Map params = message.getParams();
                String config = SerializationUtils.toJsonString((Object)params);
                msgObj.set("config", (Object)(config.length() > 2000 ? config.substring(0, 1950) : config));
                Map typeCacheData = MessageUtils.getMessageTypeInfo((String)message.getType());
                msgObj.set("type", (Object)((Long)typeCacheData.get("id")));
                String notifyType = message.getNotifyType();
                if (params.get("originalNotifyType") != null) {
                    notifyType = (String)params.get("originalNotifyType");
                }
                msgObj.set(CHANNELS, (Object)notifyType);
                msgObj.set("tplscene", (Object)message.getTplScene());
                msgObj.set(ENTITYNUMBER, (Object)message.getEntityNumber());
                msgObj.set(BIZDATAID, (Object)message.getBizDataId());
                msgObj.set("source", (Object)message.getSource());
                msgObj.set("nestentitynumber", (Object)message.getNestEntityNumber());
                msgObj.set("nestbillid", (Object)message.getNestBillId());
                msgObj.set("nestbillno", (Object)message.getNestBillno());
                msgObj.set("nestappid", (Object)message.getNestAppid());
                logger.debug("MessageCenterServiceImpl--save message");
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{msgObj});
                List receiverIds = message.isToAll() ? MessageOperateUtils.getAllEnableUsers() : message.getUserIds();
                long ct1 = System.currentTimeMillis();
                int userSize = 0;
                if (receiverIds != null && receiverIds.size() > 0) {
                    logger.debug("MessageOperateUtils_saveMessageInfo start update receiver table");
                    HashSet receiverSetIds = new HashSet(receiverIds.size());
                    receiverSetIds.addAll(receiverIds);
                    ArrayList receiverIdsAfterFilters = new ArrayList(receiverSetIds.size());
                    receiverIdsAfterFilters.addAll(receiverSetIds);
                    if (!receiverIdsAfterFilters.isEmpty()) {
                        boolean popup = false;
                        if ((NOTICE.equalsIgnoreCase(message.getType()) || ACTIVITY.equalsIgnoreCase(message.getType())) && SYSNOTICE.equalsIgnoreCase(notifyType)) {
                            popup = true;
                        }
                        int batchCount = 500;
                        int totalCount = receiverIdsAfterFilters.size();
                        int pageCount = totalCount % batchCount != 0 ? totalCount / batchCount + 1 : totalCount / batchCount;
                        for (int i = 0; i < pageCount; ++i) {
                            int startIndex = i * batchCount;
                            int endIndex = (i + 1) * batchCount > totalCount ? totalCount : (i + 1) * batchCount;
                            List<Long> pageUserIds = receiverIdsAfterFilters.subList(startIndex, endIndex);
                            MessageOperateUtils.saveMsgReceiversData(msgObj, pageUserIds, popup);
                            MessageQuantitySummaryUtils.updateMessageQuantitySummary((MessageInfo)message, pageUserIds);
                            userSize += pageUserIds.size();
                        }
                    }
                }
                long ct2 = System.currentTimeMillis();
                logger.debug(String.format("MessageOperateUtils_saveMessageInfo complete update receiver table, costTime[%s] and userSize[%s]", ct2 - ct1, userSize));
            }
            catch (Exception e) {
                logger.warn("MessageCenterServiceImpl--message data save db error" + WfUtils.getExceptionStacktrace((Throwable)e));
                tx.markRollback();
            }
            if (tempContent != null) {
                Map temp = (Map)tempContent;
                message.setContent(WfUtils.isNotEmptyString(temp.get(CONTENT)) ? (String)temp.get(CONTENT) : "");
                message.setTitle(WfUtils.isNotEmptyString(temp.get(TITLE)) ? (String)temp.get(TITLE) : "");
                message.setMessageContent(temp.get("messageContent") != null ? (ILocaleString)temp.get("messageContent") : null);
                message.setMessageTitle(temp.get("messageTitle") != null ? (ILocaleString)temp.get("messageTitle") : null);
            }
        }
    }

    private static List<Long> getAllEnableUsers() {
        QFilter filter = new QFilter("enable", "=", (Object)Character.valueOf('1'));
        DynamicObjectCollection collection = QueryServiceHelper.query((String)"bos.wf.MessageOperateUtils.getAllEnableUsers", (String)"bos_user", (String)"id", (QFilter[])new QFilter[]{filter}, null);
        ArrayList<Long> userIds = new ArrayList<Long>(collection.size());
        for (int i = 0; i < collection.size(); ++i) {
            userIds.add(((DynamicObject)collection.get(i)).getLong("id"));
        }
        return userIds;
    }

    private static void saveMsgReceiversData(DynamicObject msgObj, List<Long> pageUserIds, boolean popup) throws Exception {
        ArrayList<DynamicObject> receiverList = new ArrayList<DynamicObject>(pageUserIds.size());
        for (Long userId : pageUserIds) {
            DynamicObject receiverObj = BusinessDataServiceHelper.newDynamicObject((String)MSGRECEIVERENITTY);
            receiverObj.set(MESSAGEID, msgObj.get("id"));
            receiverObj.set(RECEIVERID, (Object)userId);
            receiverObj.set(READSTATE, (Object)UNREAD);
            receiverObj.set(CREATEDATE, (Object)WfUtils.now());
            receiverObj.set(MODIFYDATE, (Object)WfUtils.now());
            receiverObj.set(POPUP, (Object)popup);
            receiverObj.set("type", msgObj.get("type"));
            receiverObj.set(SENDER, msgObj.get(SENDER));
            receiverObj.set(SENDERNAME, msgObj.get(SENDERNAME));
            receiverObj.set(OPENATION, msgObj.get(OPENATION));
            receiverObj.set(TOALL, msgObj.get(TOALL));
            receiverObj.set(TITLE, msgObj.get(TITLE));
            receiverObj.set("tag", msgObj.get("tag"));
            receiverObj.set("tplscene", msgObj.get("tplscene"));
            receiverObj.set(ENTITYNUMBER, msgObj.get(ENTITYNUMBER));
            receiverObj.set("source", msgObj.get("source"));
            receiverObj.set(BIZDATAID, msgObj.get(BIZDATAID));
            receiverObj.set("nestentitynumber", msgObj.get("nestentitynumber"));
            receiverObj.set("nestbillid", msgObj.get("nestbillid"));
            receiverObj.set("nestbillno", msgObj.get("nestbillno"));
            receiverObj.set("nestappid", msgObj.get("nestappid"));
            receiverObj.set("config", msgObj.get("config"));
            ILocaleString content = msgObj.getLocaleString(CONTENT);
            if (WfUtils.isNotEmpty((ILocaleString)content)) {
                for (Map.Entry entry : content.entrySet()) {
                    String val = Jsoup.parse((String)((String)entry.getValue())).text();
                    if (val != null && val.length() >= 255) {
                        val = val.substring(0, 251) + "...";
                    }
                    content.put(entry.getKey(), (Object)val);
                }
                receiverObj.set(CONTENTSUMMARY, (Object)content);
            }
            receiverObj.set(CONTENTURL, msgObj.get(CONTENTURL));
            receiverList.add(receiverObj);
        }
        DynamicObject[] receiver = new DynamicObject[pageUserIds.size()];
        SaveServiceHelper.save((DynamicObject[])receiverList.toArray(receiver));
    }

    private static void saveMsgReceivers(Long messageId, List<Long> pageUserIds, List<Long> userIds, boolean popup) throws Exception {
        ArrayList<DynamicObject> receiverList = new ArrayList<DynamicObject>(pageUserIds.size());
        for (Long userId : pageUserIds) {
            DynamicObject receiverObj = BusinessDataServiceHelper.newDynamicObject((String)MSGRECEIVERENITTY);
            receiverObj.set(MESSAGEID, (Object)messageId);
            receiverObj.set(RECEIVERID, (Object)userId);
            receiverObj.set(READSTATE, (Object)UNREAD);
            receiverObj.set(CREATEDATE, (Object)WfUtils.now());
            receiverObj.set(MODIFYDATE, (Object)WfUtils.now());
            receiverObj.set(POPUP, (Object)popup);
            receiverList.add(receiverObj);
            userIds.add(userId);
        }
        DynamicObject[] receiver = new DynamicObject[pageUserIds.size()];
        SaveServiceHelper.save((DynamicObject[])receiverList.toArray(receiver));
    }

    public static void setMessageReadState(List<Object> msgIds, String state, Object userId, String terminalWay) {
        if (msgIds == null || msgIds.isEmpty()) {
            return;
        }
        ArrayList<Long> messageIds = new ArrayList<Long>(msgIds.size());
        for (Object id : msgIds) {
            if (id instanceof String) {
                messageIds.add(Long.valueOf((String)id));
                continue;
            }
            messageIds.add((Long)id);
        }
        Long uuserId = null;
        if (userId != null && StringUtils.isNotBlank((Object)userId)) {
            uuserId = userId instanceof String ? Long.valueOf((String)userId) : (Long)userId;
        }
        if (messageIds.size() < 100 && !QueryServiceHelper.exists((String)MSGRECEIVERENITTY, (QFilter[])new QFilter[]{new QFilter(MESSAGEID, "in", messageIds)})) {
            return;
        }
        int batchCount = 10000;
        int totalCount = messageIds.size();
        int pageCount = totalCount % batchCount != 0 ? totalCount / batchCount + 1 : totalCount / batchCount;
        for (int i = 0; i < pageCount; ++i) {
            int startIndex = i * batchCount;
            int endIndex = (i + 1) * batchCount > totalCount ? totalCount : (i + 1) * batchCount;
            List<Long> pageMessageIds = messageIds.subList(startIndex, endIndex);
            MessageOperateUtils.setMessageReadState(pageMessageIds, uuserId, state, terminalWay);
        }
    }

    private static void setMessageReadState(List<Long> messageIds, Long userId, String state, String terminalWay) {
        QFilter f2;
        QFilter f1 = null;
        String selectFields = "messageid, receiverid, readstate, readtime, modifydate, popup, terminalway, type";
        f1 = userId != null && StringUtils.isNotBlank((Object)userId) ? new QFilter(MESSAGEID, "in", messageIds).and(RECEIVERID, "=", (Object)userId) : new QFilter(MESSAGEID, "in", messageIds);
        DynamicObject[] msgReceivers = BusinessDataServiceHelper.load((String)MSGRECEIVERENITTY, (String)selectFields, (QFilter[])new QFilter[]{f1, f2 = new QFilter(READSTATE, "!=", (Object)DELETE).and(READSTATE, "is not null", null)});
        if (msgReceivers == null || msgReceivers.length == 0) {
            return;
        }
        List quantitySummaryInfos = MessageQuantitySummaryUtils.updateMessageQuantitySummary((DynamicObject[])msgReceivers, (String)state, (String)"setReadState");
        ArrayList<DynamicObject> msgUpdateReceivers = new ArrayList<DynamicObject>(msgReceivers.length);
        for (DynamicObject msgReceiver : msgReceivers) {
            if (msgReceiver.getString(READSTATE).equalsIgnoreCase(state)) continue;
            if (state.equals("read")) {
                msgReceiver.set(READTIME, (Object)WfUtils.now());
            } else {
                msgReceiver.set(READTIME, null);
            }
            terminalWay = WfUtils.isNotEmpty((String)terminalWay) ? terminalWay : "mcenter";
            msgReceiver.set(TERMINALWAY, (Object)terminalWay);
            if (state.equals("read") && msgReceiver.getBoolean(POPUP)) {
                msgReceiver.set(POPUP, (Object)false);
            }
            msgReceiver.set(READSTATE, (Object)state);
            msgReceiver.set(MODIFYDATE, (Object)WfUtils.now());
            msgUpdateReceivers.add(msgReceiver);
        }
        try {
            if (!msgUpdateReceivers.isEmpty()) {
                int batchCount = 1000;
                int totalCount = msgUpdateReceivers.size();
                int pageCount = totalCount % batchCount != 0 ? totalCount / batchCount + 1 : totalCount / batchCount;
                for (int i = 0; i < pageCount; ++i) {
                    int startIndex = i * batchCount;
                    int endIndex = (i + 1) * batchCount > totalCount ? totalCount : (i + 1) * batchCount;
                    List pageReceivers = msgUpdateReceivers.subList(startIndex, endIndex);
                    SaveServiceHelper.save((DynamicObject[])pageReceivers.toArray(new DynamicObject[0]));
                }
            }
            if (quantitySummaryInfos != null && !quantitySummaryInfos.isEmpty()) {
                MessageQuantitySummaryServcie servcie = MessageServiceUtil.getMessageQuantitySummaryService();
                servcie.updateQuantitySummary(quantitySummaryInfos);
                servcie.gatherDiffData(quantitySummaryInfos);
            }
            if (WfConfigurationUtil.isEnabled((String)"yunzhijiaup") && state.equals("read") && !messageIds.isEmpty()) {
                WorkflowServiceImpl wfService = (WorkflowServiceImpl)ServiceFactory.getService((String)"WorkflowService");
                JSONObject json = new JSONObject();
                json.put("msgIds", (Object)messageIds.toString());
                wfService.triggerEventSubscribe("channelmsgreadevent", json.toString());
            }
        }
        catch (Exception e) {
            logger.info(WfUtils.getExceptionStacktrace((Throwable)e));
        }
    }

    private static void deleteNoMessageData(List<Long> messageIds, Long userId) {
        DynamicObject[] msgReceivers = MessageOperateUtils.moveMessageReceiver(messageIds, userId, false);
        if (msgReceivers != null && msgReceivers.length > 0) {
            QFilter filter1 = new QFilter(MESSAGEID, "in", messageIds);
            if (WfUtils.isNotEmpty((Long)userId)) {
                filter1.and(new QFilter(RECEIVERID, "=", (Object)userId));
            }
            DeleteServiceHelper.delete((String)MSGRECEIVERENITTY, (QFilter[])new QFilter[]{filter1});
            MessageQuantitySummaryUtils.updateMessageQuantitySummary((DynamicObject[])msgReceivers, null, (String)"deleteMessge");
        }
    }

    public static Map<String, Object> deleteMessageData(List<Long> messageIds, Long userId) {
        if (messageIds == null || messageIds.isEmpty()) {
            return MessageUtils.wrapResult((String)ResManager.loadKDString((String)"\u6d88\u606fID\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (String)"MessageUtils_12", (String)"bos-message-common", (Object[])new Object[0]));
        }
        HashSet<Long> msgIds = new HashSet<Long>(messageIds);
        DynamicObject[] messageDynamicObjects = BusinessDataServiceHelper.load((String)MSGMESSAGEENTITY, (String)"id,type,toall", (QFilter[])new QFilter[]{new QFilter("id", "in", msgIds)});
        ArrayList<Long> noMessageIds = new ArrayList<Long>(msgIds);
        ArrayList<Long> messageExistIds = new ArrayList<Long>(messageDynamicObjects.length);
        ArrayList<Long> messageExistNotToAllIds = new ArrayList<Long>(messageDynamicObjects.length);
        if (messageDynamicObjects != null && messageDynamicObjects.length > 0) {
            for (DynamicObject messageDynamicObject : messageDynamicObjects) {
                Long messageId = messageDynamicObject.getLong("id");
                if (!messageDynamicObject.getBoolean(TOALL)) {
                    messageExistNotToAllIds.add(messageId);
                }
                messageExistIds.add(messageId);
                noMessageIds.remove(messageId);
            }
        }
        if (noMessageIds != null && !noMessageIds.isEmpty()) {
            MessageOperateUtils.deleteNoMessageData(noMessageIds, userId);
        }
        if (messageExistIds == null || messageExistIds.isEmpty()) {
            return MessageUtils.wrapResult((String)SUCCESS, messageExistIds);
        }
        DynamicObject[] msgReceivers = null;
        try (TXHandle tx = TX.requiresNew();){
            ArrayList<Long> moveMessgeIds = new ArrayList<Long>();
            moveMessgeIds.addAll(messageExistIds);
            msgReceivers = MessageOperateUtils.moveMessageToHistory(moveMessgeIds, userId);
            if (WfUtils.isNotEmpty((Long)userId)) {
                QFilter filter1 = new QFilter(MESSAGEID, "in", messageExistIds).and(RECEIVERID, "=", (Object)userId);
                DeleteServiceHelper.delete((String)MSGRECEIVERENITTY, (QFilter[])new QFilter[]{filter1});
                if (!messageExistNotToAllIds.isEmpty()) {
                    ArrayList<Long> canDeleteMessageIds = new ArrayList<Long>();
                    canDeleteMessageIds.addAll(messageExistNotToAllIds);
                    for (Long messageNotToAllId : messageExistNotToAllIds) {
                        QFilter filter2 = new QFilter(MESSAGEID, "=", (Object)messageNotToAllId).and(RECEIVERID, "!=", (Object)userId);
                        boolean existOtherReceiver = QueryServiceHelper.exists((String)MSGRECEIVERENITTY, (QFilter[])new QFilter[]{filter2});
                        if (!existOtherReceiver) continue;
                        canDeleteMessageIds.remove(messageNotToAllId);
                    }
                    if (!canDeleteMessageIds.isEmpty()) {
                        DeleteServiceHelper.delete((String)MSGMESSAGEENTITY, (QFilter[])new QFilter[]{new QFilter("id", "in", canDeleteMessageIds)});
                        DeleteServiceHelper.delete((String)MSGFAILMESSAGE, (QFilter[])new QFilter[]{new QFilter(MESSAGEID, "in", canDeleteMessageIds)});
                    }
                }
            } else {
                if (!messageExistNotToAllIds.isEmpty()) {
                    DeleteServiceHelper.delete((String)MSGRECEIVERENITTY, (QFilter[])new QFilter[]{new QFilter(MESSAGEID, "in", messageExistNotToAllIds)});
                }
                if (!messageExistIds.isEmpty()) {
                    DeleteServiceHelper.delete((String)MSGMESSAGEENTITY, (QFilter[])new QFilter[]{new QFilter("id", "in", messageExistIds)});
                    DeleteServiceHelper.delete((String)MSGFAILMESSAGE, (QFilter[])new QFilter[]{new QFilter(MESSAGEID, "in", messageExistIds)});
                }
            }
        }
        if (msgReceivers != null) {
            MessageQuantitySummaryUtils.updateMessageQuantitySummary((DynamicObject[])msgReceivers, null, (String)"deleteMessge");
        }
        return MessageUtils.wrapResult((String)SUCCESS, messageExistIds);
    }

    private static DynamicObject[] moveMessageToHistory(List<Long> messageIds, Long userId) {
        QFilter filter2;
        String messageFields;
        DynamicObject[] messageDynamicObjects;
        ArrayList<Long> toAllMessageIds = new ArrayList<Long>();
        QFilter filter1 = new QFilter("id", "in", messageIds);
        DynamicObject[] historyMessageDynamicObjects = BusinessDataServiceHelper.load((String)"wf_msg_himessage", (String)"id", (QFilter[])new QFilter[]{filter1});
        ArrayList<Long> canMoveMessageIds = new ArrayList<Long>();
        canMoveMessageIds.addAll(messageIds);
        if (historyMessageDynamicObjects != null && historyMessageDynamicObjects.length > 0) {
            for (DynamicObject historyMessageDynamicObject : historyMessageDynamicObjects) {
                if (!canMoveMessageIds.contains(historyMessageDynamicObject.getLong("id"))) continue;
                canMoveMessageIds.remove(historyMessageDynamicObject.getLong("id"));
            }
        }
        if ((messageDynamicObjects = BusinessDataServiceHelper.load((String)MSGMESSAGEENTITY, (String)(messageFields = "id,type,title,content,contenturl,mobcontenturl,sender,sendername,channels,operation,entitynumber,sendtime,tag,bizdataid,source,createdate,modifydate,deletedate,toall,nestentitynumber,nestbillid,nestbillno,nestappid"), (QFilter[])new QFilter[]{filter2 = new QFilter("id", "in", messageIds)})) != null && messageDynamicObjects.length > 0) {
            ArrayList<DynamicObject> historyMessages = new ArrayList<DynamicObject>(canMoveMessageIds.size());
            for (DynamicObject messageDynamicObject : messageDynamicObjects) {
                Long id = messageDynamicObject.getLong("id");
                if (messageDynamicObject.getBoolean(TOALL)) {
                    toAllMessageIds.add(id);
                }
                if (!canMoveMessageIds.contains(id)) continue;
                DynamicObject historyMessage = BusinessDataServiceHelper.newDynamicObject((String)"wf_msg_himessage");
                historyMessage.set("id", messageDynamicObject.get("id"));
                historyMessage.set("type", messageDynamicObject.get("type"));
                historyMessage.set(TITLE, messageDynamicObject.get(TITLE));
                historyMessage.set(CONTENT, messageDynamicObject.get(CONTENT));
                historyMessage.set(CONTENTURL, messageDynamicObject.get(CONTENTURL));
                historyMessage.set(MOBCONTENTURL, messageDynamicObject.get(MOBCONTENTURL));
                historyMessage.set(SENDER, messageDynamicObject.get(SENDER));
                historyMessage.set(SENDERNAME, messageDynamicObject.get(SENDERNAME));
                historyMessage.set(CHANNELS, messageDynamicObject.get(CHANNELS));
                historyMessage.set(OPENATION, messageDynamicObject.get(OPENATION));
                historyMessage.set(ENTITYNUMBER, messageDynamicObject.get(ENTITYNUMBER));
                historyMessage.set(SENDTIME, messageDynamicObject.get(SENDTIME));
                historyMessage.set("tag", messageDynamicObject.get("tag"));
                historyMessage.set(BIZDATAID, messageDynamicObject.get(BIZDATAID));
                historyMessage.set("source", messageDynamicObject.get("source"));
                historyMessage.set(CREATEDATE, messageDynamicObject.get(CREATEDATE));
                historyMessage.set(MODIFYDATE, messageDynamicObject.get(MODIFYDATE));
                historyMessage.set("deletedate", (Object)System.currentTimeMillis());
                historyMessage.set("deletereason", (Object)"mc_delete or api");
                historyMessage.set(TOALL, messageDynamicObject.get(TOALL));
                historyMessage.set("nestentitynumber", messageDynamicObject.get("nestentitynumber"));
                historyMessage.set("nestbillid", messageDynamicObject.get("nestbillid"));
                historyMessage.set("nestbillno", messageDynamicObject.get("nestbillno"));
                historyMessage.set("nestappid", messageDynamicObject.get("nestappid"));
                historyMessages.add(historyMessage);
            }
            SaveServiceHelper.save((DynamicObject[])historyMessages.toArray(new DynamicObject[0]));
        }
        if (WfUtils.isEmpty((Long)userId) && !toAllMessageIds.isEmpty()) {
            messageIds.removeAll(toAllMessageIds);
        }
        DynamicObject[] msgReceivers = null;
        if (!messageIds.isEmpty()) {
            msgReceivers = MessageOperateUtils.moveMessageReceiver(messageIds, userId, Boolean.FALSE);
        }
        if (WfUtils.isEmpty((Long)userId) && !toAllMessageIds.isEmpty()) {
            try {
                logger.debug(String.format("deleteMessageAndAsyncMoveReceiver, ready for publish, messageIds[%s]", toAllMessageIds));
                MessageBussinessInfo messageBussinessInfo = new MessageBussinessInfo();
                messageBussinessInfo.setType(MessageBussinessInfo.Type.ASYNCMOVERECEIVERWHENDELETEMSG.getNumber());
                messageBussinessInfo.setData(toAllMessageIds);
                MessageBussinessPublishUtil.publishBizMessage((MessageBussinessInfo)messageBussinessInfo);
            }
            catch (Exception e) {
                logger.warn(String.format("toall message publish mq error[%s]", WfUtils.getExceptionStacktrace((Throwable)e)));
            }
        }
        return msgReceivers;
    }

    public static DynamicObject[] moveMessageReceiver(List<Long> messageIds, Long userId, boolean toAll) {
        String selectedFileds;
        DynamicObject[] receiverDynamicObjects;
        QFilter filter = new QFilter(MESSAGEID, "in", messageIds);
        if (WfUtils.isNotEmpty((Long)userId)) {
            filter.and(RECEIVERID, "=", (Object)userId);
        }
        if ((receiverDynamicObjects = BusinessDataServiceHelper.load((String)MSGRECEIVERENITTY, (String)(selectedFileds = "id,messageid,receiverid,createdate,modifydate,readtime,readstate,popup,terminalway,type,sender,sendername,entitynumber,operation,source,bizdataid,toall,title,tag,tplscene,config,nestentitynumber,nestbillid,nestbillno,nestappid"), (QFilter[])new QFilter[]{filter})) != null && receiverDynamicObjects.length > 0) {
            ArrayList<DynamicObject> historyReceiverList = new ArrayList<DynamicObject>(receiverDynamicObjects.length);
            for (DynamicObject receiverDynamicObject : receiverDynamicObjects) {
                DynamicObject hisReceiver = BusinessDataServiceHelper.newDynamicObject((String)"wf_msg_hireceiver");
                hisReceiver.set("id", receiverDynamicObject.get("id"));
                hisReceiver.set(MESSAGEID, receiverDynamicObject.get(MESSAGEID));
                hisReceiver.set(RECEIVERID, receiverDynamicObject.get(RECEIVERID));
                hisReceiver.set(CREATEDATE, receiverDynamicObject.get(CREATEDATE));
                hisReceiver.set(MODIFYDATE, receiverDynamicObject.get(MODIFYDATE));
                hisReceiver.set(READTIME, receiverDynamicObject.get(READTIME));
                hisReceiver.set(READSTATE, receiverDynamicObject.get(READSTATE));
                hisReceiver.set("deletedate", (Object)System.currentTimeMillis());
                hisReceiver.set(POPUP, receiverDynamicObject.get(POPUP));
                hisReceiver.set(TERMINALWAY, receiverDynamicObject.get(TERMINALWAY));
                hisReceiver.set("type", receiverDynamicObject.get("type"));
                hisReceiver.set(SENDER, receiverDynamicObject.get(SENDER));
                hisReceiver.set(SENDERNAME, receiverDynamicObject.get(SENDERNAME));
                hisReceiver.set(ENTITYNUMBER, receiverDynamicObject.get(ENTITYNUMBER));
                hisReceiver.set(OPENATION, receiverDynamicObject.get(OPENATION));
                hisReceiver.set("source", receiverDynamicObject.get("source"));
                hisReceiver.set(BIZDATAID, receiverDynamicObject.get(BIZDATAID));
                hisReceiver.set(TOALL, receiverDynamicObject.get(TOALL));
                hisReceiver.set(TITLE, receiverDynamicObject.get(TITLE));
                hisReceiver.set("tag", receiverDynamicObject.get("tag"));
                hisReceiver.set("tplscene", receiverDynamicObject.get("tplscene"));
                hisReceiver.set("config", receiverDynamicObject.get("config"));
                hisReceiver.set("nestentitynumber", receiverDynamicObject.get("nestentitynumber"));
                hisReceiver.set("nestbillid", receiverDynamicObject.get("nestbillid"));
                hisReceiver.set("nestbillno", receiverDynamicObject.get("nestbillno"));
                hisReceiver.set("nestappid", receiverDynamicObject.get("nestappid"));
                hisReceiver.set("deletereason", (Object)"mc_delete or api");
                historyReceiverList.add(hisReceiver);
            }
            DynamicObject[] hisReceiver = new DynamicObject[historyReceiverList.size()];
            SaveServiceHelper.save((DynamicObject[])historyReceiverList.toArray(hisReceiver));
        }
        if (toAll) {
            DeleteServiceHelper.delete((String)MSGRECEIVERENITTY, (QFilter[])new QFilter[]{new QFilter(MESSAGEID, "in", messageIds)});
        }
        return receiverDynamicObjects;
    }

    public static DynamicObjectCollection getMessageData(EntityQueryParams entityQueryParams) {
        String queryFields = entityQueryParams.getMainEntityQueryParams().getQueryALLFields();
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>();
        qFilterList.add(new QFilter(RECEIVERID, "=", (Object)entityQueryParams.getUserId()));
        List params = entityQueryParams.getMainEntityQueryParams().getQFilter();
        if (params != null && params.size() > 0) {
            qFilterList.addAll(params);
        }
        QFilter[] qFilters = (QFilter[])qFilterList.stream().toArray(QFilter[]::new);
        StringBuilder order = new StringBuilder();
        String orderby = entityQueryParams.getMainEntityQueryParams().getOrderBySql();
        if (WfUtils.isNotEmpty((String)orderby)) {
            order.append(orderby);
        } else {
            order.append("messageid desc");
        }
        if (entityQueryParams.getLimit() == 0) {
            try (DataSet ds = ORM.create().queryDataSet("algoKey", MSGRECEIVERENITTY, queryFields, qFilters, order.toString());){
                DynamicObjectCollection resultDynamicObjectCollection;
                DynamicObjectCollection dynamicObjectCollection = resultDynamicObjectCollection = ORM.create().toPlainDynamicObjectCollection(ds);
                return dynamicObjectCollection;
            }
        }
        try (DataSet ds = ORM.create().queryDataSet("algoKey", MSGRECEIVERENITTY, queryFields, qFilters, order.toString(), entityQueryParams.getStart(), entityQueryParams.getLimit());){
            DynamicObjectCollection resultDynamicObjectCollection;
            DynamicObjectCollection dynamicObjectCollection = resultDynamicObjectCollection = ORM.create().toPlainDynamicObjectCollection(ds);
            return dynamicObjectCollection;
        }
    }

    public static long getMessageDataCount(EntityQueryParams entityQueryParams) {
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>();
        qFilterList.add(new QFilter(RECEIVERID, "=", (Object)entityQueryParams.getUserId()));
        List params = entityQueryParams.getMainEntityQueryParams().getQFilter();
        if (params != null && params.size() > 0) {
            qFilterList.addAll(params);
        }
        QFilter[] qFilters = (QFilter[])qFilterList.stream().toArray(QFilter[]::new);
        return ORM.create().count("algoKey-getMessageDataCount", MSGRECEIVERENITTY, qFilters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DynamicObjectCollection getMessageData(int start, int limit, String userId, String entityNumber, Long typeId, String readstate, Map<String, Map<String, List<Object>>> filterSql, String orderby) {
        DynamicObjectCollection messageObjectCollection;
        Map<Object, Object> data = new HashMap();
        data = WfConfigurationUtil.isRepaireMsgReceiverComplete() != false ? MessageOperateUtils.getJoinQueryDataSqlNew(start, limit, userId, entityNumber, typeId, readstate, filterSql, orderby) : MessageOperateUtils.getJoinQueryDataSql(start, limit, userId, entityNumber, typeId, readstate, filterSql, orderby);
        String sql = (String)data.get("sql");
        List params = (List)data.get("params");
        try (DataSet ds = DB.queryDataSet((String)"MessageCenter.wf_message.queryGridData", (DBRoute)DBRoute.workflow, (String)sql, (Object[])params.toArray());){
            messageObjectCollection = limit == 0 ? ORM.create().toPlainDynamicObjectCollection(ds) : ORM.create().toPlainDynamicObjectCollection(ds, start, limit);
        }
        for (DynamicObject messageObj : messageObjectCollection) {
            if (WfUtils.isNotEmpty((String)readstate) && (UNREAD.equals(readstate) || "read".equals(readstate))) {
                messageObj.set(READSTATE, (Object)readstate);
                continue;
            }
            if (messageObj.get(READSTATE) != null) continue;
            messageObj.set(READSTATE, (Object)UNREAD);
        }
        return messageObjectCollection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getMessageDataCount(String userId, String entityNumber, Long typeId, String readstate, Map<String, Map<String, List<Object>>> filterSql) {
        Map<Object, Object> data = new HashMap();
        data = WfConfigurationUtil.isRepaireMsgReceiverComplete() != false ? MessageOperateUtils.getJoinQueryCountSqlNew(userId, entityNumber, typeId, readstate, filterSql) : MessageOperateUtils.getJoinQueryCountSql(userId, entityNumber, typeId, readstate, filterSql);
        String sql = (String)data.get("sql");
        List params = (List)data.get("params");
        long count = 0L;
        try (DataSet ds = DB.queryDataSet((String)MESSAGECENTERCOUNT, (DBRoute)DBRoute.workflow, (String)sql, (Object[])params.toArray());){
            Iterator iter = ds.iterator();
            if (iter.hasNext()) {
                count = ((Row)iter.next()).getLong(COUNT);
            }
        }
        return count;
    }

    private static Map<String, Object> getJoinQueryDataSql(int start, int limit, String userId, String entityNumber, Long typeId, String readstate, Map<String, Map<String, List<Object>>> filterSql, String orderby) {
        ArrayList<Object> paramList = new ArrayList<Object>();
        String lang = RequestContext.get().getLang().toString();
        String contentSummarySQL = WfMultiLangUtils.getGeneralLangSQL((String)MSGRECEIVERENITTY, (String)"a", (String)"b", (String)"fcontent_summary", (String)CONTENTSUMMARY, (String)CONTENTSUMMARY);
        String titleSQL = WfMultiLangUtils.getGeneralLangSQL((String)MSGMESSAGEENTITY, (String)"a", (String)"b", (String)FTITLE, (String)TITLE, (String)TITLE);
        String tagSQL = WfMultiLangUtils.getGeneralLangSQL((String)MSGMESSAGEENTITY, (String)"a", (String)"b", (String)"ftag", (String)"tag", (String)"tag");
        String senderNameSQL = WfMultiLangUtils.getGeneralLangSQL((String)MSGMESSAGEENTITY, (String)"a", (String)"b", (String)"fsendername", (String)SENDERNAME, (String)SENDERNAME);
        StringBuilder sql = new StringBuilder("select ").append(limit == 0 ? "" : "top " + (start + limit));
        sql.append(" a.fid id, a.ftype type, a.fcreatedate createdate, a.fsender sender, a.fcontenturl contenturl, a.fmobcontenturl mobcontenturl, a.fconfig config, a.fentitynumber entitynumber, a.fbizdataid bizdataid, c.freadstate readstate, b.fcontent content, ");
        sql.append(titleSQL).append(", ").append(tagSQL).append(", ").append(senderNameSQL).append(", ").append(contentSummarySQL);
        sql.append(" from t_wf_msgreceiver c inner join t_wf_message a on c.fmessageid = a.fid and c.freceiverid = ?");
        paramList.add(Long.valueOf(userId));
        if (StringUtils.isNotEmpty((CharSequence)entityNumber)) {
            sql.append(" and a.fentitynumber = ? ");
            paramList.add(entityNumber);
        }
        if (WfUtils.isNotEmpty((Long)typeId)) {
            sql.append(" and a.ftype = ? ");
            paramList.add(typeId);
        }
        if (WfUtils.isNotEmpty((String)readstate)) {
            sql.append(" and c.freadstate = ").append("'").append(readstate).append("'");
        }
        sql.append(" left join t_wf_message_l b on a.fid = b.fid and b.flocaleid = ").append("'").append(lang).append("' ");
        if (StringUtils.isNotBlank(filterSql.get("sqlFilters"))) {
            sql.append(MessageOperateUtils.wrapSqlParams(filterSql.get("sqlFilters"), paramList));
        }
        sql.append(" where c.freceiverid = ? ");
        paramList.add(Long.valueOf(userId));
        if (StringUtils.isNotEmpty((CharSequence)entityNumber)) {
            sql.append(" and a.fentitynumber = ? ");
            paramList.add(entityNumber);
        }
        if (WfUtils.isNotEmpty((Long)typeId)) {
            sql.append(" and a.ftype = ? ");
            paramList.add(typeId);
        }
        if (WfUtils.isNotEmpty((String)readstate)) {
            sql.append(" and c.freadstate = ").append("'").append(readstate).append("'");
        }
        if (StringUtils.isNotBlank(filterSql.get("sqlFilters"))) {
            sql.append(MessageOperateUtils.wrapSqlParams(filterSql.get("sqlFilters"), paramList));
        }
        if (WfUtils.isNotEmpty((String)orderby)) {
            sql.append(" order by ").append(orderby).append(";");
        } else {
            sql.append(" order by c.fmessageid desc;");
        }
        HashMap<String, Object> m = new HashMap<String, Object>();
        m.put("sql", sql.toString());
        m.put("params", paramList);
        return m;
    }

    private static Map<String, Object> getJoinQueryDataSqlNew(int start, int limit, String userId, String entityNumber, Long typeId, String readstate, Map<String, Map<String, List<Object>>> filterSql, String orderby) {
        ArrayList<Object> paramList = new ArrayList<Object>();
        String lang = RequestContext.get().getLang().toString();
        String titleSQL = WfMultiLangUtils.getGeneralLangSQL((String)MSGRECEIVERENITTY, (String)"a", (String)"b", (String)FTITLE, (String)TITLE, (String)TITLE);
        String contentSummarySQL = WfMultiLangUtils.getGeneralLangSQL((String)MSGRECEIVERENITTY, (String)"a", (String)"b", (String)"fcontent_summary", (String)CONTENTSUMMARY, (String)CONTENTSUMMARY);
        String tagSQL = WfMultiLangUtils.getGeneralLangSQL((String)MSGRECEIVERENITTY, (String)"a", (String)"b", (String)"ftag", (String)"tag", (String)"tag");
        String senderNameSQL = WfMultiLangUtils.getGeneralLangSQL((String)MSGRECEIVERENITTY, (String)"a", (String)"b", (String)"fsendername", (String)SENDERNAME, (String)SENDERNAME);
        StringBuilder sql = new StringBuilder("select ").append(limit == 0 ? "" : "top " + (start + limit));
        sql.append(" a.fmessageid id, a.ftype type, a.fcreatedate createdate, a.fsender sender, a.fentitynumber entitynumber, a.fbizdataid bizdataid, a.freadstate readstate, a.fconfig config,a.fcontenturl contenturl, ");
        sql.append(titleSQL).append(", ").append(contentSummarySQL).append(", ").append(tagSQL).append(", ").append(senderNameSQL);
        sql.append(" from t_wf_msgreceiver a ");
        sql.append(" left join t_wf_msgreceiver_l b on b.fid = a.fid and b.flocaleid = ").append("'").append(lang).append("' ");
        sql.append(" where a.freceiverid = ? ");
        paramList.add(Long.valueOf(userId));
        if (StringUtils.isNotEmpty((CharSequence)entityNumber)) {
            sql.append(" and a.fentitynumber = ? ");
            paramList.add(entityNumber);
        }
        if (WfUtils.isNotEmpty((Long)typeId)) {
            sql.append(" and a.ftype = ? ");
            paramList.add(typeId);
        }
        if (WfUtils.isNotEmpty((String)readstate)) {
            sql.append(" and a.freadstate = ").append("'").append(readstate).append("'");
        }
        if (StringUtils.isNotBlank(filterSql.get("sqlFilters"))) {
            String str = MessageOperateUtils.wrapNewSqlParams(filterSql.get("sqlFilters"), paramList);
            str = str.replace("c.", "a.");
            sql.append(str);
        }
        if (WfUtils.isNotEmpty((String)orderby)) {
            if (orderby.contains("c.")) {
                orderby = orderby.replace("c.", "a.");
            }
            sql.append(" order by ").append(orderby).append(";");
        } else {
            sql.append(" order by a.fmessageid desc;");
        }
        HashMap<String, Object> m = new HashMap<String, Object>();
        m.put("sql", sql.toString());
        m.put("params", paramList);
        return m;
    }

    private static Map<String, Object> getJoinQueryCountSql(String userId, String entityNumber, Long typeId, String readstate, Map<String, Map<String, List<Object>>> filterSql) {
        ArrayList<Object> paramList = new ArrayList<Object>();
        StringBuilder sql = new StringBuilder();
        sql.append("select count(1) count from t_wf_msgreceiver c ");
        sql.append("inner join t_wf_message a on c.fmessageid = a.fid and c.freceiverid = ? ");
        paramList.add(Long.valueOf(userId));
        if (WfUtils.isNotEmpty((String)entityNumber)) {
            sql.append(" and a.fentitynumber = ? ");
            paramList.add(entityNumber);
        }
        if (WfUtils.isNotEmpty((Long)typeId)) {
            sql.append(" and a.ftype = ? ");
            paramList.add(typeId);
        }
        if (WfUtils.isNotEmpty((String)readstate)) {
            sql.append(" and c.freadstate = ").append("'").append(readstate).append("'");
        }
        if (filterSql != null && StringUtils.isNotBlank(filterSql.get("sqlFilters"))) {
            sql.append(" left join t_wf_message_l b on a.fid = b.fid and b.flocaleid = ");
            sql.append("'").append(RequestContext.get().getLang().toString()).append("' ");
            sql.append(MessageOperateUtils.wrapSqlParams(filterSql.get("sqlFilters"), paramList));
        }
        sql.append(" where c.freceiverid = ? ");
        paramList.add(Long.valueOf(userId));
        if (WfUtils.isNotEmpty((String)entityNumber)) {
            sql.append(" and a.fentitynumber = ? ");
            paramList.add(entityNumber);
        }
        if (WfUtils.isNotEmpty((Long)typeId)) {
            sql.append(" and a.ftype = ? ");
            paramList.add(typeId);
        }
        if (WfUtils.isNotEmpty((String)readstate)) {
            sql.append(" and c.freadstate = ").append("'").append(readstate).append("'");
        }
        if (filterSql != null && StringUtils.isNotBlank(filterSql.get("sqlFilters"))) {
            sql.append(MessageOperateUtils.wrapSqlParams(filterSql.get("sqlFilters"), paramList));
        }
        sql.append(";");
        HashMap<String, Object> m = new HashMap<String, Object>();
        m.put("sql", sql.toString());
        m.put("params", paramList);
        return m;
    }

    private static Map<String, Object> getJoinQueryCountSqlNew(String userId, String entityNumber, Long typeId, String readstate, Map<String, Map<String, List<Object>>> filterSql) {
        String str;
        ArrayList<Object> paramList = new ArrayList<Object>();
        StringBuilder sql = new StringBuilder();
        sql.append("select count(1) count from t_wf_msgreceiver a ");
        if (filterSql != null && StringUtils.isNotBlank(filterSql.get("sqlFilters"))) {
            sql.append(" left join t_wf_msgreceiver_l b on a.fid = b.fid and b.flocaleid = ");
            sql.append("'").append(RequestContext.get().getLang().toString()).append("' ");
            str = MessageOperateUtils.wrapNewSqlParams(filterSql.get("sqlFilters"), paramList);
            str = str.replace("c.", "a.");
            sql.append(str);
        }
        sql.append(" where a.freceiverid = ? ");
        paramList.add(Long.valueOf(userId));
        if (WfUtils.isNotEmpty((String)entityNumber)) {
            sql.append(" and a.fentitynumber = ? ");
            paramList.add(entityNumber);
        }
        if (WfUtils.isNotEmpty((Long)typeId)) {
            sql.append(" and a.ftype = ? ");
            paramList.add(typeId);
        }
        if (WfUtils.isNotEmpty((String)readstate)) {
            sql.append(" and a.freadstate = ").append("'").append(readstate).append("'");
        }
        if (filterSql != null && StringUtils.isNotBlank(filterSql.get("sqlFilters"))) {
            str = MessageOperateUtils.wrapNewSqlParams(filterSql.get("sqlFilters"), paramList);
            str = str.replace("c.", "a.");
            sql.append(str);
        }
        sql.append(";");
        HashMap<String, Object> m = new HashMap<String, Object>();
        m.put("sql", sql.toString());
        m.put("params", paramList);
        return m;
    }

    private static String wrapSqlParams(Map<String, List<Object>> filterSql, List<Object> paramList) {
        Set<String> keys = filterSql.keySet();
        String sql = "";
        Iterator<String> iterator = keys.iterator();
        while (iterator.hasNext()) {
            String s;
            sql = s = iterator.next();
            paramList.addAll(filterSql.get(sql));
        }
        return sql;
    }

    private static String wrapNewSqlParams(Map<String, List<Object>> filterSql, List<Object> paramList) {
        Set<String> keys = filterSql.keySet();
        String sql = "";
        Iterator<String> iterator = keys.iterator();
        while (iterator.hasNext()) {
            String s;
            sql = s = iterator.next();
            paramList.addAll(filterSql.get(sql));
            if (!s.contains("a.fid")) continue;
            sql = s.replaceAll("a.fid", "a.fmessageid");
            List<Object> v = filterSql.remove(s);
            filterSql.put(sql, v);
        }
        return sql;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SmsUsingQuantities getSmsUsingQuantitySummary() {
        Long totalSum = 0L;
        Long failSum = 0L;
        SmsUsingQuantities smsUsingQuantities = new SmsUsingQuantities(totalSum, failSum, Long.valueOf(totalSum - failSum));
        RequestContext contextCopy = RequestContext.get();
        try {
            String tenantId = RequestContext.get().getTenantId();
            List accounts = AccountUtils.getAllAccounts((String)tenantId);
            for (Account account : accounts) {
                RequestContext context = RequestContext.create();
                context.setAccountId(account.getAccountId());
                context.setTenantId(account.getTenantId());
                try {
                    DynamicObjectCollection cl;
                    QFilter q1 = new QFilter("number", "=", (Object)"hiSmsNumberCalculate");
                    DynamicObjectCollection repairtaskCl = QueryServiceHelper.query((String)"wf_repairtask", (String)"id,state", (QFilter[])new QFilter[]{q1});
                    if (WfUtils.isEmptyForCollection((Collection)repairtaskCl)) continue;
                    Object msgObj = MessageServiceUtil.getConfigCenterProperty((String)MESSAGE, (String)"msg.sms.msgcreatedate");
                    Object hiMsgObj = MessageServiceUtil.getConfigCenterProperty((String)MESSAGE, (String)"msg.sms.himsgcreatedate");
                    Object failMsgObj = MessageServiceUtil.getConfigCenterProperty((String)MESSAGE, (String)"msg.sms.failmsgcreatedate");
                    if (!"FINISHED".equals(((DynamicObject)repairtaskCl.get(0)).getString("state")) || msgObj != null || hiMsgObj != null || failMsgObj != null || !WfUtils.isNotEmptyForCollection((Collection)(cl = QueryServiceHelper.query((String)"wf_smsusingquantity", (String)"id, smsNumber, permitEndDate", null, (String)"permitEndDate desc", (int)1)))) continue;
                    String smsNumber = ((DynamicObject)cl.get(0)).getString("smsNumber");
                    try {
                        smsNumber = smsNumber.startsWith("d@f*g:") ? Encrypters.decode((String)smsNumber) : smsNumber;
                        totalSum = totalSum + (WfUtils.isNotEmpty((String)smsNumber) ? Long.parseLong(smsNumber) : 0L);
                    }
                    catch (Exception e) {
                        logger.error("getSmsUsingQuantitySummary is error, errorinfo is : \u77ed\u4fe1\u4f7f\u7528\u6570\u91cf\u88ab\u7834\u574f\uff0c\u89e3\u5bc6\u5931\u8d25\uff0c\u9ed8\u8ba4\u7ed90");
                    }
                }
                catch (Exception e) {
                    logger.error("smsUsingQuantitySummary-" + WfUtils.getExceptionStacktrace((Throwable)e));
                }
            }
        }
        finally {
            RequestContext contextRet = RequestContext.create();
            RequestContext.set((RequestContext)contextCopy);
        }
        smsUsingQuantities.setTotalSum(totalSum);
        smsUsingQuantities.setSuccessSum(totalSum);
        return smsUsingQuantities;
    }

    public static MessageInfo db2MessageInfoConverter(DynamicObject message) {
        MessageInfo messageInfo = new MessageInfo();
        messageInfo.setId(Long.valueOf(message.getLong("id")));
        messageInfo.setMessageTitle(message.getLocaleString(TITLE));
        messageInfo.setMessageContent(message.getLocaleString(CONTENT));
        messageInfo.setUserIds(new ArrayList());
        messageInfo.setSenderId(Long.valueOf(message.getLong(SENDER)));
        messageInfo.setMessageSenderName(message.getLocaleString(SENDERNAME));
        messageInfo.setNotifyType(message.getString(CHANNELS));
        String config = message.getString("config");
        if (WfUtils.isNotEmpty((String)config) && !"{}".equals(config)) {
            Map param = (Map)SerializationUtils.fromJsonString((String)config, Map.class);
            messageInfo.setParams(param);
            if (param.containsKey("attachmentUrls")) {
                MessageAttachmentUtils.downloadAttachmentData((MessageInfo)messageInfo);
            }
        }
        messageInfo.setSendTime(message.getDate(CREATEDATE));
        messageInfo.setType(message.getString("type"));
        messageInfo.setContentUrl(message.getString(CONTENTURL));
        messageInfo.setMobContentUrl(message.getString(MOBCONTENTURL));
        messageInfo.setEntityNumber(message.getString(ENTITYNUMBER));
        messageInfo.setOperation(message.getString(OPENATION));
        messageInfo.setBizDataId(Long.valueOf(message.getLong(BIZDATAID)));
        messageInfo.setMessageTag(message.getLocaleString("tag"));
        messageInfo.setSource(message.getString("source"));
        messageInfo.setTplScene(message.getString("tplscene"));
        messageInfo.setToAll(message.getBoolean(TOALL));
        return messageInfo;
    }
}

