/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.message.service.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.entity.MainEntityType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfPermUtils;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.message.service.api.model.MessageInfoModel;

public class MsgCenterAPIUtils {
    private static final List<String> dataType = Arrays.asList("tohandle", "handled", "toapply", "applyed", "transfer", "custom", "delegate", "msg");
    public static final String DELETE = "delete";
    public static final String UPDATE_READ_STATUS = "updateReadStatus";
    public static final String UPDATE_READ_STATUS_BY_USERID = "updateReadStatusByUserId";
    private static final String WF_MSG_LOG_ENTITYNUMBER = "wf_msg_failmessage";
    private static final String WF_MSG_LOG_DELETE_PERM_ITEM = "4715e1f1000000ac";
    private static final String WF_MSG_LOG_MODIFIED_PERM_ITEM = "4715a0df000000ac";
    private static final String APPID_WF_MSG = "L+YYPU4WNDE";
    private static final String APPID_SYS = "18XSXYEL8//U";

    private MsgCenterAPIUtils() {
    }

    public static List<Long> castObjToLong(List<Object> jObjects) {
        if (WfUtils.isEmptyForCollection(jObjects)) {
            return Collections.emptyList();
        }
        ArrayList<Long> resultList = new ArrayList<Long>(jObjects.size());
        for (Object msgId : jObjects) {
            if (msgId instanceof String) {
                resultList.add(Long.valueOf((String)msgId));
                continue;
            }
            resultList.add(Long.parseLong(msgId.toString()));
        }
        return resultList;
    }

    public static List<Object> castLongToObj(List<Long> ids) {
        if (WfUtils.isEmptyForCollection(ids)) {
            return Collections.emptyList();
        }
        ArrayList<Object> resultList = new ArrayList<Object>(ids.size());
        for (Long msgId : ids) {
            resultList.add(msgId);
        }
        return resultList;
    }

    public static Boolean checkUserIds(List<Long> userIds) {
        if (WfUtils.isEmptyForCollection(userIds)) {
            return Boolean.FALSE;
        }
        QFilter qFilter = new QFilter("id", "in", userIds);
        return QueryServiceHelper.exists((String)"bos_user", (QFilter[])new QFilter[]{qFilter});
    }

    public static Boolean checkMsgIds(List<Long> msgIds) {
        if (WfUtils.isEmptyForCollection(msgIds)) {
            return Boolean.FALSE;
        }
        QFilter qFilter = new QFilter("id", "in", msgIds);
        return QueryServiceHelper.exists((String)"wf_msg_message", (QFilter[])new QFilter[]{qFilter});
    }

    public static Boolean checkMsgParam(MessageInfoModel messageInfo) {
        if (messageInfo != null && WfUtils.isEmpty((String)messageInfo.getContent()) && WfUtils.isEmpty((String)messageInfo.getMessageContent())) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public static Boolean checkParamType(Object param) {
        if (param != null) {
            if (param instanceof Long) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public static Boolean checkParamTypeForInt(Object param) {
        if (param != null) {
            if (param instanceof Integer) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public static Boolean checkType(String type) {
        if (WfUtils.isEmpty((String)type) || !dataType.contains(type)) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public static Boolean checkMsgAndUserIsMatch(Long msgId, List<Long> userIds) {
        QFilter qFilter = new QFilter("messageid", "=", (Object)msgId).and("receiverid", "in", userIds);
        return QueryServiceHelper.exists((String)"wf_msg_receiver", (QFilter[])new QFilter[]{qFilter});
    }

    public static Boolean checkEntityNumberForMsg(String entityNumber) {
        if (WfUtils.isEmpty((String)entityNumber)) {
            return Boolean.FALSE;
        }
        try {
            MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)entityNumber);
            if (null == mainEntityType) {
                return Boolean.FALSE;
            }
        }
        catch (Exception e) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public static Boolean checkMsgType(String messageType) {
        QFilter qFilter = new QFilter("number", "=", (Object)messageType);
        return QueryServiceHelper.exists((String)"msg_type", (QFilter[])new QFilter[]{qFilter});
    }

    public static Map<String, List<Long>> checkAndFilterMessageIds(List<Long> msgIds) {
        HashMap<String, List<Long>> ret = new HashMap<String, List<Long>>(1);
        ArrayList<Long> errorIds = new ArrayList<Long>(msgIds.size());
        ArrayList<Long> rightIds = new ArrayList<Long>(msgIds.size());
        for (Long msgId : msgIds) {
            Boolean msgIdExist = QueryServiceHelper.exists((String)"wf_msg_message", (Object)msgId);
            if (!msgIdExist.booleanValue()) {
                errorIds.add(msgId);
                continue;
            }
            rightIds.add(msgId);
        }
        ret.put("errorIds", errorIds);
        ret.put("rightIds", rightIds);
        return ret;
    }

    public static Boolean checkIsHavePerm(String flag, Long currentUserId, List<Long> msgIds) {
        if (WfConfigurationUtil.disableCheckV2Api()) {
            return true;
        }
        Long userId = RequestContext.get().getCurrUserId();
        if (DELETE.equalsIgnoreCase(flag) && (WfPermUtils.checkUserIsReceiver(msgIds, (Long)userId) || WfPermUtils.hasMessageHandlerPerm((String)"api_v2"))) {
            return Boolean.TRUE;
        }
        if (UPDATE_READ_STATUS_BY_USERID.equalsIgnoreCase(flag) && (null != currentUserId && currentUserId.longValue() == userId.longValue() ? WfPermUtils.checkUserIsReceiver(msgIds, (Long)userId) : WfPermUtils.hasMessageHandlerPerm((String)"api_v2"))) {
            return Boolean.TRUE;
        }
        if (UPDATE_READ_STATUS.equalsIgnoreCase(flag) && (WfPermUtils.checkUserIsReceiver(msgIds, (Long)userId) || WfPermUtils.hasMessageHandlerPerm((String)"api_v2"))) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    private static Boolean checkUserIsReceiver(Long userId, List<Long> msgIds) {
        QFilter qFilter = new QFilter("messageid", "in", msgIds).and("receiverid", "=", (Object)userId);
        return QueryServiceHelper.exists((String)"wf_msg_receiver", (QFilter[])new QFilter[]{qFilter});
    }

    public static boolean isHavePerm(Long currUserId, String permItemId) {
        return PermissionServiceHelper.checkPermission((Long)currUserId, (String)APPID_SYS, (String)WF_MSG_LOG_ENTITYNUMBER, (String)permItemId);
    }
}

