/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.message.archive.archiveplugin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.message.archive.archiveplugin.EntityArchiveImpl;
import kd.bos.message.archive.enumeration.MessageArchiveState;
import kd.bos.message.archive.utils.MessageArchiveUtil;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.persistence.entity.design.ModelType;

public class HiprocinstArchiveImpl
extends EntityArchiveImpl {
    private Log logger = LogFactory.getLog(HiprocinstArchiveImpl.class);

    @Override
    public Iterator<Long> queryEntityIds() {
        if (!MessageArchiveUtil.isHistoricDataRepairDone().booleanValue()) {
            return new ArrayList().iterator();
        }
        try {
            this.logger.debug("HiprocinstArchiveImpl_into queryEntityId");
            QFilter f1 = new QFilter("state", "=", (Object)MessageArchiveState.ARCHIVEING.getValue());
            QFilter f2 = new QFilter("state", "=", (Object)MessageArchiveState.ARCHIVEFAIL.getValue());
            QFilter f3 = new QFilter("archiveentity", "=", (Object)"wf_hiprocinst");
            String selectProperties = "id,number,schedulesize,archstartdate,archenddate";
            DynamicObject[] archiveServices = BusinessDataServiceHelper.load((String)"wf_archiveservice", (String)selectProperties, (QFilter[])new QFilter[]{f1.or(f2), f3});
            DynamicObject targetService = null;
            if (archiveServices == null || archiveServices.length == 0) {
                return new ArrayList().iterator();
            }
            targetService = archiveServices[0];
            int startYear = targetService.getInt("archstartdate");
            int endYear = targetService.getInt("archenddate");
            Map<String, Date> archiveDates = MessageArchiveUtil.getArchiveDates(startYear, endYear);
            Date startDate = archiveDates.get("startDate");
            Date endDate = archiveDates.get("endDate");
            int scheduleSize = targetService.getInt("schedulesize");
            Long archiveServiceId = targetService.getLong("id");
            List<Long> entityIds = this.getArchiveEntityDate(archiveServiceId, startDate, endDate, scheduleSize);
            this.logger.debug(String.format("HiprocinstArchiveImpl_entityIdSeize[%s]", entityIds.size()));
            return entityIds.iterator();
        }
        catch (Exception e) {
            this.logger.warn(String.format("HiprocinstArchiveImpl_queryEntityIds has error: %s", WfUtils.getExceptionStacktrace((Throwable)e)));
            return new ArrayList().iterator();
        }
    }

    private List<Long> getArchiveEntityDate(Long archiveServiceId, Date startDate, Date endDate, int scheduleSize) {
        QFilter fl1 = new QFilter("archiveserviceid", "=", (Object)archiveServiceId);
        QFilter fl2 = new QFilter("parententity", "=", (Object)"wf_hiprocinst");
        DynamicObject[] archiveLogs = BusinessDataServiceHelper.load((String)"wf_archivelog", (String)"id,targetdate,schenddate,resourceids", (QFilter[])new QFilter[]{fl1, fl2}, (String)"targetdate desc");
        if (archiveLogs == null || archiveLogs.length == 0) {
            return new ArrayList<Long>();
        }
        DynamicObject LastTimeArchiveLog = null;
        for (int i = 0; i < archiveLogs.length; ++i) {
            DynamicObject archiveLog = archiveLogs[i];
            if (archiveLog.getDate("targetdate") == null) continue;
            LastTimeArchiveLog = archiveLog;
            break;
        }
        if (LastTimeArchiveLog != null) {
            startDate = LastTimeArchiveLog.getDate("targetdate");
            this.logger.debug(String.format("HiprocinstArchiveImpl_startDate[%s]", startDate.toString()));
        }
        List<DynamicObject> entitys = this.getHiprocinsts(startDate, endDate, scheduleSize, null, 0);
        ArrayList<Long> entityIds = new ArrayList<Long>();
        Date targetDate = null;
        if (!entitys.isEmpty()) {
            for (DynamicObject entity : entitys) {
                entityIds.add(entity.getLong("id"));
                Date endTime = entity.getDate("endtime");
                long superProcinstId = entity.getLong("superprocessinstanceid");
                if (superProcinstId != 0L) continue;
                if (targetDate == null) {
                    targetDate = endTime;
                    continue;
                }
                if (!targetDate.before(endTime)) continue;
                targetDate = endTime;
            }
            this.saveArchiveLog(archiveLogs, targetDate, entityIds);
        } else {
            this.deleteArchiveLog(archiveLogs);
        }
        return entityIds;
    }

    private void deleteArchiveLog(DynamicObject[] archiveLogs) {
        DynamicObject targetArchiveLog = null;
        for (DynamicObject archiveLog : archiveLogs) {
            if (archiveLog.getDate("targetdate") != null || archiveLog.getDate("schenddate") != null) continue;
            targetArchiveLog = archiveLog;
            break;
        }
        if (targetArchiveLog != null) {
            QFilter[] fitlers = new QFilter[]{new QFilter("id", "=", (Object)targetArchiveLog.getLong("id"))};
            DeleteServiceHelper.delete((String)"wf_archivelog", (QFilter[])fitlers);
            this.logger.debug(String.format("entityId empty and delete log [%s-%s]", targetArchiveLog.getLong("scheduleid"), targetArchiveLog.getLong("taskid")));
        }
    }

    private List<DynamicObject> getHiprocinsts(Date startDate, Date endDate, int scheduleSize, Set<Long> parentIds, int level) {
        ArrayList<DynamicObject> hiprocinstEntitys = new ArrayList<DynamicObject>();
        if (level >= 3) {
            return hiprocinstEntitys;
        }
        DynamicObject[] entitys = null;
        if (parentIds == null && level == 0) {
            QFilter f1 = new QFilter("endtime", "is not null", null);
            DynamicObject[] f2 = new QFilter("endtime", ">=", (Object)startDate);
            QFilter f3 = new QFilter("endtime", "<", (Object)endDate);
            QFilter f4 = new QFilter("superprocessinstanceid", "=", (Object)0L);
            QFilter f5 = new QFilter("processtype", "=", (Object)ModelType.AuditFlow.name());
            entitys = BusinessDataServiceHelper.load((String)"wf_hiprocinst", (String)"id,endtime,superprocessinstanceid,businesskey", (QFilter[])new QFilter[]{f1, f2, f3, f4, f5}, (String)"endtime asc", (int)scheduleSize);
        } else {
            QFilter[] filters = new QFilter[]{new QFilter("superprocessinstanceid", "in", parentIds), new QFilter("endtime", "is not null", null)};
            entitys = BusinessDataServiceHelper.load((String)"wf_hiprocinst", (String)"id,endtime,superprocessinstanceid,businesskey", (QFilter[])filters);
        }
        if (entitys != null && entitys.length > 0) {
            HashMap<Long, String> parentIdsMapping = new HashMap<Long, String>(entitys.length);
            for (DynamicObject entity : entitys) {
                parentIdsMapping.put(entity.getLong("id"), entity.getString("businesskey"));
            }
            if (parentIds == null && level == 0) {
                this.filterProcinstIds(parentIdsMapping);
            }
            HashSet<Long> ids = new HashSet<Long>(entitys.length);
            for (DynamicObject entity : entitys) {
                if (!parentIdsMapping.containsKey(entity.getLong("id"))) continue;
                hiprocinstEntitys.add(entity);
                ids.add(entity.getLong("id"));
            }
            List<DynamicObject> childHiprocinsts = this.getHiprocinsts(startDate, endDate, scheduleSize, ids, level + 1);
            hiprocinstEntitys.addAll(childHiprocinsts);
        }
        return hiprocinstEntitys;
    }

    private void filterProcinstIds(Map<Long, String> parentEntityIdsMapping) {
        QFilter bkeyf1 = new QFilter("endtime", "is null", null);
        Collection<String> businessKeys = parentEntityIdsMapping.values();
        QFilter bkeyf2 = new QFilter("businesskey", "in", businessKeys);
        DynamicObject[] checkEntitys = BusinessDataServiceHelper.load((String)"wf_hiprocinst", (String)"businesskey", (QFilter[])new QFilter[]{bkeyf1, bkeyf2});
        if (checkEntitys == null || checkEntitys.length == 0) {
            return;
        }
        for (DynamicObject checkEntity : checkEntitys) {
            String businessKey = checkEntity.getString("businesskey");
            parentEntityIdsMapping.values().removeIf(value -> value.equals(businessKey));
        }
    }

    private void saveArchiveLog(DynamicObject[] archiveLogs, Date targetDate, List<Long> entityIds) {
        DynamicObject targetArchiveLog = null;
        for (DynamicObject archiveLog : archiveLogs) {
            if (archiveLog.getDate("targetdate") != null || archiveLog.getDate("schenddate") != null) continue;
            targetArchiveLog = archiveLog;
            break;
        }
        if (targetArchiveLog != null) {
            targetArchiveLog.set("targetdate", (Object)targetDate);
            targetArchiveLog.set("resourceids", (Object)SerializationUtils.toJsonString(entityIds));
            SaveServiceHelper.save((DynamicObject[])archiveLogs);
        }
    }
}

