/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.message.archive.plugin;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.archive.api.dto.ArchiveDatabase;
import kd.bos.archive.api.dto.ScheduleResultInfo;
import kd.bos.archive.api.dto.TaskResultInfo;
import kd.bos.archive.task.resultnotify.mq.ArchiveResultBody;
import kd.bos.bill.BillShowParameter;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.operate.Delete;
import kd.bos.entity.operate.Donothing;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IConfirmCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.New;
import kd.bos.form.operate.formop.Refresh;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.message.archive.enumeration.MessageArchiveState;
import kd.bos.message.archive.service.ArchiveApiService;
import kd.bos.message.archive.service.MessageArchiveService;
import kd.bos.message.archive.utils.MessageArchiveUtil;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfUtils;

public class MessageArchiveListPlugin
extends AbstractListPlugin
implements IConfirmCallBack {
    private static Log logger = LogFactory.getLog(MessageArchiveListPlugin.class);
    private static final String ARCHIVEENTITY = "archiveEntity";
    private static final String REARCHIVE = "rearchive";
    private static final String DELETE = "delete";

    public void packageData(PackageDataEvent event) {
        DynamicObject rowData = event.getRowData();
        String progress = rowData.getString("progress");
        if (!progress.equals("0") && !progress.endsWith("%")) {
            rowData.set("progress", (Object)(progress + "%"));
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        ListSelectedRowCollection rows = ((ListView)this.getView()).getSelectedRows();
        if (REARCHIVE.equals(itemKey)) {
            this.rearchive(rows);
        }
    }

    private void rearchive(ListSelectedRowCollection rows) {
        if (rows == null || rows.size() != 1) {
            return;
        }
        Long archiveServiceId = (Long)rows.get(0).getPrimaryKeyValue();
        DynamicObject archiveService = BusinessDataServiceHelper.loadSingle((Object)archiveServiceId, (String)"wf_archiveservice");
        if (archiveService == null) {
            logger.debug(String.format("rearchive--query no service [%s]", archiveServiceId));
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u786e\u8ba4\u5f52\u6863\u670d\u52a1\u662f\u5426\u5b58\u5728\u3002", (String)"MessageArchiveListPlugin_2", (String)"bos-wf-archive", (Object[])new Object[0]), Integer.valueOf(3000));
            return;
        }
        String databaseZone = archiveService.getString("databasezone");
        ArchiveApiService archiveApiService = MessageArchiveService.create().getArchiveApiService();
        List<ArchiveDatabase> allDatabaseZones = archiveApiService.getAllDatabaseZones();
        if (allDatabaseZones == null || allDatabaseZones.isEmpty()) {
            logger.debug("rearchive--query databasezoneApi is empty");
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8c03\u7528\u63a5\u53e3\u83b7\u53d6\u5f52\u6863\u5e93\u6570\u636e\u5931\u8d25\u3002", (String)"MessageArchiveListPlugin_12", (String)"bos-wf-archive", (Object[])new Object[0]), Integer.valueOf(3000));
            return;
        }
        String archiveRouteKey = "";
        for (ArchiveDatabase archiveDatabase : allDatabaseZones) {
            if (!archiveDatabase.getNumber().equals(databaseZone)) continue;
            archiveRouteKey = archiveDatabase.getArchiveRouteKey();
            break;
        }
        if (WfUtils.isEmpty((String)archiveRouteKey)) {
            logger.debug(String.format("rearchive--not find target archiveDatabase[%s]", databaseZone));
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u786e\u8ba4\u5f52\u6863\u5e93\u662f\u5426\u5b58\u5728\u3002", (String)"MessageArchivePlugin_10", (String)"bos-wf-archive", (Object[])new Object[0]), Integer.valueOf(3000));
            return;
        }
        String archiveEntity = archiveService.getString("archiveentity");
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("wf_rearchive");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCustomParam("archiveServiceId", (Object)archiveServiceId);
        parameter.setCustomParam("archiveRouteKey", (Object)archiveRouteKey);
        parameter.setCustomParam("archiveentity", (Object)archiveEntity);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "rearchiveService"));
        this.getView().showForm(parameter);
    }

    public void listRowClick(ListRowClickEvent evt) {
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        Object source = args.getSource();
        if (source instanceof Refresh) {
            QFilter f1 = new QFilter("state", "=", (Object)MessageArchiveState.ARCHIVEING.getValue());
            DynamicObject[] archiveServices = BusinessDataServiceHelper.load((String)"wf_archiveservice", (String)"id,archiveentity", (QFilter[])new QFilter[]{f1});
            if (archiveServices == null || archiveServices.length == 0) {
                return;
            }
            HashMap<Long, String> archiveServiceMapping = new HashMap<Long, String>(archiveServices.length);
            for (DynamicObject archiveService : archiveServices) {
                archiveServiceMapping.put(archiveService.getLong("id"), archiveService.getString("archiveentity"));
            }
            Set entrySet = archiveServiceMapping.entrySet();
            for (Map.Entry entry : entrySet) {
                Long archiveServiceId = (Long)entry.getKey();
                String archiveEntity = (String)entry.getValue();
                this.updateArchiveServicePropress(archiveServiceId, archiveEntity);
            }
        } else if (source instanceof Donothing) {
            Long archiveServiceId;
            DynamicObject archiveService;
            ListSelectedRowCollection rows;
            Donothing donothing = (Donothing)source;
            String operateKey = donothing.getOperateKey();
            if ("deletearchive".equalsIgnoreCase(operateKey) && !(rows = ((ListView)this.getView()).getSelectedRows()).isEmpty() && (archiveService = BusinessDataServiceHelper.loadSingle((Object)(archiveServiceId = (Long)rows.get(0).getPrimaryKeyValue()), (String)"wf_archiveservice")) != null) {
                String state = archiveService.getString("state");
                if (!MessageArchiveState.ARCHIVEWILL.getValue().equals(state)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u5f52\u6863\u670d\u52a1\u4e0d\u53ef\u5220\u9664\u3002", (String)"MessageArchiveListPlugin_5", (String)"bos-wf-archive", (Object[])new Object[0]), Integer.valueOf(3000));
                } else {
                    String callBackId = String.format("deleteArchiveService-%s-%s", archiveServiceId, archiveService.getString("number"));
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u8bf7\u786e\u8ba4\u662f\u5426\u8981\u6267\u884c\u5f52\u6863\u670d\u52a1\u7684\u5220\u9664\u64cd\u4f5c\uff1f", (String)"MessageArchiveListPlugin_6", (String)"bos-wf-archive", (Object[])new Object[0]), MessageBoxOptions.OKCancel, ConfirmTypes.Delete, new ConfirmCallBackListener(callBackId));
                }
                args.setCancel(Boolean.TRUE.booleanValue());
            }
        } else if (source instanceof New) {
            String archiveEntity;
            if (!WfConfigurationUtil.isEnableArchive()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u524d\u5f80\u201c\u516c\u5171\u8bbe\u7f6e>\u53c2\u6570\u914d\u7f6e>\u7cfb\u7edf\u53c2\u6570>\u6d41\u7a0b\u670d\u52a1\u4e91\u201d\uff0c\u542f\u7528\u201c\u6d41\u7a0b\u5f52\u6863\u670d\u52a1\u201d\u53c2\u6570\u3002", (String)"MessageArchiveListPlugin_9", (String)"bos-wf-archive", (Object[])new Object[0]), Integer.valueOf(3000));
                args.setCancel(Boolean.TRUE.booleanValue());
                return;
            }
            Map customParams = this.getView().getFormShowParameter().getCustomParams();
            if (customParams.get(ARCHIVEENTITY) != null && "wf_hiprocinst".equals(archiveEntity = (String)customParams.get(ARCHIVEENTITY)) && !MessageArchiveUtil.isHistoricDataRepairDone().booleanValue()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5386\u53f2\u6570\u636e\u672a\u4fee\u590d\u6210\u529f\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"MessageArchiveListPlugin_10", (String)"bos-wf-archive", (Object[])new Object[0]), Integer.valueOf(3000));
                args.setCancel(Boolean.TRUE.booleanValue());
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if (MessageBoxResult.Yes == messageBoxClosedEvent.getResult() && callBackId.contains("deleteArchiveService")) {
            try {
                String[] infos = callBackId.split("-");
                Long archiveServiceId = Long.valueOf(infos[1]);
                DeleteServiceHelper.delete((String)"wf_archiveservice", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)archiveServiceId)});
                WfUtils.addOpLog((String)"wf_archiveservice", (String)"deletearchive", (String)ResManager.getLocaleString((String)"\u5220\u9664", (String)"MessageArchiveListPlugin_1", (String)"bos-wf-archive").getLocaleValue_zh_CN(), (MultiLangEnumBridge)new MultiLangEnumBridge("\u5f52\u6863\u670d\u52a1\u201c%s\u201d\u5220\u9664\u6210\u529f\u3002", "MessageArchiveListPlugin_8", "bos-wf-archive"), (Object[])new Object[]{infos[2]});
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u5f52\u6863\u670d\u52a1\u6210\u529f\u3002", (String)"MessageArchiveListPlugin_7", (String)"bos-wf-archive", (Object[])new Object[0]), Integer.valueOf(3000));
                ((ListView)this.getView()).refresh();
            }
            catch (Exception e) {
                logger.info(String.format("deleteArchive has error: %s", WfUtils.getExceptionStacktrace((Throwable)e)));
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        String returnData;
        JSONObject data;
        String actionId = evt.getActionId();
        if (actionId != null && "rearchiveService".equals(actionId) && evt.getReturnData() != null && (data = JSONObject.parseObject((String)(returnData = (String)evt.getReturnData()))).getBooleanValue("success")) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u53cd\u5f52\u6863\u64cd\u4f5c\u6267\u884c\u6210\u529f\uff0c\u8bf7\u5173\u6ce8\u6700\u7ec8\u7ed3\u679c\u3002", (String)"MessageRearchivePlugin_1", (String)"bos-wf-archive", (Object[])new Object[0]), Integer.valueOf(3000));
        }
    }

    private void updateArchiveServicePropress(Long archiveServiceId, String archiveEntity) {
        QFilter f2;
        ArrayList<Long> scheduleIds = new ArrayList<Long>();
        QFilter f1 = new QFilter("parentnumber", "=", (Object)" ").and("entitynumber", "=", (Object)archiveEntity);
        DynamicObject[] archiveCascades = BusinessDataServiceHelper.load((String)"bos_cbs_archi_cascade", (String)"number,joinfield", (QFilter[])new QFilter[]{f1.or(f2 = new QFilter("parentnumber", "=", (Object)archiveEntity))});
        if (archiveCascades == null || archiveCascades.length == 0) {
            return;
        }
        int archiveEntitySize = archiveCascades.length;
        StringBuilder sql = new StringBuilder();
        sql.append("select count(fentity) entityCount, fscheduleid scheduleid ");
        sql.append("from t_msg_archivelog where farchiveserviceid = ? ");
        sql.append("and ftargetdate is not null group by fscheduleid;");
        Object[] params = new Object[]{archiveServiceId};
        try (DataSet queryDataSet = DB.queryDataSet((String)"updateServicePropress", (DBRoute)DBRoute.workflow, (String)sql.toString(), (Object[])params);){
            for (Row row : queryDataSet) {
                Integer entityCount = row.getInteger("entityCount");
                Long scheduleId = row.getLong("scheduleid");
                if (entityCount == archiveEntitySize) continue;
                scheduleIds.add(scheduleId);
            }
        }
        catch (Exception e) {
            logger.info(String.format("refresh-hasError:[%s]", WfUtils.getExceptionStacktrace((Throwable)e)));
        }
        if (scheduleIds.isEmpty()) {
            return;
        }
        MessageArchiveService messageArchiveService = MessageArchiveService.create();
        ArchiveApiService archiveApiService = messageArchiveService.getArchiveApiService();
        List<ScheduleResultInfo> scheduleResultInfos = archiveApiService.getArchiveResult(scheduleIds);
        ArrayList<ArchiveResultBody> archiveResultBodies = new ArrayList<ArchiveResultBody>();
        for (ScheduleResultInfo scheduleResultInfo : scheduleResultInfos) {
            List taskResultInfos = scheduleResultInfo.getTaskResultInfoList();
            for (TaskResultInfo taskResultInfo : taskResultInfos) {
                String result = taskResultInfo.getResult();
                if (!"SUCCESS".equalsIgnoreCase(result) && !"FAILED".equalsIgnoreCase(result) && !"TERMINATED".equalsIgnoreCase(result)) continue;
                RequestContext requestContext = RequestContext.get();
                ArchiveResultBody archiveResultBody = new ArchiveResultBody(requestContext.getTenantId(), requestContext.getAccountId(), taskResultInfo.getEntityName(), taskResultInfo.getRootEntityName(), taskResultInfo.getResult(), taskResultInfo.getScheduleRcdId(), taskResultInfo.getTaskId(), taskResultInfo.getArchiveRoute(), taskResultInfo.getCount());
                archiveResultBodies.add(archiveResultBody);
            }
        }
        if (!archiveResultBodies.isEmpty()) {
            for (ArchiveResultBody archiveResultBody : archiveResultBodies) {
                messageArchiveService.analysisArchiveTaskResultInfo(archiveResultBody);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        Object source = args.getSource();
        OperationResult operationResult = args.getOperationResult();
        if (source instanceof Delete) {
            if (operationResult != null && operationResult.isSuccess()) {
                MessageArchiveUtil.operateScheduleJob();
                WfUtils.addOpLog((String)"wf_archiveservice", (String)"deletearchive", (String)ResManager.getLocaleString((String)"\u5220\u9664", (String)"MessageArchiveListPlugin_1", (String)"bos-wf-archive").getLocaleValue_zh_CN(), (MultiLangEnumBridge)new MultiLangEnumBridge("\u64cd\u4f5c\u6210\u529f\u3002", "MessageArchiveListPlugin_4", "bos-wf-archive"), (Object[])new Object[0]);
            }
        } else if (source instanceof New) {
            WfUtils.addOpLog((String)"wf_archiveservice", (String)"new", (String)ResManager.getLocaleString((String)"\u65b0\u589e", (String)"MessageArchiveListPlugin_11", (String)"bos-wf-archive").getLocaleValue_zh_CN(), (MultiLangEnumBridge)new MultiLangEnumBridge("\u64cd\u4f5c\u6210\u529f\u3002", "MessageArchiveListPlugin_4", "bos-wf-archive"), (Object[])new Object[0]);
        } else if (source instanceof Donothing && REARCHIVE.equals(args.getOperateKey())) {
            WfUtils.addOpLog((String)"wf_archiveservice", (String)REARCHIVE, (String)ResManager.getLocaleString((String)"\u53cd\u5f52\u6863", (String)"MessageArchiveListPlugin_3", (String)"bos-wf-archive").getLocaleValue_zh_CN(), (MultiLangEnumBridge)new MultiLangEnumBridge("\u64cd\u4f5c\u6210\u529f\u3002", "MessageArchiveListPlugin_4", "bos-wf-archive"), (Object[])new Object[0]);
        }
    }

    private void showArchiveServiceLog(Long archiverServiceId) {
        String userId = RequestContext.get().getUserId();
        String pageId = "wf_archiveservice_" + archiverServiceId + "_" + userId;
        IFormView openView = this.getView().getViewNoPlugin(pageId);
        if (openView != null) {
            openView.activate();
            this.getView().sendFormAction(openView);
            return;
        }
        ListShowParameter parameter = new ListShowParameter();
        parameter.setBillFormId("wf_archivelog");
        parameter.setFormId("bos_list");
        parameter.setCaption(ResManager.loadKDString((String)"\u5f52\u6863\u670d\u52a1\u8c03\u5ea6\u65e5\u5fd7", (String)"MessageArchiveListPlugin_0", (String)"bos-wf-archive", (Object[])new Object[0]));
        ListFilterParameter listFilterParameter = new ListFilterParameter();
        listFilterParameter.setFilter(new QFilter("archiveserviceid", "=", (Object)archiverServiceId));
        parameter.setListFilterParameter(listFilterParameter);
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        parameter.setPageId(pageId);
        this.getView().showForm((FormShowParameter)parameter);
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        super.billListHyperLinkClick(args);
        HyperLinkClickEvent evt = args.getHyperLinkClickEvent();
        if ("failreason".equals(evt.getFieldName())) {
            ListSelectedRowCollection listSelectedRowCollection = ((BillList)args.getHyperLinkClickEvent().getSource()).getSelectedRows();
            Long archiverServiceId = (Long)listSelectedRowCollection.get(0).getPrimaryKeyValue();
            this.showArchiveServiceLog(archiverServiceId);
            args.setCancel(true);
        }
    }

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (customParams != null && customParams.get(ARCHIVEENTITY) != null) {
            BillShowParameter parameter = e.getParameter();
            parameter.getOpenStyle().setShowType(ShowType.Modal);
            parameter.setCustomParam("archiveentity", customParams.get(ARCHIVEENTITY));
        }
    }
}

