/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.message.archive.plugin;

import java.util.ArrayList;
import kd.bos.bec.engine.utils.StandardTips;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.message.archive.enumeration.ArchiveScheduleLogState;
import kd.bos.message.archive.service.ArchiveApiService;
import kd.bos.message.archive.service.MessageArchiveService;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.workflow.engine.WfUtils;

public class MessageArchiveLogListPlugin
extends AbstractListPlugin {
    private static Log logger = LogFactory.getLog(MessageArchiveLogListPlugin.class);
    private static final String STATE = "state";
    private static final String RETRY = "retry";
    private static final String QUERYLOG = "querylog";
    private static final String RETURNDATA = "returndata";

    public void itemClick(ItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        ListSelectedRowCollection rows = ((ListView)this.getView()).getSelectedRows();
        switch (itemKey) {
            case "retry": {
                this.retryArchiveTask(rows);
                break;
            }
            case "querylog": {
                this.showArchiveTaskLog(rows);
                break;
            }
            case "returndata": {
                this.returnEntityResourceIds(rows);
                break;
            }
        }
    }

    public void listRowClick(ListRowClickEvent evt) {
    }

    private void retryArchiveTask(ListSelectedRowCollection rows) {
        if (rows == null || rows.size() != 1) {
            StandardTips.view((IFormView)this.getView()).notSelectRow();
            return;
        }
        try {
            Long archiveLogId = (Long)rows.get(0).getPrimaryKeyValue();
            QFilter[] filters = new QFilter[]{new QFilter("id", "=", (Object)archiveLogId)};
            DynamicObject archiveLog = BusinessDataServiceHelper.loadSingle((String)"wf_archivelog", (String)"taskid,state", (QFilter[])filters);
            String state = archiveLog.getString(STATE);
            if (WfUtils.isNotEmpty((String)state) && ArchiveScheduleLogState.SUCCESS.getValue().equals(state)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8c03\u5ea6\u4efb\u52a1\u5df2\u6210\u529f\u5b8c\u6210\uff0c\u65e0\u9700\u91cd\u8bd5\u3002", (String)"MessageArchiveLogListPlugin_5", (String)"bos-wf-archive", (Object[])new Object[0]), Integer.valueOf(3000));
                return;
            }
            ArchiveApiService archiveApiService = MessageArchiveService.create().getArchiveApiService();
            archiveApiService.retryArchiveScheduleByTask(archiveLog.getLong("taskid"));
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u6267\u884c\u6210\u529f\uff0c\u8bf7\u5173\u6ce8\u91cd\u8bd5\u7ed3\u679c\u3002", (String)"MessageArchiveLogListPlugin_3", (String)"bos-wf-archive", (Object[])new Object[0]), Integer.valueOf(3000));
            WfUtils.addOpLog((String)"wf_archivelog", (String)RETRY, (MultiLangEnumBridge)new MultiLangEnumBridge("\u91cd\u8bd5", "MessageArchiveLogListPlugin_6", "bos-wf-archive"), (MultiLangEnumBridge)new MultiLangEnumBridge("\u64cd\u4f5c\u6210\u529f\u3002", "MessageArchiveListPlugin_4", "bos-wf-archive"), (Object[])new Object[0]);
        }
        catch (Exception e) {
            this.getView().showErrorNotification(e.getMessage());
            logger.warn(String.format("messageArchiveLog retry schedule task error [%s]", WfUtils.getExceptionStacktrace((Throwable)e)));
        }
    }

    private void showArchiveTaskLog(ListSelectedRowCollection rows) {
        if (rows == null || rows.isEmpty()) {
            StandardTips.view((IFormView)this.getView()).notSelectRow();
            return;
        }
        DynamicObject[] archiveLogs = this.getArchiveScheduleLogs(rows);
        if (archiveLogs != null && archiveLogs.length > 0) {
            ArrayList<Long> taskIds = new ArrayList<Long>(archiveLogs.length);
            for (DynamicObject archiveLog : archiveLogs) {
                taskIds.add(archiveLog.getLong("taskid"));
            }
            ListShowParameter parameter = new ListShowParameter();
            parameter.setBillFormId("bos_cbs_archi_log");
            parameter.getOpenStyle().setShowType(ShowType.NewTabPage);
            parameter.getOpenStyle().setTargetKey("_submaintab_");
            parameter.setHasRight(Boolean.TRUE.booleanValue());
            parameter.setCaption(ResManager.loadKDString((String)"\u5f52\u6863\u670d\u52a1\u4efb\u52a1\u65e5\u5fd7", (String)"MessageArchiveLogListPlugin_2", (String)"bos-wf-archive", (Object[])new Object[0]));
            ListFilterParameter listFilterParameter = new ListFilterParameter();
            listFilterParameter.setFilter(new QFilter("task", "in", taskIds));
            parameter.setListFilterParameter(listFilterParameter);
            IFormView parentView = this.getView().getParentView();
            parentView.showForm((FormShowParameter)parameter);
            this.getView().sendFormAction(parentView);
        }
    }

    private void returnEntityResourceIds(ListSelectedRowCollection rows) {
        ArrayList resourceIds = null;
        if (rows == null || rows.isEmpty()) {
            StandardTips.view((IFormView)this.getView()).notSelectRow();
            return;
        }
        DynamicObject[] archiveLogs = this.getArchiveScheduleLogs(rows);
        if (archiveLogs != null && archiveLogs.length > 0) {
            resourceIds = new ArrayList(archiveLogs.length);
            for (DynamicObject archiveLog : archiveLogs) {
                String ids = archiveLog.getString("resourceids");
                if (!WfUtils.isNotEmpty((String)ids)) continue;
                resourceIds.addAll(SerializationUtils.fromJsonStringToList((String)ids, Object.class));
            }
        }
        String totalResourceIds = null;
        if (resourceIds != null) {
            totalResourceIds = SerializationUtils.toJsonString(resourceIds);
        }
        this.getView().returnDataToParent((Object)totalResourceIds);
        this.getView().close();
    }

    private DynamicObject[] getArchiveScheduleLogs(ListSelectedRowCollection rows) {
        ArrayList<Long> archiveLogIds = new ArrayList<Long>(rows.size());
        for (ListSelectedRow row : rows) {
            archiveLogIds.add((Long)row.getPrimaryKeyValue());
        }
        QFilter[] filters = new QFilter[]{new QFilter("id", "in", archiveLogIds)};
        return BusinessDataServiceHelper.load((String)"wf_archivelog", (String)"taskid,resourceids", (QFilter[])filters);
    }
}

