/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.message.archive.plugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IConfirmCallBack;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.workflow.engine.WfUtils;

public class MessageArchiveMsgPlugin
extends AbstractFormPlugin
implements ClickListener,
IConfirmCallBack {
    private static final String MSGTTITLECONTENT = "msgtitlecontent";
    private static final String MSGCHANNLES = "msgchannels";
    private static final String MSGRECEIVERS = "msgreceives";
    private static final String WF_MSGCONTENT = "wf_msgcontent";
    private static final String ARCHIVEMSGCALLBACKID = "archiveMsgCallBack";
    public static final String KEY_CHANNELS = "msgChannels";
    public static final String KEY_RECEIVERS = "msgReceivers";
    public static final String KEY_CONTENT = "titleContent";
    public static final String KEY_BASEDATAID = "fbasedataid";
    public static final String MCENTER = "mcenter";
    private static final String BTNOK = "ok";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{MSGTTITLECONTENT, BTNOK});
    }

    public void afterCreateNewData(EventObject e) {
        this.initMsgChannles();
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Object msgData = formShowParameter.getCustomParam("msgData");
        if (msgData != null && WfUtils.isNotEmpty((String)((String)msgData))) {
            Object receivers;
            Map data = (Map)SerializationUtils.fromJsonString((String)((String)msgData), Map.class);
            IDataModel model = this.getModel();
            String titleContent = (String)data.get(KEY_CONTENT);
            model.setValue(MSGTTITLECONTENT, (Object)titleContent);
            String channels = (String)data.get(KEY_CHANNELS);
            if (!channels.equals(MCENTER)) {
                model.setValue(MSGCHANNLES, (Object)channels);
            }
            if ((receivers = data.get(KEY_RECEIVERS)) != null) {
                List rs = (List)receivers;
                ArrayList userIds = new ArrayList(rs.size());
                for (Map map : rs) {
                    Map basedataMap = (Map)map.get(KEY_BASEDATAID);
                    userIds.add(basedataMap.get("id"));
                }
                model.setValue(MSGRECEIVERS, (Object)userIds.toArray());
            }
        }
    }

    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        String controlKey = control.getKey();
        if (MSGTTITLECONTENT.equals(controlKey)) {
            FormShowParameter formShowParameter = this.getView().getFormShowParameter();
            Object msgData = formShowParameter.getCustomParam("msgData");
            String titleContent = "";
            if (msgData != null && WfUtils.isNotEmpty((String)((String)msgData))) {
                Map data = (Map)SerializationUtils.fromJsonString((String)((String)msgData), Map.class);
                titleContent = (String)data.get(KEY_CONTENT);
            }
            FormShowParameter parameter = new FormShowParameter();
            parameter.getOpenStyle().setShowType(ShowType.Modal);
            parameter.setFormId(WF_MSGCONTENT);
            parameter.setCaption(ResManager.loadKDString((String)"\u5f52\u6863\u6d88\u606f\u5185\u5bb9", (String)"MessageArchiveMsgPlugin_0", (String)"bos-wf-archive", (Object[])new Object[0]));
            parameter.setCustomParam("entityNumber", (Object)"wf_archiveservice");
            parameter.setCustomParam("FROM", (Object)"task");
            parameter.setCustomParam("value", (Object)titleContent);
            parameter.setCustomParam("showTitle", (Object)Boolean.TRUE);
            parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, ARCHIVEMSGCALLBACKID));
            this.getView().showForm(parameter);
        } else if (BTNOK.equals(controlKey)) {
            Object receivers;
            IDataModel model = this.getModel();
            Object channels = model.getValue(MSGCHANNLES);
            if (channels == null) {
                channels = MCENTER;
            }
            if ((receivers = model.getValue(MSGRECEIVERS)) == null || ((MulBasedataDynamicObjectCollection)receivers).isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u201c\u6d88\u606f\u63a5\u6536\u4eba\u201d\u3002", (String)"MessageArchiveMsgPlugin_2", (String)"bos-wf-archive", (Object[])new Object[0]), Integer.valueOf(3000));
                return;
            }
            Object content = model.getValue(MSGTTITLECONTENT);
            if (content == null || WfUtils.isEmpty((String)((String)content))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u6d88\u606f\u5185\u5bb9\u201d\u3002", (String)"MessageArchiveMsgPlugin_3", (String)"bos-wf-archive", (Object[])new Object[0]), Integer.valueOf(3000));
                return;
            }
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put(KEY_CHANNELS, channels);
            data.put(KEY_RECEIVERS, receivers);
            data.put(KEY_CONTENT, content);
            this.getView().returnDataToParent((Object)SerializationUtils.toJsonString(data));
            this.getView().close();
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        Object returnData;
        String actionId = evt.getActionId();
        if (actionId != null && ARCHIVEMSGCALLBACKID.equals(actionId) && (returnData = evt.getReturnData()) != null) {
            this.getModel().setValue(MSGTTITLECONTENT, (Object)SerializationUtils.toJsonString((Object)returnData));
        }
    }

    private void initMsgChannles() {
        QFilter[] filters = new QFilter[]{new QFilter("enable", "=", (Object)"1")};
        DynamicObject[] channels = BusinessDataServiceHelper.load((String)"msg_channel", (String)"number,name", (QFilter[])filters);
        if (channels != null && channels.length > 0) {
            ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(channels.length);
            for (DynamicObject channle : channels) {
                String number = channle.getString("number");
                if ("sysnotice".equals(number)) continue;
                ILocaleString nameOrm = channle.getLocaleString("name");
                LocaleString name = new LocaleString();
                Set entrys = nameOrm.entrySet();
                for (Map.Entry entry : entrys) {
                    name.setItem((String)entry.getKey(), entry.getValue());
                }
                comboItems.add(new ComboItem(name, number));
            }
            ((ComboEdit)this.getControl(MSGCHANNLES)).setComboItems(comboItems);
        }
    }
}

