/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.message.archive.plugin;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.archive.api.dto.ArchiveDatabase;
import kd.bos.archive.api.dto.McDatabase;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Save;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IConfirmCallBack;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.message.archive.enumeration.MessageArchiveState;
import kd.bos.message.archive.model.EntitySummaryInfo;
import kd.bos.message.archive.model.PredictArchiveInfo;
import kd.bos.message.archive.service.ArchiveApiService;
import kd.bos.message.archive.service.MessageArchiveService;
import kd.bos.message.archive.utils.MessageArchiveUtil;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.workflow.engine.WfUtils;

public class MessageArchivePlugin
extends AbstractFormPlugin
implements ClickListener,
ItemClickListener,
IConfirmCallBack {
    private static Log logger = LogFactory.getLog(MessageArchivePlugin.class);
    public static final String NUMBER = "number";
    public static final String DATABASE = "database";
    public static final String DATABASEZONE = "databasezone";
    public static final String DATABASEZONENAME = "dbzonename";
    public static final String ARCHIVEENTITY = "archiveentity";
    private static final String STARTDATE = "startdate";
    private static final String ENDDATE = "enddate";
    private static final String ARCHIVEDATARANGE = "archivedatarange";
    public static final String ARCHIVEDATARANGELIST = "archivedaterangelist";
    public static final String ARCHSTATRDATE = "archstartdate";
    public static final String ARCHENDDATE = "archenddate";
    public static final String ARCHPLANSTARTDATE = "archplanstartdate";
    public static final String ALLDTAASUM = "alldatasum";
    public static final String PREDICTTIME = "predicttime";
    public static final String PROPRESS = "progress";
    public static final String FAILREASON = "failreason";
    public static final String ARCHIVEDETAIL = "archivedetail";
    public static final String ENTITYNAME = "entityname";
    public static final String ENTITYNUMBER = "entitynumber";
    public static final String ENTITYCHAIVESUM = "entityarchivesum";
    public static final String ENTRYDATERANGE = "entrydaterange";
    public static final String SCHEDULESIZE = "schedulesize";
    public static final String ARCHIVEMSG = "archivemsg";
    public static final String AECHIVESTATE = "state";
    public static final String ARCHIVESERVICESTARTDATE = "archservicestartdate";
    public static final String ARCHIVESERVICEENDDATE = "archserviceenddate";
    public static final String ARCHIVETOTALSUM = "scheduletotalsum";
    private static final String ARCHIVEDATASCAN = "archivedatascan";
    private static final String CANCLE = "cancle";
    private static final String SAVE = "save";
    private static final String ADDDBZONE = "adddbzone";
    private static final String ADDDBZONEFLEX = "flexaddzone";
    private static final String FLEXPANELAP61 = "flexpanelap61";
    private static final String FLEXPANELAP6 = "flexpanelap6";
    private static final String LABEL_NODB = "lable_nodb";
    private static final String SERVCIENUMBE_PART = "MSG_ARCHIVE_";
    private static final String WF_ARCHIVESERVICEMSG = "wf_archiveservicemsg";
    private static final String ARCHIVEMSGCALLBACKID = "archiveMsgCallBack";
    private static final String ADDDBZONECALLBACKID = "addDatabaseZoneMsgCallBack";
    private static final String CUSTOMDBZONE = "addCustomDbZone";
    public static final String MSGDATA = "msgData";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{ARCHIVEDATASCAN, CANCLE, SAVE, ARCHIVEMSG, ADDDBZONE});
    }

    private void showMsgContentPage() {
        String archiveMsg = (String)this.getModel().getValue(ARCHIVEMSG);
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setFormId(WF_ARCHIVESERVICEMSG);
        parameter.setCaption(ResManager.loadKDString((String)"\u5f52\u6863\u6d88\u606f", (String)"MessageArchivePlugin_0", (String)"bos-wf-archive", (Object[])new Object[0]));
        parameter.setCustomParam("entityNumber", (Object)"wf_archiveservice");
        parameter.setCustomParam(MSGDATA, (Object)archiveMsg);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, ARCHIVEMSGCALLBACKID));
        this.getView().showForm(parameter);
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        Object returnData;
        String actionId = evt.getActionId();
        if (actionId != null && ARCHIVEMSGCALLBACKID.equals(actionId)) {
            Object returnData2 = evt.getReturnData();
            if (returnData2 != null) {
                this.getModel().setValue(ARCHIVEMSG, returnData2);
            }
        } else if (actionId != null && ADDDBZONECALLBACKID.equals(actionId) && (returnData = evt.getReturnData()) != null) {
            String items = this.getPageCache().get(DATABASEZONE);
            ArrayList<ComboItem> dbZoneItems = new ArrayList<ComboItem>();
            Map cache = new HashMap<String, String>();
            if (WfUtils.isNotEmpty((String)items)) {
                cache = (Map)SerializationUtils.fromJsonString((String)items, Map.class);
                Set entrySet = cache.entrySet();
                for (Map.Entry entry : entrySet) {
                    String key = (String)entry.getKey();
                    if (CUSTOMDBZONE.equals(key)) continue;
                    String value = (String)entry.getValue();
                    LocaleString caption = new LocaleString(value);
                    dbZoneItems.add(new ComboItem(caption, key));
                }
            }
            String rd = (String)returnData;
            cache.put(CUSTOMDBZONE, rd);
            this.getPageCache().put(DATABASEZONE, SerializationUtils.toJsonString(cache));
            LocaleString caption = new LocaleString(rd);
            dbZoneItems.add(new ComboItem(caption, CUSTOMDBZONE));
            ((ComboEdit)this.getControl(DATABASEZONE)).setComboItems(dbZoneItems);
            this.getModel().setValue(DATABASEZONE, (Object)CUSTOMDBZONE);
            this.getModel().setValue(DATABASEZONENAME, (Object)caption);
        }
    }

    public void click(EventObject evt) {
        String controlKey;
        Control control = (Control)evt.getSource();
        switch (controlKey = control.getKey()) {
            case "archivedatascan": {
                this.showArchiveDataDetail();
                break;
            }
            case "archivemsg": {
                this.showMsgContentPage();
                break;
            }
            case "adddbzone": {
                this.showAddDbZone();
                break;
            }
            case "cancle": {
                break;
            }
            case "save": {
                break;
            }
        }
    }

    private void showAddDbZone() {
        Object baseData = this.getModel().getValue(DATABASE);
        if (baseData == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u201c\u7269\u7406\u5e93\u201d\u3002", (String)"MessageArchivePlugin_4", (String)"bos-wf-archive", (Object[])new Object[0]), Integer.valueOf(3000));
            return;
        }
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setFormId("wf_archivedbzone");
        parameter.setCaption(ResManager.loadKDString((String)"\u65b0\u589e\u5f52\u6863\u5e93", (String)"MessageArchivePlugin_5", (String)"bos-wf-archive", (Object[])new Object[0]));
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, ADDDBZONECALLBACKID));
        this.getView().showForm(parameter);
    }

    private void showArchiveDataDetail() {
        int ed;
        Object value = this.getModel().getValue(ARCHIVEENTITY);
        if (value == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u5f52\u6863\u5b9e\u4f53\u201d\u3002", (String)"MessageArchivePlugin_1", (String)"bos-wf-archive", (Object[])new Object[0]), Integer.valueOf(3000));
            return;
        }
        String startDate = (String)this.getModel().getValue(ARCHSTATRDATE);
        String endDate = (String)this.getModel().getValue(ARCHENDDATE);
        if (WfUtils.isEmpty((String)startDate) || WfUtils.isEmpty((String)endDate)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u5f52\u6863\u6570\u636e\u65f6\u95f4\u8303\u56f4\u201d\u3002", (String)"MessageArchivePlugin_2", (String)"bos-wf-archive", (Object[])new Object[0]), Integer.valueOf(3000));
            return;
        }
        int sd = Integer.parseInt(startDate);
        if (sd > (ed = Integer.parseInt(endDate))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u9009\u62e9\u201c\u5f52\u6863\u6570\u636e\u65f6\u95f4\u8303\u56f4\u201d\u3002", (String)"MessageArchivePlugin_3", (String)"bos-wf-archive", (Object[])new Object[0]), Integer.valueOf(3000));
            return;
        }
        IDataModel model = this.getModel();
        int scheduleSize = (Integer)model.getValue(SCHEDULESIZE);
        Map<String, Date> archiveDates = MessageArchiveUtil.getArchiveDates(sd, ed);
        Date archiveStartDate = archiveDates.get("startDate");
        Date archiveEndDate = archiveDates.get("endDate");
        String archiveEntity = (String)value;
        MessageArchiveService messageArchiveService = MessageArchiveService.create();
        List<EntitySummaryInfo> entitySummaryInfos = messageArchiveService.getArchiveEntityData(archiveEntity, archiveStartDate, archiveEndDate);
        PredictArchiveInfo predictData = MessageArchiveUtil.getPredictArchiveData(entitySummaryInfos, archiveEntity, scheduleSize);
        if (entitySummaryInfos != null && !entitySummaryInfos.isEmpty()) {
            model.deleteEntryData(ARCHIVEDETAIL);
            for (int i = 0; i < entitySummaryInfos.size(); ++i) {
                this.wrapArchiveEntryData(entitySummaryInfos.get(i), i);
            }
        }
        double archiveSummary = predictData.getPredictSummary();
        model.setValue(ALLDTAASUM, (Object)archiveSummary);
        double predictTime = predictData.getPredictTime();
        model.setValue(PREDICTTIME, (Object)predictTime);
        logger.info(String.format("alldatasum-%s, predicttime-%s, [save]", archiveSummary, predictTime));
    }

    private void wrapArchiveEntryData(EntitySummaryInfo entitySummaryInfo, int i) {
        IDataModel model = this.getModel();
        model.createNewEntryRow(ARCHIVEDETAIL);
        model.setValue(ENTITYNAME, (Object)entitySummaryInfo.getName(), i);
        model.setValue(ENTITYNUMBER, (Object)entitySummaryInfo.getNumber(), i);
        model.setValue(ENTITYCHAIVESUM, (Object)entitySummaryInfo.getArchiveSummary(), i);
        model.setValue(ENTRYDATERANGE, model.getValue(ARCHIVEDATARANGELIST), i);
    }

    private Boolean verifyNecessaryData() {
        OperationStatus status;
        boolean lostNecessaryData = Boolean.TRUE;
        IDataModel model = this.getModel();
        Object database = model.getValue(DATABASE);
        if (database == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u201c\u5f52\u6863\u7269\u7406\u5e93\u201d\u3002", (String)"MessageArchivePlugin_6", (String)"bos-wf-archive", (Object[])new Object[0]), Integer.valueOf(3000));
            return lostNecessaryData;
        }
        Object databaseZone = model.getValue(DATABASEZONE);
        if (databaseZone == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u201c\u5f52\u6863\u5e93\u201d\u3002", (String)"MessageArchivePlugin_7", (String)"bos-wf-archive", (Object[])new Object[0]), Integer.valueOf(3000));
            return lostNecessaryData;
        }
        Object archiveServiceStartDate = model.getValue(ARCHPLANSTARTDATE);
        if (archiveServiceStartDate == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u5f52\u6863\u670d\u52a1\u5f00\u59cb\u65f6\u95f4\u201d\u3002", (String)"MessageArchivePlugin_8", (String)"bos-wf-archive", (Object[])new Object[0]), Integer.valueOf(3000));
            return lostNecessaryData;
        }
        String archiveStartDate = (String)model.getValue(ARCHSTATRDATE);
        String archiveEndDate = (String)model.getValue(ARCHENDDATE);
        if (WfUtils.isEmpty((String)archiveStartDate) || WfUtils.isEmpty((String)archiveEndDate)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u201c\u5f52\u6863\u6570\u636e\u65f6\u95f4\u8303\u56f4\u201d\u3002", (String)"MessageArchivePlugin_9", (String)"bos-wf-archive", (Object[])new Object[0]), Integer.valueOf(3000));
            return lostNecessaryData;
        }
        if (!CUSTOMDBZONE.equals((String)databaseZone)) {
            ArchiveApiService archiveApiService = MessageArchiveService.create().getArchiveApiService();
            List<ArchiveDatabase> archiveDatabases = archiveApiService.getAllDatabaseZones();
            boolean databaseZoneExist = Boolean.FALSE;
            if (archiveDatabases != null && !archiveDatabases.isEmpty()) {
                for (ArchiveDatabase archiveDB : archiveDatabases) {
                    if (!archiveDB.getNumber().equals(databaseZone) || !archiveDB.getDatabase().equals(database)) continue;
                    databaseZoneExist = Boolean.TRUE;
                    break;
                }
            }
            if (!databaseZoneExist) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u786e\u8ba4\u5f52\u6863\u5e93\u662f\u5426\u5b58\u5728\u3002", (String)"MessageArchivePlugin_10", (String)"bos-wf-archive", (Object[])new Object[0]), Integer.valueOf(3000));
                return lostNecessaryData;
            }
        }
        if ((status = this.getView().getFormShowParameter().getStatus()) == OperationStatus.ADDNEW) {
            String archiveServiceNumber = (String)model.getValue(NUMBER);
            boolean matchPattern = MessageArchiveUtil.matchPattern("^[\\w]+$", archiveServiceNumber);
            if (!matchPattern) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f52\u6863\u670d\u52a1\u7f16\u7801\u53ea\u80fd\u82f1\u6587\u5b57\u6bcd\u3001\u6570\u5b57\u548c\u4e0b\u5212\u7ebf\u7684\u7ec4\u5408\u65b9\u5f0f\uff0c\u8bf7\u8c03\u6574\u540e\u518d\u4fdd\u5b58\u3002", (String)"MessageArchivePlugin_11", (String)"bos-wf-archive", (Object[])new Object[0]), Integer.valueOf(3000));
                return lostNecessaryData;
            }
            QFilter[] filters = new QFilter[]{new QFilter(NUMBER, "=", (Object)archiveServiceNumber)};
            boolean exists = QueryServiceHelper.exists((String)"wf_archiveservice", (QFilter[])filters);
            if (exists) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u7f16\u7801\u201d\u5df2\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u586b\u5199\u3002", (String)"MessageArchivePlugin_12", (String)"bos-wf-archive", (Object[])new Object[0]), Integer.valueOf(3000));
                return lostNecessaryData;
            }
        }
        return !lostNecessaryData;
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        Object source = args.getSource();
        if (!(source instanceof Save)) {
            return;
        }
        Boolean lostNecessaryData = this.verifyNecessaryData();
        if (lostNecessaryData.booleanValue()) {
            args.setCancel(Boolean.TRUE.booleanValue());
            return;
        }
        this.binddataBeforeSave();
    }

    private void binddataBeforeSave() {
        Object databaseZone;
        DynamicObjectCollection entryEntity;
        Object archiveDateRange;
        Object propress;
        IDataModel model = this.getModel();
        Object archiveState = model.getValue(AECHIVESTATE);
        if (archiveState == null) {
            model.setValue(AECHIVESTATE, (Object)MessageArchiveState.ARCHIVEWILL.getValue());
        }
        if ((propress = model.getValue(PROPRESS)) == null || WfUtils.isEmpty((String)((String)propress))) {
            model.setValue(PROPRESS, (Object)"0");
        }
        if ((archiveDateRange = model.getValue(ARCHIVEDATARANGELIST)) == null || WfUtils.isEmpty((String)((String)archiveDateRange))) {
            String archiveStartDate = (String)model.getValue(ARCHSTATRDATE);
            String archiveEndDate = (String)model.getValue(ARCHENDDATE);
            String dateRange = archiveStartDate + " ~ " + archiveEndDate;
            model.setValue(ARCHIVEDATARANGELIST, (Object)dateRange);
        }
        if ((entryEntity = model.getEntryEntity(ARCHIVEDETAIL)) == null || entryEntity.isEmpty()) {
            this.showArchiveDataDetail();
        }
        if ((databaseZone = this.getModel().getValue(DATABASEZONE)) != null && CUSTOMDBZONE.equals((String)databaseZone)) {
            String database = (String)this.getModel().getValue(DATABASE);
            ArchiveApiService archiveApiService = MessageArchiveService.create().getArchiveApiService();
            OrmLocaleValue name = (OrmLocaleValue)this.getModel().getValue(DATABASEZONENAME);
            ArchiveDatabase archiveDatabase = archiveApiService.addDatabaseZone(name.getDefaultItem(), database, "wf_archives_dbgroup");
            databaseZone = archiveDatabase.getNumber();
            this.getModel().setValue(DATABASEZONE, databaseZone);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        Object source = args.getSource();
        OperationResult operationResult = args.getOperationResult();
        if (source instanceof Save && operationResult != null && operationResult.isSuccess()) {
            MessageArchiveUtil.operateScheduleJob();
            WfUtils.addOpLog((String)"wf_archiveservice", (String)SAVE, (String)ResManager.getLocaleString((String)"\u4fdd\u5b58", (String)"MessageArchivePlugin_15", (String)"bos-wf-archive").getLocaleValue_zh_CN(), (MultiLangEnumBridge)new MultiLangEnumBridge("\u64cd\u4f5c\u6210\u529f\u3002", "MessageArchiveListPlugin_4", "bos-wf-archive"), (Object[])new Object[0]);
        }
    }

    public void beforeClosed(BeforeClosedEvent event) {
        IPageCache pageCache = this.getPageCache();
        if (pageCache.get(DATABASEZONE) != null) {
            pageCache.remove(DATABASEZONE);
        }
    }

    public void afterCreateNewData(EventObject e) {
        String number = "";
        QFilter[] filters = new QFilter[]{new QFilter(NUMBER, "like", (Object)"MSG_ARCHIVE_%")};
        DynamicObjectCollection archiveServices = QueryServiceHelper.query((String)"wf_archiveservice", (String)NUMBER, (QFilter[])filters);
        if (archiveServices != null && !archiveServices.isEmpty()) {
            Collections.sort(archiveServices, new Comparator<DynamicObject>(){

                @Override
                public int compare(DynamicObject d1, DynamicObject d2) {
                    String number1 = d1.getString(MessageArchivePlugin.NUMBER);
                    String number2 = d2.getString(MessageArchivePlugin.NUMBER);
                    return number2.compareTo(number1);
                }
            });
            String sn = ((DynamicObject)archiveServices.get(0)).getString(NUMBER);
            try {
                int seq = Integer.parseInt(sn.split(SERVCIENUMBE_PART)[1]);
                number = SERVCIENUMBE_PART + (seq + 1);
            }
            catch (Exception e2) {
                number = SERVCIENUMBE_PART;
            }
        } else {
            number = "MSG_ARCHIVE_1";
        }
        this.getModel().setValue(NUMBER, (Object)number);
    }

    public void afterBindData(EventObject e) {
        this.initArchiveEntity();
        this.initArchieDateRange();
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        if (status == OperationStatus.EDIT || status == OperationStatus.VIEW) {
            this.initDatabase();
            this.initDatabaseZone();
            this.getView().setVisible(Boolean.TRUE, new String[]{FLEXPANELAP61});
            this.getView().setVisible(Boolean.FALSE, new String[]{FLEXPANELAP6});
            String archiveState = (String)this.getModel().getValue(AECHIVESTATE);
            if (!archiveState.equals(MessageArchiveState.ARCHIVEWILL.getValue())) {
                this.getView().setEnable(Boolean.FALSE, new String[]{ARCHIVEENTITY, DATABASE, DATABASEZONE, ARCHIVEDATARANGE, ARCHPLANSTARTDATE, ARCHSTATRDATE, ARCHENDDATE, ADDDBZONE, ADDDBZONEFLEX, "adddbzone1"});
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{FLEXPANELAP61});
                this.getView().setVisible(Boolean.TRUE, new String[]{FLEXPANELAP6});
            }
            if (archiveState.equals(MessageArchiveState.ARCHIVEING.getValue()) || archiveState.equals(MessageArchiveState.ARCHIVEFAIL.getValue())) {
                this.getView().setEnable(Boolean.FALSE, new String[]{ARCHIVEDATASCAN});
            }
            if (archiveState.equals(MessageArchiveState.ARCHIVEOK.getValue())) {
                this.getView().setEnable(Boolean.FALSE, new String[]{ARCHIVEDATASCAN, SCHEDULESIZE, ARCHIVEMSG, SAVE});
            }
        } else {
            this.initArchiveMsg();
            this.getView().setVisible(Boolean.FALSE, new String[]{FLEXPANELAP61});
            this.getView().setVisible(Boolean.TRUE, new String[]{FLEXPANELAP6});
        }
    }

    private void initArchiveMsg() {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("msgChannels", "mcenter");
        HashMap<String, Long> rs = new HashMap<String, Long>();
        rs.put("id", Long.valueOf(RequestContext.get().getUserId()));
        HashMap<String, HashMap<String, Long>> m = new HashMap<String, HashMap<String, Long>>();
        m.put("fbasedataid", rs);
        ArrayList<HashMap<String, HashMap<String, Long>>> receivers = new ArrayList<HashMap<String, HashMap<String, Long>>>();
        receivers.add(m);
        data.put("msgReceivers", receivers);
        HashMap content = new HashMap();
        HashMap<String, String> msgTitle = new HashMap<String, String>();
        LocaleString titleLocaleString = ResManager.getLocaleString((String)"\u5f52\u6863\u670d\u52a1\u901a\u77e5", (String)"MessageArchivePlugin_13", (String)"bos-wf-archive");
        msgTitle.put("zh_CN", titleLocaleString.getLocaleValue_zh_CN());
        HashMap<String, String> msgContent = new HashMap<String, String>();
        LocaleString contentLocaleString = ResManager.getLocaleString((String)"\u60a8\u914d\u7f6e\u7f16\u53f7\u4e3a\u3010{number}\u3011\u5f52\u6863\u670d\u52a1\uff0c\u4e8e[{archservicestartdate}]\u5f00\u59cb\u6267\u884c\u5f52\u6863\u64cd\u4f5c\uff0c\u5f53\u524d\u8fdb\u5ea6\u4e3a\u3010{progress}\u3011\uff0c\u6267\u884c\u72b6\u6001\u4e3a\u3010{state}\u3011\uff0c\u8bf7\u53ca\u65f6\u5173\u6ce8\u5f52\u6863\u6700\u7ec8\u7ed3\u679c\uff0c\u8c22\u8c22\u3002", (String)"MessageArchivePlugin_14", (String)"bos-wf-archive");
        msgContent.put("zh_CN", contentLocaleString.getLocaleValue_zh_CN());
        content.put("title", msgTitle);
        content.put("content", msgContent);
        data.put("titleContent", SerializationUtils.toJsonString(content));
        this.getModel().setValue(ARCHIVEMSG, (Object)SerializationUtils.toJsonString(data));
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String propertyName = args.getProperty().getName().toLowerCase();
        if (ARCHIVEENTITY.equals(propertyName)) {
            Map<String, Date> dateRange = this.getEntityTableTimeRange();
            if (dateRange.get("startDate") != null) {
                this.getModel().setValue(STARTDATE, (Object)dateRange.get("startDate"));
            }
            if (dateRange.get("endDate") != null) {
                this.getModel().setValue(ENDDATE, (Object)dateRange.get("endDate"));
            }
            this.initDatabase();
        } else if (DATABASE.equals(propertyName)) {
            this.initDatabaseZone();
        } else if (DATABASEZONE.equals(propertyName)) {
            String databaseZone;
            Map cache;
            String items = this.getPageCache().get(DATABASEZONE);
            if (WfUtils.isNotEmpty((String)items) && (cache = (Map)SerializationUtils.fromJsonString((String)items, Map.class)).containsKey(databaseZone = (String)this.getModel().getValue(DATABASEZONE))) {
                String value = (String)cache.get(databaseZone);
                LocaleString name = new LocaleString(value);
                this.getModel().setValue(DATABASEZONENAME, (Object)name);
            }
        } else if (ARCHENDDATE.equals(propertyName) || ARCHSTATRDATE.equals(propertyName)) {
            IDataModel model = this.getModel();
            String archiveStartDate = (String)model.getValue(ARCHSTATRDATE);
            String archiveEndDate = (String)model.getValue(ARCHENDDATE);
            if (WfUtils.isNotEmpty((String)archiveStartDate) && WfUtils.isNotEmpty((String)archiveEndDate)) {
                int sd = Integer.parseInt(archiveStartDate);
                int ed = Integer.parseInt(archiveEndDate);
                if (ed < sd) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u9009\u62e9\u201c\u5f52\u6863\u6570\u636e\u65f6\u95f4\u8303\u56f4\u201d\u3002", (String)"MessageArchivePlugin_3", (String)"bos-wf-archive", (Object[])new Object[0]), Integer.valueOf(3000));
                    this.getModel().setValue(propertyName, null);
                } else {
                    String dateRange = archiveStartDate + " ~ " + archiveEndDate;
                    model.setValue(ARCHIVEDATARANGELIST, (Object)dateRange);
                }
            }
        }
    }

    private void initArchiveEntity() {
        Object archiveEntity = this.getView().getFormShowParameter().getCustomParam(ARCHIVEENTITY);
        if (archiveEntity != null) {
            ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(1);
            String entityNumber = (String)archiveEntity;
            MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
            LocaleString entityName = dataEntityType.getDisplayName();
            comboItems.add(new ComboItem(entityName, entityNumber));
            ((ComboEdit)this.getControl(ARCHIVEENTITY)).setComboItems(comboItems);
            this.getModel().setValue(ARCHIVEENTITY, (Object)entityNumber);
        }
    }

    private void initDatabase() {
        String archiveEntity = (String)this.getModel().getValue(ARCHIVEENTITY);
        ArchiveApiService archiveApiService = MessageArchiveService.create().getArchiveApiService();
        List<McDatabase> mcDatabases = archiveApiService.getDatabase(archiveEntity);
        if (mcDatabases != null && !mcDatabases.isEmpty()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{LABEL_NODB});
            ArrayList<ComboItem> dbItems = new ArrayList<ComboItem>(mcDatabases.size());
            for (McDatabase mcDatabase : mcDatabases) {
                LocaleString entityName = new LocaleString();
                String name = mcDatabase.getName();
                entityName.setLocaleValue(name);
                dbItems.add(new ComboItem(entityName, mcDatabase.getDatabaseKey()));
            }
            ((ComboEdit)this.getControl(DATABASE)).setComboItems(dbItems);
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{LABEL_NODB});
        }
    }

    private Map<String, Date> getEntityTableTimeRange() {
        String archiveEntity = (String)this.getModel().getValue(ARCHIVEENTITY);
        return MessageArchiveService.create().getEntityTimeRange(archiveEntity);
    }

    private void initArchieDateRange() {
        String state = (String)this.getModel().getValue(AECHIVESTATE);
        String archiveRange = (String)this.getModel().getValue(ARCHIVEDATARANGELIST);
        if (!MessageArchiveState.ARCHIVEWILL.getValue().equals(state) && WfUtils.isNotEmpty((String)archiveRange)) {
            String[] ranges = archiveRange.split("~");
            String sd = ranges[0].trim();
            String ed = ranges[1].trim();
            ArrayList<ComboItem> startComboItems = new ArrayList<ComboItem>(1);
            startComboItems.add(new ComboItem(new LocaleString(sd), sd));
            ((ComboEdit)this.getControl(ARCHSTATRDATE)).setComboItems(startComboItems);
            ArrayList<ComboItem> endComboItems = new ArrayList<ComboItem>(1);
            endComboItems.add(new ComboItem(new LocaleString(ed), ed));
            ((ComboEdit)this.getControl(ARCHENDDATE)).setComboItems(endComboItems);
        } else {
            Map<String, Date> dateRanage = this.getEntityTableTimeRange();
            Date endDate = dateRanage.get("endDate");
            Date startDate = dateRanage.get("startDate");
            Date currentDate = new Date();
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(currentDate);
            int currentYear = calendar.get(1);
            calendar.setTime(startDate);
            int startYear = calendar.get(1);
            calendar.setTime(endDate);
            int endYear = calendar.get(1);
            ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(1);
            for (int i = startYear; i < endYear + 1; ++i) {
                if (i >= currentYear) continue;
                LocaleString name = new LocaleString(Integer.toString(i));
                ComboItem comboItem = new ComboItem(name, Integer.toString(i));
                comboItems.add(comboItem);
            }
            ((ComboEdit)this.getControl(ARCHSTATRDATE)).setComboItems(comboItems);
            ((ComboEdit)this.getControl(ARCHENDDATE)).setComboItems(comboItems);
        }
    }

    private void initDatabaseZone() {
        String database = (String)this.getModel().getValue(DATABASE);
        ArchiveApiService archiveApiService = MessageArchiveService.create().getArchiveApiService();
        List<ArchiveDatabase> archiveDatabases = archiveApiService.getAllDatabaseZones();
        if (archiveDatabases != null && !archiveDatabases.isEmpty()) {
            ArrayList<ComboItem> dbZoneItems = new ArrayList<ComboItem>(archiveDatabases.size());
            HashMap<String, String> items = new HashMap<String, String>();
            for (ArchiveDatabase archiveDatabase : archiveDatabases) {
                if (!archiveDatabase.getDatabase().equals(database)) continue;
                LocaleString entityName = new LocaleString();
                String name = archiveDatabase.getName();
                entityName.setLocaleValue(name);
                dbZoneItems.add(new ComboItem(entityName, archiveDatabase.getNumber()));
                items.put(archiveDatabase.getNumber(), name);
            }
            ((ComboEdit)this.getControl(DATABASEZONE)).setComboItems(dbZoneItems);
            this.getPageCache().put(DATABASEZONE, SerializationUtils.toJsonString(items));
        }
    }
}

