/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.message.archive.plugin;

import com.alibaba.fastjson.JSONObject;
import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IConfirmCallBack;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.message.archive.service.ArchiveApiService;
import kd.bos.message.archive.service.MessageArchiveService;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.engine.WfUtils;

public class MessageRearchivePlugin
extends AbstractFormPlugin
implements ClickListener,
IConfirmCallBack {
    private static Log logger = LogFactory.getLog(MessageRearchivePlugin.class);
    private static final String REARCHIVECALLBACKID = "rearchiveCallBackId";
    private static final String SCHEDULEIDS = "scheduleids";
    private static final String REARCHIVE = "rearchive";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{SCHEDULEIDS, REARCHIVE});
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        Object returnData;
        String actionId = evt.getActionId();
        if (actionId != null && REARCHIVECALLBACKID.equals(actionId) && (returnData = evt.getReturnData()) != null) {
            this.getModel().setValue(SCHEDULEIDS, returnData);
        }
    }

    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        String controlKey = control.getKey();
        if (SCHEDULEIDS.equals(controlKey)) {
            FormShowParameter formShowParameter = this.getView().getFormShowParameter();
            Long archiveServiceId = (Long)formShowParameter.getCustomParam("archiveServiceId");
            String archiveEntity = (String)formShowParameter.getCustomParam("archiveentity");
            ListShowParameter parameter = new ListShowParameter();
            parameter.setBillFormId("wf_archiveloglayout");
            parameter.setFormId("bos_list");
            parameter.getOpenStyle().setShowType(ShowType.Modal);
            ListFilterParameter listFilterParameter = new ListFilterParameter();
            QFilter qFilter = new QFilter("archiveserviceid", "=", (Object)archiveServiceId).and("entity", "=", (Object)archiveEntity);
            listFilterParameter.setFilter(qFilter);
            parameter.setListFilterParameter(listFilterParameter);
            parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, REARCHIVECALLBACKID));
            StyleCss styleCss = new StyleCss();
            styleCss.setHeight("560");
            styleCss.setWidth("780");
            parameter.getOpenStyle().setInlineStyleCss(styleCss);
            this.getView().showForm((FormShowParameter)parameter);
        } else if (REARCHIVE.equals(controlKey)) {
            Object resourceIds = this.getModel().getValue(SCHEDULEIDS);
            if (!WfUtils.isNotEmptyString((Object)resourceIds)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u5f52\u6863\u8868\u5355\u8d44\u6e90ID\u3002", (String)"MessageRearchivePlugin_2", (String)"bos-wf-archive", (Object[])new Object[0]), Integer.valueOf(3000));
                return;
            }
            try {
                String rids = (String)resourceIds;
                if (!rids.startsWith("[")) {
                    rids = "[" + rids;
                }
                if (!rids.endsWith("]")) {
                    rids = rids + "]";
                }
                List entityIds = SerializationUtils.fromJsonStringToList((String)rids, Object.class);
                FormShowParameter formShowParameter = this.getView().getFormShowParameter();
                String archiveEntity = (String)formShowParameter.getCustomParam("archiveentity");
                String archiveRouteKey = (String)formShowParameter.getCustomParam("archiveRouteKey");
                ArchiveApiService archiveApiService = MessageArchiveService.create().getArchiveApiService();
                archiveApiService.rearchiveByEntityIds(archiveEntity, archiveRouteKey, entityIds);
                JSONObject returnData = new JSONObject();
                returnData.put("success", (Object)true);
                this.getView().returnDataToParent((Object)returnData.toJSONString());
                this.getView().close();
                WfUtils.addOpLog((String)"wf_rearchive", (String)REARCHIVE, (MultiLangEnumBridge)new MultiLangEnumBridge("\u53cd\u5f52\u6863", "MessageArchiveListPlugin_3", "bos-wf-archive"), (MultiLangEnumBridge)new MultiLangEnumBridge("\u64cd\u4f5c\u6210\u529f\u3002", "MessageArchiveListPlugin_4", "bos-wf-archive"), (Object[])new Object[0]);
            }
            catch (Exception e) {
                this.getView().showErrorNotification(e.getMessage());
                logger.warn(String.format("messageArchiveLog rearchive error [%s]", WfUtils.getExceptionStacktrace((Throwable)e)));
            }
        }
    }
}

