/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.message.archive.service;

import java.util.List;
import kd.bos.archive.api.dto.ArchiveDatabase;
import kd.bos.archive.api.dto.ArchivePlan;
import kd.bos.archive.api.dto.ArchiveRule;
import kd.bos.archive.api.dto.ArchiveSchedule;
import kd.bos.archive.api.dto.McDatabase;
import kd.bos.archive.api.dto.ScheduleResultInfo;
import kd.bos.archive.api.factory.ArchiveApiFactory;
import kd.bos.archive.api.service.ArchiveDatabaseApi;
import kd.bos.archive.api.service.ArchiveMcApi;
import kd.bos.archive.api.service.ArchiveResultApi;
import kd.bos.archive.api.service.ArchiveRuleApi;
import kd.bos.archive.api.service.ArchiveScheduleApi;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;

public class ArchiveApiService {
    private ArchiveMcApi getArchiveMcApi() {
        return ArchiveApiFactory.getMCServiceApi();
    }

    private ArchiveRuleApi getArchiveRuleApi() {
        return ArchiveApiFactory.getArchiveRuleApi();
    }

    private ArchiveResultApi getArchiveResultApi() {
        return ArchiveApiFactory.getArchiveResultApi();
    }

    private ArchiveDatabaseApi getArchiveDatabaseApi() {
        return ArchiveApiFactory.getArchiveDatabaseApi();
    }

    private ArchiveScheduleApi getArchiveScheduleApi() {
        return ArchiveApiFactory.getArchiveScheduleApi();
    }

    public List<McDatabase> getDatabase(String entityNumber) {
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        return this.getArchiveMcApi().findDatabase(entityType.getDBRouteKey());
    }

    public List<ArchiveDatabase> getAllDatabaseZones() {
        return this.getArchiveDatabaseApi().findAll();
    }

    public ArchiveDatabase getDatabaseZone(Long databaseZoneId) {
        return this.getArchiveDatabaseApi().find(databaseZoneId.longValue());
    }

    public ArchiveDatabase addDatabaseZone(String dbZoneName, String database, String dbZoneGroup) {
        return this.getArchiveDatabaseApi().add(dbZoneName, database, dbZoneGroup);
    }

    public void disableArchiveRule(Long archiveRuleId) {
        this.getArchiveRuleApi().disable(archiveRuleId.longValue());
    }

    public void enableArchiveRule(Long archiveRuleId) {
        this.getArchiveRuleApi().enable(archiveRuleId.longValue());
    }

    public void updateArchiveRule(Long archiveRuleId, ArchiveDatabase archiveDatabase) {
        this.getArchiveRuleApi().updateArchiveDatabase(archiveRuleId.longValue(), archiveDatabase);
    }

    public ArchiveRule getArchiveRule(Long archiveRuleId) {
        return this.getArchiveRuleApi().find(archiveRuleId.longValue());
    }

    public List<ArchiveRule> getAllArchiveRules() {
        return this.getArchiveRuleApi().findAll();
    }

    public void disableArchiveSchedule(Long archiveScheduleId) {
        this.getArchiveScheduleApi().disable(archiveScheduleId.longValue());
    }

    public void enableArchiveSchedule(Long archiveScheduleId) {
        this.getArchiveScheduleApi().enable(archiveScheduleId.longValue());
    }

    public void updateArchiveSchedule(Long archiveScheduleId, String name, ArchivePlan archivePlan, List<ArchiveRule> archiveRules) {
        this.getArchiveScheduleApi().update(archiveScheduleId.longValue(), name, archivePlan, archiveRules);
    }

    public List<ArchiveSchedule> getAllArchiveSchedules() {
        return this.getArchiveScheduleApi().findAll();
    }

    public void retryArchiveScheduleByTask(Long taskId) {
        this.getArchiveScheduleApi().retry(taskId.longValue());
    }

    public void rearchiveByEntityIds(String entityNumber, String archiveRoute, List<Object> entityIds) {
        this.getArchiveResultApi().reverse(entityNumber, archiveRoute, entityIds);
    }

    public List<ScheduleResultInfo> getArchiveResult(List<Long> scheduleIds) {
        return this.getArchiveResultApi().findScheduleResultInfo(scheduleIds);
    }
}

