/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.message.archive.service;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import kd.bos.archive.api.dto.ArchiveRule;
import kd.bos.archive.api.dto.ArchiveSchedule;
import kd.bos.archive.task.resultnotify.mq.ArchiveResultBody;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.message.archive.enumeration.MessageArchiveState;
import kd.bos.message.archive.service.ArchiveApiService;
import kd.bos.message.archive.utils.MessageArchiveUtil;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.workflow.engine.WfUtils;

public class ArchiveInfofNotifyService {
    private static Log logger = LogFactory.getLog(ArchiveInfofNotifyService.class);
    private static final String FULLPROPRESS = "100";
    private ArchiveApiService archiveApiService;

    public ArchiveInfofNotifyService(ArchiveApiService archiveApiService) {
        this.archiveApiService = archiveApiService;
    }

    public void saveArchiveScheduleStartInfo(String entityNumber, long taskId, long scheduleId) {
        QFilter[] filters;
        QFilter f1 = new QFilter("state", "=", (Object)MessageArchiveState.ARCHIVEING.getValue());
        QFilter f2 = new QFilter("state", "=", (Object)MessageArchiveState.ARCHIVEFAIL.getValue());
        QFilter f3 = new QFilter("archiveentity", "=", (Object)entityNumber);
        String selectProperties = "id,number,schedulesize,archstartdate,archenddate";
        DynamicObject[] archiveServices = BusinessDataServiceHelper.load((String)"wf_archiveservice", (String)selectProperties, (QFilter[])new QFilter[]{f1.or(f2), f3});
        DynamicObject targetService = null;
        if (archiveServices != null && archiveServices.length > 0) {
            targetService = archiveServices[0];
        }
        if (targetService != null && !QueryServiceHelper.exists((String)"wf_archivelog", (QFilter[])(filters = new QFilter[]{new QFilter("taskid", "=", (Object)taskId)}))) {
            DynamicObject archiveLog = BusinessDataServiceHelper.newDynamicObject((String)"wf_archivelog");
            archiveLog.set("archiveservice", (Object)targetService.getString("number"));
            archiveLog.set("archiveserviceid", (Object)targetService.getLong("id"));
            archiveLog.set("scheduleid", (Object)scheduleId);
            archiveLog.set("taskid", (Object)taskId);
            archiveLog.set("schstartdate", (Object)new Date());
            archiveLog.set("entity", (Object)entityNumber);
            archiveLog.set("parententity", (Object)entityNumber);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{archiveLog});
            logger.debug(String.format("HiprocinstArchiveImpl_entity[%S], schedule[%s], rootTask[%s]", entityNumber, scheduleId, taskId));
        }
    }

    public void analysisArchiveTaskResultInfo(ArchiveResultBody archiveResultBody) {
        try {
            boolean isRepeatRecored = this.updateMessageArchiveLog(archiveResultBody);
            if (!isRepeatRecored) {
                DynamicObject archiveService = this.updateMessageArchiveService(archiveResultBody);
                if (archiveService == null) {
                    logger.debug("archiveResultNotify not find archiveService");
                    return;
                }
                this.afterMessageArchive(archiveService);
            }
        }
        catch (Exception e) {
            logger.warn(String.format("MessageArchiveResultNotifier_has error %s", WfUtils.getExceptionStacktrace((Throwable)e)));
        }
    }

    private DynamicObject updateMessageArchiveService(ArchiveResultBody archiveResultBody) {
        String result = archiveResultBody.getResult();
        long count = archiveResultBody.getCount();
        long schedulercdid = archiveResultBody.getSchedulercdid();
        QFilter f0 = new QFilter("scheduleid", "=", (Object)schedulercdid);
        DynamicObject[] archiveLogs = BusinessDataServiceHelper.load((String)"wf_archivelog", (String)"archiveserviceid", (QFilter[])new QFilter[]{f0});
        if (archiveLogs == null || archiveLogs.length == 0) {
            return null;
        }
        String selectProperties = "id,number,archiveentity,database,databasezone,startdate,enddate,creator,createdate,archservicestartdate,schedulesize,archstartdate,archenddate,scheduletotalsum,alldatasum,failreason,state,archserviceenddate,progress,archivemsg";
        QFilter f1 = new QFilter("id", "=", (Object)archiveLogs[0].getLong("archiveserviceid"));
        DynamicObject[] archiveServices = BusinessDataServiceHelper.load((String)"wf_archiveservice", (String)selectProperties, (QFilter[])new QFilter[]{f1});
        if (archiveServices == null || archiveServices.length == 0) {
            return null;
        }
        DynamicObject targetService = archiveServices[0];
        if (!result.equalsIgnoreCase("success")) {
            targetService.set("state", (Object)MessageArchiveState.ARCHIVEFAIL.getValue());
            targetService.set("failreason", (Object)ResManager.loadKDString((String)"\u8c03\u5ea6\u65e5\u5fd7", (String)"MessageArchiveResultNotifier_0", (String)"bos-wf-archive", (Object[])new Object[0]));
        } else {
            BigDecimal totalSum = targetService.getBigDecimal("alldatasum");
            BigDecimal tss = totalSum.multiply(BigDecimal.valueOf(10000L));
            long ts = tss.longValue();
            BigDecimal redundancySum = tss.multiply(BigDecimal.valueOf(0.05));
            long rs = redundancySum.longValue();
            long scheduleTotalSum = targetService.getLong("scheduletotalsum") + count;
            targetService.set("scheduletotalsum", (Object)scheduleTotalSum);
            targetService.set("failreason", (Object)ResManager.loadKDString((String)"\u8c03\u5ea6\u65e5\u5fd7", (String)"MessageArchiveResultNotifier_0", (String)"bos-wf-archive", (Object[])new Object[0]));
            if (ts == scheduleTotalSum || scheduleTotalSum < ts + rs && scheduleTotalSum > ts - rs) {
                targetService.set("state", (Object)MessageArchiveState.ARCHIVEOK.getValue());
                targetService.set("archserviceenddate", (Object)new Date());
                targetService.set("progress", (Object)FULLPROPRESS);
            } else {
                targetService.set("state", (Object)MessageArchiveState.ARCHIVEING.getValue());
                BigDecimal ps = BigDecimal.valueOf(scheduleTotalSum).divide(BigDecimal.valueOf(ts), 3, 4).multiply(BigDecimal.valueOf(100L));
                targetService.set("progress", (Object)ps.doubleValue());
            }
        }
        SaveServiceHelper.save((DynamicObject[])archiveServices);
        logger.debug(String.format("MessageArchiveResultNotifier_archiveServiceSaveOk-scheduleId[%s] , archive[%s], entity[%s], count[%s], total[%s], traceId[%s], time[%s]", archiveResultBody.getSchedulercdid(), targetService.getString("number"), archiveResultBody.getEntityName(), count, targetService.getLong("scheduletotalsum"), RequestContext.get().getTraceId(), System.currentTimeMillis()));
        return targetService;
    }

    private boolean updateMessageArchiveLog(ArchiveResultBody archiveResultBody) {
        boolean isRepeatRecored = false;
        Long taskId = archiveResultBody.getTaskId();
        Long scheduleId = archiveResultBody.getSchedulercdid();
        String entityNumber = archiveResultBody.getEntityName();
        String parentEntityName = archiveResultBody.getRootEntityName();
        String result = archiveResultBody.getResult().toLowerCase();
        long count = archiveResultBody.getCount();
        String selectFields = "entity,parententity,taskid,scheduleid,summary,state,archiveserviceid,archiveservice,scheduleid,schstartdate,targetdate,schenddate";
        QFilter f1 = new QFilter("scheduleid", "=", (Object)scheduleId);
        QFilter f2 = new QFilter("taskid", "=", (Object)taskId).or("entity", "=", (Object)parentEntityName);
        DynamicObject[] archiveLogs = BusinessDataServiceHelper.load((String)"wf_archivelog", (String)selectFields, (QFilter[])new QFilter[]{f1, f2});
        if (archiveLogs != null && archiveLogs.length > 0) {
            DynamicObject parentEntityArchiveLog = null;
            DynamicObject targetEntityArchiveLog = null;
            for (DynamicObject archiveLog : archiveLogs) {
                String entity = archiveLog.getString("entity");
                String parentEntity = archiveLog.getString("parententity");
                Long taskLogId = archiveLog.getLong("taskid");
                if (WfUtils.isNotEmpty((String)entity) && WfUtils.isNotEmpty((String)parentEntity) && entity.equals(parentEntity)) {
                    parentEntityArchiveLog = archiveLog;
                }
                if (!taskLogId.equals(taskId)) continue;
                targetEntityArchiveLog = archiveLog;
            }
            if (parentEntityArchiveLog == null) {
                logger.debug(String.format("MessageArchiveResultNotifier_not find parentLogTpl [%s-%s-%s-%s]", scheduleId, taskId, entityNumber, result));
                return isRepeatRecored;
            }
            if (targetEntityArchiveLog == null) {
                targetEntityArchiveLog = BusinessDataServiceHelper.newDynamicObject((String)"wf_archivelog");
                targetEntityArchiveLog.set("archiveserviceid", (Object)parentEntityArchiveLog.getLong("archiveserviceid"));
                targetEntityArchiveLog.set("archiveservice", (Object)parentEntityArchiveLog.getString("archiveservice"));
                targetEntityArchiveLog.set("scheduleid", (Object)parentEntityArchiveLog.getLong("scheduleid"));
                targetEntityArchiveLog.set("schstartdate", (Object)parentEntityArchiveLog.getDate("schstartdate"));
                targetEntityArchiveLog.set("targetdate", (Object)parentEntityArchiveLog.getDate("targetdate"));
                targetEntityArchiveLog.set("parententity", (Object)parentEntityArchiveLog.getString("parententity"));
            } else {
                String logResult = targetEntityArchiveLog.getString("state");
                Date scheduleEndDate = targetEntityArchiveLog.getDate("schenddate");
                if (scheduleEndDate != null && "success".equalsIgnoreCase(logResult)) {
                    isRepeatRecored = true;
                }
                logger.debug(String.format("MessageArchiveResultNotifier_target log inter again [%s-%s-%s-%s]", scheduleId, taskId, entityNumber, result));
            }
            targetEntityArchiveLog.set("schenddate", (Object)new Date());
            targetEntityArchiveLog.set("taskid", (Object)taskId);
            targetEntityArchiveLog.set("entity", (Object)entityNumber);
            targetEntityArchiveLog.set("summary", (Object)count);
            targetEntityArchiveLog.set("state", (Object)result);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{targetEntityArchiveLog});
            logger.info(String.format("MessageArchiveResultNotifier_target log save ok [%s-%s-%s-%s]", scheduleId, taskId, entityNumber, result));
        }
        return isRepeatRecored;
    }

    private void afterMessageArchive(DynamicObject archiveService) {
        String propress = archiveService.getString("progress");
        String state = archiveService.getString("state");
        BigDecimal predictionTotalSum = archiveService.getBigDecimal("alldatasum");
        BigDecimal tss = predictionTotalSum.multiply(BigDecimal.valueOf(10000L));
        long archiveTotalSum = archiveService.getLong("scheduletotalsum");
        if (tss.longValue() == archiveTotalSum && FULLPROPRESS.equals(propress) && MessageArchiveState.ARCHIVEOK.getValue().equals(state)) {
            logger.debug("MessageArchiveResultNotifier_afterArchive ok");
            this.disableSchedule(archiveService);
            MessageArchiveUtil.sendArchiveMsg(archiveService);
        } else if (MessageArchiveState.ARCHIVEFAIL.getValue().equals(state)) {
            MessageArchiveUtil.sendArchiveMsg(archiveService);
        }
    }

    private void disableSchedule(DynamicObject archiveService) {
        String entityNumber = archiveService.getString("archiveentity");
        ArchiveRule targteArchiveRule = null;
        List<ArchiveRule> allArchiveRules = this.archiveApiService.getAllArchiveRules();
        if (allArchiveRules != null && !allArchiveRules.isEmpty()) {
            for (ArchiveRule archiveRule : allArchiveRules) {
                if (!archiveRule.getEntityNumber().equals(entityNumber)) continue;
                targteArchiveRule = archiveRule;
                break;
            }
        }
        if (targteArchiveRule != null) {
            Long archiveRuleId = targteArchiveRule.getId();
            this.archiveApiService.disableArchiveRule(archiveRuleId);
        }
        ArchiveSchedule targetArchiveSchedule = null;
        List<ArchiveSchedule> schedules = this.archiveApiService.getAllArchiveSchedules();
        if (schedules != null && !schedules.isEmpty()) {
            String scheduleNumber = MessageArchiveUtil.getEntityArchiveScheduleNumber(entityNumber);
            for (ArchiveSchedule archiveSchedule : schedules) {
                if (!archiveSchedule.getNumber().equals(scheduleNumber)) continue;
                targetArchiveSchedule = archiveSchedule;
                break;
            }
        }
        if (targetArchiveSchedule != null) {
            Long archiveScheduleId = targetArchiveSchedule.getId();
            this.archiveApiService.disableArchiveSchedule(archiveScheduleId);
        }
        MessageArchiveUtil.operateScheduleJob();
    }
}

