/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.message.archive.service;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.archive.api.ArchiveRepeatModeEnum;
import kd.bos.archive.api.dto.ArchiveDatabase;
import kd.bos.archive.api.dto.ArchivePlan;
import kd.bos.archive.api.dto.ArchiveRule;
import kd.bos.archive.api.dto.ArchiveSchedule;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.message.archive.enumeration.MessageArchiveState;
import kd.bos.message.archive.service.ArchiveApiService;
import kd.bos.message.archive.utils.MessageArchiveUtil;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.workflow.engine.WfUtils;

public class ArchiveScheduleTaskService {
    private static Log logger = LogFactory.getLog(ArchiveScheduleTaskService.class);
    private ArchiveApiService archiveApiService;

    public ArchiveScheduleTaskService(ArchiveApiService archiveApiService) {
        this.archiveApiService = archiveApiService;
    }

    public void triggerArchiveService(DynamicObject archiveService) {
        ArchiveRule archiveRule = null;
        ArchiveSchedule archiveSchedule = null;
        try {
            ArchiveDatabase databaseZone = this.handleDatabaseZone(archiveService);
            if (databaseZone == null) {
                logger.debug("triggerArchiveService, but query no databaseZone");
                return;
            }
            archiveRule = this.handleArchiveRule(archiveService, databaseZone);
            if (archiveRule == null) {
                logger.debug("triggerArchiveService, but query no archiveRule");
                return;
            }
            archiveSchedule = this.handleArchiveSchedule(archiveService, archiveRule);
            this.handleArchiveService(archiveService);
        }
        catch (Exception e) {
            logger.warn(String.format("triggerArchiveService hasException [%s]", WfUtils.getExceptionStacktrace((Throwable)e)));
            try {
                if (archiveRule != null) {
                    this.archiveApiService.disableArchiveRule(archiveRule.getId());
                }
                if (archiveSchedule != null) {
                    this.archiveApiService.disableArchiveSchedule(archiveSchedule.getId());
                }
            }
            catch (Exception e2) {
                logger.warn(String.format("triggerArchiveService hasException [%s]", WfUtils.getExceptionStacktrace((Throwable)e2)));
            }
        }
    }

    private void handleArchiveService(DynamicObject archiveService) {
        archiveService.set("state", (Object)MessageArchiveState.ARCHIVEING.getValue());
        archiveService.set("archservicestartdate", (Object)new Date());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{archiveService});
    }

    private ArchiveSchedule handleArchiveSchedule(DynamicObject archiveService, ArchiveRule archiveRule) {
        ArchiveSchedule targetArchiveSchedule = null;
        List<ArchiveSchedule> schedules = this.archiveApiService.getAllArchiveSchedules();
        if (schedules != null && !schedules.isEmpty()) {
            String entityNumber = archiveService.getString("archiveentity");
            String scheduleNumber = MessageArchiveUtil.getEntityArchiveScheduleNumber(entityNumber);
            for (ArchiveSchedule archiveSchedule : schedules) {
                if (!archiveSchedule.getNumber().equals(scheduleNumber)) continue;
                targetArchiveSchedule = archiveSchedule;
                break;
            }
        }
        if (targetArchiveSchedule == null) {
            logger.debug("triggerArchiveService, but query no archiveSchedule");
            return targetArchiveSchedule;
        }
        Long archiveScheduleId = targetArchiveSchedule.getId();
        this.archiveApiService.disableArchiveSchedule(archiveScheduleId);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date startTime = null;
        Date endTime = null;
        try {
            startTime = sdf.parse("2022-04-01 00:00:30");
            endTime = sdf.parse("2100-01-01 00:00:30");
        }
        catch (ParseException e) {
            logger.warn("triggerArchiveService-handleArchiveSchedule has error:" + WfUtils.getExceptionStacktrace((Throwable)e));
        }
        String name = targetArchiveSchedule.getName();
        int scheduleTime = 5;
        ArchivePlan archivePlan = new ArchivePlan(startTime, endTime, ArchiveRepeatModeEnum.ByMinutes, scheduleTime);
        ArrayList<ArchiveRule> archiveRules = new ArrayList<ArchiveRule>();
        archiveRules.add(archiveRule);
        this.archiveApiService.updateArchiveSchedule(archiveScheduleId, name, archivePlan, archiveRules);
        this.archiveApiService.enableArchiveSchedule(archiveScheduleId);
        return targetArchiveSchedule;
    }

    private ArchiveRule handleArchiveRule(DynamicObject targetService, ArchiveDatabase archiveDatabase) {
        ArchiveRule targetArchiveRule = null;
        String entity = targetService.getString("archiveentity");
        List<ArchiveRule> archiveRules = this.archiveApiService.getAllArchiveRules();
        if (archiveRules != null && !archiveRules.isEmpty()) {
            for (ArchiveRule archiveRule : archiveRules) {
                if (!archiveRule.getEntityNumber().equals(entity)) continue;
                targetArchiveRule = archiveRule;
                break;
            }
        }
        if (targetArchiveRule == null) {
            logger.debug("triggerArchiveService, but query no archiveRule");
            return targetArchiveRule;
        }
        Long archiveRuleId = targetArchiveRule.getId();
        this.archiveApiService.disableArchiveRule(archiveRuleId);
        this.archiveApiService.updateArchiveRule(archiveRuleId, archiveDatabase);
        this.archiveApiService.enableArchiveRule(archiveRuleId);
        return targetArchiveRule;
    }

    private ArchiveDatabase handleDatabaseZone(DynamicObject targetService) {
        ArchiveDatabase archiveDatabase = null;
        String database = targetService.getString("database");
        String databaseZone = targetService.getString("databasezone");
        List<ArchiveDatabase> archiveDatabases = this.archiveApiService.getAllDatabaseZones();
        if (archiveDatabases != null && !archiveDatabases.isEmpty()) {
            for (ArchiveDatabase archiveDB : archiveDatabases) {
                if (!archiveDB.getNumber().equals(databaseZone) || !archiveDB.getDatabase().equals(database)) continue;
                archiveDatabase = archiveDB;
                break;
            }
        }
        return archiveDatabase;
    }
}

