/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.message.archive.service.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.message.archive.model.EntitySummaryInfo;
import kd.bos.message.archive.service.ArchiveEntityData;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.workflow.engine.WfUtils;

public class HiprocinstArchiveDataImpl
implements ArchiveEntityData {
    private static Log logger = LogFactory.getLog(HiprocinstArchiveDataImpl.class);
    private static final String COUNT = "count";
    private static final String ENDTIME = "endtime";
    public static final String PARENTNUMBER = "parentnumber";
    private static final String NUMBER = "number";

    @Override
    public List<EntitySummaryInfo> getArchiveEntityData(String archiveEntity, Date archiveStartDate, Date archiveEndDate) {
        ArrayList<EntitySummaryInfo> entitySummaryInfos = new ArrayList<EntitySummaryInfo>();
        QFilter f1 = new QFilter(PARENTNUMBER, "=", (Object)" ").and("entitynumber", "=", (Object)archiveEntity);
        QFilter f2 = new QFilter(PARENTNUMBER, "=", (Object)archiveEntity);
        DynamicObject[] archiveCascades = BusinessDataServiceHelper.load((String)"bos_cbs_archi_cascade", (String)"number,joinfield", (QFilter[])new QFilter[]{f1.or(f2)});
        HashMap<String, DynamicObject> archiveCascadeMapping = new HashMap<String, DynamicObject>(archiveCascades.length);
        Set<String> entityNumbers = null;
        if (archiveCascades != null && archiveCascades.length > 0) {
            for (DynamicObject archiveCascade : archiveCascades) {
                if (archiveEntity.equals(archiveCascade.getString(NUMBER))) continue;
                archiveCascadeMapping.put(archiveCascade.getString(NUMBER), archiveCascade);
            }
            entityNumbers = archiveCascadeMapping.keySet();
        }
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)archiveEntity);
        String parentEntityTable = entityType.getAlias();
        String archiveSql = String.format("select fid id, fbusinesskey businessKey from %s where fendtime >= ? and fendtime < ? and fendtime is not null and fprocesstype != 'BizFlow' and FSUPERPROCINSTID = 0;", parentEntityTable);
        Object[] params = new Object[]{archiveStartDate, archiveEndDate};
        logger.info(String.format("archiveSql-%s, date:[%s-%s]", archiveSql, archiveStartDate, archiveEndDate));
        try (DataSet dataSet = DB.queryDataSet((String)"getArchiveEntityData_queryParentEntity", (DBRoute)DBRoute.workflow, (String)archiveSql, (Object[])params);){
            Iterator parentRows = dataSet.iterator();
            HashMap<Long, String> parentEntityIdsMapping = new HashMap<Long, String>();
            while (parentRows.hasNext()) {
                Row row = (Row)parentRows.next();
                parentEntityIdsMapping.put(row.getLong("id"), row.getString("businesskey"));
                if (parentEntityIdsMapping.size() % 1000 != 0 && dataSet.hasNext()) continue;
                this.filterProcinstIds(parentEntityIdsMapping);
                Map<Long, String> childIdsMapping = this.addChildProcinstIds(parentEntityIdsMapping.keySet(), 1);
                if (!childIdsMapping.isEmpty()) {
                    parentEntityIdsMapping.putAll(childIdsMapping);
                }
                Set<Long> parentEntityIds = parentEntityIdsMapping.keySet();
                this.wrapEntitySummaryInfos(entitySummaryInfos, entityType, parentEntityIds.size());
                if (entityNumbers != null && !entityNumbers.isEmpty()) {
                    this.getChildEntityData(entityNumbers, archiveCascadeMapping, entitySummaryInfos, parentEntityIds);
                }
                parentEntityIds.clear();
            }
        }
        catch (Exception e) {
            logger.warn(String.format("showArchiveDataDetail has error and description %s", WfUtils.getExceptionStacktrace((Throwable)e)));
        }
        if (entitySummaryInfos.isEmpty()) {
            logger.debug("showArchiveDataDetail query no parentData");
            this.wrapEntitySummaryInfos(entitySummaryInfos, entityType, 0);
            if (entityNumbers != null && !entityNumbers.isEmpty()) {
                for (String entityNumber : entityNumbers) {
                    MainEntityType childEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
                    this.wrapEntitySummaryInfos(entitySummaryInfos, childEntityType, 0);
                }
            }
        }
        return entitySummaryInfos;
    }

    private void filterProcinstIds(Map<Long, String> parentEntityIdsMapping) {
        QFilter bkeyf1 = new QFilter(ENDTIME, "is null", null);
        Collection<String> businessKeys = parentEntityIdsMapping.values();
        QFilter bkeyf2 = new QFilter("businesskey", "in", businessKeys);
        DynamicObject[] checkEntitys = BusinessDataServiceHelper.load((String)"wf_hiprocinst", (String)"businesskey", (QFilter[])new QFilter[]{bkeyf1, bkeyf2});
        if (checkEntitys == null || checkEntitys.length == 0) {
            return;
        }
        for (DynamicObject checkEntity : checkEntitys) {
            String businessKey = checkEntity.getString("businesskey");
            parentEntityIdsMapping.values().removeIf(value -> value.equals(businessKey));
        }
    }

    private void getChildEntityData(Set<String> entityNumbers, Map<String, DynamicObject> archiveCascadeMapping, List<EntitySummaryInfo> entitySummaryInfos, Set<Long> parentEntityIds) {
        for (String entityNumber : entityNumbers) {
            String property = archiveCascadeMapping.get(entityNumber).getString("joinfield");
            MainEntityType childEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
            String entityTable = childEntityType.getAlias();
            Map fields = childEntityType.getFields();
            String entityField = ((IDataEntityProperty)fields.get(property)).getAlias();
            StringBuilder archiveSqlChild = new StringBuilder();
            archiveSqlChild.append("select count(1) count from ").append(entityTable).append(" where ").append(entityField).append(" in (");
            for (Long parentEntityId : parentEntityIds) {
                archiveSqlChild.append(parentEntityId).append(",");
            }
            archiveSqlChild.replace(archiveSqlChild.length() - 1, archiveSqlChild.length(), ");");
            try {
                DataSet childDataset = DB.queryDataSet((String)"getArchiveEntityData_queryChildEntityCount", (DBRoute)DBRoute.workflow, (String)archiveSqlChild.toString());
                Throwable throwable = null;
                try {
                    Iterator iter = childDataset.iterator();
                    if (!iter.hasNext()) continue;
                    int childCount = childDataset.next().getInteger(COUNT);
                    this.wrapEntitySummaryInfos(entitySummaryInfos, childEntityType, childCount);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (childDataset == null) continue;
                    if (throwable != null) {
                        try {
                            childDataset.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    childDataset.close();
                }
            }
            catch (Exception e) {
                logger.warn(String.format("showArchiveDataDetail child has error and description %s", WfUtils.getExceptionStacktrace((Throwable)e)));
            }
        }
    }

    private Map<Long, String> addChildProcinstIds(Set<Long> parentIds, int level) {
        HashMap<Long, String> targetIdsMapping = new HashMap<Long, String>();
        if (level >= 3) {
            return targetIdsMapping;
        }
        QFilter[] filters = new QFilter[]{new QFilter("superprocessinstanceid", "in", parentIds), new QFilter(ENDTIME, "is not null", null)};
        DynamicObject[] entitys = BusinessDataServiceHelper.load((String)"wf_hiprocinst", (String)"id, businesskey", (QFilter[])filters);
        if (entitys != null && entitys.length > 0) {
            HashSet<Long> ids = new HashSet<Long>(entitys.length);
            for (DynamicObject entity : entitys) {
                Long id = entity.getLong("id");
                String businessKey = entity.getString("businesskey");
                targetIdsMapping.put(id, businessKey);
                ids.add(id);
            }
            Map<Long, String> childIdsMapping = this.addChildProcinstIds(ids, level + 1);
            targetIdsMapping.putAll(childIdsMapping);
        }
        return targetIdsMapping;
    }

    private void wrapEntitySummaryInfos(List<EntitySummaryInfo> entitySummaryInfos, MainEntityType entityType, int count) {
        String entityNumber = entityType.getName();
        boolean isEntityExist = Boolean.FALSE;
        for (EntitySummaryInfo entitySummaryInfo : entitySummaryInfos) {
            if (!entitySummaryInfo.getNumber().equals(entityNumber)) continue;
            int summary = entitySummaryInfo.getArchiveSummary() + count;
            entitySummaryInfo.setArchiveSummary(summary);
            isEntityExist = Boolean.TRUE;
            break;
        }
        if (!isEntityExist) {
            entitySummaryInfos.add(new EntitySummaryInfo(entityType.getDisplayName(), entityNumber, count, 0));
        }
    }

    @Override
    public Map<String, Date> getEntityTimeRange() {
        HashMap<String, Date> timeMap = new HashMap<String, Date>();
        QFilter f1 = new QFilter(ENDTIME, "is not null", null);
        QFilter f2 = new QFilter("processtype", "!=", (Object)"BizFlow");
        QFilter f3 = new QFilter("superprocessinstanceid", "=", (Object)0L);
        String archiveEntity = "wf_hiprocinst";
        DynamicObject[] proinstEnd = BusinessDataServiceHelper.load((String)archiveEntity, (String)ENDTIME, (QFilter[])new QFilter[]{f1, f2, f3}, (String)"endtime desc", (int)1);
        DynamicObject[] proinstStart = BusinessDataServiceHelper.load((String)archiveEntity, (String)ENDTIME, (QFilter[])new QFilter[]{f1, f2, f3}, (String)"endtime asc", (int)1);
        if (proinstEnd != null && proinstStart != null) {
            timeMap.put("endDate", proinstEnd[0].getDate(ENDTIME));
            timeMap.put("startDate", proinstStart[0].getDate(ENDTIME));
        }
        return timeMap;
    }
}

