/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.message.archive.service.impl;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.archive.api.dto.ArchiveDatabase;
import kd.bos.archive.route.index.ArchiveRouteCondition;
import kd.bos.archive.route.index.ArchiveRouteIndex;
import kd.bos.archive.task.resultnotify.mq.ArchiveResultBody;
import kd.bos.archive.task.resultnotify.mq.ArchiveResultNotifyServiceListener;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleDynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.db.DBRoute;
import kd.bos.db.archive.ArchiveRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.message.archive.model.EntitySummaryInfo;
import kd.bos.message.archive.service.ArchiveApiService;
import kd.bos.message.archive.service.ArchiveDataService;
import kd.bos.message.archive.service.ArchiveInfofNotifyService;
import kd.bos.message.archive.service.ArchiveScheduleTaskService;
import kd.bos.message.archive.service.MessageArchiveService;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.msg.ArchiveRouteIndexCondition;

public class MessageArchiveServiceImpl
implements MessageArchiveService {
    private static Log logger = LogFactory.getLog(MessageArchiveServiceImpl.class);
    private ArchiveApiService archiveApiService = null;
    private ArchiveDataService archiveDataService = null;
    private ArchiveInfofNotifyService archiveInfoNotifyService = null;
    private ArchiveScheduleTaskService archiveScheduleTaskService = null;

    public MessageArchiveServiceImpl() {
        this.init();
    }

    private void init() {
        this.registerAechiveResultNotifyListener();
        this.initArchiveApi();
        this.initServices();
    }

    private void registerAechiveResultNotifyListener() {
        try {
            String appId = "wf";
            String serviceName = "archiveResultNotifyService";
            String factory = "kd.bos.wf.servicehelper.ServiceFactory";
            ArchiveResultNotifyServiceListener.ArchiveResultNotifyListener archiveResultNotifyListener = new ArchiveResultNotifyServiceListener.ArchiveResultNotifyListener(appId, factory, serviceName);
            ArchiveResultNotifyServiceListener.registerArchiveResultNotifyListener((ArchiveResultNotifyServiceListener.ArchiveResultNotifyListener)archiveResultNotifyListener);
        }
        catch (Exception e) {
            logger.warn(String.format("MessageArchiveResultNotifier_registerListener has error: %s", WfUtils.getExceptionStacktrace((Throwable)e)));
        }
    }

    private void initArchiveApi() {
        if (this.archiveApiService == null) {
            this.archiveApiService = new ArchiveApiService();
        }
    }

    private void initServices() {
        if (this.archiveInfoNotifyService == null) {
            this.archiveInfoNotifyService = new ArchiveInfofNotifyService(this.archiveApiService);
        }
        if (this.archiveScheduleTaskService == null) {
            this.archiveScheduleTaskService = new ArchiveScheduleTaskService(this.archiveApiService);
        }
        if (this.archiveDataService == null) {
            this.archiveDataService = new ArchiveDataService();
        }
    }

    @Override
    public void saveArchiveScheduleStartInfo(String entityNumber, long taskId, long scheduleId) {
        this.archiveInfoNotifyService.saveArchiveScheduleStartInfo(entityNumber, taskId, scheduleId);
    }

    @Override
    public void analysisArchiveTaskResultInfo(ArchiveResultBody archiveResultBody) {
        this.archiveInfoNotifyService.analysisArchiveTaskResultInfo(archiveResultBody);
    }

    @Override
    public void triggerArchiveService(DynamicObject archiveService) {
        this.archiveScheduleTaskService.triggerArchiveService(archiveService);
    }

    @Override
    public ArchiveApiService getArchiveApiService() {
        return this.archiveApiService;
    }

    @Override
    public List<EntitySummaryInfo> getArchiveEntityData(String archiveEntity, Date archiveStartDate, Date archiveEndDate) {
        return this.archiveDataService.getPlugin(archiveEntity).getArchiveEntityData(archiveEntity, archiveStartDate, archiveEndDate);
    }

    @Override
    public Map<String, Date> getEntityTimeRange(String archiveEntity) {
        return this.archiveDataService.getPlugin(archiveEntity).getEntityTimeRange();
    }

    private void injectArchiveRouteKey(String routeKey, String archiveRouteKey) {
        if (WfUtils.isNotEmpty((String)archiveRouteKey) && !DBRoute.workflow.getRouteKey().equalsIgnoreCase(archiveRouteKey) && !WfUtils.WFS.getRouteKey().equalsIgnoreCase(archiveRouteKey)) {
            ArchiveRoute.mapRoute((String)routeKey, (String)archiveRouteKey);
        } else {
            ArchiveRoute.mapRoute((String)routeKey, (String)"");
        }
    }

    public void injectArchiveRouteInfo(String archiveRouteKey) {
        try {
            ArchiveRoute archiveRoute = ArchiveRoute.get();
            if (archiveRoute == null || WfUtils.isEmpty((String)archiveRoute.getArchiveRouteKey())) {
                this.injectArchiveRouteKey(WfUtils.WFS.getRouteKey(), archiveRouteKey);
            }
        }
        catch (Exception e) {
            logger.warn(String.format("inject_archiveRouteKey is error, %s", WfUtils.getExceptionStacktrace((Throwable)e)));
        }
    }

    public String injectArchiveRouteInfo(String archiveEntity, ArchiveRouteIndexCondition condition) {
        try {
            logger.debug(String.format("inject_archiveRouteKey_archiveRoute[%s]", ArchiveRoute.get() == null ? "" : ArchiveRoute.get().toString()));
            ArrayList<ArchiveRouteIndexCondition> archiveRouteIndexConditions = new ArrayList<ArchiveRouteIndexCondition>();
            archiveRouteIndexConditions.add(condition);
            List<String> archiveRouteKeys = this.getArchiveRouteKeys(archiveEntity, archiveRouteIndexConditions);
            if (archiveRouteKeys != null && !archiveRouteKeys.isEmpty()) {
                MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)archiveEntity);
                DBRoute dbRouteKey = DBRoute.of((String)entityType.getDBRouteKey());
                this.injectArchiveRouteKey(dbRouteKey.getRouteKey(), archiveRouteKeys.get(0));
                return archiveRouteKeys.get(0);
            }
        }
        catch (Exception e) {
            logger.warn(String.format("inject_archiveRouteKey is error, %s", WfUtils.getExceptionStacktrace((Throwable)e)));
        }
        return null;
    }

    public List<String> getArchiveRouteKeys(String archiveEntity, List<ArchiveRouteIndexCondition> archiveRouteIndexConditions) {
        try {
            MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)archiveEntity);
            ArrayList<ArchiveRouteCondition> archiveRouteConditions = new ArrayList<ArchiveRouteCondition>(archiveRouteIndexConditions.size());
            for (ArchiveRouteIndexCondition condition : archiveRouteIndexConditions) {
                String propertyDBName = condition.getIndex();
                DataEntityPropertyCollection properties = entityType.getProperties();
                for (IDataEntityProperty property : properties) {
                    if (property.getPropertyType() == LocaleDynamicObjectCollection.class || !property.getName().equalsIgnoreCase(condition.getIndex())) continue;
                    propertyDBName = property.getAlias();
                }
                archiveRouteConditions.add(new ArchiveRouteCondition(propertyDBName, condition.getIndexValue()));
            }
            DBRoute dbRouteKey = DBRoute.of((String)entityType.getDBRouteKey());
            ArchiveRouteCondition[] conditions = archiveRouteConditions.toArray(new ArchiveRouteCondition[0]);
            List archiveRouteKeys = ArchiveRouteIndex.getArchiveRoute((DBRoute)dbRouteKey, (String)entityType.getAlias(), (boolean)Boolean.FALSE, (ArchiveRouteCondition[])conditions);
            logger.debug(String.format("getArchiveRouteKeys_archiveRouteKeys[%s]", archiveRouteKeys == null ? "" : archiveRouteKeys.toString()));
            return archiveRouteKeys;
        }
        catch (Exception e) {
            logger.warn(String.format("getArchiveRouteKeys by date is error: %s", WfUtils.getExceptionStacktrace((Throwable)e)));
            return Collections.emptyList();
        }
    }

    public List<String> getArchiveRouteKeys(String archiveEntity, Date startDate, Date endDate) {
        if (WfUtils.isEmpty((String)archiveEntity) || startDate == null || endDate == null) {
            return Collections.emptyList();
        }
        String selectProperties = "archstartdate, archenddate, databasezone";
        QFilter[] filters = new QFilter[]{new QFilter("archiveentity", "=", (Object)archiveEntity)};
        DynamicObject[] archiveServices = BusinessDataServiceHelper.load((String)"wf_archiveservice", (String)selectProperties, (QFilter[])filters);
        if (archiveServices == null || archiveServices.length == 0) {
            return Collections.emptyList();
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(startDate);
        int targetStartYear = calendar.get(1);
        calendar.setTime(endDate);
        calendar.add(5, -1);
        int targetEndYear = calendar.get(1);
        HashSet<String> databaseZones = new HashSet<String>();
        for (DynamicObject archiveService : archiveServices) {
            if (targetStartYear < archiveService.getInt("archstartdate") || targetEndYear > archiveService.getInt("archenddate")) continue;
            databaseZones.add(archiveService.getString("databasezone"));
        }
        if (databaseZones.isEmpty()) {
            return Collections.emptyList();
        }
        try {
            ArrayList<String> archiveRouteKeys = new ArrayList<String>();
            List<ArchiveDatabase> archiveDatabases = this.archiveApiService.getAllDatabaseZones();
            for (ArchiveDatabase archiveDatabase : archiveDatabases) {
                if (!databaseZones.contains(archiveDatabase.getNumber())) continue;
                archiveRouteKeys.add(archiveDatabase.getArchiveRouteKey());
            }
            return archiveRouteKeys;
        }
        catch (Exception e) {
            logger.warn(String.format("getArchiveRouteKeys by date is error: %s", WfUtils.getExceptionStacktrace((Throwable)e)));
            return Collections.emptyList();
        }
    }
}

