/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.message.archive.task;

import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.message.archive.enumeration.MessageArchiveState;
import kd.bos.message.archive.model.EntitySummaryInfo;
import kd.bos.message.archive.model.PredictArchiveInfo;
import kd.bos.message.archive.service.MessageArchiveService;
import kd.bos.message.archive.utils.MessageArchiveUtil;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfUtils;

public class MessageArchiveScheduleTask
extends AbstractTask {
    private static Log logger = LogFactory.getLog(MessageArchiveScheduleTask.class);

    public void execute(RequestContext context, Map<String, Object> param) {
        if (!WfConfigurationUtil.isEnableArchive()) {
            logger.debug("MessageArchiveSchdulePlugin, triggerArchiveService not enable archive");
            return;
        }
        DynamicObject archiveService = this.getArchiveService();
        if (archiveService == null) {
            logger.debug("MessageArchiveSchdulePlugin, triggerArchiveService not find archiveService");
            return;
        }
        String entityNumber = archiveService.getString("archiveentity");
        if ("wf_hiprocinst".equalsIgnoreCase(entityNumber) && !MessageArchiveUtil.isHistoricDataRepairDone().booleanValue()) {
            logger.debug("MessageArchiveSchdulePlugin, triggerArchiveService historicdata not repaired");
            return;
        }
        this.recalculateArchiveServiceData(archiveService);
        logger.debug(String.format("MessageArchiveSchdulePlugin, triggerArchiveService and archiveServiceNumber[%s]", archiveService.getString("number")));
        MessageArchiveService messageArchiveService = MessageArchiveService.create();
        messageArchiveService.triggerArchiveService(archiveService);
    }

    private DynamicObject getArchiveService() {
        DynamicObject targetArchiveService = null;
        String selectFields = "id,number,archiveentity,database,databasezone,dbzonename,state,archservicestartdate,archplanstartdate,alldatasum,predicttime,archivedaterangelist,schedulesize,archstartdate,archenddate,archivedetail.entityname,archivedetail.entitynumber,archivedetail.entrydaterange,archivedetail.entityarchivesum";
        QFilter f1 = new QFilter("state", "!=", (Object)MessageArchiveState.ARCHIVEOK.getValue());
        DynamicObject[] archiveServices = BusinessDataServiceHelper.load((String)"wf_archiveservice", (String)selectFields, (QFilter[])new QFilter[]{f1}, (String)"archplanstartdate asc");
        if (archiveServices == null || archiveServices.length == 0) {
            return targetArchiveService;
        }
        HashSet<String> notCanTriggerEntitys = new HashSet<String>();
        for (DynamicObject archiveService : archiveServices) {
            String state = archiveService.getString("state");
            if (!state.equals(MessageArchiveState.ARCHIVEING.getValue()) && !state.equals(MessageArchiveState.ARCHIVEFAIL.getValue())) continue;
            notCanTriggerEntitys.add(archiveService.getString("archiveentity"));
        }
        for (int i = 0; i < archiveServices.length; ++i) {
            Date currentDate;
            Date planStartDate;
            DynamicObject archiveService = archiveServices[i];
            String entityNumber = archiveService.getString("archiveentity");
            if (notCanTriggerEntitys.contains(entityNumber) || !(planStartDate = archiveService.getDate("archplanstartdate")).before(currentDate = new Date())) continue;
            targetArchiveService = archiveService;
            break;
        }
        return targetArchiveService;
    }

    private void recalculateArchiveServiceData(DynamicObject archiveService) {
        String archiveDateRange = archiveService.getString("archivedaterangelist");
        int scheduleSize = archiveService.getInt("schedulesize");
        String archiveEntity = archiveService.getString("archiveentity");
        String startDate = archiveService.getString("archstartdate");
        String endDate = archiveService.getString("archenddate");
        Map<String, Date> archiveDates = MessageArchiveUtil.getArchiveDates(Integer.parseInt(startDate), Integer.parseInt(endDate));
        Date archiveStartDate = archiveDates.get("startDate");
        Date archiveEndDate = archiveDates.get("endDate");
        MessageArchiveService messageArchiveService = MessageArchiveService.create();
        List<EntitySummaryInfo> entitySummaryInfos = messageArchiveService.getArchiveEntityData(archiveEntity, archiveStartDate, archiveEndDate);
        PredictArchiveInfo predictData = MessageArchiveUtil.getPredictArchiveData(entitySummaryInfos, archiveEntity, scheduleSize);
        archiveService.set("alldatasum", (Object)predictData.getPredictSummary());
        archiveService.set("predicttime", (Object)predictData.getPredictTime());
        logger.debug(String.format("alldatasum-%s, predicttime-%s, [scanschedule]", predictData.getPredictSummary(), predictData.getPredictTime()));
        DynamicObjectCollection detailObjects = archiveService.getDynamicObjectCollection("archivedetail");
        if (entitySummaryInfos != null && !entitySummaryInfos.isEmpty()) {
            for (int i = 0; i < entitySummaryInfos.size(); ++i) {
                EntitySummaryInfo info = entitySummaryInfos.get(i);
                DynamicObject targetEntry = null;
                if (!detailObjects.isEmpty()) {
                    for (DynamicObject entry : detailObjects) {
                        String entityNumber = entry.getString("entitynumber");
                        if (!WfUtils.isNotEmpty((String)entityNumber) || !entityNumber.equals(info.getNumber())) continue;
                        targetEntry = entry;
                        break;
                    }
                }
                if (targetEntry == null) {
                    targetEntry = new DynamicObject(detailObjects.getDynamicObjectType(), true);
                    detailObjects.add((Object)targetEntry);
                }
                targetEntry.set("entityname", (Object)info.getName());
                targetEntry.set("entitynumber", (Object)info.getNumber());
                targetEntry.set("entrydaterange", (Object)archiveDateRange);
                targetEntry.set("entityarchivesum", (Object)info.getArchiveSummary());
            }
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{archiveService});
    }
}

